delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

insert into help_category (help_category_id,name,parent_category_id) values (0,"Point properties",24),(1,"Column Types",12),(2,"Geometry constructors",24),(3,"Data Definition",12),(4,"Comparison operators",16),(5,"WKB",24),(6,"MBR",24),(7,"Polygon properties",24),(8,"Encryption Functions",16),(9,"GeometryCollection properties",24),(10,"Numeric Functions",16),(11,"String Functions",16),(12,"Contents",-1),(13,"Geometry properties",24),(14,"Control flow functions",16);
insert into help_category (help_category_id,name,parent_category_id) values (15,"Date and Time Functions",16),(16,"Functions",12),(17,"WKT",24),(18,"Miscellaneous Functions",16),(19,"Administration",12),(20,"Information Functions",16),(21,"LineString properties",24),(22,"Functions and Modifiers for Use with GROUP BY Clauses",16),(23,"Transactions",12),(24,"Geographic features",12),(25,"Geometry relations",24),(26,"Data Manipulation",12),(27,"Logical operators",16),(28,"Bit Functions",16);

insert into help_topic (help_topic_id,help_category_id,name,description,example) values (0,11,"ASCII","   ASCII(@var{str})\nReturns the numeric value of the leftmost character of the string\n@var{str}. Returns 0 if @var{str} is the empty string.  Returns\nNULL if @var{str} is NULL.\nASCII() works for characters with numeric values from 0 to\n255.\n","mysql> SELECT ASCII('2');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII('dx');\n        -> 100"),(1,11,"LOAD_FILE","   LOAD_FILE(@var{file_name})\nReads the file and returns the file contents as a string.  The file\nmust be located on the server, you must specify the full pathname to the\nfile, and you must have the FILE privilege.  The file must\nbe readable by all and be smaller than max_allowed_packet bytes.\n\nIf the file doesn't exist or cannot be read because one of the preceding\nconditions is not satisfied, the function returns NULL.\n","mysql> UPDATE @var{tbl_name}\n           SET @var{blob_column}=LOAD_FILE('/tmp/picture')\n           WHERE id=1;"),(2,11,"OCTETLENGTH","   OCTET_LENGTH(@var{str})\n\nOCTET_LENGTH() is a synonym for LENGTH().\n",""),(3,11,"INSTR","   INSTR(@var{str},@var{substr})\nReturns the position of the first occurrence of substring @var{substr} in\nstring @var{str}. This is the same as the two-argument form of\nLOCATE(), except that the arguments are swapped.\n","mysql> SELECT INSTR('foobarbar', 'bar');\n        -> 4\nmysql> SELECT INSTR('xbar', 'foobar');\n        -> 0"),(4,4,"IN","   @var{expr} IN (@var{value},...)\nReturns 1 if @var{expr} is any of the values in the IN list,\nelse returns 0.  If all values are constants, they are\nevaluated according to the type of @var{expr} and sorted. The search for the\nitem then is done using a binary search. This means IN is very quick\nif the IN value list consists entirely of constants.  If @var{expr}\nis a case-sensitive string expression, the string comparison is performed in\ncase-sensitive fashion.\n","mysql> SELECT 2 IN (0,3,5,'wefwf');\n        -> 0\nmysql> SELECT 'wefwf' IN (0,3,5,'wefwf');\n        -> 1"),(5,15,"CURRENT_TIME","   CURRENT_TIME\n   CURRENT_TIME()\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for\nCURTIME().\n",""),(6,6,"MBRCONTAINS","   MBRContains(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangle of\n@var{g1} contains the Minimum Bounding Rectangle of @var{g2}.\n","mysql> SET @g1 = GeomFromText('Polygon((0 0,0 3,3 3,3 0,0 0))');\nmysql> SET @g2 = GeomFromText('Point(1 1)');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+"),(7,15,"DATE FUNCTION","   DATE(@var{expr})\n\nExtracts the date part of the date or datetime expression @var{expr}.\n","mysql> SELECT DATE('2003-12-31 01:02:03');\n        -> '2003-12-31'"),(8,19,"MERGE","\n@menu\n* MERGE table problems::        MERGE Table Problems\n@end menu\n\nThe MERGE storage engine was introduced in MySQL 3.23.25. It\nis also known as the MRG_MyISAM engine. The code is now reasonably\nstable.\n\nA MERGE table is a collection of identical MyISAM tables that\ncan be used as one.  ``Identical'' means that all tables have\nidentical column and index information.  You can't merge tables in which the\ncolumns are listed in a different order, don't have exactly the same columns, or\nhave the indexes in different order.  However, any or all of the tables can be\ncompressed with @command{myisampack}.\nSee also : [myisampack, , @command{myisampack]}.\nDifferences in table options such as AVG_ROW_LENGTH, MAX_ROWS,\nor PACK_KEYS do not matter.\n","mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20));\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20));\nmysql> INSERT INTO t1 (message) VALUES ('Testing'),('table'),('t1');\nmysql> INSERT INTO t2 (message) VALUES ('Testing'),('table'),('t2');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    TYPE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;"),(9,25,"WITHIN","   Within(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} is spatially within\n@var{g2}.\n",""),(10,5,"MLINEFROMWKB","   MLineFromWKB(@var{wkb}[,@var{srid}])\n   MultiLineStringFromWKB(@var{wkb}[,@var{srid}])\nConstructs a MULTILINESTRING value using its WKB representation and SRID.\n",""),(11,11,"TRIM","   TRIM([{BOTH | LEADING | TRAILING} [@var{remstr}] FROM] @var{str})\n   TRIM(@var{remstr} FROM] @var{str})\nReturns the string @var{str} with all @var{remstr} prefixes and/or suffixes\nremoved. If none of the specifiers BOTH, LEADING, or\nTRAILING is given, BOTH is assumed. If @var{remstr} is optional\nand not specified, spaces are removed.\n","mysql> SELECT TRIM('  bar   ');\n        -> 'bar'\nmysql> SELECT TRIM(LEADING 'x' FROM 'xxxbarxxx');\n        -> 'barxxx'\nmysql> SELECT TRIM(BOTH 'x' FROM 'xxxbarxxx');\n        -> 'bar'\nmysql> SELECT TRIM(TRAILING 'xyz' FROM 'barxxyz');\n        -> 'barx'"),(12,11,"LPAD","   LPAD(@var{str},@var{len},@var{padstr})\nReturns the string @var{str}, left-padded with the string @var{padstr}\nto a length of @var{len} characters. If @var{str} is longer\nthan @var{len}, the return value is shortened to @var{len} characters.\n","mysql> SELECT LPAD('hi',4,'??');\n        -> '??hi'\nmysql> SELECT LPAD('hi',1,'??');\n        -> 'h'"),(13,1,"TINYBLOB","   TINYBLOB\n   TINYTEXT\n\nA BLOB or TEXT column with a maximum length of 255 (2^8\n@minus{} 1)\ncharacters.\n",""),(14,24,"SPATIAL","MySQL can create spatial indexes using syntax similar to that for creating\nregular indexes, but extended with the SPATIAL keyword.\nSpatial columns that are indexed currently must be declared NOT NULL.\nThe following examples demonstrate how to create spatial indexes.\n\n\n   With CREATE TABLE:\n\nmysql> CREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g));\n\n   With ALTER TABLE:\n\nmysql> ALTER TABLE geom ADD SPATIAL INDEX(g);\n\n   With CREATE INDEX:\n\nmysql> CREATE SPATIAL INDEX sp_index ON geom (g);\n\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\n\n   With ALTER TABLE:\n\nmysql> ALTER TABLE geom DROP INDEX g;\n\n   With DROP INDEX:\n\nmysql> DROP INDEX sp_index ON geom;\n\n\nExample: Suppose that a table geom contains more than 32,000 geometries,\nwhich are stored in the column g of type GEOMETRY.\nThe table also has an AUTO_INCREMENT column fid for storing\nobject ID values.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (15,26,"KILL","Each connection to @command{mysqld} runs in a separate thread.  You can see\nwhich threads are running with the SHOW PROCESSLIST statement and kill\na thread with the KILL thread_id statement.\n\nAs of MySQL 5.0.0, KILL allows the optional CONNECTION or\nQUERY modifiers:\n\n\n --- KILL CONNECTION is the same as KILL with no modifier:\nIt terminates the connection associated with the given @var{thread_id}.\n\n --- KILL QUERY terminates the statement that the connection currently\nis executing, but leaves the connection intact.\n\n\nIf you have the PROCESS privilege, you can see all threads.\nIf you have the SUPER privilege, you can kill all threads and\nstatements.  Otherwise, you can see and kill only your own threads and\nstatements.\n\nYou can also use the @command{mysqladmin processlist} and @command{mysqladmin kill}\ncommands to examine and kill threads.\n\nNote: You currently cannot use KILL with the Embedded MySQL\nServer library, because the embedded server merely runs inside the threads\nof the host application, it does not create connection threads of its own.\n","KILL [CONNECTION | QUERY] @var{thread_id}"),(16,11,"BIT_LENGTH","   BIT_LENGTH(@var{str})\nReturns the length of the string @var{str} in bits.\n","mysql> SELECT BIT_LENGTH('text');\n        -> 32"),(17,24,"GEOMETRY","MySQL provides a standard way of creating spatial columns for\ngeometry types, for example, with CREATE TABLE or ALTER TABLE.\nCurrently, spatial columns are supported only for MyISAM tables.\n","mysql> CREATE TABLE geom (g GEOMETRY);\nQuery OK, 0 rows affected (0.02 sec)"),(18,26,"INSERT INTO","INSERT inserts new rows into an existing table.  The INSERT ...\nVALUES and INSERT ... SET forms of the statement insert rows based\non explicitly specified values.  The INSERT ... SELECT form inserts\nrows selected from another table or tables.  The INSERT ... VALUES\nform with multiple value lists is supported in MySQL 3.22.5 or\nlater.  The INSERT ... SET syntax is supported in MySQL\n3.22.10 or later.\nINSERT ... SELECT is discussed further in\nSee also : [INSERT SELECT,  , INSERT SELECT].\n","INSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] @var{tbl_name} [(@var{col_name},...)]\n    VALUES ({@var{expr} | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE @var{col_name}=@var{expr}, ... ]"),(19,23,"SAVEPOINT","SAVEPOINT identifier\nROLLBACK TO SAVEPOINT identifier\n\nStarting from MySQL 4.0.14 and 4.1.1, InnoDB supports the SQL statements\nSAVEPOINT and ROLLBACK TO SAVEPOINT.\n",""),(20,26,"PURGE","","PURGE MASTER LOGS TO 'mysql-bin.010';\nPURGE MASTER LOGS BEFORE '2003-04-02 22:46:26';"),(21,19,"CHECK","CHECK TABLE works only on MyISAM and InnoDB tables. On\nMyISAM tables, This is the same thing as running @command{myisamchk\n--medium-check @var{tbl_name}} on the table.\n\nIf you don't specify any option, MEDIUM is used.\n","CHECK TABLE @var{tbl_name} [, @var{tbl_name}] ... [@var{option}] ...\n\n@var{option} = {QUICK | FAST | MEDIUM | EXTENDED | CHANGED}"),(22,15,"WEEKDAY","   WEEKDAY(@var{date})\nReturns the weekday index for\n@var{date} (0 = Monday, 1 = Tuesday, ... 6 = Sunday).\n","mysql> SELECT WEEKDAY('1998-02-03 22:23:00');\n        -> 1\nmysql> SELECT WEEKDAY('1997-11-05');\n        -> 2"),(23,6,"MBREQUAL","   MBREqual(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries @var{g1} and @var{g2} are the same.\n",""),(24,11,"BINARY","   BINARY\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by byte\nrather than character by character. This causes the comparison to be\ncase sensitive even\nif the column isn't defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n","mysql> SELECT 'a' = 'A';\n        -> 1\nmysql> SELECT BINARY 'a' = 'A';\n        -> 0\nmysql> SELECT 'a' = 'a ';\n        -> 1\nmysql> SELECT BINARY 'a' = 'a ';\n        -> 0"),(25,22,"STDDEV","   STD(@var{expr})\n   STDDEV(@var{expr})\nReturns the standard deviation of @var{expr} (the square root of\nVARIANCE()). This is an extension to standard SQL. The STDDEV()\nform of this function is provided for Oracle compatibility.\n",""),(26,10,"SIN","   SIN(@var{X})\nReturns the sine of @var{X}, where @var{X} is given in radians.\n","mysql> SELECT SIN(PI());\n        -> 0.000000"),(27,1,"CHAR","   [NATIONAL] CHAR(@var{M}) [BINARY | ASCII | UNICODE]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored.  @var{M} represents the column length.  The\nrange of @var{M} is 0 to 255 characters (1 to 255 prior to MySQL 3.23).\n\nNote: Trailing spaces are removed when CHAR values are\nretrieved.\n\nFrom MySQL 4.1.0, a CHAR column with a length specification greater\nthan 255 is converted to the smallest TEXT type that can hold values\nof the given length.  For example, CHAR(500) is converted to\nTEXT, and CHAR(200000) is converted to MEDIUMTEXT.\nThis is a compatibility feature.  However, this conversion causes the\ncolumn to become a variable-length column, and also affects trailing-space\nremoval.\n\nCHAR is shorthand for CHARACTER.\nNATIONAL CHAR (or its equivalent short form, NCHAR) is the\nstandard SQL way to define that a CHAR column should use the default\ncharacter set.  This is the default in MySQL.\n\nThe BINARY attribute causes sorting and comparisons to be\ncase sensitive.\n\nFrom MySQL 4.1.0 on, the ASCII attribute can be specified. It\nassigns the latin1 character set to a CHAR column.\n\nFrom MySQL 4.1.1 on, the UNICODE attribute can be specified. It\nassigns the ucs2 character set to a CHAR column.\n\nMySQL allows you to create a column of type CHAR(0). This is mainly\nuseful when you have to be compliant with some old applications that depend\non the existence of a column but that do not actually use the value.  This\nis also quite nice when you need a column that can take only two values: A\nCHAR(0) column that is not defined as NOT NULL occupies only\none bit and can take only the values NULL and '' (the empty\nstring).\n\n   CHAR\nThis is a synonym for CHAR(1).\n",""),(28,10,"SQRT","   SQRT(@var{X})\nReturns the non-negative square root of @var{X}.\n","mysql> SELECT SQRT(4);\n        -> 2.000000\nmysql> SELECT SQRT(20);\n        -> 4.472136"),(29,10,"ROUND","   ROUND(@var{X})\n   ROUND(@var{X},@var{D})\nReturns the argument @var{X}, rounded to the nearest integer.\nWith two arguments, returns @var{X} rounded to @var{D} decimals.\nIf @var{D} is negative, the integer part of the number is zeroed out.\n","mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (30,11,"CONCAT","   CONCAT(@var{str1},@var{str2},...)\nReturns the string that results from concatenating the arguments.  Returns\nNULL if any argument is NULL.  May have one or more arguments.\nA numeric argument is converted to its equivalent string form.\n","mysql> SELECT CONCAT('My', 'S', 'QL');\n        -> 'MySQL'\nmysql> SELECT CONCAT('My', NULL, 'QL');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> '14.3'"),(31,15,"CURRENT_TIMESTAMP","   CURRENT_TIMESTAMP\n   CURRENT_TIMESTAMP()\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for\nNOW().\n",""),(32,27,"!","   NOT\n   !\nLogical NOT.\nEvaluates to 1 if the operand is 0,\nto 0 if the operand is non-zero,\nand NOT NULL returns NULL.\n","mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1"),(33,4,"GREATEST","   GREATEST(@var{value1},@var{value2},...)\nWith two or more arguments, returns the largest (maximum-valued) argument.\nThe arguments are compared using the same rules as for LEAST().\n","mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST('B','A','C');\n        -> 'C'"),(34,11,"LOWER","   LOWER(@var{str})\nReturns the string @var{str} with all characters changed to lowercase\naccording to the current character set mapping (the default is ISO-8859-1\nLatin1).\n","mysql> SELECT LOWER('QUADRATICALLY');\n        -> 'quadratically'"),(35,10,"%","   MOD(@var{N},@var{M})\n   @var{N} % @var{M}\n   @var{N} MOD @var{M}\nModulo (like the % operator in C).\nReturns the remainder of @var{N} divided by @var{M}.\n","mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2"),(36,28,"&","   &\nBitwise AND:\n","mysql> SELECT 29 & 15;\n        -> 13"),(37,15,"DAYNAME","   DAYNAME(@var{date})\nReturns the name of the weekday for @var{date}.\n","mysql> SELECT DAYNAME('1998-02-05');\n        -> 'Thursday'"),(38,10,"- UNARY","   -\nUnary minus. Changes the sign of the argument.\n","mysql> SELECT - 2;\n        -> -2"),(39,26,"CHANGE MASTER TO","\nCHANGE MASTER TO master_def [, master_def] ...\n\nmaster_def:\n      MASTER_HOST = '@var{host_name}'\n    | MASTER_USER = '@var{user_name}'\n    | MASTER_PASSWORD = '@var{password}'\n    | MASTER_PORT = @var{port_num}\n    | MASTER_CONNECT_RETRY = @var{count}\n    | MASTER_LOG_FILE = '@var{master_log_name}'\n    | MASTER_LOG_POS = @var{master_log_pos}\n    | RELAY_LOG_FILE = '@var{relay_log_name}'\n    | RELAY_LOG_POS = @var{relay_log_pos}\n    | MASTER_SSL = {0|1}\n    | MASTER_SSL_CA = '@var{ca_file_name}'\n    | MASTER_SSL_CAPATH = '@var{ca_directory_name}'\n    | MASTER_SSL_CERT = '@var{cert_file_name}'\n    | MASTER_SSL_KEY = '@var{key_file_name}'\n    | MASTER_SSL_CIPHER = '@var{cipher_list}'\n\nChanges the parameters that the slave server uses for connecting to and\ncommunicating with the master server.\n\nMASTER_USER, MASTER_PASSWORD, MASTER_SSL,\nMASTER_SSL_CA, MASTER_SSL_CAPATH, MASTER_SSL_CERT,\nMASTER_SSL_KEY, and MASTER_SSL_CIPHER provide information for\nthe slave about how to connect to its master.\n\nThe relay log options (RELAY_LOG_FILE and RELAY_LOG_POS) are\navailable beginning with MySQL 4.0.\n\nThe SSL options\n(MASTER_SSL,\nMASTER_SSL_CA,\nMASTER_SSL_CAPATH,\nMASTER_SSL_CERT,\nMASTER_SSL_KEY,\nand\nMASTER_SSL_CIPHER)\nare available beginning with MySQL 4.1.1.\nYou can change these options even on slaves that are compiled without SSL\nsupport. They are saved to the *master.info file, but is ignored\nuntil you use a server that has SSL support enabled.\n\nIf you don't specify a given parameter, it keeps its old\nvalue, except as indicated in the following discussion. For example, if the password to connect to your MySQL master has\nchanged, you just need to issue these statements\nto tell the slave about the new password:\n\nmysql> STOP SLAVE; -- if replication was running\nmysql> CHANGE MASTER TO MASTER_PASSWORD='new3cret';\nmysql> START SLAVE; -- if you want to restart replication\n\nThere is no need to specify the parameters that do\nnot change (host, port, user, and so forth).\n\nMASTER_HOST and MASTER_PORT are the hostname (or IP address) of\nthe master host and its TCP/IP port. Note that if MASTER_HOST is\nequal to localhost, then, like in other parts of MySQL, the port\nmay be ignored (if Unix socket files can be used, for example).\n\nIf you specify MASTER_HOST or MASTER_PORT,\nthe slave assumes that the master server is different than\nbefore (even if you specify a host or port value that is\nthe same as the current value.) In this case, the old values for the master\nbinary log name and position are considered no longer applicable, so if you\ndo not specify MASTER_LOG_FILE and MASTER_LOG_POS in the\nstatement, MASTER_LOG_FILE='' and MASTER_LOG_POS=4 are\nsilently appended to it. \n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates\nat which the slave I/O thread should begin reading from the master the\nnext time the thread starts.\nIf you specify either of them, you can't specify RELAY_LOG_FILE or\nRELAY_LOG_POS.\nIf neither of MASTER_LOG_FILE or MASTER_LOG_POS are\nspecified, the slave uses the last coordinates of the /slave SQL thread/\nbefore CHANGE MASTER was issued. This ensures that\nreplication has no discontinuity, even if the slave SQL thread was late\ncompared to the slave I/O thread, when you just want to change, say, the\npassword to use. This safe behavior was introduced starting from MySQL\n4.0.17 and 4.1.1. (Before these versions, the coordinates used were \nthe last coordinates of the slave I/O thread before CHANGE MASTER\nwas issued. This caused the SQL thread to possibly lose some events\nfrom the master, thus breaking replication.)\n\nCHANGE MASTER /deletes all relay log files/ and starts\na new one, unless you specify RELAY_LOG_FILE or\nRELAY_LOG_POS. In that case, relay logs are kept;\nas of MySQL 4.1.1 the relay_log_purge global variable\nis set silently to 0.\n\nCHANGE MASTER TO updates the contents of the *master.info and\n*relay-log.info files.\n\nCHANGE MASTER is useful for setting up a slave when you have\nthe snapshot of the master and have recorded the log and the offset\ncorresponding to it.  After loading the snapshot into the slave, you\ncan run CHANGE MASTER TO MASTER_LOG_FILE='@var{log_name_on_master',\nMASTER_LOG_POS=@var{log_offset_on_master}} on the slave.\n\nExamples:\n\nmysql> CHANGE MASTER TO\n    ->     MASTER_HOST='master2.mycompany.com',\n    ->     MASTER_USER='replication',\n    ->     MASTER_PASSWORD='bigs3cret',\n    ->     MASTER_PORT=3306,\n    ->     MASTER_LOG_FILE='master2-bin.001',\n    ->     MASTER_LOG_POS=4,\n    ->     MASTER_CONNECT_RETRY=10;\n\nmysql> CHANGE MASTER TO\n    ->     RELAY_LOG_FILE='slave-relay-bin.006',\n    ->     RELAY_LOG_POS=4025;\n",""),(40,10,"*","   *\nMultiplication:\n","mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> 0"),(41,11,"RTRIM","   RTRIM(@var{str})\nReturns the string @var{str} with trailing space characters removed.\n","mysql> SELECT RTRIM('barbar   ');\n        -> 'barbar'"),(42,10,"+","   +\nAddition:\n","mysql> SELECT 3+5;\n        -> 8"),(43,4,"COALESCE","   COALESCE(@var{value},...)\nReturns the first non-NULL value in the list.\n","mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL"),(44,26,"SHOW MASTER STATUS","SHOW MASTER STATUS\n\nProvides status information on the binary log files of the master.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (45,10,"LOG","   LOG(@var{X})\n   LOG(@var{B},@var{X})\nIf called with one parameter, this function returns the natural logarithm\nof @var{X}.\n","mysql> SELECT LOG(2);\n        -> 0.693147\nmysql> SELECT LOG(-2);\n        -> NULL"),(46,10,"/","   /\nDivision:\n","mysql> SELECT 3/5;\n        -> 0.60"),(47,19,"RESET SLAVE","RESET SLAVE\n\nMakes the slave forget its replication position in the master's binary logs.\nThis statement is meant to be used for a clean start: It deletes the\n*master.info and *relay-log.info files, all the relay logs,\nand starts a new relay log.\n\nNote: All relay logs are deleted, even if they have not been\ntotally executed by the slave SQL thread.  (This is a condition likely to\nexist on a replication slave if you have issued a STOP SLAVE\nstatement or if the slave is highly loaded.)\n\nConnection information stored in the *master.info file is immediately\nreset using any values specified in the corresponding startup options.\nThis information includes values such as master host, master port, master\nuser, and master password.  If the slave SQL thread was in the middle of\nreplicating temporary tables when it was stopped, and RESET SLAVE\nis issued, these replicated temporary tables are deleted on the slave.\n\nThis statement was named FLUSH SLAVE before MySQL 3.23.26.\n",""),(48,25,"INTERSECTS","   Intersects(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} spatially intersects\n@var{g2}.\n",""),(49,28,"<<","   <<\nShifts a longlong (BIGINT) number to the left.\n","mysql> SELECT 1 << 2;\n        -> 4"),(50,11,"REPEAT","   REPEAT(@var{str},@var{count})\nReturns a string consisting of the string @var{str} repeated @var{count}\ntimes. If @var{count <= 0}, returns an empty string. Returns NULL if\n@var{str} or @var{count} are NULL.\n","mysql> SELECT REPEAT('MySQL', 3);\n        -> 'MySQLMySQLMySQL'"),(51,4,"<=","   <=\nLess than or equal:\n","mysql> SELECT 0.1 <= 2;\n        -> 1"),(52,26,"LOAD TABLE FROM MASTER","LOAD TABLE @var{tbl_name} FROM MASTER\n\nTransfers a copy of the table from master to the slave. This statement is\nimplemented mainly for debugging of LOAD DATA FROM MASTER.\nIt requires that the account used for connecting to the master server has the\nRELOAD and SUPER privileges on the master and the\nSELECT privilege on the master table to load.\nOn the slave side, the user that issues LOAD TABLE FROM MASTER should\nhave privileges to drop and create the table.\n\nThe conditions for LOAD DATA FROM MASTER apply here, too. For\nexample, LOAD TABLE FROM MASTER works only for MyISAM tables.\nThe timeout notes for LOAD DATA FROM MASTER apply as well.\n",""),(53,15,"TIME_FORMAT","   TIME_FORMAT(@var{time},@var{format})\nThis is used like the DATE_FORMAT() function, but the\n@var{format} string may contain only those format specifiers that handle\nhours, minutes, and seconds.  Other specifiers produce a NULL value or\n0.\n",""),(54,11,"CHAR_LENGTH","   CHAR_LENGTH(@var{str})\n\nReturns the length of the string @var{str}, measured in characters.\nA multi-byte character counts as a single character.\nThis means that for a string containing five two-byte characters,\nLENGTH() returns 10, whereas CHAR_LENGTH() returns\n5.\n",""),(55,8,"PASSWORD","","mysql> SELECT PASSWORD('badpwd');\n        -> '7f84554057dd964b'"),(56,4,"<","   <\nLess than:\n","mysql> SELECT 2 < 2;\n        -> 0"),(57,4,"=","   =\nEqual:\n","mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT '0' = 0;\n        -> 1\nmysql> SELECT '0.0' = 0;\n        -> 1\nmysql> SELECT '0.01' = 0;\n        -> 0\nmysql> SELECT '.01' = 0.01;\n        -> 1"),(58,4,">","   >\nGreater than:\n","mysql> SELECT 2 > 2;\n        -> 0"),(59,13,"ISEMPTY","   IsEmpty(@var{g})\nReturns 1 if the geometry value @var{g} is the empty geometry, 0 if it is not\nempty, and @minus{}1 if the argument is NULL.\nIf the geometry is empty, it represents the empty point set.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (60,10,"ABS","   ABS(@var{X})\nReturns the absolute value of @var{X}.\n","mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32"),(61,11,"LCASE","   LCASE(@var{str})\n\nLCASE() is a synonym for LOWER().\n",""),(62,19,"SHOW","\nSET allows you to set variables and options.\n\nSHOW has many forms that provide information about databases,\ntables, columns, or status information about the server.\nThis section describes those following:\n\nSHOW [FULL] COLUMNS FROM @var{tbl_name} [FROM @var{db_name}] [LIKE '@var{pattern}']\nSHOW CREATE DATABASE @var{db_name}\nSHOW CREATE TABLE @var{tbl_name}\nSHOW DATABASES [LIKE '@var{pattern}']\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [@var{offset},] @var{row_count}]\nSHOW GRANTS FOR @var{user}\nSHOW INDEX FROM @var{tbl_name} [FROM @var{db_name}]\nSHOW INNODB STATUS\nSHOW [BDB] LOGS\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW STATUS [LIKE '@var{pattern}']\nSHOW TABLE STATUS [FROM @var{db_name}] [LIKE '@var{pattern}']\nSHOW [OPEN] TABLES [FROM @var{db_name}] [LIKE '@var{pattern}']\nSHOW [GLOBAL | SESSION] VARIABLES [LIKE '@var{pattern}']\nSHOW WARNINGS [LIMIT [@var{offset},] @var{row_count}]\n\nIf the syntax for a given SHOW statement includes a LIKE\n'@var{pattern'} part, '@var{pattern'} is a string that can contain the SQL %\nand _ wildcard characters.\nThe pattern is useful for restricting statement output to matching values.\n",""),(63,15,"CURTIME","   CURTIME()\n\nReturns the current time as a value in 'HH:MM:SS' or HHMMSS\nformat, depending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT CURTIME();\n        -> '23:50:26'\nmysql> SELECT CURTIME() + 0;\n        -> 235026"),(64,1,"TYPE SET","   SET('@var{value1}','@var{value2}',...)\n\nA set.  A string object that can have zero or more values, each of which must\nbe chosen from the list of values '@var{value1'}, '@var{value2'},\n... A SET column can have a maximum of 64 members.\nSET values are represented internally as integers.\n  \n",""),(65,26,"SHOW BINLOG","SHOW BINLOG EVENTS\n   [IN '@var{log_name}'] [FROM @var{pos}] [LIMIT [@var{offset},] @var{row_count}]\n\nShows the events in the binary log. \nIf you do not specify 'log_name', the first binary log will be displayed.\n",""),(66,3,"RENAME TABLE","RENAME TABLE @var{tbl_name} TO @var{new_tbl_name}\n    [, @var{tbl_name2} TO @var{new_tbl_name2}] ...\n\nThis statement renames one or more tables.  It was added in MySQL 3.23.23.\n\nThe rename operation is done atomically, which means that no other thread\ncan access any of the tables while the rename is running. For example,\nif you have an existing table old_table, you can create another\ntable new_table that has the same structure but is empty, and then\nreplace the existing table with the empty one as follows:\n","CREATE TABLE @var{new_table} (...);\nRENAME TABLE @var{old_table} TO @var{backup_table}, @var{new_table} TO @var{old_table};"),(67,11,"SUBSTRING_INDEX","   SUBSTRING_INDEX(@var{str},@var{delim},@var{count})\nReturns the substring from string @var{str} before @var{count}\noccurrences of the delimiter @var{delim}.\nIf @var{count} is positive, everything to the left of the final delimiter\n(counting from the left) is returned.\nIf @var{count} is negative, everything to the right of the final delimiter\n(counting from the right) is returned.\n","mysql> SELECT SUBSTRING_INDEX('www.mysql.com', '.', 2);\n        -> 'www.mysql'\nmysql> SELECT SUBSTRING_INDEX('www.mysql.com', '.', -2);\n        -> 'mysql.com'"),(68,15,"LOCALTIME","   LOCALTIME\n   LOCALTIME()\n\nLOCALTIME and LOCALTIME() are synonyms for\nNOW().\n",""),(69,0,"X","   X(@var{p})\nReturns the X-coordinate value for the point @var{p} as a double-precision\nnumber.\n","mysql> SELECT X(GeomFromText('Point(56.7 53.34)'));\n+--------------------------------------+\n| X(GeomFromText('Point(56.7 53.34)')) |\n+--------------------------------------+\n|                                 56.7 |\n+--------------------------------------+"),(70,19,"START SLAVE","START SLAVE [@var{thread_type} [, @var{thread_type}] ... ]\nSTART SLAVE [SQL_THREAD] UNTIL\n    MASTER_LOG_FILE = '@var{log_name}', MASTER_LOG_POS = @var{log_pos}\nSTART SLAVE [SQL_THREAD] UNTIL\n    RELAY_LOG_FILE = '@var{log_name}', RELAY_LOG_POS = @var{log_pos}\n\nthread_type: IO_THREAD | SQL_THREAD\n\nSTART SLAVE with no options starts both of the slave threads.\nThe I/O thread reads queries from the master server and stores them in the\nrelay log.  The SQL thread reads the relay log and executes the\nqueries.\nSTART SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it\nreturns without any error. However, even in that case, it might be that the slave\nthreads start and then later stop (for example, because they don't manage to\nconnect to the master or read its binary logs, or some other\nproblem). START SLAVE will not warn you about this. You must\ncheck your slave's error log for error messages generated by\nthe slave threads, or check that they are running fine with SHOW\nSLAVE STATUS.\n",""),(71,26,"SHOW MASTER LOGS","SHOW MASTER LOGS\nSHOW BINARY LOGS\n\nLists the binary log files on the server. This statement is used as part of\nthe procedure described in [PURGE MASTER LOGS] for determining which logs\ncan be purged.\n",""),(72,0,"Y","   Y(@var{p})\nReturns the Y-coordinate value for the point @var{p} as a double-precision\nnumber.\n","mysql> SELECT Y(GeomFromText('Point(56.7 53.34)'));\n+--------------------------------------+\n| Y(GeomFromText('Point(56.7 53.34)')) |\n+--------------------------------------+\n|                                53.34 |\n+--------------------------------------+"),(73,10,"DIV","Integer division.\nSimilar to FLOOR() but safe with BIGINT values.\n","mysql> SELECT 5 DIV 2;\n        -> 2"),(74,8,"ENCRYPT","   ENCRYPT(@var{str}[,@var{salt}])\nEncrypt @var{str} using the Unix crypt() system call. The\n@var{salt} argument should be a string with two characters.\n(As of MySQL 3.22.16, @var{salt} may be longer than two characters.)\nIf no @var{salt} argument is given, a random value is used.\n","mysql> SELECT ENCRYPT('hello');\n        -> 'VxuFAJXVARROc'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (75,19,"BACKUP TABLE","Note: This statement is deprecated. We are working on a better\nreplacement for it that will provide online backup capabilities.\nIn the meantime, the @command{mysqlhotcopy} script can be used instead.\n\nBACKUP TABLE copies to the backup directory the minimum number of\ntable files needed to restore the table, after flushing any buffered changes\nto disk. The statement works only for MyISAM tables.  It copies the\n*.frm definition  and *.MYD data files. The *.MYI\nindex file can be rebuilt from those two files.\nThe directory should be specified as a full pathname.\n","BACKUP TABLE @var{tbl_name} [, @var{tbl_name}] ... TO '@var{/path/to/backup/directory}'"),(76,28,"^","   ^\nBitwise XOR:\n","mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8"),(77,15,"TIMESTAMPDIFF FUNCTION","","mysql> SELECT TIMESTAMPDIFF(MONTH,'2003-02-01','2003-05-01');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,'2002-05-01','2001-01-01');\n        -> -1"),(78,1,"BLOB TYPE TEXT BLOB","   BLOB\n   TEXT\n\nA BLOB or TEXT column with a maximum length of 65,535 (2^16\n@minus{}1)\ncharacters.\n",""),(79,26,"INSERT SELECT","INSERT [LOW_PRIORITY] [IGNORE] [INTO] @var{tbl_name} [(@var{column_list})]\n    SELECT ...\n\nWith INSERT ... SELECT, you can quickly insert many rows\ninto a table from one or many tables.\n","INSERT INTO tbl_temp2 (fld_id)\n    SELECT tbl_temp1.fld_order_id\n    FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;"),(80,26,"HANDLER","The HANDLER statement provides direct access to table storage engine\ninterfaces.  It is available for MyISAM tables as MySQL 4.0.0 and\nInnoDB tables as of MySQL 4.0.3.\n","HANDLER @var{tbl_name} OPEN [ AS @var{alias} ]\nHANDLER @var{tbl_name} READ @var{index_name} { = | >= | <= | < } (@var{value1},@var{value2},...)\n    [ WHERE @var{where_condition} ] [LIMIT ... ]\nHANDLER @var{tbl_name} READ @var{index_name} { FIRST | NEXT | PREV | LAST }\n    [ WHERE @var{where_condition} ] [LIMIT ... ]\nHANDLER @var{tbl_name} READ { FIRST | NEXT }\n    [ WHERE @var{where_condition} ] [LIMIT ... ]\nHANDLER @var{tbl_name} CLOSE"),(81,15,"LOCALTIMESTAMP","   LOCALTIMESTAMP\n   LOCALTIMESTAMP()\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for\nNOW().\n",""),(82,1,"SMALLINT","   SMALLINT[(@var{M})] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The\nunsigned range is 0 to 65535.\n",""),(83,18,"RELEASE_LOCK","   RELEASE_LOCK(@var{str})\nReleases the lock named by the string @var{str} that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the\nlock wasn't locked by this thread (in which case the lock is not released),\nand NULL if the named lock didn't exist.  The lock will not exist if\nit was never obtained by a call to GET_LOCK() or if it already has\nbeen released.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\nSee also : [DO,  , DO].\n",""),(84,10,"LOG2","   LOG2(@var{X})\nReturns the base-2 logarithm of @var{X}.\n","mysql> SELECT LOG2(65536);\n        -> 16.000000\nmysql> SELECT LOG2(-100);\n        -> NULL"),(85,5,"POLYFROMWKB","   PolyFromWKB(@var{wkb}[,@var{srid}])\n   PolygonFromWKB(@var{wkb}[,@var{srid}])\nConstructs a POLYGON value using its WKB representation and SRID.\n",""),(86,5,"GEOMCOLLFROMWKB","   GeomCollFromWKB(@var{wkb}[,@var{srid}])\n   GeometryCollectionFromWKB(@var{wkt}[,@var{srid}])\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and SRID.\n",""),(87,15,"FROM_UNIXTIME","   FROM_UNIXTIME(@var{unix_timestamp})\n   FROM_UNIXTIME(@var{unix_timestamp},@var{format})\nReturns a representation of the @var{unix_timestamp} argument as a value in\n'YYYY-MM-DD HH:MM:SS' or YYYYMMDDHHMMSS format, depending on\nwhether the function is used in a string or numeric context.\n\nmysql> SELECT FROM_UNIXTIME(875996580);\n        -> '1997-10-04 22:23:00'\nmysql> SELECT FROM_UNIXTIME(875996580) + 0;\n        -> 19971004222300\n\nIf @var{format} is given, the result is formatted according to the\n@var{format} string. @var{format} may contain the same specifiers as\nthose listed in the entry for the DATE_FORMAT() function.\n","mysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      '%Y %D %M %h:%i:%s %x');\n        -> '2003 6th August 06:22:58 2003'"),(88,15,"SUBTIME","   SUBTIME(@var{expr},@var{expr2})\n\n\nSUBTIME() subtracts @var{expr2} from @var{expr} and returns the result.\n@var{expr} is a time or datetime expression, and @var{expr2} is a time\nexpression.\n","mysql> SELECT SUBTIME('1997-12-31 23:59:59.999999',\n    ->                '1 1:1:1.000002');\n        -> '1997-12-30 22:58:58.999997'\nmysql> SELECT SUBTIME('01:00:00.999999', '02:00:00.999998');\n        -> '-00:59:59.999999'"),(89,1,"DOUBLE","   DOUBLE[(@var{M},@var{D})] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number.\nAllowable values are -1.7976931348623157E+308 to\n-2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308.  If\nUNSIGNED is specified, negative values are disallowed.\n@var{M} is the display width and @var{D} is the number of decimals.\nDOUBLE without arguments or FLOAT(@var{p)} (where\n@var{p} is in the\nrange from 25 to 53) stands for a double-precision floating-point number.\n\n   DOUBLE PRECISION[(@var{M},@var{D})] [UNSIGNED] [ZEROFILL]\n   REAL[(@var{M},@var{D})] [UNSIGNED] [ZEROFILL]\n\nThese are synonyms for DOUBLE.\nException: If the server SQL mode includes the REAL_AS_FLOAT option,\nREAL is a synonym for FLOAT rather than DOUBLE.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (90,10,"LN","   LN(@var{X})\nReturns the natural logarithm of @var{X}.\n","mysql> SELECT LN(2);\n        -> 0.693147\nmysql> SELECT LN(-2);\n        -> NULL"),(91,6,"MBRTOUCHES","   MBRTouches(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries @var{g1} and @var{g2} touch.\n",""),(92,20,"LAST_INSERT_ID","   LAST_INSERT_ID()\n   LAST_INSERT_ID(@var{expr})\nReturns the last automatically generated value that was inserted into\nan AUTO_INCREMENT column.\n","mysql> SELECT LAST_INSERT_ID();\n        -> 195"),(93,3,"ALTER VIEW","This statement changes the definition of an existing view.\n@var{select_statement} is as for CREATE VIEW.\nSee also : [CREATE VIEW,  , CREATE VIEW].\n","ALTER VIEW @var{view_name} [(@var{column_list})] AS @var{select_statement}"),(94,2,"MULTIPOINT","   MultiPoint(@var{pt1},@var{pt2},...)\nConstructs a WKB MultiPoint value using WKB Point arguments.\nIf any argument is not a WKB Point, the return value is NULL.\n",""),(95,11,"CONCAT_WS","   CONCAT_WS(@var{separator},@var{str1},@var{str2},...)\n\nCONCAT_WS() stands for CONCAT With Separator and is a special form of\nCONCAT().  The first argument is the separator for the rest of the\narguments.\nThe separator is added between the strings to be concatenated.\nThe separator can be a string as can the rest of the\narguments. If the separator is NULL, the result is NULL.\nThe function skips any NULL values after the\nseparator argument.\n","mysql> SELECT CONCAT_WS(',','First name','Second name','Last Name');\n        -> 'First name,Second name,Last Name'\nmysql> SELECT CONCAT_WS(',','First name',NULL,'Last Name');\n        -> 'First name,Last Name'"),(96,26,"LOAD DATA","The LOAD DATA INFILE statement reads rows from a text file into a\ntable at a very high speed.\nFor more information about the efficiency of INSERT versus\nLOAD DATA INFILE and speeding up LOAD DATA INFILE,\n[Insert speed].\n\nYou can also load data files by using the @command{mysqlimport} utility; it\noperates by sending a LOAD DATA INFILE statement to the server.  The\n--local option causes @command{mysqlimport} to read data files from the\nclient host.  You can specify the --compress option to get better\nperformance over slow networks if the client and server support the\ncompressed protocol.\nSee also : [mysqlimport,  , @command{mysqlimport]}.\n\nIf you specify the LOW_PRIORITY keyword, execution of the\nLOAD DATA statement is delayed until no other clients are reading\nfrom the table.\n\nIf you specify the CONCURRENT keyword with a MyISAM table that\nsatisfies the condition for concurrent inserts (that is, it contains no free\nblocks in the middle),\nthen other threads can retrieve data from the table while LOAD DATA\nis executing. Using this option affects the performance of LOAD DATA\na bit, even if no other thread is using the table at the same time.\n\nIf the LOCAL keyword is specified, it is\ninterpreted with respect to the client end of the connection:\n\n\n --- If LOCAL is specified, the file is read by the client program on the\nclient host and sent to the server.\n\n --- If LOCAL is not specified, the\nfile must be located on the server host and is read directly by the server.\n\n\nLOCAL is available in MySQL 3.22.6 or later.\n\nFor security reasons, when reading text files located on the server, the\nfiles must either reside in the database directory or be readable by all.\nAlso, to use LOAD DATA INFILE on server files, you must have the\nFILE privilege.\n","LOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE '@var{file_name}.txt'\n    [REPLACE | IGNORE]\n    INTO TABLE @var{tbl_name}\n    [FIELDS\n        [TERMINATED BY '\\t']\n        [[OPTIONALLY] ENCLOSED BY '']\n        [ESCAPED BY '\\\\' ]\n    ]\n    [LINES \n        [STARTING BY '']    \n        [TERMINATED BY '\\n']\n    ]\n    [IGNORE @var{number} LINES]\n    [(@var{col_name},...)]"),(97,10,"TRUNCATE","   TRUNCATE(@var{X},@var{D})\nReturns the number @var{X}, truncated to @var{D} decimals.  If @var{D}\nis 0, the result will have no decimal point or fractional part.\nIf @var{D} is negative, the integer part of the number is zeroed out.\n","mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100"),(98,10,"FLOOR","   FLOOR(@var{X})\nReturns the largest integer value not greater than @var{X}.\n","mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2"),(99,15,"GET_FORMAT","   GET_FORMAT(DATE|TIME|DATETIME, 'EUR'|'USA'|'JIS'|'ISO'|'INTERNAL')\nReturns a format string. This function is useful in combination with the \nDATE_FORMAT() and the STR_TO_DATE() functions.\nThe three possible values for the first argument \nand the five possible values for the second argument result in 15 possible \nformat strings (for the specifiers used, see the table in the \nDATE_FORMAT() function description).\n     Function Call 	 Result\n   GET_FORMAT(DATE,'USA') 	 '%m.%d.%Y'\n   GET_FORMAT(DATE,'JIS') 	 '%Y-%m-%d'\n   GET_FORMAT(DATE,'ISO') 	 '%Y-%m-%d'\n   GET_FORMAT(DATE,'EUR') 	 '%d.%m.%Y'\n   GET_FORMAT(DATE,'INTERNAL') 	 '%Y%m%d'\n   GET_FORMAT(DATETIME,'USA') 	 '%Y-%m-%d-%H.%i.%s'\n   GET_FORMAT(DATETIME,'JIS') 	 '%Y-%m-%d %H:%i:%s'\n   GET_FORMAT(DATETIME,'ISO') 	 '%Y-%m-%d %H:%i:%s'\n   GET_FORMAT(DATETIME,'EUR') 	 '%Y-%m-%d-%H.%i.%s'\n   GET_FORMAT(DATETIME,'INTERNAL') 	 '%Y%m%d%H%i%s'\n   GET_FORMAT(TIME,'USA') 	 '%h:%i:%s %p'\n   GET_FORMAT(TIME,'JIS') 	 '%H:%i:%s'\n   GET_FORMAT(TIME,'ISO') 	 '%H:%i:%s'\n   GET_FORMAT(TIME,'EUR') 	 '%H.%i.%S'\n   GET_FORMAT(TIME,'INTERNAL') 	 '%H%i%s'\n  \nISO format is ISO 9075, not ISO 8601.\n\nAs of MySQL 4.1.4, TIMESTAMP can also be used;\nGET_FORMAT() returns the same values as for DATETIME.\n","mysql> SELECT DATE_FORMAT('2003-10-03',GET_FORMAT(DATE,'EUR'));\n        -> '03.10.2003'\nmysql> SELECT STR_TO_DATE('10.31.2003',GET_FORMAT(DATE,'USA'));\n        -> 2003-10-31\n@c Following is commented out because not yet implemented\n@c mysql> SET DATE_FORMAT=GET_FORMAT(DATE, 'USA'); SELECT '2003-10-31';\n@c         -> 10-31-2003"),(100,11,"LOCATE","   LOCATE(@var{substr},@var{str})\n   LOCATE(@var{substr},@var{str},@var{pos})\n\nThe first syntax\nreturns the position of the first occurrence of substring @var{substr}\nin string @var{str}.\nThe second syntax\nreturns the position of the first occurrence of substring @var{substr} in\nstring @var{str}, starting at position @var{pos}.\nReturns 0 if @var{substr} is not in @var{str}.\n",""),(101,4,">=","   >=\nGreater than or equal:\n","mysql> SELECT 2 >= 2;\n        -> 1"),(102,28,">>","   >>\nShifts a longlong (BIGINT) number to the right.\n","mysql> SELECT 4 >> 2;\n        -> 1"),(103,10,"CEILING","   CEILING(@var{X})\n   CEIL(@var{X})\nReturns the smallest integer value not less than @var{X}.\n","mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEIL(-1.23);\n        -> -1"),(104,14,"IFNULL","   IFNULL(@var{expr1},@var{expr2})\nIf @var{expr1} is not NULL, IFNULL() returns @var{expr1},\nelse it returns @var{expr2}.  IFNULL() returns a numeric or string\nvalue, depending on the context in which it is used.\n","mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,'yes');\n        -> 'yes'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (105,28,"|","   |\nBitwise OR:\n","mysql> SELECT 29 | 15;\n        -> 31"),(106,13,"ISSIMPLE","   IsSimple(@var{g})\n\nCurrently, this function is a placeholder and should not be used.\nIf implemented, its behavior will be as described in the next paragraph.\n\nReturns 1 if the geometry value @var{g} has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and @minus{}1 if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple.\n",""),(107,17,"MLINEFROMTEXT","   MLineFromText(@var{wkt}[,@var{srid}])\n   MultiLineStringFromText(@var{wkt}[,@var{srid}])\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n",""),(108,3,"CREATE VIEW","This statement creates a new view, or replaces an existing one if the\nOR REPLACE clause is given. The @var{select_statement} is a\nSELECT statement that provides the definition of the view.\nThe optional column list can be given to define explicit names for the\nview columns.\n\nWITH CHECK OPTION, if given, is parsed and ignored.\n",""),(109,11,"CHAR FUNCTION","   CHAR(@var{N},...)\nCHAR() interprets the arguments as integers and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\n","mysql> SELECT CHAR(77,121,83,81,'76');\n        -> 'MySQL'\nmysql> SELECT CHAR(77,77.3,'77.3');\n        -> 'MMM'"),(110,10,"DEGREES","   DEGREES(@var{X})\nReturns the argument @var{X}, converted from radians to degrees.\n","mysql> SELECT DEGREES(PI());\n        -> 180.000000"),(111,28,"~","   ~\nInvert all bits.\n","mysql> SELECT 5 & ~1;\n        -> 4"),(112,15,"ADDDATE","   ADDDATE(@var{date},INTERVAL @var{expr} @var{type})\n   ADDDATE(@var{expr},@var{days})\n\nWhen invoked with the INTERVAL form of the second argument,\nADDDATE() is a synonym for DATE_ADD().  The related\nfunction SUBDATE() is a synonym for DATE_SUB().\nFor information on the INTERVAL argument, see the\ndiscussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD('1998-01-02', INTERVAL 31 DAY);\n        -> '1998-02-02'\nmysql> SELECT ADDDATE('1998-01-02', INTERVAL 31 DAY);\n        -> '1998-02-02'\n\nAs of MySQL 4.1.1, the second syntax is allowed, where @var{expr} is a date\nor datetime expression and @var{days} is the number of days to be added to\n@var{expr}.\n\nmysql> SELECT ADDDATE('1998-01-02', 31);\n        -> '1998-02-02'\n",""),(113,25,"OVERLAPS","   Overlaps(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} spatially overlaps\n@var{g2}.\nThe term /spatially overlaps/ is used if two\ngeometries intersect and their intersection results in a geometry of the\nsame dimension but not equal to either of the given geometries.\n",""),(114,25,"EQUALS","   Equals(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} is spatially equal to\n@var{g2}.\n",""),(115,10,"ACOS","   ACOS(@var{X})\nReturns the arc cosine of @var{X}, that is, the value whose cosine is\n@var{X}. Returns NULL if @var{X} is not in the range -1 to\n1.\n","mysql> SELECT ACOS(1);\n        -> 0.000000\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.570796"),(116,11,"LEFT","   LEFT(@var{str},@var{len})\nReturns the leftmost @var{len} characters from the string @var{str}.\n","mysql> SELECT LEFT('foobarbar', 5);\n        -> 'fooba'"),(117,26,"RESET MASTER","RESET MASTER\n\nDeletes all binary logs listed in the index file,\nresets the binary log index file to be empty, and creates a new binary log\nfile.\n\nThis statement was named FLUSH MASTER before MySQL 3.23.26.\n",""),(118,11,"LENGTH","   LENGTH(@var{str})\nReturns the length of the string @var{str}, measured in bytes.\nA multi-byte character counts as multiple bytes.\nThis means that for a string containing five two-byte characters,\nLENGTH() returns 10, whereas CHAR_LENGTH() returns\n5.\n","mysql> SELECT LENGTH('text');\n        -> 4"),(119,11,"LTRIM","   LTRIM(@var{str})\nReturns the string @var{str} with leading space characters removed.\n","mysql> SELECT LTRIM('  barbar');\n        -> 'barbar'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (120,4,"NOT BETWEEN","   @var{expr} NOT BETWEEN @var{min} AND @var{max}\nThis is the same as NOT (@var{expr BETWEEN @var{min} AND @var{max})}.\n",""),(121,1,"NUMERIC","   DECIMAL[(@var{M}[,@var{D}])] [UNSIGNED] [ZEROFILL]\n\nAn unpacked fixed-point number.  Behaves like a CHAR column;\n``unpacked'' means the number is stored as a string, using one character for\neach digit of the value.  @var{M} is the total number of digits and\n@var{D} is the number of decimals.  The decimal point and (for negative\nnumbers) the - sign are not counted in @var{M}, although space for\nthem is reserved. If @var{D} is 0, values have no decimal point or\nfractional part.  The maximum range of DECIMAL values is the same as\nfor DOUBLE, but the actual range for a given DECIMAL column\nmay be constrained by the choice of @var{M} and @var{D}.  If\nUNSIGNED is specified, negative values are disallowed.\n\nIf @var{D} is omitted, the default is 0.  If @var{M} is omitted, the\ndefault is 10.\n\nPrior to MySQL 3.23, the @var{M} argument must be large enough to\ninclude the space needed for the sign and the decimal point.\n\n   DEC[(@var{M}[,@var{D}])] [UNSIGNED] [ZEROFILL]\n   NUMERIC[(@var{M}[,@var{D}])] [UNSIGNED] [ZEROFILL]\n   FIXED[(@var{M}[,@var{D}])] [UNSIGNED] [ZEROFILL]\n\nThese are synonyms for DECIMAL.\n\nThe FIXED synonym was added in MySQL 4.1.0 for compatibility\nwith other servers.\n",""),(122,10,"ATAN2","   ATAN(@var{Y},@var{X})\n   ATAN2(@var{Y},@var{X})\nReturns the arc tangent of the two variables @var{X} and @var{Y}. It is\nsimilar to calculating the arc tangent of @var{Y / @var{X}}, except that the\nsigns of both arguments are used to determine the quadrant of the\nresult.\n","mysql> SELECT ATAN(-2,2);\n        -> -0.785398\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.570796"),(123,26,"RESET","The RESET statement is used to clear the state of various server\noperations. It also acts as a stronger\nversion of the FLUSH statement.  See also : [FLUSH, , FLUSH].\n","RESET @var{reset_option} [, @var{reset_option}] ..."),(124,17,"MPOLYFROMTEXT","   MPolyFromText(@var{wkt}[,@var{srid}])\n   MultiPolygonFromText(@var{wkt}[,@var{srid}])\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n",""),(125,23,"START TRANSACTION","By default, MySQL runs with autocommit mode enabled. This means that\nas soon as you execute a statement that updates (modifies) a table,\nMySQL stores the update on disk.\n\nIf you are using transaction-safe tables (like InnoDB or BDB),\nyou can disable autocommit mode with the following statement:\n\nSET AUTOCOMMIT=0;\n\nAfter disabling autocommit mode by setting the AUTOCOMMIT variable to\nzero, you must use COMMIT to store your changes to disk or\nROLLBACK if you want to ignore the changes you have made since\nthe beginning of your transaction.\n\nIf you want to disable autocommit mode for a single series of\nstatements, you can use the START TRANSACTION statement:\n","START TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;"),(126,15,"DAYOFMONTH","   DAYOFMONTH(@var{date})\nReturns the day of the month for @var{date}, in the range 1 to\n31.\n","mysql> SELECT DAYOFMONTH('1998-02-03');\n        -> 3"),(127,10,"RAND","   RAND()\n   RAND(@var{N})\nReturns a random floating-point value in the range from 0 to 1.0.\nIf an integer argument @var{N} is specified, it is used as the seed value\n(producing a repeatable sequence).\n","mysql> SELECT RAND();\n        -> 0.9233482386203\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND(20);\n        -> 0.15888261251047\nmysql> SELECT RAND();\n        -> 0.63553050033332\nmysql> SELECT RAND();\n        -> 0.70100469486881"),(128,11,"CONV","   CONV(@var{N},@var{from_base},@var{to_base})\nConverts numbers between different number bases.  Returns a string\nrepresentation of the number @var{N}, converted from base @var{from_base}\nto base @var{to_base}.  Returns NULL if any argument is NULL.\nThe argument @var{N} is interpreted as an integer, but may be specified as\nan integer or a string.  The minimum base is 2 and the maximum base is\n36.  If @var{to_base} is a negative number, @var{N} is regarded as a\nsigned number.  Otherwise, @var{N} is treated as unsigned.  CONV() works\nwith 64-bit precision.\n","mysql> SELECT CONV('a',16,2);\n        -> '1010'\nmysql> SELECT CONV('6E',18,8);\n        -> '172'\nmysql> SELECT CONV(-17,10,-18);\n        -> '-H'\nmysql> SELECT CONV(10+'10'+'10'+0xa,10,10);\n        -> '40'"),(129,11,"REPLACE","   REPLACE(@var{str},@var{from_str},@var{to_str})\nReturns the string @var{str} with all occurrences of the string\n@var{from_str} replaced by the string @var{to_str}.\n","mysql> SELECT REPLACE('www.mysql.com', 'w', 'Ww');\n        -> 'WwWwWw.mysql.com'"),(130,1,"FLOAT","   FLOAT(@var{p}) [UNSIGNED] [ZEROFILL]\n\nA floating-point number.  @var{p} represents the precision. It can be from\n0 to 24 for a single-precision floating-point number and from 25 to 53 for a\ndouble-precision floating-point number. These types are like the FLOAT\nand DOUBLE types described immediately following.  FLOAT(p)\nhas the same range as the corresponding FLOAT and DOUBLE\ntypes, but the display width and number of decimals are undefined.\n\nAs of MySQL 3.23, this is a true floating-point value.  In\nearlier MySQL versions, FLOAT(@var{p)} always has two decimals.\n\nThis syntax is provided for ODBC compatibility.\n\nUsing FLOAT might give you some unexpected problems because\nall calculations in MySQL are done with double precision.\nSee also : [No matching rows].\n\n   FLOAT[(@var{M},@var{D})] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number.  Allowable values are\n-3.402823466E+38 to -1.175494351E-38, 0,\nand 1.175494351E-38 to 3.402823466E+38.  If\nUNSIGNED is specified, negative values are disallowed.  @var{M}\nis the display width and @var{D} is the number of decimals.  FLOAT\nwithout arguments or FLOAT(@var{p)} (where @var{p} is in the range from\n0 to 24) stands for a single-precision floating-point number.\n",""),(131,1,"ENUM","   ENUM('@var{value1}','@var{value2}',...)\n\nAn enumeration.  A string object that can have only one value, chosen\nfrom the list of values '@var{value1'}, '@var{value2'}, ...,\nNULL or the special '' error value.  An ENUM column can\nhave a maximum of 65,535 distinct values.\nENUM values are represented internally as integers.\n",""),(132,21,"STARTPOINT","   StartPoint(@var{ls})\nReturns the Point that is the start point of the LineString value\n@var{ls}.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+"),(133,17,"GEOMFROMTEXT","   GeomFromText(@var{wkt}[,@var{srid}])\n   GeometryFromText(@var{wkt}[,@var{srid}])\nConstructs a geometry value of any type using its WKT representation and SRID.\n",""),(134,18,"INET_NTOA","   INET_NTOA(@var{expr})\nGiven a numeric network address (4 or 8 byte), returns the dotted-quad\nrepresentation of the address as a string.\n","mysql> SELECT INET_NTOA(3520061480);\n        -> '209.207.224.40'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (135,20,"COLLATION","   COLLATION(@var{str})\nReturns the collation for the character set of the string argument.\n","mysql> SELECT COLLATION('abc');\n        -> 'latin1_swedish_ci'\nmysql> SELECT COLLATION(_utf8'abc');\n        -> 'utf8_general_ci'"),(136,4,"!=","   <>\n   !=\nNot equal:\n","mysql> SELECT '.01' <> '0.01';\n        -> 1\nmysql> SELECT .01 <> '0.01';\n        -> 0\nmysql> SELECT 'zapp' <> 'zappp';\n        -> 1"),(137,11,"RPAD","   RPAD(@var{str},@var{len},@var{padstr})\nReturns the string @var{str}, right-padded with the string @var{padstr}\nto a length of @var{len} characters. If @var{str} is longer\nthan @var{len}, the return value is shortened to @var{len} characters.\n","mysql> SELECT RPAD('hi',5,'?');\n        -> 'hi???'\nmysql> SELECT RPAD('hi',1,'?');\n        -> 'h'"),(138,1,"DATE","A date.  The supported range is '1000-01-01' to '9999-12-31'.\nMySQL displays DATE values in 'YYYY-MM-DD' format, but\nallows you to assign values to DATE columns using either strings or\nnumbers.\n",""),(139,21,"ENDPOINT","   EndPoint(@var{ls})\nReturns the Point that is the end point of the LineString value\n@var{ls}.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+"),(140,5,"POINTFROMWKB","   PointFromWKB(@var{wkb}[,@var{srid}])\nConstructs a POINT value using its WKB representation and SRID.\n",""),(141,11,"CHARACTER_LENGTH","   CHARACTER_LENGTH(@var{str})\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n",""),(142,15,"DAYOFYEAR","   DAYOFYEAR(@var{date})\nReturns the day of the year for @var{date}, in the range 1 to\n366.\n","mysql> SELECT DAYOFYEAR('1998-02-03');\n        -> 34"),(143,11,"EXPORT_SET","   EXPORT_SET(@var{bits},@var{on},@var{off}[,@var{separator}[,@var{number_of_bits}]])\nReturns a string in which for every bit set in the value @var{bits}, you\nget an @var{on} string and for every reset bit you get an @var{off}\nstring.  Bits in @var{bits} are examined from right to left (from low-order\nto high-order bits). Strings are added to the result from left to right,\nseparated by the @var{separator} string (default ,). The number of\nbits examined is given by @var{number_of_bits} (default 64).\n","mysql> SELECT EXPORT_SET(5,'Y','N',',',4);\n        -> 'Y,N,Y,N'\nmysql> SELECT EXPORT_SET(6,'1','0',',',10);\n        -> '0,1,1,0,0,0,0,0,0,0'"),(144,11,"LIKE","   @var{expr} LIKE @var{pat} [ESCAPE '@var{escape-char}']\nPattern matching using\nSQL simple regular expression comparison. Returns 1 (TRUE) or 0\n(FALSE).  If either @var{expr} or @var{pat} is NULL, the result is\nNULL.\n\nWith LIKE you can use the following two wildcard characters\nin the pattern:\n\n     Character 	 Description\n   % 	 Matches any number of characters, even zero characters\n   _ 	 Matches exactly one character\n  \n","mysql> SELECT 'David!' LIKE 'David_';\n        -> 1\nmysql> SELECT 'David!' LIKE '%D%v%';\n        -> 1"),(145,1,"MEDIUMBLOB","   MEDIUMBLOB\n   MEDIUMTEXT\n\nA BLOB or TEXT column with a maximum length of 16,777,215\n(2^24 @minus{} 1) characters.\n",""),(146,11,"MAKE_SET","   MAKE_SET(@var{bits},@var{str1},@var{str2},...)\nReturns a set value (a string containing substrings separated by ,\ncharacters) consisting of the strings that have the corresponding bit in\n@var{bits} set.  @var{str1} corresponds to bit 0, @var{str2} to bit 1,\nand so on.  NULL values in @var{str1}, @var{str2}, ...\nare not appended to the result.\n","mysql> SELECT MAKE_SET(1,'a','b','c');\n        -> 'a'\nmysql> SELECT MAKE_SET(1 | 4,'hello','nice','world');\n        -> 'hello,world'\nmysql> SELECT MAKE_SET(1 | 4,'hello','nice',NULL,'world');\n        -> 'hello'\nmysql> SELECT MAKE_SET(0,'a','b','c');\n        -> ''"),(147,20,"USER","   USER()\n\nReturns the current MySQL username and hostname.\n","mysql> SELECT USER();\n        -> 'davida@localhost'"),(148,19,"GRANT TYPES","For the GRANT and REVOKE statements, priv_type can be\nspecified as any of the following:\n\n     Privilege 	 Meaning\n   ALL [PRIVILEGES] 	 Sets all simple privileges except GRANT OPTION\n   ALTER  	 Allows use of ALTER TABLE\n   CREATE 	 Allows use of CREATE TABLE\n   CREATE TEMPORARY TABLES 	 Allows use of CREATE TEMPORARY TABLE\n   CREATE VIEW 	 Allows use of CREATE VIEW\n   DELETE 	 Allows use of DELETE\n   DROP 	 Allows use of DROP TABLE\n   EXECUTE 	 Allows the user to run stored procedures (MySQL 5.0)\n   FILE 	 Allows use of SELECT ... INTO OUTFILE and LOAD DATA INFILE\n   INDEX 	 Allows use of CREATE INDEX and DROP INDEX\n   INSERT 	 Allows use of INSERT\n   LOCK TABLES 	 Allows use of LOCK TABLES on tables for which you have the SELECT privilege\n   PROCESS 	 Allows use of SHOW FULL PROCESSLIST\n   REFERENCES 	 Not yet implemented\n   RELOAD 	 Allows use of FLUSH\n   REPLICATION CLIENT 	 Allows the user to ask where the slave or master servers are\n   REPLICATION SLAVE 	 Needed for replication slaves (to read binary log events from the master)\n   SELECT 	 Allows use of SELECT\n   SHOW DATABASES 	 SHOW DATABASES shows all databases\n   SHOW VIEW 	 Allows use of SHOW CREATE VIEW\n   SHUTDOWN 	 Allows use of @command{mysqladmin shutdown}\n   SUPER 	 Allows use of CHANGE MASTER, KILL,\nPURGE MASTER LOGS, and SET GLOBAL statements, the @command{mysqladmin debug} command; allows you to connect (once) even if max_connections is reached\n   UPDATE 	 Allows use of UPDATE\n   USAGE 	 Synonym for ``no privileges''\n   GRANT OPTION 	 Allows privileges to be granted\n  \n",""),(149,26,"UNION","UNION is used to combine the result from many SELECT\nstatements into one result set.  UNION is available from MySQL 4.0.0\non.\n\nSelected columns listed in corresponding positions of each SELECT\nstatement should have the same type. (For example, the first column selected\nby the first statement should have the same type as the first column selected\nby the other statements.) The column names used in\nthe first SELECT statement are used as the column names for the\nresults returned.\n","SELECT ...\nUNION [ALL | DISTINCT]\nSELECT ...\n  [UNION [ALL | DISTINCT]\n   SELECT ...]");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (150,1,"BLOB","A BLOB is a binary large object that can hold a variable amount of\ndata.  The four BLOB types, TINYBLOB, BLOB,\nMEDIUMBLOB, and LONGBLOB, differ only in the maximum length of\nthe values they can hold.\n",""),(151,1,"DATETIME","A date and time combination.  The supported range is '1000-01-01\n00:00:00' to '9999-12-31 23:59:59'.  MySQL displays\nDATETIME values in 'YYYY-MM-DD HH:MM:SS' format, but allows you\nto assign values to DATETIME columns using either strings or numbers.\n",""),(152,25,"RELATED","   Related(@var{g1},@var{g2},@var{pattern_matrix})\nReturns 1 or 0 to indicate whether or not the spatial relationship specified\nby @var{pattern_matrix} exists between @var{g1} and @var{g2}.\nReturns @minus{}1 if the arguments are NULL.\nThe pattern matrix is a string. Its specification will be noted here if this\nfunction is implemented.\n",""),(153,10,"EXP","   EXP(@var{X})\nReturns the value of e (the base of natural logarithms) raised to\nthe power of @var{X}.\n","mysql> SELECT EXP(2);\n        -> 7.389056\nmysql> SELECT EXP(-2);\n        -> 0.135335"),(154,18,"INET_ATON","   INET_ATON(@var{expr})\nGiven the dotted-quad representation of a network address as a string,\nreturns an integer that represents the numeric value of the address.\nAddresses may be 4- or 8-byte addresses.\n","mysql> SELECT INET_ATON('209.207.224.40');\n        -> 3520061480"),(155,5,"GEOMFROMWKB","   GeomFromWKB(@var{wkb}[,@var{srid}])\n   GeometryFromWKB(@var{wkt}[,@var{srid}])\nConstructs a geometry value of any type using its WKB representation and SRID.\n",""),(156,25,"DISJOINT","   Disjoint(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} is spatially disjoint\nfrom (does not intersect) @var{g2}.\n",""),(157,3,"CREATE DATABASE","CREATE DATABASE creates a database with the given name.  \nTo use CREATE DATABASE, you need the CREATE privilege on the\ndatabase.\n","CREATE {DATABASE | SCHEMA} [IF NOT EXISTS] @var{db_name}\n    [@var{create_specification} [, @var{create_specification}] ...]\n\n@var{create_specification}:\n    [DEFAULT] CHARACTER SET @var{charset_name}\n  | [DEFAULT] COLLATE @var{collation_name}"),(158,10,"COS","   COS(@var{X})\nReturns the cosine of @var{X}, where @var{X} is given in radians.\n","mysql> SELECT COS(PI());\n        -> -1.000000"),(159,10,"CRC32","   CRC32(@var{expr})\nComputes a cyclic redundancy check value and returns a 32-bit unsigned value.\nThe result is NULL if the argument is NULL.\nThe argument is expected be a string and will be treated as one if it is not.\n","mysql> SELECT CRC32('MySQL');\n        -> 3259397556"),(160,2,"GEOMETRYCOLLECTION","   GeometryCollection(@var{g1},@var{g2},...)\nConstructs a WKB GeometryCollection. If any argument is not a\nwell-formed WKB representation of a geometry, the return value is\nNULL.\n",""),(161,18,"FORMAT","   FORMAT(@var{X},@var{D})\nFormats the number @var{X} to a format like '#,###,###.##', rounded\nto @var{D} decimals, and returns the result as a string.\nIf @var{D} is 0, the result will have no\ndecimal point or fractional part.\n","mysql> SELECT FORMAT(12332.123456, 4);\n        -> '12,332.1235'\nmysql> SELECT FORMAT(12332.1,4);\n        -> '12,332.1000'\nmysql> SELECT FORMAT(12332.2,0);\n        -> '12,332'"),(162,11,"COMPRESS","   COMPRESS(@var{string_to_compress})\nCompresses a string. This function requires MySQL to have been compiled\nwith a compression library such as zlib. Otherwise, the return\nvalue is always NULL. The compressed string can be uncompressed with\nUNCOMPRESS().\n","mysql> SELECT LENGTH(COMPRESS(REPEAT('a',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(''));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS('a'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT('a',16)));\n        -> 15"),(163,10,"COT","   COT(@var{X})\nReturns the cotangent of @var{X}.\n","mysql> SELECT COT(12);\n        -> -1.57267341\nmysql> SELECT COT(0);\n        -> NULL"),(164,15,"FROM_DAYS","   FROM_DAYS(@var{N})\nGiven a daynumber @var{N}, returns a DATE value.\n","mysql> SELECT FROM_DAYS(729669);\n        -> '1997-10-07'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (165,4,"INTERVAL","   INTERVAL(@var{N},@var{N1},@var{N2},@var{N3},...)\nReturns 0 if @var{N} < @var{N1}, 1 if @var{N} < @var{N2}\nand so on or -1 if @var{N} is NULL. All arguments are treated\nas integers.  It is required that @var{N1} < @var{N2} < @var{N3} < \n... < @var{Nn} for this function to work correctly. This is because\na binary search is used (very fast).\n","mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0"),(166,19,"GRANT","The GRANT and REVOKE statements allow system administrators to\ncreate MySQL user accounts and to grant rights to and revoke them from\naccounts.  GRANT and REVOKE are implemented in MySQL 3.22.11\nor later. For earlier MySQL versions, these statements do nothing.\n\nMySQL account information is stored in the tables of the mysql\ndatabase. This database and the access control system are discussed\nextensively in [MySQL Database Administration], which you should consult\nfor additional details.\n\nPrivileges can be granted at four levels:\n\n   Global level\nGlobal privileges apply to all databases on a given server. These privileges\nare stored in the mysql.user table.\nGRANT ALL ON *.* and\nREVOKE ALL ON *.* grant and revoke only global privileges.\n\n   Database level\nDatabase privileges apply to all tables in a given database. These privileges\nare stored in the mysql.db and mysql.host tables.\nGRANT ALL ON @var{db_name.*} and\nREVOKE ALL ON @var{db_name.*} grant and revoke only database privileges.\n\n   Table level\nTable privileges apply to all columns in a given table. These privileges are\nstored in the mysql.tables_priv table.\nGRANT ALL ON @var{db_name.tbl_name} and\nREVOKE ALL ON @var{db_name.tbl_name} grant and revoke only table privileges.\n\n   Column level\nColumn privileges apply to single columns in a given table. These privileges are\nstored in the mysql.columns_priv table.\nWhen using REVOKE, you must specify the same columns that were granted.\n  \n","GRANT @var{priv_type} [(@var{column_list})] [, @var{priv_type} [(@var{column_list})]] ...\n    ON {@var{tbl_name} | * | *.* | @var{db_name}.*}\n    TO @var{user} [IDENTIFIED BY [PASSWORD] '@var{password}']\n        [, @var{user} [IDENTIFIED BY [PASSWORD] '@var{password}']] ...\n    [REQUIRE\n        NONE |\n        [{SSL| X509}]\n        [CIPHER '@var{cipher}' [AND]]\n        [ISSUER '@var{issuer}' [AND]]\n        [SUBJECT '@var{subject}']]\n    [WITH [GRANT OPTION | MAX_QUERIES_PER_HOUR @var{count} |\n                          MAX_UPDATES_PER_HOUR @var{count} |\n                          MAX_CONNECTIONS_PER_HOUR @var{count}]]"),(167,26,"INSERT DELAYED","The DELAYED option for the INSERT statement is a\nMySQL extension to standard SQL that is very useful if you have clients\nthat can't wait for the INSERT to complete.  This is a common\nproblem when you use MySQL for logging and you also\nperiodically run SELECT and UPDATE statements that take a\nlong time to complete.  DELAYED was introduced in MySQL\n3.22.15.\n\nWhen a client uses INSERT DELAYED, it gets an okay from the server at\nonce, and the row is queued to be inserted when the table is not in use by\nany other thread.\n\nAnother major benefit of using INSERT DELAYED is that inserts\nfrom many clients are bundled together and written in one block. This is much\nfaster than doing many separate inserts.\n\nThere are some constraints on the use of DELAYED:\n\n\n --- INSERT DELAYED works only with MyISAM and ISAM\ntables.\nAs of MySQL 4.0.14, it also works with InnoDB tables.\nFor MyISAM tables, if there are no free blocks in the middle of the\ndata file, concurrent SELECT and INSERT statements are supported.\nUnder these circumstances, you very seldom need to use INSERT\nDELAYED with MyISAM. See also : [MyISAM].\n\n --- INSERT DELAYED should be used only for INSERT statements that\nspecify value lists. This is enforced as of MySQL 4.0.18.  The server ignores\nDELAYED for INSERT DELAYED ... SELECT statements.\n\n --- The server ignores\nDELAYED for INSERT DELAYED ... ON DUPLICATE UPDATE statements.\n\n --- Because the statement returns immediately before the rows are inserted,\nyou cannot use LAST_INSERT_ID() to get the AUTO_INCREMENT\nvalue the statement might generate.\n\n --- DELAYED rows are not visible to SELECT statements until they\nactually have been inserted.\n","INSERT DELAYED ..."),(168,15,"WEEK","   WEEK(@var{date}[,@var{mode}])\nThe function returns the week number for @var{date}.  The two-argument form\nof WEEK() allows you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to\n53 or from 1 to 52. If the @var{mode} argument is\nomitted, the value of the default_week_format system variable is\nused (or 0 before MySQL 4.0.14).\nSee also : [Server system variables].\n\nThe following table describes how the @var{mode} argument works:\n\n     Value 	 Meaning\n   0 	 Week starts on Sunday; return value range is 0 to\n53; week 1 is the first week that starts in this year\n   1 	 Week starts on Monday; return value range is 0 to\n53; week 1 is the first week that has more than three days in this year\n   2 	 Week starts on Sunday; return value range is 1 to\n53; week 1 is the first week that starts in this year\n   3 	 Week starts on Monday; return value range is 1 to\n53; week 1 is the first week that has more than three days in this year\n   4 	 Week starts on Sunday; return value range is 0 to\n53; week 1 is the first week that has more than three days in this year\n   5 	 Week starts on Monday; return value range is 0 to\n53; week 1 is the first week that starts in this year\n   6 	 Week starts on Sunday; return value range is 1 to\n53; week 1 is the first week that has more than three days in this year\n   7 	 Week starts on Monday; return value range is 1 to\n53; week 1 is the first week that starts in this year\n  \n\nThe @var{mode} value of 3 can be used as of MySQL 4.0.5.\nValues of 4 and above can be used as of MySQL 4.0.17.\n","mysql> SELECT WEEK('1998-02-20');\n        -> 7\nmysql> SELECT WEEK('1998-02-20',0);\n        -> 7\nmysql> SELECT WEEK('1998-02-20',1);\n        -> 8\nmysql> SELECT WEEK('1998-12-31',1);\n        -> 53"),(169,15,"TO_DAYS","   TO_DAYS(@var{date})\nGiven a date @var{date}, returns a daynumber (the number of days since year\n0).\n","mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS('1997-10-07');\n        -> 729669"),(170,19,"CHECKSUM","\nReports a table checksum.\n\nIf QUICK is specified, the live table checksum is reported if it is\navailable, or NULL otherwise.  This is very fast.  A live checksum\nis enabled by specifying the CHECKSUM=1 table option, currently\nsupported only for MyISAM tables.\nSee also : [CREATE TABLE,  , CREATE TABLE].\n\nIn EXTENDED mode the whole table is read row by row and the checksum\nis calculated. This can be very slow for large tables.\n\nBy default, if neither QUICK nor EXTENDED is specified, MySQL\nreturns a live checksum if the table storage engine supports it and scans\nthe table otherwise.\n\nThis statement is implemented in MySQL 4.1.1.\n\n\n  @subsubsection OPTIMIZE TABLE Syntax\n\n\n\n\nOPTIMIZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE @var{tbl_name} [, @var{tbl_name}] ...\n\nOPTIMIZE TABLE should be used if you have deleted a large part of a\ntable or if you have made many changes to a table with variable-length rows\n(tables that have VARCHAR, BLOB, or TEXT columns).\nDeleted records are maintained in a linked list and subsequent INSERT\noperations reuse old record positions. You can use OPTIMIZE TABLE to\nreclaim the unused space and to defragment the data file.\n","CHECKSUM TABLE @var{tbl_name} [, @var{tbl_name}] ... [ QUICK | EXTENDED ]"),(171,15,"TIME FUNCTION","   TIME(@var{expr})\n\nExtracts the time part of the time or datetime expression @var{expr}.\n","mysql> SELECT TIME('2003-12-31 01:02:03');\n        -> '01:02:03'\nmysql> SELECT TIME('2003-12-31 01:02:03.000123');\n        -> '01:02:03.000123'"),(172,11,"RLIKE","   @var{expr} REGEXP @var{pat}\n   @var{expr} RLIKE @var{pat}\nPerforms a pattern match of a string expression @var{expr} against a pattern\n@var{pat}.  The pattern can be an extended regular expression.\nThe syntax for regular expressions is discussed in\n[Regexp].  Returns 1 if @var{expr} matches @var{pat}, otherwise\nreturns 0.  If either @var{expr} or @var{pat} is NULL,\nthe result is NULL.  RLIKE is a synonym for REGEXP,\nprovided for\nmSQL compatibility. Note: Because MySQL uses the C escape\nsyntax in strings (for example, \\n to represent newline), you must double any \\ that\nyou use in your REGEXP strings.  As of MySQL 3.23.4,\nREGEXP is not case sensitive for normal (not binary) strings.\n","mysql> SELECT 'Monty!' REGEXP 'm%y%%';\n        -> 0\nmysql> SELECT 'Monty!' REGEXP '.*';\n        -> 1\nmysql> SELECT 'new*\\n*line' REGEXP 'new\\\\*.\\\\*line';\n        -> 1\nmysql> SELECT 'a' REGEXP 'A', 'a' REGEXP BINARY 'A';\n        -> 1  0\nmysql> SELECT 'a' REGEXP '^[a-d]';\n        -> 1"),(173,15,"PERIOD_ADD","   PERIOD_ADD(@var{P},@var{N})\nAdds @var{N} months to period @var{P} (in the format YYMM or\nYYYYMM). Returns a value in the format YYYYMM.\nNote that the period argument @var{P} is /not/ a date value.\n","mysql> SELECT PERIOD_ADD(9801,2);\n        -> 199803"),(174,20,"FOUND_ROWS","\nA SELECT statement may include a LIMIT clause to restrict the\nnumber of rows the server returns to the client.\nIn some cases, it is desirable to know how many rows the statement would have\nreturned without the LIMIT, but without running the statement again.\nTo get this row count, include a SQL_CALC_FOUND_ROWS option in the\nSELECT statement, then invoke FOUND_ROWS() afterward:\n","mysql> SELECT SQL_CALC_FOUND_ROWS * FROM @var{tbl_name}\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();"),(175,17,"POINTFROMTEXT","   PointFromText(@var{wkt}[,@var{srid}])\nConstructs a POINT value using its WKT representation and SRID.\n",""),(176,22,"BIT_AND","   BIT_AND(@var{expr})\nReturns the bitwise AND of all bits in @var{expr}. The calculation is\nperformed with 64-bit (BIGINT) precision.\n","mysql> SELECT order.custid, customer.name, MAX(payments)\n    ->        FROM order,customer\n    ->        WHERE order.custid = customer.custid\n    ->        GROUP BY order.custid;"),(177,15,"MICROSECOND","   MICROSECOND(@var{expr})\n\nReturns the microseconds from the time or datetime expression @var{expr} as a\nnumber in the range from 0 to 999999.\n","mysql> SELECT MICROSECOND('12:00:00.123456');\n        -> 123456\nmysql> SELECT MICROSECOND('1997-12-31 23:59:59.000010');\n        -> 10"),(178,4,"IS NULL","   IS NULL\n   IS NOT NULL\nTests whether a value is or is not NULL.\n","mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\nmysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0"),(179,17,"WKT DEFINITION","The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (180,26,"SET SQL_LOG_BIN","SET SQL_LOG_BIN = {0|1}\n\nDisables or enables binary logging for the current connection \n(SQL_LOG_BIN is a session variable)\nif the client connects using an account that has the SUPER privilege.\nThe statement is refused with an error if the client does not have that\nprivilege. (Before MySQL 4.1.2, the statement was simply ignored in that case.)\n",""),(181,22,"AVG","   AVG(@var{expr})\nReturns the average value of @var{expr}.\n","mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;"),(182,15,"SEC_TO_TIME","   SEC_TO_TIME(@var{seconds})\nReturns the @var{seconds} argument, converted to hours, minutes, and seconds,\nas a value in 'HH:MM:SS' or HHMMSS format, depending on whether\nthe function is used in a string or numeric context.\n","mysql> SELECT SEC_TO_TIME(2378);\n        -> '00:39:38'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938"),(183,1,"LONGBLOB","   LONGBLOB\n   LONGTEXT\n\nA BLOB or TEXT column with a maximum length of 4,294,967,295 or\n4GB (2^32 @minus{} 1) characters.  Up to MySQL\n3.23, the client/server protocol and MyISAM tables had a limit\nof 16MB per communication packet / table row. From MySQL 4.0, the maximum\nallowed length of LONGBLOB or LONGTEXT columns depends on the\nconfigured maximum packet size in the client/server protocol and available\nmemory.\n",""),(184,25,"CROSSES","   Crosses(@var{g1},@var{g2})\nReturns 1 if @var{g1} spatially crosses @var{g2}.\nReturns NULL if g1 is a Polygon or a MultiPolygon,\nor if @var{g2} is a Point or a MultiPoint.\nOtherwise, returns 0.\n\nThe term /spatially crosses/ denotes a spatial relation between two given\ngeometries that has the following properties:\n\n\n --- The two geometries intersect\n\n --- Their intersection results in a geometry that has\na dimension that is one less than the maximum dimension of the two given\ngeometries\n\n --- Their intersection is not equal to either of the two given geometries\n",""),(185,21,"GLENGTH","   GLength(@var{ls})\nReturns as a double-precision number the length of the LineString\nvalue @var{ls} in its associated spatial reference.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+"),(186,27,"XOR","   XOR\nLogical XOR.\nReturns NULL if either operand is NULL.\nFor non-NULL operands, evaluates to 1 if an odd number\nof operands is non-zero,\notherwise 0 is returned.\n","mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1"),(187,9,"NUMGEOMETRIES","   NumGeometries(@var{gc})\nReturns the number of geometries in the GeometryCollection value\n@var{gc}.\n","mysql> SET @gc = 'GeometryCollection(Point(1 1),LineString(2 2, 3 3))';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+"),(188,17,"MPOINTFROMTEXT","   MPointFromText(@var{wkt}[,@var{srid}])\n   MultiPointFromText(@var{wkt}[,@var{srid}])\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n",""),(189,15,"ADDTIME","   ADDTIME(@var{expr},@var{expr2})\n\n\nADDTIME() adds @var{expr2} to @var{expr} and returns the result.\n@var{expr} is a time or datetime expression, and @var{expr2} is a time\nexpression.\n","mysql> SELECT ADDTIME('1997-12-31 23:59:59.999999',\n    ->                '1 1:1:1.000002');\n        -> '1998-01-02 01:01:01.000001'\nmysql> SELECT ADDTIME('01:00:00.999999', '02:00:00.999998');\n        -> '03:00:01.999997'"),(190,7,"AREA","   Area(@var{poly})\nReturns as a double-precision number the area of the Polygon value\n@var{poly}, as measured in its spatial reference system.\n","mysql> SET @poly = 'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+"),(191,15,"MINUTE","   MINUTE(@var{time})\nReturns the minute for @var{time}, in the range 0 to 59.\n","mysql> SELECT MINUTE('98-02-03 10:05:03');\n        -> 5"),(192,10,"PI","   PI()\nReturns the value of PI. The default number of decimals displayed is five, but\nMySQL internally uses the full double-precision value for PI.\n","mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116"),(193,6,"MBROVERLAPS","   MBROverlaps(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries @var{g1} and @var{g2} overlap.\n",""),(194,1,"INT","   INT[(@var{M})] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to\n2147483647.  The unsigned range is 0 to 4294967295.\n\n   INTEGER[(@var{M})] [UNSIGNED] [ZEROFILL]\n\nThis is a synonym for INT.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (195,4,"BETWEEN AND","   @var{expr} BETWEEN @var{min} AND @var{max}\nIf @var{expr} is greater than or equal to @var{min} and @var{expr} is\nless than or equal to @var{max}, BETWEEN returns 1,\notherwise it returns 0.  This is equivalent to the expression\n(@var{min <= @var{expr} AND @var{expr} <= @var{max})} if all the arguments are of the\nsame type. Otherwise type conversion takes place according to the rules\ndescribed at the beginning of this section, but applied to all the three\narguments. Note: Before MySQL\n4.0.5, arguments were converted to the type of @var{expr} instead.\n","mysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT 'b' BETWEEN 'a' AND 'c';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND '3';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND 'x-3';\n        -> 0"),(196,11,"SPACE","   SPACE(@var{N})\nReturns a string consisting of @var{N} space characters.\n","mysql> SELECT SPACE(6);\n        -> '      '"),(197,15,"MAKEDATE","   MAKEDATE(@var{year},@var{dayofyear})\n\nReturns a date, given year and day-of-year values.\n@var{dayofyear} must be greater than 0 or the result will be NULL.\n","mysql> SELECT MAKEDATE(2001,31), MAKEDATE(2001,32);\n        -> '2001-01-31', '2001-02-01'\nmysql> SELECT MAKEDATE(2001,365), MAKEDATE(2004,365);\n        -> '2001-12-31', '2004-12-30'\nmysql> SELECT MAKEDATE(2001,0);\n        -> NULL"),(198,27,"||","   OR\n   ||\nLogical OR.\nEvaluates to 1 if any operand is non-zero,\nto NULL if any operand is NULL,\notherwise 0 is returned.\n","mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1"),(199,16,"TRUE FALSE","TRUE and FALSE added as alias for 1 and 0, respectively.\n",""),(200,15,"WEEKOFYEAR","   WEEKOFYEAR(@var{date})\n\nReturns the calendar week of the date as a number in the\nrange from 1 to 53.\n","mysql> SELECT WEEKOFYEAR('1998-02-20');\n        -> 8"),(201,10,"RADIANS","   RADIANS(@var{X})\nReturns the argument @var{X}, converted from degrees to radians.\n","mysql> SELECT RADIANS(90);\n        -> 1.570796"),(202,4,"ISNULL","   ISNULL(@var{expr})\nIf @var{expr} is NULL, ISNULL() returns 1, otherwise\nit returns 0.\n","mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1"),(203,7,"EXTERIORRING","   ExteriorRing(@var{poly})\nReturns the exterior ring of the Polygon value @var{poly}\nas a LineString.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+"),(204,24,"GEOMETRY HIERARCHY","Geometry is the base class. It's an abstract class.\nThe instantiable subclasses of Geometry are restricted to zero-, one-,\nand two-dimensional geometric objects that exist in\ntwo-dimensional coordinate space. All instantiable geometry classes are\ndefined so that valid instances of a geometry class are topologically closed\n(that is, all defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point,\nCurve, Surface, and GeometryCollection:\n\n\n --- Point represents zero-dimensional objects.\n\n --- Curve represents one-dimensional objects, and has subclass\nLineString, with sub-subclasses Line and LinearRing.\n\n --- Surface is designed for two-dimensional objects and\nhas subclass Polygon.\n\n --- GeometryCollection\nhas specialized zero-, one-, and two-dimensional collection classes named\nMultiPoint, MultiLineString, and MultiPolygon\nfor modeling geometries corresponding to collections of\nPoints, LineStrings, and Polygons, respectively.\nMultiCurve and MultiSurface are introduced as abstract superclasses\nthat generalize the collection interfaces to handle Curves and Surfaces.\n\n\nGeometry, Curve, Surface, MultiCurve,\nand MultiSurface are defined as non-instantiable classes.\nThey define a common set of methods for their subclasses and\nare included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection,\nMultiPoint, MultiLineString, and\nMultiPolygon are instantiable classes.\n",""),(205,2,"POINT","   Point(@var{x},@var{y})\nConstructs a WKB Point using its coordinates.\n",""),(206,26,"SHOW SLAVE HOSTS","SHOW SLAVE HOSTS\n\nDisplays a list of slaves currently registered with the master. \nAny slave not started with the --report-host=slave_name \noption will not be visible in that list.\n",""),(207,26,"EXPLAIN","The EXPLAIN statement can be used either as a synonym for\nDESCRIBE or as a way to obtain information about how MySQL will execute\na SELECT statement:\n\n --- The EXPLAIN @var{tbl_name} syntax is synonymous with DESCRIBE @var{tbl_name}\nor\nSHOW COLUMNS FROM @var{tbl_name}.\n --- When you precede a SELECT statement with the keyword EXPLAIN,\nMySQL explains how it would process the SELECT, providing\ninformation about how tables are joined and in which order.\n","EXPLAIN @var{tbl_name}"),(208,15,"NOW","   NOW()\n\nReturns the current date and time as a value in 'YYYY-MM-DD HH:MM:SS'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n","mysql> SELECT NOW();\n        -> '1997-12-15 23:50:26'\nmysql> SELECT NOW() + 0;\n        -> 19971215235026"),(209,11,"UNHEX","   UNHEX(@var{str})\n\nDoes the opposite of HEX(@var{str)}. That is, it interprets each pair of\nhexadecimal digits in the argument as a number and converts it to the\ncharacter represented by the number. The resulting characters are returned as\na binary string.\n","mysql> SELECT UNHEX('4D7953514C');\n        -> 'MySQL'\nmysql> SELECT 0x4D7953514C;\n        -> 'MySQL'\nmysql> SELECT UNHEX(HEX('string'));\n        -> 'string'\nmysql> SELECT HEX(UNHEX('1267'));\n        -> '1267'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (210,15,"UTC_TIMESTAMP","   UTC_TIMESTAMP\n   UTC_TIMESTAMP()\nReturns the current UTC date and time as a value in 'YYYY-MM-DD HH:MM:SS'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n","mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> '2003-08-14 18:08:04', 20030814180804"),(211,7,"NUMINTERIORRINGS","   NumInteriorRings(@var{poly})\nReturns the number of interior rings in the Polygon value @var{poly}.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+"),(212,8,"AES_DECRYPT","   AES_ENCRYPT(@var{str},@var{key_str})\n   AES_DECRYPT(@var{crypt_str},@var{key_str})\nThese functions allow encryption and decryption of data using the official\nAES (Advanced Encryption Standard) algorithm, previously known as \"Rijndael.\"\nEncoding with a 128-bit key length is used, but you can extend it up to\n256 bits by modifying the source. We chose 128 bits because it is much\nfaster and it is usually secure enough.\n\nThe input arguments may be any length. If either argument is NULL,\nthe result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven length\nstrings and so the result string length may be calculated as\n16*(trunc(@var{string_length/16)+1)}.\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it\nreturns NULL. However, it is possible for AES_DECRYPT()\nto return a non-NULL value (possibly garbage) if the input data or\nthe key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n","INSERT INTO t VALUES (1,AES_ENCRYPT('text','password'));"),(213,8,"MD5","   MD5(@var{str})\nCalculates an MD5 128-bit checksum for the string. The value is returned\nas a string of 32 hex digits,\nor NULL if the argument was NULL.\nThe return value can, for example, be used as a hash key.\n","mysql> SELECT MD5('testing');\n        -> 'ae2b1fca515949e5d54fb22b8ed95575'"),(214,26,"DELETE","DELETE deletes rows from @var{tbl_name} that satisfy the condition\ngiven by @var{where_definition}, and returns the number of records deleted.\n\nIf you issue a DELETE statement with no WHERE clause, all\nrows are deleted.  A faster way to do this, when you don't want to know\nthe number of deleted rows, is to use TRUNCATE TABLE.\nSee also : [TRUNCATE,  , TRUNCATE].\n","DELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM @var{tbl_name}\n       [WHERE @var{where_definition}]\n       [ORDER BY ...]\n       [LIMIT @var{row_count}]"),(215,15,"CONVERT_TZ","   CONVERT_TZ(@var{dt},@var{from_tz},@var{to_tz})\n\nCONVERT_TZ()\nconverts a datetime value @var{dt} from time zone given by @var{from_tz}\nto the time zone given by @var{to_tz} and returns the resulting value.\nTime zones may be specified as described in [Time zone support].\nThis function returns NULL if the arguments are invalid.\n","mysql> SELECT CONVERT_TZ('2004-01-01 12:00:00','GMT','MET');\n        -> '2004-01-01 13:00:00'\nmysql> SELECT CONVERT_TZ('2004-01-01 12:00:00','+00:00','-07:00');\n        -> '2004-01-01 05:00:00'"),(216,26,"SHOW CREATE VIEW","This statement shows a CREATE VIEW statement that will create\nthe given view.\n","SHOW CREATE VIEW @var{view_name}"),(217,13,"DIMENSION","   Dimension(@var{g})\nReturns the inherent dimension of the geometry value @var{g}. The result\ncan be @minus{}1, 0, 1, or 2. (The meaning of these values is given in\n[GIS class geometry].)\n","mysql> SELECT Dimension(GeomFromText('LineString(1 1,2 2)'));\n+------------------------------------------------+\n| Dimension(GeomFromText('LineString(1 1,2 2)')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+"),(218,1,"TIME","   TIME\n\nA time.  The range is '-838:59:59' to '838:59:59'.\nMySQL displays TIME values in 'HH:MM:SS' format, but\nallows you to assign values to TIME columns using either strings or\nnumbers.\n",""),(219,15,"LAST_DAY","   LAST_DAY(@var{date})\n\nTakes a date or datetime value and returns the corresponding value for the\nlast day of the month.  Returns NULL if the argument is invalid.\n","mysql> SELECT LAST_DAY('2003-02-05');\n        -> '2003-02-28'\nmysql> SELECT LAST_DAY('2004-02-05');\n        -> '2004-02-29'\nmysql> SELECT LAST_DAY('2004-01-01 01:01:01');\n        -> '2004-01-31'\nmysql> SELECT LAST_DAY('2003-03-32');\n        -> NULL"),(220,13,"ENVELOPE","   Envelope(@var{g})\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value @var{g}.\nThe result is returned as a Polygon value.\n\nmysql> SELECT AsText(Envelope(GeomFromText('LineString(1 1,2 2)')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText('LineString(1 1,2 2)'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n",""),(221,2,"POLYGON","   Polygon(@var{ls1},@var{ls2},...)\nConstructs a WKB Polygon value from a number of WKB LineString\narguments. If any argument does not represent the WKB of a LinearRing\n(that is, not a closed and simple LineString) the return value\nis NULL.\n",""),(222,4,"NOT IN","   @var{expr} NOT IN (@var{value},...)\nThis is the same as NOT (@var{expr IN (@var{value},...))}.\n",""),(223,11,"INSERT","   INSERT(@var{str},@var{pos},@var{len},@var{newstr})\nReturns the string @var{str}, with the substring beginning at position\n@var{pos} and @var{len} characters long replaced by the string\n@var{newstr}.\n","mysql> SELECT INSERT('Quadratic', 3, 4, 'What');\n        -> 'QuWhattic'"),(224,15,"PERIOD_DIFF","   PERIOD_DIFF(@var{P1},@var{P2})\nReturns the number of months between periods @var{P1} and @var{P2}.\n@var{P1} and @var{P2} should be in the format YYMM or YYYYMM.\nNote that the period arguments @var{P1} and @var{P2} are /not/\ndate values.\n","mysql> SELECT PERIOD_DIFF(9802,199703);\n        -> 11");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (225,25,"DISTANCE","   Distance(@var{g1},@var{g2})\nReturns as a double-precision number\nthe shortest distance between any two points in the two geometries.\n",""),(226,11,"ELT","   ELT(@var{N},@var{str1},@var{str2},@var{str3},...)\nReturns @var{str1} if @var{N} = 1, @var{str2} if @var{N} =\n2, and so on.  Returns NULL if @var{N} is less than 1\nor greater than the number of arguments.  ELT() is the complement of\nFIELD().\n","mysql> SELECT ELT(1, 'ej', 'Heja', 'hej', 'foo');\n        -> 'ej'\nmysql> SELECT ELT(4, 'ej', 'Heja', 'hej', 'foo');\n        -> 'foo'"),(227,20,"ROW_COUNT","   ROW_COUNT()\n\nROW_COUNT() returns the number of rows updated, inserted, or deleted\nby the preceding statement.  This is the same as the row count that the\n@command{mysql} client displays and the value from the\nmysql_affected_rows() C API function.\n","mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)"),(228,22,"COUNT","   COUNT(@var{expr})\nReturns a count of the number of non-NULL values in the rows\nretrieved by a SELECT statement.\n","mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;"),(229,26,"PURGE MASTER LOGS BEFORE TO","PURGE {MASTER | BINARY} LOGS TO '@var{log_name}'\nPURGE {MASTER | BINARY} LOGS BEFORE '@var{date}'\n\nDeletes all the binary logs listed in the log\nindex that are strictly prior to the specified log or date.\nThe logs also are removed from the list recorded in the log index file,\nso that the given log becomes the first. \n",""),(230,19,"SET PASSWORD","","SET PASSWORD = PASSWORD('@var{some password}')\nSET PASSWORD FOR @var{user} = PASSWORD('@var{some password}')"),(231,3,"DROP DATABASE","DROP DATABASE drops all tables in the database and deletes the\ndatabase.  Be /very/ careful with this statement!\nTo use DROP DATABASE, you need the DROP privilege on the\ndatabase.\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS\nto prevent an error from occurring if the database doesn't exist.\n\nDROP SCHEMA can be used as of MySQL 5.0.2.\n","DROP {DATABASE | SCHEMA} [IF EXISTS] @var{db_name}"),(232,22,"MIN MAX","   MIN(@var{expr})\n   MAX(@var{expr})\nReturns the minimum or maximum value of @var{expr}.  MIN() and\nMAX() may take a string argument; in such cases they return the\nminimum or maximum string value. See also : [MySQL indexes].\n","mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;"),(233,22,"COUNT DISTINCT","   COUNT(DISTINCT @var{expr},[@var{expr}...])\nReturns a count of the number of different non-NULL values.\n","mysql> SELECT COUNT(DISTINCT results) FROM student;"),(234,6,"MBRDISJOINT","   MBRDisjoint(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries @var{g1} and @var{g2} are disjoint (do not intersect).\n",""),(235,10,"LOG10","   LOG10(@var{X})\nReturns the base-10 logarithm of @var{X}.\n","mysql> SELECT LOG10(2);\n        -> 0.301030\nmysql> SELECT LOG10(100);\n        -> 2.000000\nmysql> SELECT LOG10(-100);\n        -> NULL"),(236,15,"SYSDATE","   SYSDATE()\n\nSYSDATE() is a synonym for NOW().\n",""),(237,15,"TIMESTAMP FUNCTION","   TIMESTAMP(@var{expr})\n   TIMESTAMP(@var{expr},@var{expr2})\n\nWith one argument, returns the date or datetime expression @var{expr}\nas a datetime value.\nWith two arguments, adds the time expression @var{expr2} to the\ndate or datetime expression @var{expr} and returns a datetime value.\n","mysql> SELECT TIMESTAMP('2003-12-31');\n        -> '2003-12-31 00:00:00'\nmysql> SELECT TIMESTAMP('2003-12-31 12:00:00','12:00:00');\n        -> '2004-01-01 00:00:00'"),(238,16,"FUNCTION","A user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like native (built in) MySQL function such as\nABS() and CONCAT().\n\nAGGREGATE is a new option for MySQL 3.23.  An\nAGGREGATE function works exactly like a native MySQL\nGROUP function like SUM or COUNT().\n\nCREATE FUNCTION saves the function's name, type, and shared library\nname in the mysql.func system table.  You must have the\nINSERT and DELETE privileges for the mysql database\nto create and drop functions.\n","CREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|REAL|INTEGER}\n       SONAME shared_library_name\n\nDROP FUNCTION function_name"),(239,5,"LINEFROMWKB","   LineFromWKB(@var{wkb}[,@var{srid}])\n   LineStringFromWKB(@var{wkb}[,@var{srid}])\nConstructs a LINESTRING value using its WKB representation and SRID.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (240,9,"GEOMETRYN","   GeometryN(@var{gc},@var{n})\nReturns the @var{n}-th geometry in the GeometryCollection value\n@var{gc}.  Geometry numbers begin at 1.\n","mysql> SET @gc = 'GeometryCollection(Point(1 1),LineString(2 2, 3 3))';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+"),(241,27,"&&","   AND\n   &&\nLogical AND.\nEvaluates to 1 if all operands are non-zero and not NULL,\nto 0 if one or more operands are 0,\notherwise NULL is returned.\n","mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0"),(242,8,"ENCODE","   ENCODE(@var{str},@var{pass_str})\nEncrypt @var{str} using @var{pass_str} as the password.\nTo decrypt the result, use DECODE().\n\nThe result is a binary string of the same length as @var{str}.\nIf you want to save it in a column, use a BLOB column type.\n",""),(243,10,"ATAN","   ATAN(@var{X})\nReturns the arc tangent of @var{X}, that is, the value whose tangent is\n@var{X}.\n","mysql> SELECT ATAN(2);\n        -> 1.107149\nmysql> SELECT ATAN(-2);\n        -> -1.107149"),(244,10,"POWER","   POW(@var{X},@var{Y})\n   POWER(@var{X},@var{Y})\nReturns the value of @var{X} raised to the power of @var{Y}.\n","mysql> SELECT POW(2,2);\n        -> 4.000000\nmysql> SELECT POW(2,-2);\n        -> 0.250000"),(245,18,"MASTER_POS_WAIT","   MASTER_POS_WAIT(@var{log_name},@var{log_pos}[,@var{timeout}])\n\nThis function is useful for control of master/slave synchronization.\nIt blocks until the slave has read and applied all updates up to the specified\nposition in the master log.\nThe return value is the number of log events it had to wait for to get to\nthe specified position.  The function returns NULL if the slave SQL thread\nis not started, the slave's master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL.\nIf the slave is already past the specified position, the function returns\nimmediately.\n","SELECT MASTER_POS_WAIT('@var{master_log_file}', @var{master_log_pos})"),(246,3,"DROP INDEX","DROP INDEX drops the index named @var{index_name} from the table\n@var{tbl_name}.  In MySQL 3.22 or later, DROP INDEX is mapped to an\nALTER TABLE statement to drop the index.  See also : [ALTER TABLE, ,\nALTER TABLE].  DROP INDEX doesn't do anything prior to MySQL\n3.22.\n","DROP INDEX @var{index_name} ON @var{tbl_name}"),(247,20,"CONNECTION_ID","   CONNECTION_ID()\nReturns the connection ID (thread ID) for the connection.\nEvery connection has its own unique ID.\n","mysql> SELECT CONNECTION_ID();\n        -> 23786"),(248,3,"ALTER DATABASE","\nALTER DATABASE allows you to change the overall characteristics of a\ndatabase.  These characteristics are stored in the *db.opt file in the\ndatabase directory.\nTo use ALTER DATABASE, you need the ALTER privilege on the\ndatabase.\n","ALTER {DATABASE | SCHEMA} @var{db_name}\n    @var{alter_specification} [, @var{alter_specification}] ...\n\n@var{alter_specification}:\n    [DEFAULT] CHARACTER SET @var{charset_name}\n  | [DEFAULT] COLLATE @var{collation_name}"),(249,26,"JOIN","MySQL supports the following JOIN syntaxes for the\n@var{table_references} part of SELECT statements and multiple-table\nDELETE and UPDATE statements:\n\n@var{table_reference}, @var{table_reference}\n@var{table_reference} [INNER | CROSS] JOIN @var{table_reference} [@var{join_condition}]\n@var{table_reference} STRAIGHT_JOIN @var{table_reference}\n@var{table_reference} LEFT [OUTER] JOIN @var{table_reference} [@var{join_condition}]\n@var{table_reference} NATURAL [LEFT [OUTER]] JOIN @var{table_reference}\n{ OJ @var{table_reference} LEFT OUTER JOIN @var{table_reference}\n    ON @var{conditional_expr} }\n@var{table_reference} RIGHT [OUTER] JOIN @var{table_reference} [@var{join_condition}]\n@var{table_reference} NATURAL [RIGHT [OUTER]] JOIN @var{table_reference}\n\n@var{table_reference} is defined as:\n\n@var{tbl_name} [[AS] @var{alias}]\n    [[USE INDEX (@var{key_list})]\n      | [IGNORE INDEX (@var{key_list})]\n      | [FORCE INDEX (@var{key_list})]]\n\n@var{join_condition} is defined as:\n\nON @var{conditional_expr} | USING (@var{column_list})\n","mysql> SELECT table1.* FROM table1\n    ->        LEFT JOIN table2 ON table1.id=table2.id\n    ->        WHERE table2.id IS NULL;"),(250,2,"MULTIPOLYGON","   MultiPolygon(@var{poly1},@var{poly2},...)\nConstructs a WKB MultiPolygon value from a set of WKB Polygon\narguments.\nIf any argument is not a WKB Polygon, the rerurn value is NULL.\n",""),(251,26,"LOAD DATA FROM MASTER","LOAD DATA FROM MASTER\n\nTakes a snapshot of the master and copies it to the slave.  It updates the\nvalues of MASTER_LOG_FILE and MASTER_LOG_POS so that the slave\nwill start replicating from the correct position. Any table and database\nexclusion rules specified with the --replicate-*-do-* and\n--replicate-*-ignore-* options are honored.\n--replicate-rewrite-db is /not/ taken into account (because one user\ncould, with this option, set up a non-unique mapping such as\n--replicate-rewrite-db=db1->db3 and\n--replicate-rewrite-db=db2->db3, which would confuse the slave when\nit loads the master's tables).\n\nUse of this statement is subject to the following conditions:\n\n\n --- It works only with MyISAM tables.\n\n --- It acquires a global read lock on the master while taking the snapshot,\nwhich prevents updates on the master during the load operation.\n\n\nIn the future, it is planned to make this statement work with\nInnoDB tables and to remove the need for a global read lock by using\nnon-blocking online backup.\n\nIf you are loading big tables, you might have to increase the values\nof net_read_timeout and net_write_timeout\non both your master and slave servers.\nSee also : [Server system variables].\n\nNote that LOAD DATA FROM MASTER does /not/ copy any\ntables from the mysql database.  This makes it easy to have\ndifferent users and privileges on the master and the slave.\n\nThe LOAD DATA FROM MASTER statement\nrequires the replication account that is used to connect to the master\nto have the RELOAD and SUPER privileges on the master and the\nSELECT privilege for all master tables you want to load. All\nmaster tables for which the user does not have the SELECT privilege are\nignored by LOAD DATA FROM MASTER. This is because the\nmaster will hide them from the user: LOAD DATA FROM MASTER calls\nSHOW DATABASES to know the master databases to load, but\nSHOW DATABASES returns only databases for which the user has\nsome privilege.\nSee [SHOW DATABASES,  , SHOW DATABASES].\nOn the slave's side, the user that issues LOAD DATA FROM MASTER should\nhave grants to drop and create the databases and tables that are copied.\n",""),(252,16,"CHAR BYTE","CHAR BYTE is an alias for CHAR BINARY.\n",""),(253,13,"SRID","   SRID(@var{g})\nReturns an integer indicating the Spatial Reference System ID for the geometry\nvalue @var{g}.\n","mysql> SELECT SRID(GeomFromText('LineString(1 1,2 2)',101));\n+-----------------------------------------------+\n| SRID(GeomFromText('LineString(1 1,2 2)',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+"),(254,15,"DATE OPERATIONS","   DATE_ADD(@var{date},INTERVAL @var{expr} @var{type})\n   DATE_SUB(@var{date},INTERVAL @var{expr} @var{type})\n\nThese functions perform date arithmetic.\n@var{date} is a DATETIME or DATE value specifying the starting\ndate.  @var{expr} is an expression specifying the interval value to be added\nor subtracted from the starting date.  @var{expr} is a string; it may start\nwith a - for negative intervals.  @var{type} is a keyword indicating\nhow the expression should be interpreted.\n","mysql> SELECT '1997-12-31 23:59:59' + INTERVAL 1 SECOND;\n        -> '1998-01-01 00:00:00'\nmysql> SELECT INTERVAL 1 DAY + '1997-12-31';\n        -> '1998-01-01'\nmysql> SELECT '1998-01-01' - INTERVAL 1 SECOND;\n        -> '1997-12-31 23:59:59'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL 1 SECOND);\n        -> '1998-01-01 00:00:00'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL 1 DAY);\n        -> '1998-01-01 23:59:59'\nmysql> SELECT DATE_ADD('1997-12-31 23:59:59',\n    ->                 INTERVAL '1:1' MINUTE_SECOND);\n        -> '1998-01-01 00:01:00'\nmysql> SELECT DATE_SUB('1998-01-01 00:00:00',\n    ->                 INTERVAL '1 1:1:1' DAY_SECOND);\n        -> '1997-12-30 22:58:59'\nmysql> SELECT DATE_ADD('1998-01-01 00:00:00',\n    ->                 INTERVAL '-1 10' DAY_HOUR);\n        -> '1997-12-30 14:00:00'\nmysql> SELECT DATE_SUB('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\nmysql> SELECT DATE_ADD('1992-12-31 23:59:59.000002',\n    ->            INTERVAL '1.999999' SECOND_MICROSECOND);\n        -> '1993-01-01 00:00:01.000001'");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (255,5,"MPOLYFROMWKB","   MPolyFromWKB(@var{wkb}[,@var{srid}])\n   MultiPolygonFromWKB(@var{wkb}[,@var{srid}])\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n",""),(256,26,"FLUSH","You should use the FLUSH statement if you want to clear some of the\ninternal caches MySQL uses.  To execute FLUSH, you must have\nthe RELOAD privilege.\n","FLUSH [LOCAL | NO_WRITE_TO_BINLOG] @var{flush_option} [, @var{flush_option}] ..."),(257,18,"IS_USED_LOCK","   IS_USED_LOCK(@var{str})\nChecks whether the lock named @var{str} is in use (that is, locked).\nIf so, it returns the connection identifier of the client that holds\nthe lock.\nOtherwise, it returns NULL.\n",""),(258,20,"SESSION_USER","   SESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n",""),(259,1,"BIGINT","   BIGINT[(@var{M})] [UNSIGNED] [ZEROFILL]\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to\n18446744073709551615.\n",""),(260,15,"DAY","   DAY(@var{date})\n\nDAY() is a synonym for DAYOFMONTH().\nIt is available as of MySQL 4.1.1.\n",""),(261,11,"MATCH AGAINST","As of MySQL 3.23.23, MySQL has support for full-text indexing\nand searching.  A full-text index in MySQL is an index of type\nFULLTEXT.  FULLTEXT indexes are used with MyISAM tables\nonly and can be created from CHAR, VARCHAR,\nor TEXT columns at CREATE TABLE time or added later with\nALTER TABLE or CREATE INDEX.  For large datasets, it will be\nmuch faster to load your data into a table that has no FULLTEXT\nindex, then create the index with ALTER TABLE (or\nCREATE INDEX).  Loading data into a table that already has a\nFULLTEXT index could be significantly slower.\n","mysql> SELECT id, body, MATCH (title,body) AGAINST\n    -> ('Security implications of running MySQL as root') AS score\n    -> FROM articles WHERE MATCH (title,body) AGAINST\n    -> ('Security implications of running MySQL as root');\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)"),(262,3,"DROP TABLE","DROP TABLE removes one or more tables. You must have the DROP\nprivilege for each table. All table data and the table\ndefinition are /removed/, so /be careful/ with this statement!\n\nIn MySQL 3.22 or later, you can use the keywords IF EXISTS\nto prevent an error from occurring for tables that don't exist.  As of\nMySQL 4.1, a NOTE is generated for each non-existent table when\nusing IF EXISTS.\nSee also : [SHOW WARNINGS,  , SHOW WARNINGS].\n\nRESTRICT and CASCADE are allowed to make porting easier.\nFor the moment, they do nothing.\n\nNote: DROP TABLE automatically commits the current\nactive transaction, unless you are using MySQL 4.1 or higher and the\nTEMPORARY keyword.\n","DROP [TEMPORARY] TABLE [IF EXISTS]\n    @var{tbl_name} [, @var{tbl_name}] ...\n    [RESTRICT | CASCADE]"),(263,26,"SELECT","SELECT is used to retrieve rows selected from one or more tables.\nSupport for UNION statements and subqueries is available as of MySQL\n4.0 and 4.1, respectively.\nSee [UNION,  , UNION] and [Subqueries].\n\n --- Each @var{select_expr} indicates a column you want to retrieve.\n\n --- @var{table_references} indicates the table or tables from which to retrieve rows.\nIts syntax is described in [JOIN,  , JOIN].\n\n --- @var{where_definition} consists of the keyword WHERE followed by\nan expression that indicates the condition or conditions that rows\nmust satisfy to be selected.\n\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.  \n","SELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    @var{select_expr}, ...\n    [INTO OUTFILE '@var{file_name}' @var{export_options}\n      | INTO DUMPFILE '@var{file_name}']\n    [FROM @var{table_references}\n      [WHERE @var{where_definition}]\n      [GROUP BY {@var{col_name} | @var{expr} | @var{position}}\n        [ASC | DESC], ... [WITH ROLLUP]]\n      [HAVING @var{where_definition}]\n      [ORDER BY {@var{col_name} | @var{expr} | @var{position}}\n        [ASC | DESC] , ...]\n      [LIMIT {[@var{offset},] @var{row_count} | @var{row_count} OFFSET @var{offset}}]\n      [PROCEDURE @var{procedure_name}(@var{argument_list})]\n      [FOR UPDATE | LOCK IN SHARE MODE]]"),(264,15,"HOUR","   HOUR(@var{time})\nReturns the hour for @var{time}. The range of the return value will be\n0 to 23 for time-of-day values.\n","mysql> SELECT HOUR('10:05:03');\n        -> 10"),(265,20,"COERCIBILITY","   COERCIBILITY(@var{str})\nReturns the collation coercibility value of the string argument.\n","mysql> SELECT COERCIBILITY('abc' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY('abc');\n        -> 3\nmysql> SELECT COERCIBILITY(USER());\n        -> 2"),(266,5,"MPOINTFROMWKB","   MPointFromWKB(@var{wkb}[,@var{srid}])\n   MultiPointFromWKB(@var{wkb}[,@var{srid}])\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n",""),(267,18,"DEFAULT","   DEFAULT(@var{col_name})\nReturns the default value for a table column.\nStarting from MySQL 5.0.2, you will get an error if the column doesn't have\na default value.\n","mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;"),(268,20,"CHARSET","   CHARSET(@var{str})\nReturns the character set of the string argument.\n","mysql> SELECT CHARSET('abc');\n        -> 'latin1'\nmysql> SELECT CHARSET(CONVERT('abc' USING utf8));\n        -> 'utf8'\nmysql> SELECT CHARSET(USER());\n        -> 'utf8'"),(269,26,"DO","DO executes the expressions but doesn't return any results.  This is\nshorthand for SELECT @var{expr, ...}, but has the advantage that it's\nslightly faster when you don't care about the result.\n\nDO is useful mainly with functions that have side effects, such as\nRELEASE_LOCK().\n","DO @var{expr} [, @var{expr}] ...");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (270,15,"MONTHNAME","   MONTHNAME(@var{date})\nReturns the full name of the month for @var{date}.\n","mysql> SELECT MONTHNAME('1998-02-05');\n        -> 'February'"),(271,25,"TOUCHES","   Touches(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} spatially touches\n@var{g2}. Two geometries /spatially touch/ if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n",""),(272,3,"ALTER TABLE","ALTER TABLE allows you to change the structure of an existing table.\nFor example, you can add or delete columns, create or destroy indexes, change\nthe type of existing columns, or rename columns or the table itself.  You can\nalso change the comment for the table and type of the table.\n","ALTER [IGNORE] TABLE @var{tbl_name}\n    @var{alter_specification} [, @var{alter_specification}] ...\n\n@var{alter_specification}:\n    ADD [COLUMN] @var{column_definition} [FIRST | AFTER @var{col_name} ]\n  | ADD [COLUMN] (@var{column_definition},...)\n  | ADD INDEX [@var{index_name}] [@var{index_type}] (@var{index_col_name},...)\n  | ADD [CONSTRAINT [@var{symbol}]]\n        PRIMARY KEY [@var{index_type}] (@var{index_col_name},...)\n  | ADD [CONSTRAINT [@var{symbol}]]\n        UNIQUE [@var{index_name}] [@var{index_type}] (@var{index_col_name},...)\n  | ADD [FULLTEXT|SPATIAL] [@var{index_name}] (@var{index_col_name},...)\n  | ADD [CONSTRAINT [@var{symbol}]]\n        FOREIGN KEY [@var{index_name}] (@var{index_col_name},...)\n        [@var{reference_definition}]\n  | ALTER [COLUMN] @var{col_name} {SET DEFAULT @var{literal} | DROP DEFAULT}\n  | CHANGE [COLUMN] @var{old_col_name} @var{column_definition}\n        [FIRST|AFTER @var{col_name}]\n  | MODIFY [COLUMN] @var{column_definition} [FIRST | AFTER @var{col_name}]\n  | DROP [COLUMN] @var{col_name}\n  | DROP PRIMARY KEY\n  | DROP INDEX @var{index_name}\n  | DROP FOREIGN KEY @var{fk_symbol}\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO] @var{new_tbl_name}\n  | ORDER BY @var{col_name}\n  | CONVERT TO CHARACTER SET @var{charset_name} [COLLATE @var{collation_name}]\n  | [DEFAULT] CHARACTER SET @var{charset_name} [COLLATE @var{collation_name}]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | @var{table_options}"),(273,11,"HEX","   HEX(@var{N_or_S})\n\nIf @var{N_OR_S} is a number, returns a string representation of the hexadecimal\nvalue of @var{N}, where @var{N} is a longlong (BIGINT) number.\nThis is equivalent to CONV(N,10,16).\n\nFrom MySQL 4.0.1 and up,\nif @var{N_OR_S} is a string, returns a hexadecimal string of @var{N_OR_S}\nwhere each character in @var{N_OR_S} is converted to two hexadecimal digits.\n","mysql> SELECT HEX(255);\n        -> 'FF'\nmysql> SELECT 0x616263;\n        -> 'abc'\nmysql> SELECT HEX('abc');\n        -> 616263"),(274,11,"RIGHT","   RIGHT(@var{str},@var{len})\nReturns the rightmost @var{len} characters from the string @var{str}.\n","mysql> SELECT RIGHT('foobarbar', 4);\n        -> 'rbar'"),(275,1,"TIMESTAMP","   TIMESTAMP[(@var{M})]\n\nA timestamp.  The range is '1970-01-01 00:00:00' to partway through the\nyear 2037.\n\nA TIMESTAMP column is useful for recording the date and time of an\nINSERT or UPDATE operation. The first TIMESTAMP column\nin a table is automatically set to the date and time of the most recent\noperation if you don't assign it a value yourself.  You can also set any\nTIMESTAMP column to the current date and time by assigning it a\nNULL value.\n\nFrom MySQL 4.1 on, TIMESTAMP is returned as a string with the format\n'YYYY-MM-DD HH:MM:SS'. If you want to obtain the value as a number,\nyou should add +0 to the timestamp column. Different timestamp\ndisplay widths are not supported.\n\nIn MySQL 4.0 and earlier, TIMESTAMP values are displayed in\nYYYYMMDDHHMMSS, YYMMDDHHMMSS, YYYYMMDD, or YYMMDD\nformat, depending on whether @var{M} is 14 (or missing), 12,\n8, or 6, but allows you to assign values to TIMESTAMP\ncolumns using either strings or numbers.\nThe @var{M} argument affects only how a TIMESTAMP column is displayed,\nnot storage.  Its values always are stored using four bytes each.\nFrom MySQL 4.0.12, the --new option can be used\nto make the server behave as in MySQL 4.1.\n\nNote that TIMESTAMP(@var{M)} columns where @var{M} is 8 or 14 are reported to\nbe numbers, whereas other TIMESTAMP(@var{M)} columns are reported to be\nstrings.  This is just to ensure that you can reliably dump and restore\nthe table with these types.\n",""),(276,15,"MAKETIME","   MAKETIME(@var{hour},@var{minute},@var{second})\n\nReturns a time value calculated from the @var{hour}, @var{minute}, and\n@var{second} arguments.\n","mysql> SELECT MAKETIME(12,15,30);\n        -> '12:15:30'"),(277,7,"INTERIORRINGN","   InteriorRingN(@var{poly},@var{n})\nReturns the @var{n}-th interior ring for the Polygon value\n@var{poly} as a LineString.\nRing numbers begin at 1.\n","mysql> SET @poly =\n    -> 'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+"),(278,15,"STR_TO_DATE","   STR_TO_DATE(@var{str},@var{format})\nThis is the reverse function of the DATE_FORMAT() function. It takes a \nstring @var{str} and a format string @var{format}.\nSTR_TO_DATE() returns a DATETIME value if the format\nstring contains both date and time parts, or a DATE or TIME\nvalue if the string contains only date or time parts.\n\nThe date, time, or datetime values contained in @var{str} should be given \nin the format indicated by @var{format}. For the specifiers that can be \nused in @var{format}, see the table in the DATE_FORMAT() function \ndescription. All other characters are just taken verbatim, thus not being \ninterpreted.\nIf @var{str} contains an illegal date, time, or datetime value, \nSTR_TO_DATE() returns NULL.\n","@c next example commented out until format string becomes optional\n@c mysql> SELECT STR_TO_DATE('2003-10-03');\n@c         -> 2003-10-03 00:00:00\nmysql> SELECT STR_TO_DATE('03.10.2003 09.20',\n    ->                    '%d.%m.%Y %H.%i');\n        -> '2003-10-03 09:20:00'\nmysql> SELECT STR_TO_DATE('10arp', '%carp');\n        -> '0000-10-00 00:00:00'\nmysql> SELECT STR_TO_DATE('2003-15-10 00:00:00',\n    ->                    '%Y-%m-%d %H:%i:%s');\n        -> NULL"),(279,28,"BIT_COUNT","   BIT_COUNT(@var{N})\nReturns the number of bits that are set in the argument @var{N}.\n","mysql> SELECT BIT_COUNT(29);\n        -> 4"),(280,10,"TAN","   TAN(@var{X})\nReturns the tangent of @var{X}, where @var{X} is given in radians.\n","mysql> SELECT TAN(PI()+1);\n        -> 1.557408"),(281,2,"MULTILINESTRING","   MultiLineString(@var{ls1},@var{ls2},...)\nConstructs a WKB MultiLineString value using using WKB LineString\narguments.  If any argument is not a WKB LineString, the return\nvalue is NULL.\n",""),(282,19,"STOP SLAVE","STOP SLAVE [@var{thread_type} [, @var{thread_type}] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads.\nSTOP SLAVE requires the SUPER privilege.\n\nLike START SLAVE, as of MySQL 4.0.2, this statement\nmay be used with the IO_THREAD and SQL_THREAD options to name\nthe thread or threads to stop.\n",""),(283,15,"UTC_DATE","   UTC_DATE\n   UTC_DATE()\nReturns the current UTC date as a value in 'YYYY-MM-DD' or\nYYYYMMDD format, depending on whether the function is used in a\nstring or numeric context.\n","mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> '2003-08-14', 20030814"),(284,3,"CREATE INDEX","In MySQL 3.22 or later, CREATE INDEX is mapped to an\nALTER TABLE statement to create indexes.\nSee also : [ALTER TABLE, , ALTER TABLE].\nThe CREATE INDEX statement doesn't do anything prior\nto MySQL 3.22.\n","CREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX @var{index_name} [@var{index_type}]\n    ON @var{tbl_name} (@var{index_col_name},...)\n\n@var{index_col_name}:\n    @var{col_name} [(@var{length})] [ASC | DESC]");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (285,11,"UNCOMPRESSED_LENGTH","   UNCOMPRESSED_LENGTH(@var{compressed_string})\nReturns the length of a compressed string before compression.\n","mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT('a',30)));\n        -> 30"),(286,1,"AUTO_INCREMENT","The AUTO_INCREMENT attribute can be used to generate a unique\nidentity for new rows:\n","CREATE TABLE animals (\n             id MEDIUMINT NOT NULL AUTO_INCREMENT,\n             name CHAR(30) NOT NULL,\n             PRIMARY KEY (id)\n             );\nINSERT INTO animals (name) VALUES ('dog'),('cat'),('penguin'),\n                                  ('lax'),('whale'),('ostrich');\nSELECT * FROM animals;"),(287,8,"OLD_PASSWORD","   OLD_PASSWORD(@var{str})\n\n\nOLD_PASSWORD() is available as of MySQL 4.1, when the implementation of\nPASSWORD() was changed to improve security. OLD_PASSWORD()\nreturns the value of the pre-4.1 implementation of PASSWORD().\n[Password hashing].\n\n   PASSWORD(@var{str})\nCalculates and returns a password string from the plaintext password\n@var{str}, or NULL if the argument was NULL. This is\nthe function that is used for encrypting MySQL passwords for storage\nin the Password column of the user grant table.\n",""),(288,11,"STRCMP","   STRCMP(@var{expr1},@var{expr2})\nSTRCMP()\nreturns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort order,\nand 1 otherwise.\n","mysql> SELECT STRCMP('text', 'text2');\n        -> -1\nmysql> SELECT STRCMP('text2', 'text');\n        -> 1\nmysql> SELECT STRCMP('text', 'text');\n        -> 0"),(289,13,"BOUNDARY","   Boundary(@var{g})\nReturns a geometry that is the closure of the combinatorial boundary of the\ngeometry value @var{g}.\n",""),(290,15,"DATEDIFF","   DATEDIFF(@var{expr},@var{expr2})\n\n\nDATEDIFF() returns the number of days between the start date\n@var{expr} and the end date @var{expr2}.\n@var{expr} and @var{expr2} are date or date-and-time expressions.\nOnly the date parts of the values are used in the calculation.\n","mysql> SELECT DATEDIFF('1997-12-31 23:59:59','1997-12-30');\n        -> 1\nmysql> SELECT DATEDIFF('1997-11-30 23:59:59','1997-12-31');\n        -> -31"),(291,1,"TINYINT","   TINYINT[(@var{M})] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The\nunsigned range is 0 to 255.\n\n   BIT\n   BOOL\n   BOOLEAN\nThese are synonyms for TINYINT(1).\nThe BOOLEAN synonym was added in MySQL 4.1.0.\nA value of zero is considered false. Non-zero values are considered true.\n\nIn the future,\nfull boolean type handling will be introduced in accordance with standard SQL.\n",""),(292,19,"SET GLOBAL SQL_SLAVE_SKIP_COUNTER","SET GLOBAL SQL_SLAVE_SKIP_COUNTER = @var{n}\n\nSkip the next @var{n} events from the master. This is\nuseful for recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave thread is not running.\nOtherwise, it produces an error.\n\nBefore MySQL 4.0, omit the GLOBAL keyword from the statement.\n",""),(293,8,"DES_ENCRYPT","   DES_ENCRYPT(@var{str}[,(@var{key_num}|@var{key_str})])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\nOn error, this function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See also : [Secure connections].\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given:\n\n     Argument 	 Description\n   No argument 	\nThe first key from the DES key file is used.\n   @var{key_num} 	\nThe given key number (0-9) from the DES key file is used.\n   @var{key_str} 	\nThe given key string is used to encrypt @var{str}.\n  \n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character\nis CHAR(128 | key_num).\n\nThe 128 is added to make it easier to recognize an encrypted key.\nIf you use a string key, @var{key_num} will be 127.\n\nThe string length for the result will be\n@var{new_len = @var{orig_len} + (8-(@var{orig_len} % 8))+1}.\n","@var{key_num} @var{des_key_str}"),(294,15,"QUARTER","   QUARTER(@var{date})\nReturns the quarter of the year for @var{date}, in the range 1\nto 4.\n","mysql> SELECT QUARTER('98-04-01');\n        -> 2"),(295,20,"DATABASE","   DATABASE()\nReturns the default (current) database name.\n","mysql> SELECT DATABASE();\n        -> 'test'"),(296,3,"CREATE TABLE","CREATE TABLE creates a table with the given name.\nYou must have the CREATE privilege for the table.\n\nRules for allowable table names are given in [Legal names].  \nBy default, the table is created in the current database.  \nAn error occurs if the table already exists, if there is no current database,\nor if the database does not exist.\n","CREATE [TEMPORARY] TABLE [IF NOT EXISTS] @var{tbl_name}\n    [(@var{create_definition},...)]\n    [@var{table_options}] [@var{select_statement}]"),(297,11,"BIN","   BIN(@var{N})\nReturns a string representation of the binary value of @var{N}, where\n@var{N} is a longlong (BIGINT) number.  This is equivalent to\nCONV(@var{N,10,2)}.  Returns NULL if @var{N} is NULL.\n","mysql> SELECT BIN(12);\n        -> '1100'"),(298,10,"SIGN","   SIGN(@var{X})\nReturns the sign of the argument as -1, 0, or 1, depending\non whether @var{X} is negative, zero, or positive.\n","mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1"),(299,15,"TIME_TO_SEC","   TIME_TO_SEC(@var{time})\nReturns the @var{time} argument, converted to seconds.\n","mysql> SELECT TIME_TO_SEC('22:23:00');\n        -> 80580\nmysql> SELECT TIME_TO_SEC('00:39:38');\n        -> 2378");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (300,15,"TIMESTAMPADD FUNCTION","","mysql> SELECT TIMESTAMPADD(MINUTE,1,'2003-01-02');\n        -> '2003-01-02 00:01:00'\nmysql> SELECT TIMESTAMPADD(WEEK,1,'2003-01-02');\n        -> '2003-01-09'"),(301,11,"REVERSE","   REVERSE(@var{str})\nReturns the string @var{str} with the order of the characters reversed.\n","mysql> SELECT REVERSE('abc');\n        -> 'cba'"),(302,4,"<=>","   <=>\nNULL-safe equal.\nThis operator performs an equality comparison like the = operator, but\nreturns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n","mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL"),(303,11,"SUBSTRING","   SUBSTRING(@var{str},@var{pos})\n   SUBSTRING(@var{str} FROM @var{pos})\n   SUBSTRING(@var{str},@var{pos},@var{len})\n   SUBSTRING(@var{str} FROM @var{pos} FOR @var{len})\n\nThe forms without a @var{len} argument\nreturn a substring from string @var{str} starting at position @var{pos}.\nThe forms with a @var{len} argument\nreturn a substring @var{len} characters long from string @var{str},\nstarting at position @var{pos}.\nThe forms that use FROM are standard SQL syntax.\n","mysql> SELECT SUBSTRING('Quadratically',5);\n        -> 'ratically'\nmysql> SELECT SUBSTRING('foobarbar' FROM 4);\n        -> 'barbar'\nmysql> SELECT SUBSTRING('Quadratically',5,6);\n        -> 'ratica'"),(304,14,"NULLIF","   NULLIF(@var{expr1},@var{expr2})\nReturns NULL if @var{expr1 = @var{expr2}} is true, else returns @var{expr1}.\nThis is the same as CASE WHEN @var{expr1 = @var{expr2} THEN NULL ELSE @var{expr1} END}.\n","mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1"),(305,25,"CONTAINS","   Contains(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not @var{g1} completely contains\n@var{g2}.\n",""),(306,15,"CURRENT_DATE","   CURRENT_DATE\n   CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for\nCURDATE().\n",""),(307,22,"VARIANCE","   VARIANCE(@var{expr})\nReturns the standard variance of @var{expr} (considering rows as the\nwhole population, not as a sample; so it has the number of rows as\ndenominator). This is an extension to \nstandard SQL, available only in MySQL 4.1 or later.\n",""),(308,26,"UPDATE","The UPDATE statement updates columns in existing table rows with new values.\nThe SET clause indicates which columns to modify and the values\nthey should be given.  The WHERE clause, if given, specifies\nwhich rows should be updated.  Otherwise, all rows are updated. If the\nORDER BY clause is specified, the rows will be updated in the\norder that is specified. The LIMIT clause places a limit on the number\nof rows that can be updated.\n\nThe UPDATE statement supports the following modifiers:\n\n\n --- If you specify the LOW_PRIORITY keyword, execution of the\nUPDATE is delayed until no other clients are reading from the table.\n\n --- If you specify the IGNORE keyword, the update statement will not\nabort even if duplicate-key errors occur during the update.  Rows for which\nconflicts occur are not updated.\n","UPDATE [LOW_PRIORITY] [IGNORE] @var{tbl_name}\n    SET @var{col_name1}=@var{expr1} [, @var{col_name2}=@var{expr2} ...]\n    [WHERE @var{where_definition}]\n    [ORDER BY ...]\n    [LIMIT @var{row_count}]"),(309,15,"TIMESTAMPDIFF","   TIMESTAMPDIFF(@var{interval},@var{datetime_expr1},@var{datetime_expr2})\n\nReturns the integer difference between the date or datetime expressions\n@var{datetime_expr1} and\n@var{datetime_expr2}. The unit for the result is given by the\n@var{interval} argument. The legal values for @var{interval} are the same as\nthose listed in the description of the TIMESTAMPADD() function.\n",""),(310,11,"FIND_IN_SET","   FIND_IN_SET(@var{str},@var{strlist})\nReturns a value 1 to @var{N} if the string @var{str} is in the string list\n@var{strlist} consisting of @var{N} substrings. A string list is a string\ncomposed of substrings separated by , characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic.\nReturns 0 if @var{str} is not in @var{strlist} or if @var{strlist}\nis the empty string.  Returns NULL if either argument is NULL.\nThis function will not work properly if the first argument contains a comma\n(,) character.\n","mysql> SELECT FIND_IN_SET('b','a,b,c,d');\n        -> 2"),(311,15,"YEARWEEK","Returns year and week for a date.  The @var{start} argument works exactly\nlike the @var{start} argument to WEEK().  The year in the\nresult may be\ndifferent from the year in the date argument for the first and the last\nweek of the year.\n","mysql> SELECT YEARWEEK('1987-01-01');\n        -> 198653"),(312,26,"SET","SET sets different types of variables that affect the operation of the\nserver or your client. It can be used to assign values to user variables or\nsystem variables.\n","SET @var{variable_assignment} [, @var{variable_assignment}] ...\n\n@var{variable_assignment}:\n      @var{user_var_name} = @var{expr}\n    | [GLOBAL | SESSION] @var{system_var_name} = @var{expr}\n    | @@[global. | session.]@var{system_var_name} = @var{expr}"),(313,11,"SOUNDEX","   SOUNDEX(@var{str})\nReturns a soundex string from @var{str}. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get\na standard soundex string.  All non-alphabetic characters are ignored in the\ngiven string. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n","mysql> SELECT SOUNDEX('Hello');\n        -> 'H400'\nmysql> SELECT SOUNDEX('Quadratically');\n        -> 'Q36324'"),(314,18,"IS_FREE_LOCK","   IS_FREE_LOCK(@var{str})\nChecks whether the lock named @var{str} is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock),\n0 if the lock is in use, and\nNULL on errors (such as incorrect arguments).\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (315,11,"UPPER","   UPPER(@var{str})\nReturns the string @var{str} with all characters changed to uppercase\naccording to the current character set mapping (the default is ISO-8859-1\nLatin1).\n","mysql> SELECT UPPER('Hej');\n        -> 'HEJ'"),(316,19,"FLUSH QUERY CACHE","You can defragment the query cache to better utilize its memory\nwith the FLUSH QUERY CACHE statement.\nThe statement does not remove any queries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache.  The FLUSH TABLES statement also does this.\n",""),(317,3,"DROP VIEW","DROP VIEW removes one or more views. You must have the DROP\nprivilege for each view.\n\nYou can use the keywords IF EXISTS to prevent an error from occurring\nfor views that don't exist.  When this clause is given, a NOTE is\ngenerated for each non-existent view.\nSee also : [SHOW WARNINGS,  , SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n","DROP VIEW [IF EXISTS]\n    @var{view_name} [, @var{view_name}] ...\n    [RESTRICT | CASCADE]"),(318,20,"CURRENT_USER","   CURRENT_USER()\nReturns the username and hostname combination that the current session was authenticated\nas. This value corresponds to the MySQL account that determines your\naccess privileges. It can be different from the value of USER().\n","mysql> SELECT USER();\n        -> 'davida@localhost'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user ''@'localhost' to\ndatabase 'mysql'\nmysql> SELECT CURRENT_USER();\n        -> '@localhost'"),(319,15,"DAYOFWEEK","   DAYOFWEEK(@var{date})\nReturns the weekday index\nfor @var{date} (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday).  These index values correspond to the ODBC standard.\n","mysql> SELECT DAYOFWEEK('1998-02-03');\n        -> 3"),(320,26,"LOAD INDEX","The LOAD INDEX INTO CACHE statement preloads a table index into the\nkey cache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise.  LOAD INDEX INTO\nCACHE is used only for MyISAM tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the non-leaf\nnodes of the index to be preloaded.\n","LOAD INDEX INTO CACHE\n  @var{tbl_index_list} [, @var{tbl_index_list}] ...\n\n@var{tbl_index_list}:\n  @var{tbl_name}\n    [[INDEX|KEY] (@var{index_name}[, @var{index_name}] ...)]\n    [IGNORE LEAVES]"),(321,26,"TRUNCATE TABLE","TRUNCATE TABLE empties a table completely.\nLogically, this is equivalent to a DELETE statement that deletes all\nrows, but there are practical differences under some circumstances.\n\nFor InnoDB, TRUNCATE TABLE is mapped to\nDELETE, so there is no difference. For other storage engines,\nTRUNCATE TABLE differs from DELETE FROM ...\nin the following ways from MySQL 4.0 and up:\n\n --- Truncate operations drop and re-create the table, which is much faster\nthan deleting rows one by one.\n --- Truncate operations are not transaction-safe; you will get an error if\nyou have an active transaction or an active table lock.\n --- The number of deleted rows is not returned.\n --- As long as the table definition file *@var{tbl_name.frm} is\nvalid, the table can be re-created as an empty table with TRUNCATE\nTABLE, even if the data or index files have become corrupted.\n --- The table handler does not remember the last used AUTO_INCREMENT\nvalue, but starts counting from the beginning.  This is true even for\nMyISAM, which normally does not reuse sequence values.\n\nIn MySQL 3.23, TRUNCATE TABLE is mapped to\nCOMMIT; DELETE FROM @var{tbl_name}, so it behaves like DELETE.\nSee also : [DELETE,  , DELETE].\n\nTRUNCATE TABLE is an Oracle SQL extension.\nThis statement was added in MySQL 3.23.28, although from 3.23.28\nto 3.23.32, the keyword TABLE must be omitted.\n","TRUNCATE TABLE @var{tbl_name}"),(322,1,"MEDIUMINT","   MEDIUMINT[(@var{M})] [UNSIGNED] [ZEROFILL]\n\nA medium-size integer. The signed range is -8388608 to\n8388607. The unsigned range is 0 to 16777215.\n",""),(323,11,"UCASE","   UCASE(@var{str})\n\nUCASE() is a synonym for UPPER().\n",""),(324,21,"ISCLOSED","   IsClosed(@var{ls})\nReturns 1 if the LineString value @var{ls} is closed\n(that is, its StartPoint() and EndPoint() values are the same).\nReturns 0 if @var{ls} is not closed, and @minus{}1 if it is NULL.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT IsClosed(GeomFromText(@ls));\n+-----------------------------+\n| IsClosed(GeomFromText(@ls)) |\n+-----------------------------+\n|                           0 |\n+-----------------------------+"),(325,1,"YEAR TYPE","   YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit format.\nIn four-digit format, the\nallowable values are 1901 to 2155, and 0000.\nIn two-digit format, the allowable values are\n70 to 69, representing years from\n1970 to 2069.  MySQL displays YEAR values in\nYYYY format, but allows you to assign values to YEAR columns\nusing either strings or numbers. The YEAR type is unavailable prior\nto MySQL 3.22.\n",""),(326,15,"SECOND","   SECOND(@var{time})\nReturns the second for @var{time}, in the range 0 to 59.\n","mysql> SELECT SECOND('10:05:03');\n        -> 3"),(327,11,"POSITION","   POSITION(@var{substr} IN @var{str})\n\nPOSITION(@var{substr IN @var{str})} is a synonym for LOCATE(@var{substr,@var{str})}.\n","mysql> SELECT LOCATE('bar', 'foobarbar');\n        -> 4\nmysql> SELECT LOCATE('xbar', 'foobar');\n        -> 0\nmysql> SELECT LOCATE('bar', 'foobarbar',5);\n        -> 7"),(328,19,"CONSTRAINT","The syntax of a foreign key constraint definition in InnoDB looks like\nthis:\n\n[CONSTRAINT @var{symbol}] FOREIGN KEY [@var{id}] (@var{index_col_name}, ...)\n    REFERENCES @var{tbl_name} (@var{index_col_name}, ...)\n    [ON DELETE {RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT}]\n    [ON UPDATE {RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT}]\n","CREATE TABLE product (category INT NOT NULL, id INT NOT NULL,\n                      price DECIMAL,\n                      PRIMARY KEY(category, id)) TYPE=INNODB;\nCREATE TABLE customer (id INT NOT NULL,\n                      PRIMARY KEY (id)) TYPE=INNODB;\nCREATE TABLE product_order (no INT NOT NULL AUTO_INCREMENT,\n                      product_category INT NOT NULL,\n                      product_id INT NOT NULL,\n                      customer_id INT NOT NULL,\n                      PRIMARY KEY(no),\n                      INDEX (product_category, product_id),\n                      FOREIGN KEY (product_category, product_id)\n                        REFERENCES product(category, id)\n                        ON UPDATE CASCADE ON DELETE RESTRICT,\n                      INDEX (customer_id),\n                      FOREIGN KEY (customer_id)\n                        REFERENCES customer(id)) TYPE=INNODB;"),(329,22,"SUM","   SUM(@var{expr})\nReturns the sum of @var{expr}.  If the return set has no rows,\nSUM() returns NULL.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (330,19,"REPAIR","REPAIR TABLE repairs a possibly corrupted table.\nBy default,\nit has the same effect as @command{myisamchk --recover @var{tbl_name}}.\nREPAIR TABLE works only on MyISAM tables.\n","REPAIR [LOCAL | NO_WRITE_TO_BINLOG] TABLE\n    @var{tbl_name} [, @var{tbl_name}] ... [QUICK] [EXTENDED] [USE_FRM]"),(331,11,"ORD","   ORD(@var{str})\nIf the leftmost character of the string @var{str} is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code * 256)\n+ (3rd byte code * 256^2) ...\n\nIf the leftmost character is not a multi-byte character, ORD()\nreturns the same value as the ASCII() function.\n","mysql> SELECT ORD('2');\n        -> 50"),(332,21,"POINTN","   PointN(@var{ls},@var{n})\nReturns the @var{n}-th point in the Linestring value @var{ls}.\nPoint numbers begin at 1.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+"),(333,1,"VARCHAR","   [NATIONAL] VARCHAR(@var{M}) [BINARY]\n\nA variable-length string.  @var{M} represents the maximum column length.\nThe range of @var{M} is 0 to 255 characters (1 to 255 prior to MySQL 4.0.2).\n\nNote: Trailing spaces are removed when VARCHAR values are\nstored, which differs from the standard SQL specification.\n\nFrom MySQL 4.1.0 on, a VARCHAR column with a length specification\ngreater than 255 is converted to the smallest TEXT type that can hold\nvalues of the given length.  For example, VARCHAR(500) is converted\nto TEXT, and VARCHAR(200000) is converted to\nMEDIUMTEXT.  This is a compatibility feature.\nHowever, this conversion affects trailing-space removal.\n\nVARCHAR is shorthand for CHARACTER VARYING.\n\nThe BINARY attribute causes sorting and comparisons to be\ncase sensitive.\n",""),(334,14,"CASE","   CASE @var{value} WHEN [@var{compare-value}] THEN @var{result} [WHEN [@var{compare-value}] THEN @var{result} ...] [ELSE @var{result}] END\n   CASE WHEN [@var{condition}] THEN @var{result} [WHEN [@var{condition}] THEN @var{result} ...] [ELSE @var{result}] END\n\nThe first version returns the @var{result} where\n@var{value=@var{compare-value}}. The second version returns the result for\nthe first condition that is true. If there was no matching result\nvalue, the result after ELSE is returned, or NULL if there is no\nELSE part.\n","mysql> SELECT CASE 1 WHEN 1 THEN 'one'\n    ->     WHEN 2 THEN 'two' ELSE 'more' END;\n        -> 'one'\nmysql> SELECT CASE WHEN 1>0 THEN 'true' ELSE 'false' END;\n        -> 'true'\nmysql> SELECT CASE BINARY 'B'\n    ->     WHEN 'a' THEN 1 WHEN 'b' THEN 2 END;\n        -> NULL"),(335,6,"MBR DEFINITION","Every geometry occupies some position in space. The exterior of\na geometry is all space not occupied by the geometry. The interior\nis the space occupied by the geometry. The boundary is the\ninterface between the geometry's interior and exterior.\n\n --- Its MBR (Minimum Bounding Rectangle), or Envelope.\nThis is the bounding geometry, formed by the minimum and maximum (X,Y)\ncoordinates:\n","((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))"),(336,11,"MID","   MID(@var{str},@var{pos},@var{len})\n\nMID(@var{str,@var{pos},@var{len})} is a synonym for\nSUBSTRING(@var{str,@var{pos},@var{len})}.\n",""),(337,6,"MBRINTERSECTS","   MBRIntersects(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangles of\nthe two geometries @var{g1} and @var{g2} intersect.\n",""),(338,11,"NOT LIKE","   @var{expr} NOT LIKE @var{pat} [ESCAPE '@var{escape-char}']\n\nThis is the same as NOT (@var{expr LIKE @var{pat} [ESCAPE '@var{escape-char}'])}.\n",""),(339,8,"DES_DECRYPT","   DES_DECRYPT(@var{crypt_str}[,@var{key_str}])\n\nDecrypts a string encrypted with DES_ENCRYPT().\nOn error, this function returns NULL.\n\nNote that this function works only if MySQL has been configured with\nSSL support. See also : [Secure connections].\n\nIf no @var{key_str} argument is given, DES_DECRYPT() examines\nthe first byte of the encrypted string to determine the DES key number\nthat was used to encrypt the original string, and then reads the key\nfrom the DES key file to decrypt the message.  For this to work,\nthe user must have the SUPER privilege. The key file can be specified\nwith the --des-key-file server option.\n\nIf you pass this function a @var{key_str} argument, that string\nis used as the key for decrypting the message.\n\nIf the @var{crypt_str} argument doesn't look like an encrypted string,\nMySQL will return the given @var{crypt_str}.\n",""),(340,11,"OCT","   OCT(@var{N})\nReturns a string representation of the octal value of @var{N}, where\n@var{N} is a longlong (BIGINT)number.  This is equivalent to\nCONV(N,10,8).\nReturns NULL if @var{N} is NULL.\n","mysql> SELECT OCT(12);\n        -> '14'"),(341,18,"GET_LOCK","   GET_LOCK(@var{str},@var{timeout})\nTries to obtain a lock with a name given by the string @var{str}, with a\ntimeout of @var{timeout} seconds.  Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has already locked the name), or NULL if an error\noccurred (such as running out of memory or the thread was killed with\n@command{mysqladmin kill}).  If you have a lock obtained with GET_LOCK(),\nit is released when you execute\nRELEASE_LOCK(), execute a new GET_LOCK(), or your connection\nterminates (either normally or abnormally).\n\nThis function can be used to implement application locks or to\nsimulate record locks.  Names are locked on a server-wide basis.\nIf a name has been locked by one client, GET_LOCK() blocks\nany request by another client for a lock with the same name. This\nallows clients that agree on a given lock name to use the name to\nperform cooperative advisory locking.\n","mysql> SELECT GET_LOCK('lock1',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK('lock2');\n        -> 1\nmysql> SELECT GET_LOCK('lock2',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK('lock2');\n        -> 1\nmysql> SELECT RELEASE_LOCK('lock1');\n        -> NULL"),(342,5,"ASBINARY","   AsBinary(@var{g})\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n","SELECT AsBinary(g) FROM geom;"),(343,15,"YEAR","   YEAR(@var{date})\nReturns the year for @var{date}, in the range 1000 to 9999.\n","mysql> SELECT YEAR('98-02-03');\n        -> 1998"),(344,20,"BENCHMARK","   BENCHMARK(@var{count},@var{expr})\nThe BENCHMARK() function executes the expression @var{expr}\nrepeatedly @var{count} times.  It may be used to time how fast MySQL\nprocesses the expression.  The result value is always 0.  The intended\nuse is from within the @command{mysql} client, which reports query execution times:\n","mysql> SELECT BENCHMARK(1000000,ENCODE('hello','goodbye'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE('hello','goodbye')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (345,11,"CAST","The CAST() and CONVERT() functions can be used to take a\nvalue of one type and produce a value of another type.\n\nThe @var{type} can be one of the following values:\n\n --- BINARY\n --- CHAR\n --- DATE\n --- DATETIME\n --- SIGNED [INTEGER]\n --- TIME\n --- UNSIGNED [INTEGER]\n\nBINARY produces a binary string. See the entry for the BINARY\noperator in this section for a description of how this affects comparisons.\n\nCAST() and CONVERT() are available as of MySQL 4.0.2.\nThe CHAR conversion type is available as of 4.0.6.\nThe USING form of CONVERT() is available as of 4.1.0.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax.\nThe non-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets.  In MySQL, transcoding names are the same as the\ncorresponding character set names.  For example, this statement converts\nthe string 'abc' in the server's default character set to the\ncorresponding string in the utf8 character set:\n\nSELECT CONVERT('abc' USING utf8);\n\n  \n\nThe cast functions are useful when you want to create a column with\na specific type in a CREATE ... SELECT statement:\n","SELECT @var{enum_col} FROM @var{tbl_name} ORDER BY CAST(@var{enum_col} AS CHAR);"),(346,26,"CACHE INDEX","The CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables.\n\nThe following statement assigns indexes from the tables t1,\nt2, and t3 to the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n","CACHE INDEX\n  @var{tbl_index_list} [, @var{tbl_index_list}] ...\n  IN @var{key_cache_name}\n\n@var{tbl_index_list}:\n  @var{tbl_name} [[INDEX|KEY] (@var{index_name}[, @var{index_name}] ...)]"),(347,17,"LINEFROMTEXT","   LineFromText(@var{wkt}[,@var{srid}])\n   LineStringFromText(@var{wkt}[,@var{srid}])\nConstructs a LINESTRING value using its WKT representation and SRID.\n",""),(348,17,"GEOMCOLLFROMTEXT","   GeomCollFromText(@var{wkt}[,@var{srid}])\n   GeometryCollectionFromText(@var{wkt}[,@var{srid}])\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n",""),(349,17,"ASTEXT","   AsText(@var{g})\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n","mysql> SELECT AsText(g) FROM geom;\n+-------------------------+\n| AsText(p1)              |\n+-------------------------+\n| POINT(1 1)              |\n| LINESTRING(0 0,1 1,2 2) |\n+-------------------------+"),(350,20,"VERSION","   VERSION()\nReturns a string that indicates the MySQL server version.\n","mysql> SELECT VERSION();\n        -> '4.1.3-beta-log'"),(351,6,"MBRWITHIN","   MBRWithin(@var{g1},@var{g2})\nReturns 1 or 0 to indicate whether or not the Minimum Bounding Rectangle\nof @var{g1} is within the Minimum Bounding Rectangle of @var{g2}.\n","mysql> SET @g1 = GeomFromText('Polygon((0 0,0 3,3 3,3 0,0 0))');\nmysql> SET @g2 = GeomFromText('Polygon((0 0,0 5,5 5,5 0,0 0))');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+"),(352,15,"TIMESTAMPADD","   TIMESTAMPADD(@var{interval},@var{int_expr},@var{datetime_expr})\n\nAdds the integer expression @var{int_expr} to the date or datetime expression\n@var{datetime_expr}. The unit for @var{int_expr} is given by the\ninterval argument, which should be one of the following values:\nFRAC_SECOND,\nSECOND,\nMINUTE,\nHOUR,\nDAY,\nWEEK,\nMONTH,\nQUARTER,\nor\nYEAR.\n\nThe @var{interval} value may be specified using one of keywords as shown,\nor with a prefix of SQL_TSI_. For example, DAY or\nSQL_TSI_DAY both are legal.\n",""),(353,4,"LEAST","   LEAST(@var{value1},@var{value2},...)\nWith two or more arguments, returns the smallest (minimum-valued) argument.\nThe arguments are compared using the following rules.\n\n --- If the return value is used in an INTEGER context or all arguments\nare integer-valued, they are compared as integers.\n\n --- If the return value is used in a REAL context or all arguments are\nreal-valued, they are compared as reals.\n\n --- If any argument is a case-sensitive string, the arguments are compared\nas case-sensitive strings.\n\n --- In other cases, the arguments are compared as case-insensitive strings.\n","mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST('B','A','C');\n        -> 'A'"),(354,11,"FIELD","   FIELD(@var{str},@var{str1},@var{str2},@var{str3},...)\nReturns the index of @var{str} in the @var{str1}, @var{str2},\n@var{str3}, ... list.\nReturns 0 if @var{str} is not found.\nFIELD() is the complement of ELT().\n","mysql> SELECT FIELD('ej', 'Hej', 'ej', 'Heja', 'hej', 'foo');\n        -> 2\nmysql> SELECT FIELD('fo', 'Hej', 'ej', 'Heja', 'hej', 'foo');\n        -> 0"),(355,15,"CURDATE","   CURDATE()\n\nReturns the current date as a value in 'YYYY-MM-DD' or YYYYMMDD\nformat, depending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT CURDATE();\n        -> '1997-12-15'\nmysql> SELECT CURDATE() + 0;\n        -> 19971215"),(356,15,"UTC_TIME","   UTC_TIME\n   UTC_TIME()\nReturns the current UTC time as a value in 'HH:MM:SS' or HHMMSS\nformat, depending on whether the function is used in a string or numeric\ncontext.\n","mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> '18:07:53', 180753"),(357,19,"SHOW SLAVE STATUS","SHOW SLAVE STATUS\n\nProvides status information on\nessential parameters of the slave threads. If you issue this statement using\nthe\n@command{mysql} client, you can use a \\G statement terminator rather than\nsemicolon to get a more readable vertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n          Master_Host: localhost\n          Master_User: root\n          Master_Port: 3306\n        Connect_Retry: 3\n      Master_Log_File: gbichot-bin.005\n  Read_Master_Log_Pos: 79\n       Relay_Log_File: gbichot-relay-bin.005\n        Relay_Log_Pos: 548\nRelay_Master_Log_File: gbichot-bin.005\n     Slave_IO_Running: Yes\n    Slave_SQL_Running: Yes\n      Replicate_Do_DB:\n  Replicate_Ignore_DB:\n           Last_Errno: 0\n           Last_Error:\n         Skip_Counter: 0\n  Exec_Master_Log_Pos: 79\n      Relay_Log_Space: 552\n      Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n   Master_SSL_Allowed: No\n   Master_SSL_CA_File:\n   Master_SSL_CA_Path:\n      Master_SSL_Cert:\n    Master_SSL_Cipher:\n       Master_SSL_Key:\nSeconds_Behind_Master: 8\n",""),(358,11,"SOUNDS LIKE","   @var{expr1} SOUNDS LIKE @var{expr2}\n\nThis is the same as SOUNDEX(@var{expr1) = SOUNDEX(@var{expr2})}. It is\navailable only in MySQL 4.1 or later. \n",""),(359,19,"DESCRIBE","{DESCRIBE | DESC} @var{tbl_name} [@var{col_name} | @var{wild}]\n\nDESCRIBE provides information about a table's columns.  It is a\nshortcut for SHOW COLUMNS FROM.\n","");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (360,15,"MONTH","   MONTH(@var{date})\nReturns the month for @var{date}, in the range 1 to 12.\n","mysql> SELECT MONTH('1998-02-03');\n        -> 2"),(361,19,"ANALYZE","This statement analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock.  This works on\nMyISAM and BDB tables and (as of MySQL 4.0.13) InnoDB\ntables. For MyISAM tables, this\nstatement is equivalent to using @command{myisamchk -a}.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than a\nconstant.\n","ANALYZE [LOCAL | NO_WRITE_TO_BINLOG] TABLE @var{tbl_name} [, @var{tbl_name}] ..."),(362,8,"DECODE","   DECODE(@var{crypt_str},@var{pass_str})\nDecrypts the encrypted string @var{crypt_str} using @var{pass_str} as the\npassword.  @var{crypt_str} should be a string returned from\nENCODE().\n",""),(363,22,"BIT_OR","   BIT_OR(@var{expr})\nReturns the bitwise OR of all bits in @var{expr}. The calculation is\nperformed with 64-bit (BIGINT) precision.\n",""),(364,16,"DUAL","SELECT ... FROM DUAL is an alias for SELECT ....\n(To be compatible with some other databases).\n",""),(365,10,"ASIN","   ASIN(@var{X})\nReturns the arc sine of @var{X}, that is, the value whose sine is\n@var{X}. Returns NULL if @var{X} is not in the range -1 to\n1.\n","mysql> SELECT ASIN(0.2);\n        -> 0.201358\nmysql> SELECT ASIN('foo');\n        -> 0.000000"),(366,17,"POLYFROMTEXT","   PolyFromText(@var{wkt}[,@var{srid}])\n   PolygonFromText(@var{wkt}[,@var{srid}])\nConstructs a POLYGON value using its WKT representation and SRID.\n",""),(367,20,"SYSTEM_USER","   SYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n",""),(368,10,"- BINARY","   -\nSubtraction:\n","mysql> SELECT 3-5;\n        -> -2"),(369,21,"NUMPOINTS","   NumPoints(@var{ls})\nReturns the number of points in the LineString value @var{ls}.\n","mysql> SET @ls = 'LineString(1 1,2 2,3 3)';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+"),(370,23,"ISOLATION","SET [GLOBAL | SESSION] TRANSACTION ISOLATION LEVEL\n{ READ UNCOMMITTED | READ COMMITTED | REPEATABLE READ | SERIALIZABLE }\n\nThis statement\nsets the transaction isolation level for the next transaction, globally, or\nfor the current session.\n\nThe default behavior of SET TRANSACTION is to set the isolation level\nfor the next (not yet\nstarted) transaction.  If you use the GLOBAL keyword, the statement\nsets the default transaction level globally for all new connections\ncreated from that point on. Existing connections are unaffected.\nYou need the SUPER\nprivilege to do this.  Using the SESSION keyword sets the\ndefault transaction level for all future transactions performed on the\ncurrent connection.\n\nFor descriptions of each InnoDB transaction isolation level, see\n[InnoDB transaction isolation, InnoDB transaction isolation].\nInnoDB supports each of these levels\nfrom MySQL 4.0.5 on. The default level is REPEATABLE READ.\n\nYou can set the initial default global isolation level for @command{mysqld} with\nthe --transaction-isolation option.\nSee also : [Server options].\n",""),(371,15,"EXTRACT","   EXTRACT(@var{type} FROM @var{date})\n\nThe EXTRACT() function uses the same kinds of interval type\nspecifiers as DATE_ADD() or DATE_SUB(), but extracts parts\nfrom the date rather than performing date arithmetic.\n","mysql> SELECT EXTRACT(YEAR FROM '1999-07-02');\n       -> 1999\nmysql> SELECT EXTRACT(YEAR_MONTH FROM '1999-07-02 01:02:03');\n       -> 199907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM '1999-07-02 01:02:03');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM '2003-01-02 10:30:00.00123');\n        -> 123"),(372,22,"BIT_XOR","   BIT_XOR(@var{expr})\nReturns the bitwise XOR of all bits in @var{expr}. The calculation is\nperformed with 64-bit (BIGINT) precision.\n",""),(373,2,"LINESTRING","   LineString(@var{pt1},@var{pt2},...)\nConstructs a WKB LineString value from a number of WKB Point\narguments.  If any argument is not a WKB Point, the return value\nis NULL.  If the number of Point arguments is less than two,\nthe return value is NULL.\n",""),(374,11,"QUOTE","   QUOTE(@var{str})\nQuotes a string to produce a result that can be used as a properly escaped\ndata value in an SQL statement.  The string is returned surrounded by single\nquotes and with each instance of single quote ('), backslash (\\),\nASCII NUL, and Control-Z preceded by a backslash.  If the argument is\nNULL, the return value is the word ``NULL'' without surrounding\nsingle quotes.\nThe QUOTE() function was added in MySQL 4.0.3.\n","mysql> SELECT QUOTE('Don\\'t!');\n        -> 'Don\\'t!'\nmysql> SELECT QUOTE(NULL);\n        -> NULL");
insert into help_topic (help_topic_id,help_category_id,name,description,example) values (375,13,"GEOMETRYTYPE","   GeometryType(@var{g})\nReturns as a string the name of the geometry type of which\nthe geometry instance @var{g} is a member.\nThe name will correspond to one of the instantiable Geometry subclasses.\n","mysql> SELECT GeometryType(GeomFromText('POINT(1 1)'));\n+------------------------------------------+\n| GeometryType(GeomFromText('POINT(1 1)')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+"),(376,8,"SHA","   SHA1(@var{str})\n   SHA(@var{str})\nCalculates an SHA1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a string of 40 hex\ndigits, or NULL if the argument was NULL.\nOne of the possible uses for this function is as a hash key. You can\nalso use it as a cryptographically safe function for storing passwords.\n","mysql> SELECT SHA1('abc');\n        -> 'a9993e364706816aba3e25717850c26c9cd0d89d'"),(377,19,"RESTORE","\nRESTORE TABLE @var{tbl_name} [, @var{tbl_name}] ... FROM '@var{/path/to/backup/directory}'\n\nRestores the table or tables from a backup that was made with BACKUP\nTABLE. Existing tables will not be overwritten; if you try to restore over\nan existing table, you will get an error.  Just as BACKUP TABLE,\nRESTORE TABLE currently works only for MyISAM tables.\nThe directory should be specified as a full pathname.\n\nThe backup for each table consists of its *.frm format file and\n*.MYD data file. The restore operation restores those files, then\nuses them to rebuild the *.MYI index file.  Restoring takes longer\nthan backing up due to the need to rebuild the indexes. The more indexes the\ntable has, the longer it will take.\n",""),(378,18,"UUID","   UUID()\n\nReturns a Universal Unique Identifier (UUID) generated\naccording to ``DCE 1.1: Remote Procedure Call'' (Appendix A)\nCAE (Common Applications Environment) Specifications\npublished by The Open Group in October 1997 (Document Number C706).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers that are\nnot connected to each other.\n\nA UUID is a 128-bit number represented by a string\nof five hexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\nformat:\n\n\n --- The first three numbers are generated from a timestamp.\n\n --- The fourth number preserves temporal uniqueness in case the timestamp value loses\nmonotonicity (for example, due to daylight saving time).\n\n --- The fifth number is an IEEE 802 node number that provides spatial uniqueness.  A\nrandom number is substituted if the latter is not available (for example,\nbecause the host computer has no Ethernet card, or we do not know how to\nfind the hardware address of an interface on your operating system).  In\nthis case, spatial uniqueness cannot be guaranteed. Nevertheless, a\ncollision should have /very/ low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MySQL uses a randomly generated\n48-bit number.\n","mysql> SELECT UUID();\n        -> '6ccd780c-baba-1026-9564-0040f4311e29'"),(379,19,"REVOKE","","REVOKE @var{priv_type} [(@var{column_list})] [, @var{priv_type} [(@var{column_list})]] ...\n    ON {@var{tbl_name} | * | *.* | @var{db_name}.*}\n    FROM @var{user} [, @var{user}] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM @var{user} [, @var{user}] ..."),(380,26,"REPLACE INTO","REPLACE works exactly like INSERT, except that if an old\nrecord in the table has the same value as a new record for a PRIMARY\nKEY or a UNIQUE index, the old record is deleted before the new\nrecord is inserted.\nSee also : [INSERT, ,INSERT].\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index,\nusing a REPLACE statement makes no sense. It becomes equivalent to\nINSERT, because there is no index to be used to determine whether a new\nrow duplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement.  Any missing columns are set to their default\nvalues, just as happens for INSERT.  You can't refer to values from\nthe old row and use them in the new row.  It appeared that you could do this\nin some old MySQL versions, but that was a bug that has been corrected.\n\nTo be able to use REPLACE, you must have INSERT and\nDELETE privileges for the table.\n","REPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] @var{tbl_name} [(@var{col_name},...)]\n    VALUES ({@var{expr} | DEFAULT},...),(...),..."),(381,15,"TIMEDIFF","   TIMEDIFF(@var{expr},@var{expr2})\n\n\nTIMEDIFF() returns the time between the start time\n@var{expr} and the end time @var{expr2}.\n@var{expr} and @var{expr2} are time or date-and-time expressions, but both\nmust be of the same type.\n","mysql> SELECT TIMEDIFF('2000:01:01 00:00:00',\n    ->                 '2000:01:01 00:00:00.000001');\n        -> '-00:00:00.000001'\nmysql> SELECT TIMEDIFF('1997-12-31 23:59:59.000001',\n    ->                 '1997-12-30 01:01:01.000002');\n        -> '46:58:57.999999'"),(382,23,"LOCK","LOCK TABLES locks tables for the current thread.  UNLOCK\nTABLES releases any locks held by the current thread.  All tables that\nare locked by the current thread are implicitly unlocked when the\nthread issues another LOCK TABLES, or when the connection to the\nserver is closed.\n","LOCK TABLES\n    @var{tbl_name} [AS @var{alias}] {READ [LOCAL] | [LOW_PRIORITY] WRITE}\n    [, @var{tbl_name} [AS @var{alias}] {READ [LOCAL] | [LOW_PRIORITY] WRITE}] ...\nUNLOCK TABLES"),(383,11,"UNCOMPRESS","   UNCOMPRESS(@var{string_to_uncompress})\nUncompresses a string compressed by the COMPRESS() function.\nIf the argument is not a compressed value, the result is NULL.\nThis function requires MySQL to have been compiled with a compression library\nsuch as zlib. Otherwise, the return value is always NULL.\n","mysql> SELECT UNCOMPRESS(COMPRESS('any string'));\n        -> 'any string'\nmysql> SELECT UNCOMPRESS('any string');\n        -> NULL"),(384,22,"GROUP_CONCAT","   GROUP_CONCAT(@var{expr})\nThis function returns a string result with the concatenated values from a\ngroup.  The full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] @var{expr} [,@var{expr} ...]\n             [ORDER BY {@var{unsigned_integer} | @var{col_name} | @var{expr}}\n                 [ASC | DESC] [,@var{col_name} ...]]\n             [SEPARATOR @var{str_val}])\n","mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student \n    ->     GROUP BY student_name;"),(385,11,"NOT REGEXP","   @var{expr} NOT REGEXP @var{pat}\n   @var{expr} NOT RLIKE @var{pat}\n\nThis is the same as NOT (@var{expr REGEXP @var{pat})}.\n",""),(386,15,"DATE_FORMAT","   DATE_FORMAT(@var{date},@var{format})\nFormats the @var{date} value according to the @var{format} string. The\nfollowing specifiers may be used in the @var{format} string:\n\n     Specifier 	 Description\n   %a 	 Abbreviated weekday name (Sun..Sat)\n   %b 	 Abbreviated month name (Jan..Dec)\n   %c 	 Month, numeric (0..12)\n   %D 	 Day of the month with English suffix (0th, 1st, 2nd, 3rd, ...)\n   %d 	 Day of the month, numeric (00..31)\n   %e 	 Day of the month, numeric (0..31)\n   %f 	 Microseconds (000000..999999)\n   %H 	 Hour (00..23)\n   %h 	 Hour (01..12)\n   %I 	 Hour (01..12)\n   %i 	 Minutes, numeric (00..59)\n   %j 	 Day of year (001..366)\n   %k 	 Hour (0..23)\n   %l 	 Hour (1..12)\n   %M 	 Month name (January..December)\n   %m 	 Month, numeric (00..12)\n   %p 	 AM or PM\n   %r 	 Time, 12-hour (hh:mm:ss followed by AM or PM)\n   %S 	 Seconds (00..59)\n   %s 	 Seconds (00..59)\n   %T 	 Time, 24-hour (hh:mm:ss)\n   %U 	 Week (00..53), where Sunday is the first day of the week\n   %u 	 Week (00..53), where Monday is the first day of the week\n   %V 	 Week (01..53), where Sunday is the first day of the week; used with %X\n   %v 	 Week (01..53), where Monday is the first day of the week; used with %x\n   %W 	 Weekday name (Sunday..Saturday)\n   %w 	 Day of the week (0=Sunday..6=Saturday)\n   %X 	 Year for the week where Sunday is the first day of the week, numeric, four digits; used with %V\n   %x 	 Year for the week, where Monday is the first day of the week, numeric, four digits; used with %v\n   %Y 	 Year, numeric, four digits\n   %y 	 Year, numeric, two digits\n   %% 	 A literal %.\n  \n\nAll other characters are copied to the result without interpretation.\n\nThe %v, %V, %x, and %X format specifiers are\navailable as of MySQL 3.23.8.  %f is available as of MySQL 4.1.1.\n\nAs of MySQL 3.23, the % character is required before\nformat specifier characters.  In earlier versions of MySQL,\n% was optional.\n\nThe reason the ranges for the month and day specifiers begin with zero\nis that MySQL allows incomplete dates such as '2004-00-00' to be\nstored as of MySQL 3.23.\n","mysql> SELECT DATE_FORMAT('1997-10-04 22:23:00', '%W %M %Y');\n        -> 'Saturday October 1997'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00', '%H:%i:%s');\n        -> '22:23:00'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00',\n                          '%D %y %a %d %m %b %j');\n        -> '4th 97 Sat 04 10 Oct 277'\nmysql> SELECT DATE_FORMAT('1997-10-04 22:23:00',\n                          '%H %k %I %r %T %S %w');\n        -> '22 22 10 10:23:00 PM 22:23:00 00 6'\nmysql> SELECT DATE_FORMAT('1999-01-01', '%X %V');\n        -> '1998 52'"),(387,15,"UNIX_TIMESTAMP","   UNIX_TIMESTAMP()\n   UNIX_TIMESTAMP(@var{date})\nIf called with no argument, returns a Unix timestamp (seconds since\n'1970-01-01 00:00:00' GMT) as an unsigned integer. If\nUNIX_TIMESTAMP() is called with a @var{date} argument, it\nreturns the value of the argument as seconds since '1970-01-01\n00:00:00' GMT.  @var{date} may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format\nYYMMDD or YYYYMMDD in local time.\n","mysql> SELECT UNIX_TIMESTAMP();\n        -> 882226357\nmysql> SELECT UNIX_TIMESTAMP('1997-10-04 22:23:00');\n        -> 875996580"),(388,14,"IF","   IF(@var{expr1},@var{expr2},@var{expr3})\nIf @var{expr1} is TRUE (@var{expr1 <> 0} and @var{expr1 <> NULL}) then\nIF() returns @var{expr2}, else it returns @var{expr3}.\nIF() returns a numeric or string value, depending on the context\nin which it is used.\n","mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,'yes','no');\n        -> 'yes'\nmysql> SELECT IF(STRCMP('test','test1'),'no','yes');\n        -> 'no'"),(389,15,"SUBDATE","   SUBDATE(@var{date},INTERVAL @var{expr} @var{type})\n   SUBDATE(@var{expr},@var{days})\n\nWhen invoked with the INTERVAL form of the second argument,\nSUBDATE() is a synonym for DATE_SUB().\nFor information on the INTERVAL argument, see the\ndiscussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\nmysql> SELECT SUBDATE('1998-01-02', INTERVAL 31 DAY);\n        -> '1997-12-02'\n\nAs of MySQL 4.1.1, the second syntax is allowed, where @var{expr} is a date\nor datetime expression and @var{days} is the number of days to be\nsubtracted from @var{expr}.\n\nmysql> SELECT SUBDATE('1998-01-02 12:00:00', 31);\n        -> '1997-12-02 12:00:00'\n","");

insert into help_keyword (help_keyword_id,name) values (0,"CEIL"),(1,"IN"),(2,"DISABLE"),(3,"MERGE"),(4,"STRIPED"),(5,"IS"),(6,"CHARACTER"),(7,"DATE_SUB"),(8,"REPLICATION"),(9,"REFERENCES"),(10,"UNCOMMITTED"),(11,"DESC"),(12,"INNOBASE"),(13,"LINES"),(14,"LEVEL");
insert into help_keyword (help_keyword_id,name) values (15,"SPATIAL"),(16,"LEADING"),(17,"OFFSET"),(18,"START"),(19,"INNER"),(20,"AGGREGATE"),(21,"SAVEPOINT"),(22,"MULTIPOINTFROMTEXT"),(23,"CHECK"),(24,"FAST"),(25,"BEGIN"),(26,"BINARY"),(27,"AFTER"),(28,"SQL_BIG_RESULT"),(29,"CHAR");
insert into help_keyword (help_keyword_id,name) values (30,"STATUS"),(31,"FROM"),(32,"MYISAM"),(33,"MASTER_SSL"),(34,"AUTOCOMMIT"),(35,"MAX_CONNECTIONS_PER_HOUR"),(36,"VARIABLE"),(37,"SQL_CALC_FOUND_ROWS"),(38,"INTEGER"),(39,"USE"),(40,"WARNINGS"),(41,"LOW_PRIORITY"),(42,"DES_KEY_FILE"),(43,"IGNORE"),(44,"COMMITTED");
insert into help_keyword (help_keyword_id,name) values (45,"LIMIT"),(46,"FILE"),(47,"<>"),(48,"PASSWORD"),(49,"EXISTS"),(50,"INDEX"),(51,"SHA1"),(52,"TEMPORARY"),(53,"SIGNED"),(54,"SHOW"),(55,"GLOBAL"),(56,"FIXED"),(57,"MULTILINESTRINGFROMTEXT"),(58,"MASTER"),(59,"CASCADE");
insert into help_keyword (help_keyword_id,name) values (60,"FORCE"),(61,"RELAY_LOG_FILE"),(62,"CHANGE"),(63,"KEYS"),(64,"COMMIT"),(65,"COMPRESSED"),(66,"ENCLOSED"),(67,"MASTER_PORT"),(68,"SQL_NO_CACHE"),(69,"DELAY_KEY_WRITE"),(70,"MASTER_HOST"),(71,"WITH"),(72,"HOUR_SECOND"),(73,"USAGE"),(74,"TABLE");
insert into help_keyword (help_keyword_id,name) values (75,"YEAR_MONTH"),(76,"GRANTS"),(77,"NO_WRITE_TO_BINLOG"),(78,"REGEXP"),(79,"SCHEMAS"),(80,"USING"),(81,"UNLOCK"),(82,"WORK"),(83,"VALUES"),(84,"READ"),(85,"TINYTEXT"),(86,"FLOAT4"),(87,"BYTE"),(88,"FLOAT8"),(89,"SLAVE");
insert into help_keyword (help_keyword_id,name) values (90,"REAL"),(91,"INDEXES"),(92,"RAID_TYPE"),(93,"ASC"),(94,"NEXT"),(95,"ADD"),(96,"MODIFY"),(97,"FLOOR"),(98,"FULLTEXT"),(99,"X509"),(100,"PREV"),(101,"CIPHER"),(102,"SOUNDS"),(103,"CONVERT"),(104,"LOGS");
insert into help_keyword (help_keyword_id,name) values (105,"LEFT"),(106,"KEY"),(107,"BOTH"),(108,"SQL_SMALL_RESULT"),(109,"MOD"),(110,"RESET"),(111,"MASTER_SSL_CERT"),(112,"MEMORY"),(113,"PROCESSLIST"),(114,"FOREIGN"),(115,"REPLACE"),(116,"CACHE"),(117,"DROP"),(118,"SHUTDOWN"),(119,"AVG_ROW_LENGTH");
insert into help_keyword (help_keyword_id,name) values (120,"CONCURRENT"),(121,"DATA"),(122,"MASTER_SSL_KEY"),(123,"STARTING"),(124,"MULTIPOINTFROMWKB"),(125,"DISTINCTROW"),(126,"DATE"),(127,"LONGBINARY"),(128,"RETURNS"),(129,"REPEATABLE"),(130,"HIGH_PRIORITY"),(131,"RENAME"),(132,"GEOMETRYCOLLECTIONFROMWKB"),(133,"VARYING"),(134,"NO");
insert into help_keyword (help_keyword_id,name) values (135,"LIKE"),(136,"EVENTS"),(137,"NATURAL"),(138,"DATETIME"),(139,"LAST"),(140,"USER_RESOURCES"),(141,"ALTER"),(142,"ROW_FORMAT"),(143,"MASTER_LOG_FILE"),(144,"CREATE"),(145,"MIDDLEINT"),(146,"INTERVAL"),(147,"AES_ENCRYPT"),(148,"MAX"),(149,"GRANT");
insert into help_keyword (help_keyword_id,name) values (150,"HEAP"),(151,"ROLLBACK"),(152,"CHECKSUM"),(153,"MASTER_SSL_CIPHER"),(154,"ON"),(155,"ENGINES"),(156,"RAID_CHUNKS"),(157,"OR"),(158,"DATE_ADD"),(159,"SQL_SLAVE_SKIP_COUNTER"),(160,"BDB"),(161,"SHARE"),(162,"MULTIPOLYGONFROMTEXT"),(163,"MODE"),(164,"POLYGONFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (165,"STOP"),(166,"PROCEDURE"),(167,"MRG_MYISAM"),(168,"FULL"),(169,"ORDER"),(170,"SEPARATOR"),(171,"SUPER"),(172,"INSERT_METHOD"),(173,"MINUTE"),(174,"OPEN"),(175,"NONE"),(176,"OPTION"),(177,"WRITE"),(178,"MASTER_CONNECT_RETRY"),(179,"RELOAD");
insert into help_keyword (help_keyword_id,name) values (180,"ISAM"),(181,"SCHEMA"),(182,"AS"),(183,"CLIENT"),(184,"GEOMETRYCOLLECTIONFROMTEXT"),(185,"NOT"),(186,"NULL"),(187,"SQL_CACHE"),(188,"MEDIUMTEXT"),(189,"DELETE"),(190,"LINESTRINGFROMTEXT."),(191,"DECIMAL"),(192,"TIME"),(193,"ZEROFILL"),(194,"RESTRICT");
insert into help_keyword (help_keyword_id,name) values (195,"INSERT"),(196,"GROUP"),(197,"BY"),(198,"CLOSE"),(199,"COLUMN"),(200,"SQL_THREAD"),(201,"COUNT"),(202,"SESSION"),(203,"NCHAR"),(204,"DAY_MINUTE"),(205,"SERIAL"),(206,"SQL_LOG_BIN"),(207,"AGAINST"),(208,"FUNCTION"),(209,"FIELDS");
insert into help_keyword (help_keyword_id,name) values (210,"BOOLEAN"),(211,"LONGTEXT"),(212,"OPTIONALLY"),(213,"SERIALIZABLE"),(214,"UNIQUE"),(215,"INNODB"),(216,"PARTIAL"),(217,"MATCH"),(218,"MAX_UPDATES_PER_HOUR"),(219,"JOIN"),(220,"TYPES"),(221,"MAX_ROWS"),(222,"SONAME"),(223,"MULTIPOLYGONFROMWKB"),(224,"FLUSH");
insert into help_keyword (help_keyword_id,name) values (225,"ENGINE"),(226,"BTREE"),(227,"CSV"),(228,"BIGINT"),(229,"DAY"),(230,"UNSIGNED"),(231,"DISTINCT"),(232,"TRAILING"),(233,"SELECT"),(234,"HOUR"),(235,"IO_THREAD"),(236,"EXECUTE"),(237,"END"),(238,"DATABASES"),(239,"POLYGONFROMWKB");
insert into help_keyword (help_keyword_id,name) values (240,"DEFAULT"),(241,"BERKELEYDB"),(242,"RAID0"),(243,"FALSE"),(244,"MASTER_LOG_POS"),(245,"PACK_KEYS"),(246,"QUICK"),(247,"RIGHT"),(248,"OUTER"),(249,"TIMESTAMP"),(250,"MASTER_PASSWORD"),(251,"LONG"),(252,"IMPORT"),(253,"INT1"),(254,"INT2");
insert into help_keyword (help_keyword_id,name) values (255,"INT3"),(256,"RAID_CHUNKSIZE"),(257,"SSL"),(258,"INT4"),(259,"TABLES"),(260,"DAY_HOUR"),(261,"WHERE"),(262,"INT8"),(263,"RELAY_LOG_POS"),(264,"TO"),(265,"MIN_ROWS"),(266,"DELAYED"),(267,"BETWEEN"),(268,"HOSTS"),(269,"MASTER_SSL_CA");
insert into help_keyword (help_keyword_id,name) values (270,"PROCESS"),(271,"DATABASE"),(272,"STD"),(273,"ELSE"),(274,"ALL"),(275,"INTO"),(276,"HOUR_MINUTE"),(277,"BIT"),(278,"DUMPFILE"),(279,"CHANGED"),(280,"RTREE"),(281,"UPDATE"),(282,"VIEW"),(283,"SET"),(284,"TRUE");
insert into help_keyword (help_keyword_id,name) values (285,"DUPLICATE"),(286,"NATIONAL"),(287,"VARIABLES"),(288,"EXTENDED"),(289,"THEN"),(290,"TYPE"),(291,"LOAD"),(292,"GEOMETRYFROMWKB"),(293,"USE_FRM"),(294,"MAX_QUERIES_PER_HOUR"),(295,"SECOND"),(296,"ERRORS"),(297,"CONSTRAINT"),(298,"MEDIUM"),(299,"ENABLE");
insert into help_keyword (help_keyword_id,name) values (300,"MINUTE_SECOND"),(301,"VARCHARACTER"),(302,"ESCAPE"),(303,"DEC"),(304,"BACKUP"),(305,"COLUMNS"),(306,"AND"),(307,"CROSS"),(308,"LINESTRINGFROMWKB"),(309,"OUTFILE"),(310,"POW"),(311,"SECURITY"),(312,"MIN"),(313,"YEAR"),(314,"PRIVILEGES");
insert into help_keyword (help_keyword_id,name) values (315,"COMMENT"),(316,"TRANSACTION"),(317,"ESCAPED"),(318,"INFILE"),(319,"ACTION"),(320,"REQUIRE"),(321,"LOCAL"),(322,"FIRST"),(323,"TERMINATED"),(324,"QUERY"),(325,"MONTH"),(326,"IDENTIFIED"),(327,"DIRECTORY"),(328,"BINLOG"),(329,"BOOL");
insert into help_keyword (help_keyword_id,name) values (330,"DYNAMIC"),(331,"SQL_BUFFER_RESULT"),(332,"FOR"),(333,"STRING"),(334,"ISSUER"),(335,"PRECISION"),(336,"ISOLATION"),(337,"DAY_SECOND"),(338,"SUBJECT"),(339,"PRIMARY"),(340,"VALUE"),(341,"MASTER_USER"),(342,"REVOKE"),(343,"WHEN"),(344,"GEOMETRYFROMTEXT");
insert into help_keyword (help_keyword_id,name) values (345,"LOCK"),(346,"HAVING"),(347,"IF"),(348,"MULTILINESTRINGFROMWKB"),(349,"STRAIGHT_JOIN");

insert into help_relation (help_topic_id,help_keyword_id) values (103,0),(261,1),(65,1),(263,1),(272,2),(296,3),(296,4),(178,5),(27,6),(333,6),(248,6),(254,7),(166,8),(166,9),(328,9);
insert into help_relation (help_topic_id,help_keyword_id) values (296,9),(370,10),(359,11),(263,11),(384,11),(296,12),(96,13),(370,14),(272,15),(284,15),(11,16),(263,17),(70,18),(125,18),(249,19);
insert into help_relation (help_topic_id,help_keyword_id) values (238,20),(19,21),(188,22),(296,23),(21,24),(125,25),(27,26),(71,26),(345,26),(333,26),(272,27),(263,28),(252,29),(345,29),(357,30);
insert into help_relation (help_topic_id,help_keyword_id) values (62,30),(44,30),(52,31),(65,31),(263,31),(214,31),(62,31),(11,31),(251,31),(296,32),(39,33),(125,34),(166,35),(312,36),(263,37);
insert into help_relation (help_topic_id,help_keyword_id) values (238,38),(194,38),(249,39),(62,40),(96,41),(214,41),(308,41),(380,41),(18,41),(382,41),(256,42),(272,43),(96,43),(263,43),(308,43);
insert into help_relation (help_topic_id,help_keyword_id) values (249,43),(18,43),(370,44),(65,45),(263,45),(214,45),(80,45),(308,45),(166,46),(136,47),(166,48),(262,49),(317,49),(157,49),(231,49);
insert into help_relation (help_topic_id,help_keyword_id) values (272,50),(14,50),(62,50),(246,50),(296,50),(284,50),(249,50),(376,51),(262,52),(345,53),(357,54),(71,54),(65,54),(206,54),(44,54);
insert into help_relation (help_topic_id,help_keyword_id) values (292,55),(370,55),(312,55),(121,56),(296,56),(107,57),(52,58),(71,58),(39,58),(117,58),(44,58),(251,58),(262,59),(328,59),(296,59);
insert into help_relation (help_topic_id,help_keyword_id) values (317,59),(249,60),(39,61),(272,62),(39,62),(272,63),(62,63),(125,64),(296,65),(96,66),(39,67),(263,68),(296,69),(39,70),(166,71);
insert into help_relation (help_topic_id,help_keyword_id) values (254,72),(166,73),(75,74),(52,74),(21,74),(377,74),(330,74),(262,74),(14,74),(62,74),(361,74),(254,75),(62,76),(330,77),(361,77);
insert into help_relation (help_topic_id,help_keyword_id) values (256,77),(172,78),(62,79),(214,80),(249,80),(382,81),(125,82),(380,83),(370,84),(80,84),(382,84),(13,85),(130,86),(252,87),(89,88);
insert into help_relation (help_topic_id,help_keyword_id) values (357,89),(70,89),(47,89),(282,89),(206,89),(238,90),(89,90),(62,91),(296,92),(263,93),(384,93),(80,94),(272,95),(14,95),(272,96);
insert into help_relation (help_topic_id,help_keyword_id) values (73,97),(272,98),(296,98),(284,98),(166,99),(80,100),(166,101),(358,102),(345,103),(71,104),(62,104),(249,105),(272,106),(14,106),(328,106);
insert into help_relation (help_topic_id,help_keyword_id) values (296,106),(18,106),(11,107),(263,108),(35,109),(47,110),(316,110),(117,110),(39,111),(263,112),(62,113),(272,114),(328,114),(296,114),(96,115);
insert into help_relation (help_topic_id,help_keyword_id) values (316,116),(238,117),(272,117),(262,117),(246,117),(317,117),(231,117),(166,118),(272,119),(296,119),(96,120),(96,121),(296,121),(251,121),(39,122);
insert into help_relation (help_topic_id,help_keyword_id) values (96,123),(266,124),(263,125),(7,126),(138,126),(345,126),(254,126),(183,127),(238,128),(370,129),(263,130),(18,130),(272,131),(86,132),(333,133);
insert into help_relation (help_topic_id,help_keyword_id) values (328,134),(296,134),(358,135),(62,135),(65,136),(249,137),(345,138),(80,139),(256,140),(272,141),(166,141),(14,141),(93,141),(296,142),(39,143);
insert into help_relation (help_topic_id,help_keyword_id) values (238,144),(14,144),(62,144),(296,144),(284,144),(157,144),(322,145),(254,146),(212,147),(232,148),(166,149),(296,150),(125,151),(19,151),(296,152);
insert into help_relation (help_topic_id,help_keyword_id) values (39,153),(328,154),(249,154),(62,155),(296,156),(198,157),(254,158),(292,159),(296,160),(263,161),(124,162),(261,163),(263,163),(366,164),(282,165);
insert into help_relation (help_topic_id,help_keyword_id) values (263,166),(296,167),(62,168),(296,168),(272,169),(263,169),(214,169),(308,169),(384,169),(384,170),(166,171),(296,172),(254,173),(62,174),(80,174);
insert into help_relation (help_topic_id,help_keyword_id) values (166,175),(166,176),(382,177),(39,178),(166,179),(296,180),(62,181),(248,181),(157,181),(231,181),(263,182),(249,182),(382,182),(166,183),(348,184);
insert into help_relation (help_topic_id,help_keyword_id) values (32,185),(157,185),(328,186),(178,186),(263,187),(145,188),(328,189),(296,189),(347,190),(121,191),(345,192),(171,192),(218,192),(121,193),(291,193);
insert into help_relation (help_topic_id,help_keyword_id) values (194,193),(130,193),(259,193),(89,193),(262,194),(328,194),(317,194),(167,195),(18,195),(263,196),(272,197),(166,197),(96,197),(263,197),(214,197);
insert into help_relation (help_topic_id,help_keyword_id) values (296,197),(308,197),(384,197),(80,198),(272,199),(70,200),(282,200),(233,201),(370,202),(312,202),(27,203),(254,204),(286,205),(296,205),(180,206);
insert into help_relation (help_topic_id,help_keyword_id) values (261,207),(238,208),(96,209),(62,209),(291,210),(261,210),(183,211),(96,212),(370,213),(272,214),(62,215),(296,215),(296,216),(261,217),(166,218);
insert into help_relation (help_topic_id,help_keyword_id) values (263,219),(62,220),(296,221),(238,222),(255,223),(316,224),(272,225),(296,225),(284,226),(96,227),(73,228),(254,229),(121,230),(291,230),(345,230);
insert into help_relation (help_topic_id,help_keyword_id) values (194,230),(130,230),(259,230),(89,230),(233,231),(263,231),(384,231),(11,232),(380,233),(207,233),(254,234),(70,235),(282,235),(166,236),(334,237);
insert into help_relation (help_topic_id,help_keyword_id) values (62,238),(85,239),(272,240),(286,240),(296,240),(18,240),(296,241),(296,242),(199,243),(39,244),(296,245),(21,246),(330,246),(214,246),(249,247);
insert into help_relation (help_topic_id,help_keyword_id) values (249,248),(237,249),(275,249),(39,250),(183,251),(96,252),(291,253),(82,254),(322,255),(296,256),(166,257),(194,258),(62,259),(382,259),(254,260);
insert into help_relation (help_topic_id,help_keyword_id) values (214,261),(80,261),(308,261),(259,262),(39,263),(39,264),(19,264),(296,265),(167,266),(380,266),(18,266),(195,267),(62,268),(206,268),(39,269);
insert into help_relation (help_topic_id,help_keyword_id) values (166,270),(62,271),(157,271),(231,271),(25,272),(334,273),(166,274),(263,274),(149,274),(263,275),(380,275),(18,275),(254,276),(291,277),(263,278);
insert into help_relation (help_topic_id,help_keyword_id) values (21,279),(284,280),(263,281),(328,281),(18,281),(317,282),(93,282),(272,283),(292,283),(328,283),(125,283),(180,283),(308,283),(248,283),(380,283);
insert into help_relation (help_topic_id,help_keyword_id) values (199,284),(18,285),(27,286),(333,286),(62,287),(21,288),(330,288),(334,289),(272,290),(296,290),(52,291),(96,291),(251,291),(155,292),(330,293);
insert into help_relation (help_topic_id,help_keyword_id) values (166,294),(254,295),(62,296),(272,297),(296,297),(21,298),(272,299),(254,300),(333,301),(144,302),(121,303),(75,304),(62,305),(241,306),(195,306);
insert into help_relation (help_topic_id,help_keyword_id) values (249,307),(239,308),(263,309),(244,310),(166,311),(232,312),(254,313),(166,314),(296,315),(370,316),(125,316),(96,317),(96,318),(328,319),(296,319);
insert into help_relation (help_topic_id,help_keyword_id) values (166,320),(96,321),(330,321),(361,321),(256,321),(382,321),(272,322),(80,322),(296,322),(96,323),(316,324),(254,325),(166,326),(296,327),(65,328);
insert into help_relation (help_topic_id,help_keyword_id) values (291,329),(296,330),(263,331),(263,332),(62,332),(238,333),(166,334),(89,335),(370,336),(254,337),(166,338),(272,339),(286,340),(39,341),(166,342);
insert into help_relation (help_topic_id,help_keyword_id) values (334,343),(133,344),(263,345),(382,345),(263,346),(262,347),(317,347),(157,347),(231,347),(10,348),(263,349),(249,349);

