/* keyrus - a applet for switch internation keyboard layouts

   Copyright 2005 Alexander Chukov <sash@pdaXrom.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include <libmb/mb.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <dirent.h>

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(text) gettext(text)
#else
# define _(text) (text)
#endif

#ifdef USE_LIBSN
#define SN_API_NOT_YET_FROZEN 1
#include <libsn/sn.h>
#endif 

typedef struct {
    char		name[20];
    MBPixbufImage	*pixmap;
    MBPixbufImage	*pixmap_scaled;
} Keymap;

Keymap keymaps[8];
int nummaps = 0;
int default_map = 0;

static int keybstatus = 0;

static MBPixbuf *pb;

static char* ThemeName = NULL;

#ifdef USE_LIBSN

static SnDisplay *sn_dpy;

static void 
sn_activate(char *name, char *exec_str)
{
  SnLauncherContext *context;
  pid_t child_pid = 0;

  context = sn_launcher_context_new (sn_dpy, 0);
  
  sn_launcher_context_set_name (context, name);
  sn_launcher_context_set_binary_name (context, exec_str);
  
  sn_launcher_context_initiate (context, "monoluanch launch", exec_str,
				CurrentTime);

  switch ((child_pid = fork ()))
    {
    case -1:
      fprintf (stderr, "Fork failed\n" );
      break;
    case 0:
      sn_launcher_context_setup_child_process (context);
      mb_exec(exec_str);
      fprintf (stderr, "Failed to exec %s \n", exec_str);
      _exit (1);
      break;
    }
}

#endif

int scanmaps(void)
{
    struct dirent **namelist;
    int		namecount = 0;
    char	pixname[80];
    char	*icon_path;
    int		i;
    int		ff = 0;

    fprintf(stderr, "%s() called\n", __func__);

    if (nummaps) ff = 1;
    nummaps = 0;
    default_map = keybstatus = 0;

    namecount = scandir("/etc/X11/kb/", &namelist, 0, alphasort);
    for (i = 0; i < namecount; i++) {
	if (!fnmatch("*.xmodmap_??", namelist[i]->d_name, 0)) {
	    strcpy(keymaps[nummaps].name, namelist[i]->d_name);
	    strcpy(pixname, &keymaps[nummaps].name[strlen(keymaps[nummaps].name) - 2]);
	    strcat(pixname, ".png");
	    icon_path = mb_dot_desktop_icon_get_full_path (ThemeName, 32, pixname);

	    if (ff && keymaps[nummaps].pixmap) mb_pixbuf_img_free(pb, keymaps[nummaps].pixmap);
	    if (ff && keymaps[nummaps].pixmap_scaled) mb_pixbuf_img_free(pb, keymaps[nummaps].pixmap_scaled);
	    else keymaps[nummaps].pixmap_scaled = NULL;

	    if (icon_path == NULL || !(keymaps[nummaps].pixmap = mb_pixbuf_img_new_from_file(pb, icon_path))) {
		fprintf(stderr, "mb-applet-keyboard: failed to load icon %s\n", pixname);
	        continue;
	    }

	    free(icon_path);

	    if (strcmp(pixname, "us.png") == 0) default_map = nummaps;
	    else if (strcmp(pixname, "en.png") == 0) default_map = nummaps;

	    fprintf(stderr, "keymap = %s, pixmap = %s\n", keymaps[nummaps].name, pixname);

	    nummaps++;
	}
    }

    keybstatus = default_map;

    return nummaps;
}

void 
fork_exec(char *cmd)
{
  switch (fork())
    {
    case 0:
      setpgid(0, 0); /* Stop us killing child */
      mb_exec(cmd);
      fprintf(stderr, "minitime: Failed to Launch '%s'", cmd);
      exit(1);
    case -1:
      fprintf(stderr, "minitime: Failed to Launch '%s'", cmd);
      break;
    }
}

void
paint_callback (MBTrayApp *app, Drawable drw )
{


  int      power_pixels = 0;
  unsigned char r = 0, g = 0, b = 0;
  int      x, y;
  int      bar_width, bar_height, bar_x, bar_y;

  MBPixbufImage *img_backing = NULL;
  
  img_backing = mb_tray_app_get_background (app, pb);

  mb_pixbuf_img_composite(pb, img_backing, keymaps[keybstatus].pixmap_scaled, 0, 0);

  mb_pixbuf_img_render_to_drawable(pb, img_backing, drw, 0, 0);

  mb_pixbuf_img_free( pb, img_backing );
}

void
resize_callback (MBTrayApp *app, int w, int h )
{
  int i;
  
  for (i = 0; i < nummaps; i++) {
    if (keymaps[i].pixmap_scaled) mb_pixbuf_img_free(pb, keymaps[i].pixmap_scaled);
    keymaps[i].pixmap_scaled = mb_pixbuf_img_scale(pb, keymaps[i].pixmap, w, h);
  }
}

/*
void 
load_icon(void)
{
 char *icon_path = NULL;
 
 printf("%s() called", __func__);

 if (rus_icon) mb_pixbuf_img_free(pb, rus_icon);
 if (eng_icon) mb_pixbuf_img_free(pb, eng_icon);

 icon_path = mb_dot_desktop_icon_get_full_path (ThemeName, 
						32, 
						KEYRUS_IMG );

 if (icon_path == NULL 
     || !(rus_icon = mb_pixbuf_img_new_from_file(pb, icon_path)))
    {
      fprintf(stderr, "mb-applet-keyboard: failed to load icon %s\n", KEYRUS_IMG);
      exit(1);
    }

  free(icon_path);

  icon_path = mb_dot_desktop_icon_get_full_path (ThemeName, 
						 32, 
						 KEYENG_IMG );

 if (icon_path == NULL 
     || !(eng_icon = mb_pixbuf_img_new_from_file(pb, icon_path)))
    {
      fprintf(stderr, "mb-applet-battery: failed to load icon %s\n", KEYENG_IMG);
      exit(1);
    }

 free(icon_path);

 return;
}
*/

void 
theme_callback (MBTrayApp *app, char *theme_name)
{
  if (!theme_name) return;
  if (ThemeName) free(ThemeName);
  ThemeName = strdup(theme_name);
  //load_icon();
  scanmaps();
  resize_callback (app, mb_tray_app_width(app), mb_tray_app_width(app) );
}

void
button_callback (MBTrayApp *app, int x, int y, Bool is_released )
{
  char tray_msg[256];
  char str[256];

  if (!is_released) return;

  keybstatus++;
  if (keybstatus == nummaps) keybstatus = 0;

  strcpy(str, "xmodmap /etc/X11/kb/");
  strcat(str, keymaps[keybstatus].name);

  system(str);

  mb_tray_app_repaint(app);
}

static Bool 
file_exists(char *filename)
{
  struct stat st; 		/* XXX Should probably check if exe too */
  if (stat(filename, &st)) return False;
  return True;
}

int
main( int argc, char *argv[])
{
  MBTrayApp *app = NULL;
  struct timeval tv;

  fprintf(stderr, "%s() called\n", __func__);

#if ENABLE_NLS
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, DATADIR "/locale");
  bind_textdomain_codeset (PACKAGE, "UTF-8"); 
  textdomain (PACKAGE);
#endif


  app = mb_tray_app_new ( _("Keyboard Switcher"),
			  resize_callback,
			   paint_callback,
			  &argc,
			  &argv );  
  
   pb = mb_pixbuf_new(mb_tray_app_xdisplay(app), 
		      mb_tray_app_xscreen(app));
   
   mb_tray_app_set_button_callback (app, button_callback );
   
   mb_tray_app_set_theme_change_callback (app, theme_callback );
   
   scanmaps();
//   load_icon();

   mb_tray_app_set_icon(app, pb, keymaps[default_map].pixmap);

#ifdef USE_LIBSN
  sn_dpy = sn_display_new (mb_tray_app_xdisplay(app), NULL, NULL);
#endif
   
   mb_tray_app_main (app);

   return 1;
}


