#!/bin/bash
#
# test-interaction.sh
# ====
#
# Launches a number of window types, and then via 'xnee' automates
# common user interactions.  Useful when running with valgrind.
#
# A screenshot is taken of the end result and compared to an earlier
# saved correct result. If there's a diffence, the original and new
# screenshot are shown using 'display' and test failed.

if [ -z "$(xdpyinfo | grep dimensions: | grep 240x320)" ]; then
   echo "$0: Display must be 240x320 for event playback to work correctly"
   exit 2 # 2 indicates mis-setup 
fi
if [ -z $(which xnee|grep "/xnee") ]; then
   echo "$0: 'xnee' required for event automation is missing"
   exit 2
fi
if [ -z $(which xwd|grep "/xwd") ]; then
   echo "$0: 'xwd' required for test result comparison is missing"
   exit 2
fi
if [ \! -x winspew ]; then
   echo "$0: 'winspew' test utility missing, compile it first!"
   exit 2
fi


# blondie theme required
mbcontrol -t blondie

# Launch various window types. 
./winspew -np -t "Window",normal 2>&1 > /dev/null &
./winspew -np -t "Window",dock,+0+300 2>&1 > /dev/null &
./winspew -np -t "Window",toolbar 2>&1 > /dev/null &
./winspew -np -t "Window",normal -c "Dialog",160x110 -c "Dialog",100x100 2>&1 > /dev/null &
./winspew -np -t "Window",normal -c "Dialog",160x150,accept_button:help_button 2>&1 > /dev/null &
./winspew -np -t "Window",normal -c "Dialog",320x110,no_decor 2>&1 > /dev/null &

# Now playback recorded interactions with Xnee. 
#
# To create your own 'recording', use something like the below with 
# ctrl-c to stop.
#
# xnee -ae -o test-interaction.xnee -l -1

xnee -rep -f test-interaction.xnee 2>&1 > /dev/null

# hack.. sleep for a couple of seconds and fire a xrefresh
# maybe some xnee events still queued ..

sleep 2 && xrefresh

#
# This screenshot stuff is pretty experimental....
#

ret=""
function file_compare ()
{
	if [ \! -f $1 ]; then
		ret="ERROR: file '$1' missing"
		return
	fi
	if [ \! -f $2 ]; then
		ret="ERROR: file '$2' missing"
		return
	fi
	a=$(cat $1|wc -c)
	b=$(cat $2|wc -c)
	if [ $a -eq $b ]; then
		cmp --verbose $1 $2 > $LOGS/cmp.log
		if [ $(cat $LOGS/cmp.log|wc -l) -eq 0 ]; then
			# files are exact matches
			ret=""
		else
			ret="ERROR: Files differ!\n  see '$1', '$2', '$LOGS/cmp.log'"
		fi
	else
		ret="ERROR: File sizes differ!\n$(ls -s $1 $2)\nDoes your display have correct bit-depth?"
	fi
}

echo "$0: grabbing screenshot..."
SHOT=$LOGS/out.xwd
rm -f $SHOT

#xwd -root -out ./test-interaction.xwd
xwd -root -out $SHOT

killall winspew

file_compare ./test-interaction.xwd $SHOT
if [ -z "$ret" ]; then
  echo "$0: Test Succeeded"
  exit 0
else  
  echo -e "$0: Test Failed - $ret"
  
  if [ \! -z $(which display|grep "/display") ]; then
    # assumes the main display is :0, and shows the screenshots there
    # using 'display' from ImageMagick package
    DISPLAY=:0 display -title "Correct: ./test-interaction.xwd" ./test-interaction.xwd &
    DISPLAY=:0 display -title "Failure: $SHOT" $SHOT &
    echo "(the correct and failed image are now shown using 'display')"
  fi
  exit 1
fi
