/*
 * toadkk-tcs8000.h:
 *
 * Time-stamp: <02/10/11 14:19:08 imai>
 */
#ifndef __ASM_VR41XX_TOADKK_TCS8000_H
#define __ASM_VR41XX_TOADKK_TCS8000_H

#define VR4181A_INTCS_BASE	0xaa000000	/* set by bootloader */
#define INTCS(a)		(VR4181A_INTCS_BASE+(a))

#define VR4181A_SIU0_BASE	INTCS(0x00c040)
#define VR4181A_SIU1_BASE	INTCS(0x00c010)
#define VR4181A_SIU2_BASE	INTCS(0x00c000)

#define VR4181A_CLKDIVCTRL	INTCS(0x00b002)

#define VR4181A_CMUCLKMSK0	INTCS(0x00b010)
#define VR4181A_CMUCLKMSK1	INTCS(0x00b012)
#define VR4181A_CMUCLKMSK3	INTCS(0x000490)

#define VR4181A_GPMODE0		INTCS(0x00b300)
#define VR4181A_GPMODE1		INTCS(0x00b302)
#define VR4181A_GPMODE2		INTCS(0x00b304)
#define VR4181A_GPMODE3		INTCS(0x00b306)
#define VR4181A_GPMODE4		INTCS(0x00b308)
#define VR4181A_GPMODE5		INTCS(0x00b30a)
#define VR4181A_GPMODE6		INTCS(0x00b30c)
#define VR4181A_GPMODE7		INTCS(0x00b30e)
#define VR4181A_PINMODE0	INTCS(0x00b380)
#define VR4181A_PINMODE1	INTCS(0x00b382)
#define VR4181A_PINMODE2	INTCS(0x00b384)
#define VR4181A_SIUSIGCTRL	INTCS(0x00b394)
#define VR4181A_NVREG0		INTCS(0x00b370)

#define VR4181A_USBSIGCTRL	INTCS(0x00b392)

/* bus control */
#define VR4181A_SDRAM		INTCS(0x000000)
#define VR4181A_SFLASH		INTCS(0x000008)
#define VR4181A_PCS0		INTCS(0x000010)
#define VR4181A_PCS1		INTCS(0x000018)
#define VR4181A_PCS2		INTCS(0x000020)
#define VR4181A_PCS3		INTCS(0x000028)
#define VR4181A_PCS4		INTCS(0x000030)
#define VR4181A_ISAW		INTCS(0x000038)
#define VR4181A_ISAW		INTCS(0x000038)
#define VR4181A_PCIW0		INTCS(0x000060)
#define VR4181A_PCIW1		INTCS(0x000068)
#define VR4181A_INTCS		INTCS(0x000070)
#define VR4181A_ROMCS		INTCS(0x000078)

/* ICU */
#define VR4181A_MSYSINT0REG	INTCS(0x00b090)
#define VR4181A_MSYSINT1REG	INTCS(0x00b092)
#define VR4181A_MSYSINT2REG	INTCS(0x00b094)
#define VR4181A_MSYSINT3REG	INTCS(0x00b096)

#define VR4181A_SIU0_INT	20
#define VR4181A_SIU1_INT	21
#define VR4181A_SIU2_INT	22
#define VR4181A_GPIO11_INT	83
#define VR4181A_ECU0_INT	25
#define VR4181A_ECU1_INT	27
#define VR4181A_USBHU_INT	36
#define VR4181A_USBFU_INT	37
#define VR4181A_AC97U_INT	38

#define VR41XX_PCI_IO_START	0x08000000
#define VR41XX_PCI_IO_END	0x087fffff

#define VR41XX_PCI_MEM_START	0x08800000
#define VR41XX_PCI_MEM_END	0x08ffffff

#define VR41XX_PCI_MEM1_BASE	0x08800000
#define VR41XX_PCI_MEM1_SIZE	0x00400000
#define VR41XX_PCI_MEM1_MASK	0x7f800000

#define VR41XX_PCI_MEM2_BASE	0x08c00000
#define VR41XX_PCI_MEM2_SIZE	0x00400000
#define VR41XX_PCI_MEM2_MASK	0x7f800000

/* PCMCIA */
#define VR4181A_ECUINDX0		INTCS(0x00d000)
#define VR4181A_ECUINDX1		INTCS(0x00d020)
#define VR4181A_ECUDAT0			INTCS(0x00d004)
#define VR4181A_ECUDAT1			INTCS(0x00d024)
#define VR4181A_ECUINT0			INTCS(0x00d008)
#define VR4181A_ECUINT1			INTCS(0x00d028)
#define VR4181A_ECUINTMSK0		INTCS(0x00d00c)
#define VR4181A_ECUINTMSK1		INTCS(0x00d02c)
#define VR4181A_ECUIDE0			INTCS(0x00d010)


#define VR4181A_ISAW			INTCS(0x000038)
#define VR4181A_ISATIM			INTCS(0x000138)

#define VR4181A_PCMCIA_WIN_SIZE_MEM	0x00800000
#define VR4181A_PCMCIA_WIN_SIZE_ATTR	0x00800000
#define VR4181A_PCMCIA_WIN_SIZE_IO	0x01000000

#define VR4181A_PCMCIA_MEM_BASE_0	0x10000000
#define VR4181A_PCMCIA_ATTR_BASE_0	0x10800000
#define VR4181A_PCMCIA_MEM_BASE_1	0x11000000
#define VR4181A_PCMCIA_ATTR_BASE_1	0x11800000
#define VR4181A_PCMCIA_IO_BASE_0	0x12000000
#define VR4181A_PCMCIA_IO_BASE_1	0x13000000

/* PCI */
#define VR4181A_PCICTRL_L		INTCS(0x0002e0)
#define VR4181A_PCICTRL_H		INTCS(0x0002e4)
#define VR4181A_PCIARB			INTCS(0x0002e8)
#define VR4181A_PCIINIT01		INTCS(0x0002f0)
#define VR4181A_PCIINIT11		INTCS(0x0002f8)

#define VR4181A_BAR_SDRAM		INTCS(0x000218)
#define VR4181A_BAR_ROMCS		INTCS(0x000280)

/* watchdog timer */
#define VR4181A_WDTCNTREG		INTCS(0x00b0e0)
#define VR4181A_WDTSETREG		INTCS(0x00b0e2)
#define VR4181A_WDTCLRREG		INTCS(0x00b0e4)
#define VR4181A_WDTTIMREG		INTCS(0x00b0e6)


/* address space allocation */

#define VR4181A_PCI_MEM_BASE		0x08000000
#define VR4181A_PCI_MEM_MASK		0x7f800000
#define VR4181A_PCI_MEM_SIZE		0x00800000

#define VR4181A_PCI_IO_BASE		0x08800000
#define VR4181A_PCI_IO_MASK		0x7f800000
#define VR4181A_PCI_IO_SIZE		0x00800000

#define VR4181A_PCI_MEM_START		VR4181A_PCI_MEM_BASE
#define VR4181A_PCI_MEM_END		(VR4181A_PCI_MEM_START+VR4181A_PCI_MEM_SIZE-1)

#define VR4181A_PCI_IO_START		VR4181A_PCI_IO_BASE
#define VR4181A_PCI_IO_END		(VR4181A_PCI_IO_BASE+VR4181A_PCI_IO_SIZE-1)

#define IO_MEM_RESOURCE_START		VR4181A_PCI_MEM_BASE
#define IO_MEM_RESOURCE_END		(VR4181A_PCI_MEM_BASE+VR4181A_PCI_MEM_SIZE)

#define IO_PORT_RESOURCE_START		VR4181A_PCI_IO_BASE
#define IO_PORT_RESOURCE_END		(VR4181A_PCI_IO_BASE+VR4181A_PCI_IO_SIZE)

#endif /* __ASM_VR41XX_TOADKK_TCS8000_H*/
