/*
 *      Option sending and piggybacking module
 *
 *      Authors:
 *      Niklas Kmpe                <nhkampe@cc.hut.fi>
 *
 *      $Id: mobhdr.h,v 1.2 2003/06/17 18:53:13 jamey Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _MOBHDR_H
#define _MOBHDR_H

/*
 * Status codes for mipv6_ack_rcvd()
 */
#define STATUS_UPDATE 0
#define STATUS_REMOVE 1

#define HOME_INIT_COOKIE	0x8
#define CAREOF_INIT_COOKIE	0x10
#define HOME_COOKIE		0x20
#define CAREOF_COOKIE		0x40

#define WAIT_HOTI_COTI		(HOME_INIT_COOKIE|CAREOF_INIT_COOKIE)
#define WAIT_HOT_COT		(HOME_COOKIE|CAREOF_COOKIE)

/* RR states for mipv6_send_upd_option() */
#define RR_INIT			0x00
#define RR_WAITH		0x01
#define RR_WAITC		0x02
#define RR_WAITHC		0x13
#define RR_DONE			0x10

/* Return value of mipv6_rr_needed() */
#define NO_RR			0
#define DO_RR			1
#define RR_FOR_COA              2
#define INPROGRESS_RR		3

#define MH_UNKNOWN_CN 1
#define MH_AUTH_FAILED 2
#define MH_SEQUENCE_MISMATCH 3

struct mipv6_bul_entry;

/*
 * sendopts module initialization & deinitialization
 */
int mipv6_mh_common_init(void);
void mipv6_mh_common_exit(void);
int mipv6_mh_mn_init(void);

struct mipv6_mh_opt {
	struct mipv6_mo_uid		*uid;
	struct mipv6_mo_alt_coa		*alt_coa;
	struct mipv6_mo_nonce_indices	*nonce_indices;
	struct mipv6_mo_bauth_data	*auth_data;
	struct mipv6_mo_br_advice	*br_advice;
	int freelen;
	int totlen;
	u8 *next_free;
	u8 data[0];
};

struct mobopt {
	struct mipv6_mo_alt_coa		*alt_coa;
	struct mipv6_mo_nonce_indices	*nonce_indices;
	struct mipv6_mo_bauth_data	*auth_data;
	struct mipv6_mo_br_advice	*br_advice;
};

int parse_mo_tlv(void *mos, int len, struct mobopt *opts);

int mipv6_add_pad(u8 *data, int n);

struct mipv6_mh_opt *alloc_mh_opts(int totlen);
int append_mh_opt(struct mipv6_mh_opt *ops, u8 type, u8 len, void *data);

struct mipv6_auth_parm {
	struct in6_addr *coa;
	struct in6_addr *cn_addr;
	__u8 *k_bu;
};

int send_mh(struct in6_addr *daddr, 
	    struct in6_addr *saddr, 
	    u8 *msg, u8 msg_len, u8 msg_type,
	    struct in6_addr *hao_addr,
	    struct in6_addr *rth_addr,
	    struct mipv6_mh_opt *ops,
	    struct mipv6_auth_parm *parm);

int mipv6_mh_register(int type, int (*func)(
	struct in6_addr *, struct in6_addr *, 
	struct in6_addr *, struct in6_addr *, struct mipv6_mh *));

/*
 * Send a binding request. Actual sending may be delayed up to
 * maxdelay milliseconds. If 0, request is sent immediately.
 * On a mobile node, use the mobile node's home address for saddr.
 * Returns 0 on success, non-zero on failure.
 */
int mipv6_send_brr(struct in6_addr *saddr, struct in6_addr *daddr,
	long maxdelay, struct mipv6_mh_opt *ops);

/*
 * Send a binding acknowledgement. Actual sending may be delayed up to
 * maxdelay milliseconds. If 0, acknowledgement is sent immediately.
 * On a mobile node, use the mobile node's home address for saddr.
 * Returns 0 on success, non-zero on failure.
 */
int mipv6_send_ba(struct in6_addr *saddr, struct in6_addr *daddr,
	struct in6_addr *coaddr, long maxdelay, __u8 status, 
	__u16 sequence, __u32 lifetime, __u32 refresh, __u8 *k_bu);

/*
 * Send a binding update. Actual sending may be delayed up to maxdelay
 * milliseconds. 'flags' may contain any of MIPV6_BU_F_ACK,
 * MIPV6_BU_F_HOME, MIPV6_BU_F_ROUTER bitwise ORed. If MIPV6_BU_F_ACK is
 * included retransmission will be attempted until the update has been
 * acknowledged. Retransmission is done if no acknowledgement is received
 * within 'initdelay' seconds. 'exp' specifies whether to use exponential
 * backoff (exp != 0) or linear backoff (exp == 0). For exponential
 * backoff the time to wait for an acknowledgement is doubled on each
 * retransmission until a delay of 'maxackdelay', after which
 * retransmission is no longer attempted. For linear backoff the delay
 * is kept constant and 'maxackdelay' specifies the maximum number of
 * retransmissions instead. If sub-options are present ops must contain
 * all sub-options to be added.
 * On a mobile node, use the mobile node's home address for saddr.
 * Returns 0 on success, non-zero on failure.
 */
int mipv6_send_bu(struct in6_addr *saddr, struct in6_addr *daddr, 
		  struct in6_addr *coa, long maxdelay, __u32 initdelay, 
		  __u32 maxackdelay, __u8 exp, __u8 flags, __u8 plength, 
		  __u32 lifetime, struct mipv6_mh_opt *ops);

/** send_bu_msg - sends a Binding Update 
 *
 * @bulentry : Binding Update List entry with the information 
 * for building a BU
 *
 * Function builds a BU msg based on the contents of a bul entry.
 * Does not change the bul entry.
 **/
int send_bu_msg(struct mipv6_bul_entry *bulentry);

int mipv6_send_be(struct in6_addr *saddr, struct in6_addr *daddr, 
		  struct in6_addr *home, __u8 status);
int mipv6_send_RR_bu(struct mipv6_bul_entry *bulentry);
/*
 * This function must be called to notify the module of the receipt of
 * a binding acknowledgement so that it can cease retransmitting the
 * option. The caller must have validated the acknowledgement before calling
 * this function. 'status' can be either STATUS_UPDATE in which case the
 * binding acknowledgement is assumed to be valid and the corresponding
 * binding update list entry is updated, or STATUS_REMOVE in which case
 * the corresponding binding update list entry is removed (this can be
 * used upon receiving a negative acknowledgement).
 * Returns 0 if a matching binding update has been sent or non-zero if
 * not.
 */
int mipv6_ba_rcvd(int ifindex, struct in6_addr *cnaddr, 
		  struct in6_addr *home_addr, __u16 sequence,
		  __u32 lifetime, __u32 refresh, int status);

/* RR related function to initialize RR */
int mipv6_RR_start(struct in6_addr *home_addr, struct in6_addr *cn_addr,
		   struct in6_addr *coa, struct mipv6_bul_entry *bulentry,
		   long maxdelay, __u32 initdelay, __u32 maxackdelay,
		   __u8 flags, __u8 plength, __u32 lifetime,
		   struct mipv6_mh_opt *ops);

/* RR related function to send home_test and careof_test messages */
int mipv6_send_addr_test(struct in6_addr *daddr, struct in6_addr *saddr, 
			 struct mipv6_mh_addr_ti *init, int type);

/* RR related function to send home_test_init and careof_test_init messages */
int mipv6_send_addr_test_init(struct in6_addr *daddr, struct in6_addr *saddr,
			      u8 msg_type, __u8 *test_cookie);

/* Binding Authentication Data Option routines */
#define MAX_HASH_LENGTH 20
#define MIPV6_RR_MAC_LENGTH 12

int mipv6_auth_build(struct in6_addr *cn_addr, struct in6_addr *coa, 
		     __u8 *opt, __u8 *aud_data, __u8 *k_bu);

int mipv6_auth_check(struct in6_addr *cn_addr, struct in6_addr *coa, 
		     __u8 *opt, __u8 optlen, struct mipv6_mo_bauth_data *aud, 
		     __u8 *k_bu);
#endif /* _MOBHDR_H */
