/*
 *  $Id: longhaul.c,v 1.3 2001/08/10 11:58:48 davej Exp $
 *
 *	(C) 2001  Dave Jones, Arjan van de ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *  Based upon datasheets 'bios5_2.pdf' provided by VIA.
 *  Driver derived from the K6 PowerNOW! code.
 *
 *  BIG FAT DISCLAIMER: Work in progress code. Possibly *dangerous*
 *
 *	Version $Id: longhaul.c,v 1.3 2001/08/10 11:58:48 davej Exp $
 */

#include <linux/kernel.h>
#include <linux/module.h> 
#include <linux/sched.h>
#include <linux/init.h>
#include <asm/msr.h>
#include <asm/timex.h>
#include <asm/io.h>
#include <linux/delay.h>
#include <linux/proc_fs.h>

static unsigned long cpu_khz=350000;

/* Clock ratio multiplied by 10 */
static int clock_ratio[16] = {
		/* ?? is undefined in the spec. */
				30,	/* 0001 -> 3.0x */
				40,	/* 0010 -> 4.0x */
			0, /* 0011 -> ???x*/
				55,	/* 0100 -> 5.5x */
				35,	/* 0101 -> 3.5x */
				45,	/* 0110 -> 4.5x */
			0,	/* 0111 -> ???x */
				50,	/* 1000 -> 5.0x */
				70,	/* 1001 -> 7.0x */
				80,	/* 1010 -> 8.0x */
				60,	/* 1011 -> 6.0x */
			0,	/* 1100 -> ???x */
				75,	/* 1101 -> 7.5x */
				65,	/* 1111 -> 6.5x */
};

static unsigned int clock_bogomips[8];

static unsigned int busfreq,cpufreq;

void set_cpu_frequency_longhaul(unsigned int Mhz, int fsb)
{
	int i;
	unsigned int best=200; /* safe initial values */
	unsigned int besti=4;
	unsigned long lo, hi;

	cpufreq = Mhz;
	/* Find out which bit-pattern we want */

	for (i=0;i<8;i++) {
		unsigned int newclock;
		newclock = (clock_ratio[i]*fsb/10);
		if ((newclock > best) && (newclock <= (Mhz+1))) {
			/* +1 is for compensating rouding errors */
			best = newclock;
			besti = i;
		}
	}

	/* "besti" now contains the bitpattern of the new multiplier.
	   we now need to transform it to the desired format. */

	rdmsr (0x1147, lo, hi);
	hi |= (1<<19);		/* Enable software clock multiplier */
	hi |= besti<<23;	/* desired multiplier */
	wrmsr (0x1147, lo, hi);

	/* Disable software clock multiplier */
	rdmsr (0x1147, lo, hi);
	hi &= (!(1<<19));
	wrmsr (0x1147, lo, hi);

	/* now adjust bogomips */
	if (!clock_bogomips[besti]) {
		/*scale_bogomips(clock_ratio[besti]);*/
		clock_bogomips[besti] = loops_per_jiffy;
	} else {
		loops_per_jiffy = clock_bogomips[besti];
	}
}

static int get_cpu_multiplier(void)
{
	unsigned long invalue=0,lo, hi;
	
	rdmsr (0x1147, lo, hi);
	invalue = (lo & (1<<26|1<<25|1<<24|1<<23)) <<23;

	printk("Clock ratio is %i\n",clock_ratio[(invalue >> 5)&7]);
	return clock_ratio[(invalue >> 5)&7];
}

int longhaul_init(void)
{	
	busfreq = cpu_khz / get_cpu_multiplier() / 100;	
	return 0;
}
void longhaul_exit(void)
{
}

module_init(longhaul_init);
module_exit(longhaul_exit);

