/*
 * Hardware definitions for Dell Axim X5
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * Author: Martin Demin.
 *
 * History:
 *
 * 2003-05-26   Martin Demin       Adapted for use on Dell Axim X5
 * 2003-05-14	Joshua Wise        Adapted for the HP iPAQ H1900
 * 2002-08-23   Jamey Hicks        Adapted for use with PXA250-based iPAQs
 * 2001-10-??   Andrew Christian   Added support for iPAQ H3800
 *                                 and abstracted EGPIO interface.
 *
 */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/sched.h>
#include <linux/pm.h>
#include <linux/bootmem.h>

#include <asm/irq.h>
#include <asm/hardware.h>
#include <asm/setup.h>

#include <asm/mach/irq.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <asm/arch/irq.h>
#include <asm/types.h>

#include <asm/hardware/mq1132.h>
#include <linux/serial_core.h>

#include <asm/arch/axim-gpio.h>

#include "generic.h"

static void msleep(unsigned int msec)
{
	current->state = TASK_INTERRUPTIBLE;
	schedule_timeout( (msec * HZ + 999) / 1000);
}

/*
  On screen enable, we get 
  
     h3800_video_power_on(1)
     LCD controller starts
     h3800_video_lcd_enable(1)

  On screen disable, we get
  
     h3800_video_lcd_enable(0)
     LCD controller stops
     h3800_video_power_on(0)
*/

static void axim_video_power_on( int setp )
{
}

static void axim_video_lcd_enable( int setp )
{
}

static void axim_control_egpio( enum ipaq_egpio_type x, int setp )
{
#if 0
	switch (x) {
	case IPAQ_EGPIO_LCD_POWER:
		axim_video_power_on( setp );
		break;
	case IPAQ_EGPIO_LCD_ENABLE:
		axim_video_lcd_enable( setp );
		break;
	case IPAQ_EGPIO_CODEC_NRESET:
	case IPAQ_EGPIO_AUDIO_ON:
	case IPAQ_EGPIO_QMUTE:
		printk("%s: error - should not be called\n", __FUNCTION__);
		break;
	case IPAQ_EGPIO_OPT_NVRAM_ON:
		// SET_ASIC2( GPIO2_OPT_ON_NVRAM );
		break;
	case IPAQ_EGPIO_OPT_ON:
		// SET_ASIC2( GPIO2_OPT_ON );
		break;
	case IPAQ_EGPIO_CARD_RESET:
		break;
	case IPAQ_EGPIO_OPT_RESET:
		break;
	case IPAQ_EGPIO_IR_ON:
		break;
	case IPAQ_EGPIO_IR_FSEL:
		break;
	case IPAQ_EGPIO_RS232_ON:
		break;
	case IPAQ_EGPIO_BLUETOOTH_ON:
		break;
	case IPAQ_EGPIO_VPP_ON:
		break;
	default:
		printk("%s: unhandled egpio=%d\n", __FUNCTION__, x);
	}
#endif
}

static unsigned long axim_read_egpio( enum ipaq_egpio_type x)
{
	switch (x) {
	case IPAQ_EGPIO_PCMCIA_CD0_N:
		return(GPLR(GPIO_NR_H3900_PCMCIA_CD0_N) & GPIO_bit(GPIO_NR_H3900_PCMCIA_CD0_N));
	case IPAQ_EGPIO_PCMCIA_CD1_N:
		return(GPLR(GPIO_NR_H3900_PCMCIA_CD1_N) & GPIO_bit(GPIO_NR_H3900_PCMCIA_CD1_N));
	case IPAQ_EGPIO_PCMCIA_IRQ0:
		return(GPLR(GPIO_NR_H3900_PCMCIA_IRQ0_N) & GPIO_bit(GPIO_NR_H3900_PCMCIA_IRQ0_N));
	case IPAQ_EGPIO_PCMCIA_IRQ1:
		return(GPLR(GPIO_NR_H3900_PCMCIA_IRQ1_N) & GPIO_bit(GPIO_NR_H3900_PCMCIA_IRQ1_N));
        default:
		printk("%s:%d: unknown ipaq_egpio_type=%d\n", __FUNCTION__, __LINE__, x);
		return 0;
	}
}

/* We need to fix ASIC2 GPIO over suspend/resume.  At the moment,
   it doesn't appear that ASIC3 GPIO has the same problem */

static int axim_pm_callback( int req )
{
	static u16 asic3_data;
	static u16 asic2_data;
	int result = 0;
	
	printk(__FUNCTION__ " %d\n", req);

	switch (req) {
	case PM_RESUME:
		break;

	case PM_SUSPEND:
		break;
	default:
		printk("%s: unrecognized PM callback\n", __FUNCTION__);
		break;
	}
	return result;
}

static int axim_egpio_irq_number(int egpio_nr)
{
	printk("%s: unhandled egpio_nr=%d\n", __FUNCTION__, egpio_nr); 
	return -EINVAL;
}

static void axim_set_led (enum led_color color, int cycle_time, int duty_time)
{
}

static void axim_backlight_power (int on)
{
}

static struct ipaq_model_ops axim_model_ops __initdata = {
	.generic_name = "Axim",
	.control      = axim_control_egpio,
	.read         = axim_read_egpio,
	.pm_callback  = axim_pm_callback,
	.irq_number   = axim_egpio_irq_number,
	.set_led      = axim_set_led,
	.backlight_power = axim_backlight_power
};

static void __init axim_init_irq( void )
{
//	int i;

	/* Initialize standard IRQs */
	pxa_init_irq();
	if(mq1132_init())
	{
	    printk("Error initializing MediaQ !!!!!\n");
	}
}

static struct map_desc axim_io_desc[] __initdata = {
 /* virtual            physical           length      domain     r  w  c  b */
//  { H3600_BANK_2_VIRT, H3600_BANK_2_PHYS, 0x02800000, DOMAIN_IO, 0, 1, 0, 0 }, /* static memory bank 2  CS#2 */
//  { H3600_BANK_4_VIRT, H3600_BANK_4_PHYS, 0x00800000, DOMAIN_IO, 0, 1, 0, 0 }, /* static memory bank 4  CS#4 */
//  { H3600_BANK_5_VIRT, H3600_BANK_5_PHYS, 0x02000000, DOMAIN_IO, 0, 1, 0, 0 }, /* static memory bank 5  CS#5 */
  { 0xf4000000, 0x14040000, 0x00800000, DOMAIN_IO, 		 0, 1, 0, 0 }, /* MediaQ */
  LAST_DESC
};

void __init axim_map_io(void)
{
	printk("pxa_map_io ");
	pxa_map_io();
	printk("done\niotable_init() ");
	iotable_init(axim_io_desc);
	printk("done\n ");

	/* Configure power management stuff. */
/*	PGSR0 = GPSRx_SleepValue;
	PGSR1 = GPSRy_SleepValue;
	PGSR2 = GPSRz_SleepValue;
	PWER = PWER_GPIO0 | PWER_RTC;
	PFER = PWER_GPIO0 | PWER_RTC;
	PRER = 0;
	PCFR = PCFR_OPDE;
*/	
}

static void __init aximx5_map_io(void)
{
	axim_map_io();
#if 0
	/* Demo: Please have a block like this. */
	/* Set up GPIO direction and alternate function registers */
	GAFR0_L = GAFR0x_InitValue;
	GAFR0_U = GAFR1x_InitValue;
	GAFR1_L = GAFR0y_InitValue;
	GAFR1_U = GAFR1y_InitValue;
	GAFR2_L = GAFR0z_InitValue;
	GAFR2_U = GAFR1z_InitValue;
	
	GPDR0 = GPDRx_InitValue;
	GPDR1 = GPDRy_InitValue;
	GPDR2 = GPDRz_InitValue;
	
	GPCR0 = 0x0fffffff;       /* All outputs are set low by default */
	
	/* Add wakeup on AC plug/unplug */
	PWER  |= PWER_GPIO8;
	PFER  |= PWER_GPIO8;
	PRER  |= PWER_GPIO8;
#endif

	ipaq_model_ops = axim_model_ops;
}

MACHINE_START(AXIM, "Dell Axim X5")
	MAINTAINER("Martin Demin (demo@twincar.sk)")
	BOOT_MEM(0xa0000000, 0x40000000, io_p2v(0x40000000))
	BOOT_PARAMS(0xa0000100)
	MAPIO(aximx5_map_io)
	INITIRQ(axim_init_irq)
MACHINE_END
