/* This file is part of the KDE libraries
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __jsextension_h__
#define __jsextension_h__

#if defined(ENABLE_JS_HOSTEXTEND)

#include <kjs/object.h>
#include <kjs/interpreter.h>
#include <kparts/part.h>
#include <qstring.h>

typedef void (*JsHostExtend)(KJS::ExecState *exec, KParts::ReadOnlyPart *part,
	const KURL &url, const QString &mimetype, KJS::Object &hostobj );

namespace KJS {

    void addJsExtension( const JsHostExtend ext );

}

#endif // ENABLE_JS_HOSTEXTEND

#endif // __jsextension_h__
