/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "libgimpbase/gimpbaseenums.h"
#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimpgrid.h"
#include "core/gimpimage-grid.h"
#include "core/gimpimage.h"

static ProcRecord image_grid_get_spacing_proc;
static ProcRecord image_grid_set_spacing_proc;
static ProcRecord image_grid_get_offset_proc;
static ProcRecord image_grid_set_offset_proc;
static ProcRecord image_grid_get_foreground_color_proc;
static ProcRecord image_grid_set_foreground_color_proc;
static ProcRecord image_grid_get_background_color_proc;
static ProcRecord image_grid_set_background_color_proc;
static ProcRecord image_grid_get_style_proc;
static ProcRecord image_grid_set_style_proc;

void
register_grid_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &image_grid_get_spacing_proc);
  procedural_db_register (gimp, &image_grid_set_spacing_proc);
  procedural_db_register (gimp, &image_grid_get_offset_proc);
  procedural_db_register (gimp, &image_grid_set_offset_proc);
  procedural_db_register (gimp, &image_grid_get_foreground_color_proc);
  procedural_db_register (gimp, &image_grid_set_foreground_color_proc);
  procedural_db_register (gimp, &image_grid_get_background_color_proc);
  procedural_db_register (gimp, &image_grid_set_background_color_proc);
  procedural_db_register (gimp, &image_grid_get_style_proc);
  procedural_db_register (gimp, &image_grid_set_style_proc);
}

static Argument *
image_grid_get_spacing_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gdouble xspacing = 0;
  gdouble yspacing = 0;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        {
          xspacing = grid->xspacing;
          yspacing = grid->yspacing;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&image_grid_get_spacing_proc, success);

  if (success)
    {
      return_args[1].value.pdb_float = xspacing;
      return_args[2].value.pdb_float = yspacing;
    }

  return return_args;
}

static ProcArg image_grid_get_spacing_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_grid_get_spacing_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "xspacing",
    "The image's grid horizontal spacing"
  },
  {
    GIMP_PDB_FLOAT,
    "yspacing",
    "The image's grid vertical spacing"
  }
};

static ProcRecord image_grid_get_spacing_proc =
{
  "gimp-image-grid-get-spacing",
  "gimp-image-grid-get-spacing",
  "Gets the spacing of an image's grid.",
  "This procedure retrieves the horizontal and vertical spacing of an image's grid. It takes the image as parameter.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  image_grid_get_spacing_inargs,
  2,
  image_grid_get_spacing_outargs,
  { { image_grid_get_spacing_invoker } }
};

static Argument *
image_grid_set_spacing_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gdouble xspacing;
  gdouble yspacing;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  xspacing = args[1].value.pdb_float;

  yspacing = args[2].value.pdb_float;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        g_object_set (grid,
                      "xspacing", xspacing,
                      "yspacing", yspacing,
                      NULL);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_grid_set_spacing_proc, success);
}

static ProcArg image_grid_set_spacing_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_FLOAT,
    "xspacing",
    "The image's grid horizontal spacing"
  },
  {
    GIMP_PDB_FLOAT,
    "yspacing",
    "The image's grid vertical spacing"
  }
};

static ProcRecord image_grid_set_spacing_proc =
{
  "gimp-image-grid-set-spacing",
  "gimp-image-grid-set-spacing",
  "Sets the spacing of an image's grid.",
  "This procedure sets the horizontal and vertical spacing of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  3,
  image_grid_set_spacing_inargs,
  0,
  NULL,
  { { image_grid_set_spacing_invoker } }
};

static Argument *
image_grid_get_offset_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gdouble xoffset = 0;
  gdouble yoffset = 0;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        {
          xoffset = grid->xoffset;
          yoffset = grid->yoffset;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&image_grid_get_offset_proc, success);

  if (success)
    {
      return_args[1].value.pdb_float = xoffset;
      return_args[2].value.pdb_float = yoffset;
    }

  return return_args;
}

static ProcArg image_grid_get_offset_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_grid_get_offset_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "xoffset",
    "The image's grid horizontal offset"
  },
  {
    GIMP_PDB_FLOAT,
    "yoffset",
    "The image's grid vertical offset"
  }
};

static ProcRecord image_grid_get_offset_proc =
{
  "gimp-image-grid-get-offset",
  "gimp-image-grid-get-offset",
  "Gets the offset of an image's grid.",
  "This procedure retrieves the horizontal and vertical offset of an image's grid. It takes the image as parameter.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  image_grid_get_offset_inargs,
  2,
  image_grid_get_offset_outargs,
  { { image_grid_get_offset_invoker } }
};

static Argument *
image_grid_set_offset_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gdouble xoffset;
  gdouble yoffset;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  xoffset = args[1].value.pdb_float;

  yoffset = args[2].value.pdb_float;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        g_object_set (grid,
                      "xoffset", xoffset,
                      "yoffset", yoffset,
                      NULL);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_grid_set_offset_proc, success);
}

static ProcArg image_grid_set_offset_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_FLOAT,
    "xoffset",
    "The image's grid horizontal offset"
  },
  {
    GIMP_PDB_FLOAT,
    "yoffset",
    "The image's grid vertical offset"
  }
};

static ProcRecord image_grid_set_offset_proc =
{
  "gimp-image-grid-set-offset",
  "gimp-image-grid-set-offset",
  "Sets the offset of an image's grid.",
  "This procedure sets the horizontal and vertical offset of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  3,
  image_grid_set_offset_inargs,
  0,
  NULL,
  { { image_grid_set_offset_invoker } }
};

static Argument *
image_grid_get_foreground_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpRGB fgcolor;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        fgcolor = grid->fgcolor;
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&image_grid_get_foreground_color_proc, success);

  if (success)
    return_args[1].value.pdb_color = fgcolor;

  return return_args;
}

static ProcArg image_grid_get_foreground_color_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_grid_get_foreground_color_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "fgcolor",
    "The image's grid foreground color"
  }
};

static ProcRecord image_grid_get_foreground_color_proc =
{
  "gimp-image-grid-get-foreground-color",
  "gimp-image-grid-get-foreground-color",
  "Sets the foreground color of an image's grid.",
  "This procedure gets the foreground color of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  image_grid_get_foreground_color_inargs,
  1,
  image_grid_get_foreground_color_outargs,
  { { image_grid_get_foreground_color_invoker } }
};

static Argument *
image_grid_set_foreground_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpRGB fgcolor;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  fgcolor = args[1].value.pdb_color;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        g_object_set (grid,
                      "fgcolor", &fgcolor,
                      NULL);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_grid_set_foreground_color_proc, success);
}

static ProcArg image_grid_set_foreground_color_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_COLOR,
    "fgcolor",
    "The new foreground color"
  }
};

static ProcRecord image_grid_set_foreground_color_proc =
{
  "gimp-image-grid-set-foreground-color",
  "gimp-image-grid-set-foreground-color",
  "Gets the foreground color of an image's grid.",
  "This procedure sets the foreground color of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  2,
  image_grid_set_foreground_color_inargs,
  0,
  NULL,
  { { image_grid_set_foreground_color_invoker } }
};

static Argument *
image_grid_get_background_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  GimpRGB bgcolor;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        bgcolor = grid->bgcolor;
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&image_grid_get_background_color_proc, success);

  if (success)
    return_args[1].value.pdb_color = bgcolor;

  return return_args;
}

static ProcArg image_grid_get_background_color_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_grid_get_background_color_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "bgcolor",
    "The image's grid background color"
  }
};

static ProcRecord image_grid_get_background_color_proc =
{
  "gimp-image-grid-get-background-color",
  "gimp-image-grid-get-background-color",
  "Sets the background color of an image's grid.",
  "This procedure gets the background color of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  image_grid_get_background_color_inargs,
  1,
  image_grid_get_background_color_outargs,
  { { image_grid_get_background_color_invoker } }
};

static Argument *
image_grid_set_background_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  GimpRGB bgcolor;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  bgcolor = args[1].value.pdb_color;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        g_object_set (grid,
                      "bgcolor", &bgcolor,
                      NULL);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_grid_set_background_color_proc, success);
}

static ProcArg image_grid_set_background_color_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_COLOR,
    "bgcolor",
    "The new background color"
  }
};

static ProcRecord image_grid_set_background_color_proc =
{
  "gimp-image-grid-set-background-color",
  "gimp-image-grid-set-background-color",
  "Gets the background color of an image's grid.",
  "This procedure sets the background color of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  2,
  image_grid_set_background_color_inargs,
  0,
  NULL,
  { { image_grid_set_background_color_invoker } }
};

static Argument *
image_grid_get_style_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 style = 0;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        {
          style = grid->style;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&image_grid_get_style_proc, success);

  if (success)
    return_args[1].value.pdb_int = style;

  return return_args;
}

static ProcArg image_grid_get_style_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcArg image_grid_get_style_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "style",
    "The image's grid style"
  }
};

static ProcRecord image_grid_get_style_proc =
{
  "gimp-image-grid-get-style",
  "gimp-image-grid-get-style",
  "Gets the style of an image's grid.",
  "This procedure retrieves the style of an image's grid.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  image_grid_get_style_inargs,
  1,
  image_grid_get_style_outargs,
  { { image_grid_get_style_invoker } }
};

static Argument *
image_grid_set_style_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 style;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  style = args[1].value.pdb_int;
  if (style < GIMP_GRID_DOTS || style > GIMP_GRID_SOLID)
    success = FALSE;

  if (success)
    {
      GimpGrid *grid = gimp_image_get_grid (gimage);

      if (grid)
        g_object_set (grid,
                      "style", style,
                      NULL);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&image_grid_set_style_proc, success);
}

static ProcArg image_grid_set_style_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  },
  {
    GIMP_PDB_INT32,
    "style",
    "The image's grid style"
  }
};

static ProcRecord image_grid_set_style_proc =
{
  "gimp-image-grid-set-style",
  "gimp-image-grid-set-style",
  "Sets the style unit of an image's grid.",
  "This procedure sets the style of an image's grid. It takes the image and the new style as parameters.",
  "Sylvain Foret",
  "Sylvain Foret",
  "2005",
  NULL,
  GIMP_INTERNAL,
  2,
  image_grid_set_style_inargs,
  0,
  NULL,
  { { image_grid_set_style_invoker } }
};
