/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef SLIDE_LIST_H
#define SLIDE_LIST_H

#include <glib-object.h>
#include <gtk/gtktreeview.h>

#include "presentation.h"

G_BEGIN_DECLS

typedef struct _CriaSlideList CriaSlideList;
typedef struct _CriaSlideListClass CriaSlideListClass;
typedef struct _CriaSlideListPrivate CriaSlideListPrivate;

GType		  cria_slide_list_get_type	       (void);
CriaPresentation* cria_slide_list_get_presentation     (CriaSlideList	* self);
CriaSlide*	  cria_slide_list_get_selected	       (CriaSlideList	* self);
GtkWidget*	  cria_slide_list_new		       (CriaPresentation* presentation);
void		  cria_slide_list_refresh	       (CriaSlideList   * self);
void		  cria_slide_list_select_first	       (CriaSlideList	* self);
void		  cria_slide_list_select_last	       (CriaSlideList	* self);
void		  cria_slide_list_select_next	       (CriaSlideList	* self);
void		  cria_slide_list_select_previous      (CriaSlideList	* self);
void		  cria_slide_list_set_presentation     (CriaSlideList	* self,
							CriaPresentation* presentation);

#define CRIA_TYPE_SLIDE_LIST			(cria_slide_list_get_type ())
#define CRIA_SLIDE_LIST(object)			(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE_LIST, CriaSlideList))
#define CRIA_SLIDE_LIST_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_SLIDE_LIST, CriaSlideListClass))
#define CRIA_IS_SLIDE_LIST(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE_LIST))
#define CRIA_IS_SLIDE_LIST_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE_LIST))
#define CRIA_SLIDE_LIST_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE_LIST, CriaSlideListClass))

struct _CriaSlideList {
	GtkTreeView		  base_instance;
	CriaSlideListPrivate	* priv;
};

struct _CriaSlideListClass {
	GtkTreeViewClass  base_class;

	/* signals */
	void (*signal)	       (CriaSlideList	* template,
				const	gchar	* string);
};

G_END_DECLS

#endif /* SLIDE_LIST_H */

