#ifndef MAINWIN_H
#define MAINWIN_H

#include <gtk/gtk.h>

#include "number.h"
#include "tbutton.h"
#include "textbox.h"
#include "svis.h"
#include "vis.h"

typedef enum {
    TIMER_ELAPSED, TIMER_REMAINING
} TimerMode;


/* yes, main window size is fixed */
#define MAINWIN_WIDTH            (gint)275
#define MAINWIN_HEIGHT           (gint)116
#define MAINWIN_TITLEBAR_HEIGHT  (gint)14
#define MAINWIN_SHADED_HEIGHT    MAINWIN_TITLEBAR_HEIGHT


extern GtkWidget *mainwin;
extern GdkGC *mainwin_gc;
extern gboolean mainwin_moving;
extern GtkWidget *mainwin_jtf;
extern GtkItemFactory *mainwin_vis_menu, *mainwin_general_menu,
    *mainwin_options_menu;
extern TextBox *mainwin_info;
extern GtkItemFactory *mainwin_play_menu;

extern Number *mainwin_minus_num, *mainwin_10min_num, *mainwin_min_num,
    *mainwin_10sec_num, *mainwin_sec_num;

extern TButton *mainwin_shuffle, *mainwin_repeat, *mainwin_eq, *mainwin_pl;
extern gint mainwin_timeout_tag;

extern Vis *active_vis;
extern Vis *mainwin_vis;
extern SVis *mainwin_svis;
extern gint bitrate, frequency, numchannels;

void mainwin_create(void);
void create_popups(void);
void read_volume(gint when);
void play_medium(void);
gint idle_func(gpointer data);

void set_timer_mode(TimerMode mode);

void draw_main_window(gboolean);
void mainwin_quit_cb(void);
void mainwin_lock_info_text(gchar * text);
void mainwin_release_info_text(void);
void mainwin_play_pushed(void);
void mainwin_stop_pushed(void);
void mainwin_eject_pushed(void);

void mainwin_set_back_pixmap(void);

void mainwin_adjust_volume_motion(gint v);
void mainwin_adjust_volume_release(void);
void mainwin_adjust_balance_motion(gint b);
void mainwin_adjust_balance_release(void);
void mainwin_set_volume_slider(gint percent);
void mainwin_set_balance_slider(gint percent);

void mainwin_vis_set_type(VisType mode);

void mainwin_set_info_text(void);
void mainwin_set_song_info(gint rate, gint freq, gint nch);
void mainwin_clear_song_info(void);

void mainwin_set_always_on_top(gboolean always);
void mainwin_set_volume_diff(gint diff);
void mainwin_set_balance_diff(gint diff);

void mainwin_show(gboolean);
void mainwin_real_show(void);
void mainwin_real_hide(void);
void mainwin_move(gint x, gint y);
void mainwin_shuffle_pushed(gboolean toggled);
void mainwin_repeat_pushed(gboolean toggled);
void mainwin_disable_seekbar(void);
void mainwin_set_shape_mask(void);
void mainwin_recreate(void);
void mainwin_set_shade_menu_cb(gboolean shaded);
void mainwin_set_shade(gboolean shaded);
void mainwin_shade_toggle(void);
void mainwin_update_jtf();
void mainwin_set_title(const gchar * text);
void mainwin_show_dirbrowser(void);
void mainwin_show_add_url_window(void);
void mainwin_minimize_cb(void);

void mainwin_general_menu_callback(gpointer cb_data, guint action,
				   GtkWidget * w);

enum {
    MAINWIN_GENERAL_ABOUT, MAINWIN_GENERAL_PLAYFILE,
    MAINWIN_GENERAL_PLAYDIRECTORY,
    MAINWIN_GENERAL_PLAYLOCATION, MAINWIN_GENERAL_FILEINFO,
    MAINWIN_GENERAL_SHOWMWIN, MAINWIN_GENERAL_SHOWPLWIN,
    MAINWIN_GENERAL_SHOWEQWIN, MAINWIN_GENERAL_PLAYCD,
    MAINWIN_GENERAL_EXIT,

    MAINWIN_GENERAL_PREV, MAINWIN_GENERAL_PLAY,
    MAINWIN_GENERAL_PAUSE, MAINWIN_GENERAL_STOP, MAINWIN_GENERAL_NEXT,
    MAINWIN_GENERAL_STOPFADE, MAINWIN_GENERAL_BACK5SEC,
    MAINWIN_GENERAL_FWD5SEC, MAINWIN_GENERAL_START, MAINWIN_GENERAL_BACK10,
    MAINWIN_GENERAL_FWD10, MAINWIN_GENERAL_JTT, MAINWIN_GENERAL_JTF,
    MAINWIN_GENERAL_QUEUE, MAINWIN_GENERAL_CQUEUE,
    MAINWIN_GENERAL_VOLUP, MAINWIN_GENERAL_VOLDOWN
};

#endif
