.\" $Xorg: XtSetArg.man,v 1.3 2000/08/17 19:42:02 cpqbld Exp $
.\"
.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" $XFree86: xc/doc/man/Xt/XtSetArg.man,v 1.4 2003/04/28 22:18:20 herrb Exp $
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtSet-Arg XtMerge-Arg-Lists wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XtSetArg 3Xt __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtSetArg, XtMergeArgLists \- set and merge ArgLists
.SH SYNTAX
.HP
int XtSetArg(Arg \fIarg\fP, String \fIname\fP, XtArgVal \fIvalue\fP); 
.HP
ArgList XtMergeArgLists(ArgList \fIargs1\fP, Cardinal \fInum_args1\fP, ArgList
\fIargs2\fP, Cardinal \fInum_args2\fP); 
.SH ARGUMENTS
.IP \fIarg\fP 1i
Specifies the name-value pair to set.
.IP \fIargs1\fP 1i
Specifies the first
.ZN ArgList .
.IP \fIargs2\fP 1i
Specifies the second 
.ZN ArgList .
.IP \fInum_args1\fP 1i
Specifies the number of arguments in the first argument list.
.IP \fInum_args2\fP 1i
Specifies the number of arguments in the second argument list.
.IP \fIname\fP 1i
Specifies the name of the resource.
.IP \fIvalue\fP 1i
Specifies the value of the resource if it will fit in an
.ZN XtArgVal 
or the address.
.SH DESCRIPTION
The
.ZN XtSetArg
function is usually used in a highly stylized manner to
minimize the probability of making a mistake; for example:
.LP
.Ds
.TA .5i 3i
.ta .5i 3i
Arg args[20];
int n;

n = 0;
XtSetArg(args[n], XtNheight, 100);	n++;
XtSetArg(args[n], XtNwidth, 200);	n++;
XtSetValues(widget, args, n);
.De
.LP
Alternatively, an application can statically declare the argument list
and use
.ZN XtNumber :
.LP
.Ds
.TA .5i 3i
.ta .5i 3i
static Args args[] = {
	{XtNheight, (XtArgVal) 100},
	{XtNwidth, (XtArgVal) 200},
};
XtSetValues(Widget, args, XtNumber(args));
.De
.LP
Note that you should not use auto-increment or auto-decrement
within the first argument to
.ZN XtSetArg .
.ZN XtSetArg
can be implemented as a macro that dereferences the first argument twice.
.LP
The
.ZN XtMergeArgLists
function allocates enough storage to hold the combined
.ZN ArgList
structures and copies them into it.
Note that it does not check for duplicate entries.
When it is no longer needed,
free the returned storage by using
.ZN XtFree .
.SH "SEE ALSO"
XtOffset(3Xt)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
