/**********************************************************************
*
*  commonlib.h
*
*  Descripion  - This is a header file that exports the commonlib
*                functions.
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/

#ifndef _COMMLIB_H_
#define _COMMLIB_H_

#include <sys/soundcard.h>

#define NV_MIXER_PRELEFT    SOUND_MIXER_NRDEVICES+1
#define NV_MIXER_PRERIGHT   NV_MIXER_PRELEFT+1
#define NV_MIXER_PRERLEFT   NV_MIXER_PRELEFT+2
#define NV_MIXER_PRERRIGHT  NV_MIXER_PRELEFT+3
#define NV_MIXER_PRECENTER  NV_MIXER_PRELEFT+4
#define NV_MIXER_PRESUB     NV_MIXER_PRELEFT+5
#define NV_MIXER_MICBOOST   NV_MIXER_PRELEFT+6

#define NV_MIXER_LINUXVER   NV_MIXER_PRELEFT+7
#define NV_MIXER_DRIVERVER  NV_MIXER_PRELEFT+8
#define NV_MIXER_CODECVER   NV_MIXER_PRELEFT+9

/* Function to open/close the mixer for nvaudio. */
int  open_mixer();
void free_mixer();


/* Function to set/get the Speaker selection */
int set_speaker_select(int option);
int get_speaker_select( void );

/* Function to set/get the Analog/Digital Output Status */
int get_analogout( void );
int get_digitalout( void );
int set_analogout( int enablebit );
int set_digitalout( int enablebit );

/* Function to set/get swap linein / micin Status */
int get_swaplinein( void );
int get_swapmicin( void );
int set_swaplinein( int enablebit );
int set_swapmicin( int enablebit );

/* function to set/get volumes of common registers*/
int set_common_volregister( int mixernum, int value);
int get_common_volregister( int mixernum, int *mute);
int set_mic_boost( int enablebit );

/* function to set/get mute state */
int set_mute( int mixernum, int value);
int get_mute( int mixernum);

/*function to set/get record input */
int set_record_channel(int inport);
int get_record_channel();

/*Function to find the codec type*/
int get_nvinfo(int index, char* value, int *type);
int verify_codec();

#endif
