/**********************************************************************
*
*  nvioctl.h
*
*  Descripion  - Header file used for the common structures for the
*  ioctls used for apps and driver
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NV_IOCTL_H_
#define _NV_IOCTL_H_

#define NV_SPKR_STEREO   2
#define NV_SPKR_QUAD     4
#define NV_SPKR_51       6

#define PREMIX_LEFT     0
#define PREMIX_RIGHT    PREMIX_LEFT+1
#define PREMIX_RLEFT    PREMIX_LEFT+2
#define PREMIX_RRIGHT   PREMIX_LEFT+3
#define PREMIX_CENTER   PREMIX_LEFT+4
#define PREMIX_SUB      PREMIX_LEFT+5

#define NV_MASTER_MUTE  PREMIX_LEFT+6
 
#define PREMIX_MUTE     0x80

#define LINUX_INFO      2
#define DRIVER_INFO     3
#define CODEC_INFO      4

#define REALTEK_CODEC              0x1
#define ADI_CODEC                  0x2
#define SIGMATEL_CODEC             0x3

/*
 Common struct used to pass and get info between
 app and kernel
*/
struct nv_ioctl {
     unsigned long cmd;
     unsigned long val[4];
     char     name[20];
};

/*
   enum on/off params
*/

enum on_offparams {
	ANALOG_OUT = 0,
	DIGITAL_OUT,
	MIC_BOOST,
	MIXERMUTE,
	SWAP_LINEIN,
	SWAP_MICIN
};
/* IOCTLS used to read and write the ac97 controller,
   codec registers and speaker configuration
   This is common between the application and driver
*/

#define NV_IOC_MAGIC 'n'
#define NV_IOCRESET   _IO(NV_IOC_MAGIC, 0)

#define NV_AC97CODEC_READ  _IOR(NV_IOC_MAGIC,1,struct nv_ioctl)
#define NV_AC97CODEC_WRITE _IOW(NV_IOC_MAGIC,2,struct nv_ioctl)
#define NV_AC97CON_READ    _IOR(NV_IOC_MAGIC,3,struct nv_ioctl)
#define NV_AC97CON_WRITE   _IOW(NV_IOC_MAGIC,4,struct nv_ioctl)
#define NV_SET_SPKRSELECT  _IOW(NV_IOC_MAGIC,5,struct nv_ioctl)
#define NV_GET_SPKRSELECT  _IOR(NV_IOC_MAGIC,6,struct nv_ioctl)
#define NV_SET_ANALOGOUT   _IOW(NV_IOC_MAGIC,7,struct nv_ioctl)
#define NV_GET_ANALOGOUT   _IOR(NV_IOC_MAGIC,8,struct nv_ioctl)
#define NV_SET_DIGITALOUT  _IOW(NV_IOC_MAGIC,9,struct nv_ioctl)
#define NV_GET_DIGITALOUT  _IOR(NV_IOC_MAGIC,10,struct nv_ioctl)
#define NV_SET_MICBOOST    _IOW(NV_IOC_MAGIC,11,struct nv_ioctl)
#define NV_GET_MICBOOST    _IOR(NV_IOC_MAGIC,12,struct nv_ioctl)
#define NV_SET_PREMIXVOL   _IOW(NV_IOC_MAGIC,13,struct nv_ioctl)
#define NV_GET_PREMIXVOL   _IOR(NV_IOC_MAGIC,14,struct nv_ioctl)
#define NV_GET_INFO        _IOR(NV_IOC_MAGIC,15,struct nv_ioctl)
#define NV_SET_MIXERMUTE   _IOW(NV_IOC_MAGIC,16,struct nv_ioctl)
#define NV_GET_MIXERMUTE   _IOR(NV_IOC_MAGIC,17,struct nv_ioctl)
#define NV_GET_ONOFF       _IOR(NV_IOC_MAGIC,18,struct nv_ioctl)
#define NV_SET_ONOFF       _IOW(NV_IOC_MAGIC,19,struct nv_ioctl)

#define NV_IOC_HARDRESET   _IO(NV_IOC_MAGIC, 20)

#define NV_IOC_MAXNR  NV_IOC_HARDRESET


#endif /* _NV_IOCTL_H_ */

