// MakeDoc
// version 2
//
// Compresses text files into a format that is ready to export to a Pilot
// and work with Rick Bram's PilotDOC reader.
//
// Copyright (C) Pat Beirne, 2000.
// Distributable under the GNU General Public License Version 2 or later.
//
// ver 0.6 enforce 31 char limit on database names
// ver 0.7 change header and record0 to structs
// ver 2.0 added category control on the command line
//		changed extensions from .prc to .pdb


//#pragma pack(1)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "makedoc9.h"
#include "zlib.h"
#include <netinet/in.h>
#include <qstring.h>
#include <qregexp.h>
#include <qimage.h>
#include "Palm2QImage.h"

typedef unsigned long DWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;
//#define DISP_BITS 11
#define COUNT_BITS 3
#define DATATYPE_TBMP 2
#define DATATYPE_TBMP_COMPRESSED 3

struct dbHeader {
    char docName[32];
    WORD flags;
    WORD version;
    DWORD creationDate;
    DWORD modificationDate;
    DWORD unused0;
    DWORD unused1;
    DWORD appInfoOffset;
    DWORD sortInfoId;
    char magic[8];
    DWORD unused2;
};

struct recordIdList {
    DWORD nextRecordListId; //always zero
    WORD numRecords;
};

struct Offset {
    DWORD recordOffset;
    DWORD unused;
};

struct reservedIDs {
    WORD name;
    WORD ID;
};

struct indexRecord {
    WORD uid;
    WORD version;
    WORD records;
};

struct recordHeader {
    WORD uid;
    WORD paragraphs;
    WORD size;
    unsigned char type;
    unsigned char reserved;
};

struct paragraphInfo {
    WORD size;
    WORD attributes;
};

////////////// utilities //////////////////////////////////////

int Unzip(BYTE * in_buf, BYTE * out_buf, int in_size, int out_size)
{
    int err;
    err = 0;
    uLongf out_len;
    out_len = uLongf(out_size);
    err = uncompress(out_buf, &out_len, in_buf, in_size);
    return err;
}

int Decompress(BYTE * in_buf, BYTE * out_buf, unsigned int in_size)
{
    unsigned int i,j;
    for (j=i=0; j<in_size; )
    {
	unsigned int c;

	// take a char from the input buffer
	c = in_buf[j++];

	// separate the char into zones: 0, 1...8, 9...0x7F, 0x80...0xBF, 0xC0...0xFF

	// codes 1...8 mean copy that many bytes; for accented chars & binary
	if (c>0 && c<9) while(c--) out_buf[i++] = in_buf[j++];

	// codes 0, 9...0x7F represent themselves
        else if (c<0x80) out_buf[i++] = c;

	// codes 0xC0...0xFF represent "space + ascii char"
        else if (c>=0xC0) out_buf[i++] = ' ', out_buf[i++] = c ^ 0x80;

	// codes 0x80...0xBf represent sequences
	else
	{
	    int m,n;
	    c <<= 8;
	    c += in_buf[j++];
	    m = (c & 0x3FFF) >> COUNT_BITS;
	    n = c & ((1<<COUNT_BITS) - 1);
	    n += 3;
	    while (n--)
	    {
		out_buf[i] = out_buf[i-m];
		i++;
	    }
	}
    }
    return i;
}

int GetImage(char* src, int recordId, const char * thisPicture)
{
    unsigned int fileSize,dataSize;
    FILE *fin;
    recordIdList thisRecordIdList;
    Offset * offsets;
    int recordNum;
    BYTE *buffer_out,*buffer_in;
    buffer_out = buffer_in = NULL;
    indexRecord thisIndexRecord;
    
    
    fin = fopen(src,"rb");
    if (fin == 0) return 0;
    fseek(fin,0,SEEK_END);
    fileSize = ftell(fin);
    fseek(fin,72,SEEK_SET);
    fread (&thisRecordIdList,1,6,fin);
    thisRecordIdList.numRecords = ntohs(thisRecordIdList.numRecords);

    //printf("Records %d\n",thisRecordIdList.numRecords);
    
    offsets = new Offset[thisRecordIdList.numRecords];
    if (offsets == NULL)
    {
	fclose(fin);
	return 0;
    }
    for (int i=0; i<thisRecordIdList.numRecords; i++)
    {
	fread(&offsets[i],1,8,fin);
	offsets[i].recordOffset = ntohl(offsets[i].recordOffset);
    }
    
    fseek(fin,offsets[0].recordOffset,SEEK_SET);
    fread(&thisIndexRecord,1,6,fin);
    thisIndexRecord.uid = ntohs(thisIndexRecord.uid);
    thisIndexRecord.version = ntohs(thisIndexRecord.version);
    thisIndexRecord.records = ntohs(thisIndexRecord.records);
    
    recordHeader thisRecordHeader;
    recordNum = 1;
    for (int i=1; i<thisRecordIdList.numRecords; i++)
    {
	fseek(fin,offsets[i].recordOffset,SEEK_SET);
	fread(&thisRecordHeader,1,8,fin);
	thisRecordHeader.uid = ntohs(thisRecordHeader.uid);
	recordNum = i;
	if (thisRecordHeader.uid == recordId) break;
    }

    thisRecordHeader.size = ntohs(thisRecordHeader.size);
    if ( recordNum< (thisRecordIdList.numRecords - 1)) dataSize = offsets[recordNum+1].recordOffset - ftell(fin);
    else dataSize = fileSize - ftell(fin);
    delete[] offsets;
    
    //printf("Record Type = %d\n",thisRecordHeader.type); 
    if (thisRecordHeader.type == DATATYPE_TBMP_COMPRESSED)
    {
	buffer_out = new BYTE[thisRecordHeader.size];
	buffer_in = new BYTE[dataSize];
	fread(buffer_in,1,dataSize,fin);
	
	if (thisIndexRecord.version == 2)
	{
	    //printf("Unzipping image\n");
	    if(Unzip(buffer_in,buffer_out,dataSize,thisRecordHeader.size) != Z_OK)
	    {
		//printf("Error unzipping\n");
		delete[] buffer_out;
		delete[] buffer_in;
		fclose(fin);
		return 0;
	    }
	} else if (thisIndexRecord.version == 1)
	{
	    //printf("Uncompressing image\n");
	    if(Decompress(buffer_in,buffer_out,dataSize) != thisRecordHeader.size)
	    {
		//printf("Error uncompressing\n");
		delete[] buffer_out;
		delete[] buffer_in;
		fclose(fin);
		return 0;
	    }
	} else {
	    //printf("Unknown compression\n");
	    delete[] buffer_out;
	    delete[] buffer_in;
	    fclose(fin);
	    return 0;
	}
	delete[] buffer_in;
    } else if (thisRecordHeader.type == DATATYPE_TBMP)
    {
	//printf("Image not compressed\n");
	buffer_out = new BYTE[thisRecordHeader.size];
	//fread(buffer_out,1,dataSize,fin);
	fread(buffer_out,1,thisRecordHeader.size,fin);
    } else {
	fclose(fin);
	return 0;
    }
    dataSize = thisRecordHeader.size;
    QImage * image =  Palm2QImage(buffer_out,dataSize);
    if (image)
    {
	QPixmap * p = new QPixmap();
	p->convertFromImage(*image,0);
	p->save(QString(thisPicture),"BMP");
	p->~QPixmap();
    	image->~QImage();
    }
    delete[] buffer_out;
    return 0;
}

int Decomp(char* src, char* dest,char * recordMap,bool reorder)
{
    int mapPointer;
    mapPointer = 0;
    dbHeader thisDocHeader;
    recordIdList thisRecordIdList;
    indexRecord thisIndexRecord;
    unsigned int dataSize;
    unsigned int fileSize;
    unsigned int outIndex;
    WORD nextUID;
    WORD recordNum;
    nextUID = 0;
    recordNum = 0;
    bool err;
    err = false;
    int docType;
    docType = 0;
    Offset * offsets;
    reservedIDs * IDs;
    paragraphInfo * thisParagraphInfo;
    BYTE *buffer_out,*buffer_in,*tempPointer;
    thisParagraphInfo = NULL;
    buffer_out = NULL;
    buffer_in = NULL;
    
    FILE *fin;
    FILE *fout;
    FILE *fRecordMap;
    unlink(recordMap);
    //FILE *debug;
    //debug = fopen("/tmp/justreader/debug","wb");

    fin = fopen(src,"rb");
    if (fin == 0) return 0;
    fseek(fin,0,SEEK_END);
    fileSize = ftell(fin);
    fseek(fin,0,SEEK_SET);
    //printf("File size = %d\n",fileSize);
    
    fout = fopen(dest,"wb");
    if (fout == 0) return 0;
    
    
    fread (&thisDocHeader,1,72,fin);
    //fwrite (thisDocHeader.magic,8,1, stdout);
    if (strncmp("DataPlkr",thisDocHeader.magic,8) == 0) docType = 1;
    else if(strncmp("TEXtREAd",thisDocHeader.magic,8) == 0) docType = 2;
    if (docType<1) return 0;
    
    fread (&thisRecordIdList,1,6,fin);
	thisRecordIdList.numRecords = ntohs(thisRecordIdList.numRecords);
    //printf("\nNumber of records is %d\n",thisRecordIdList.numRecords);
   
    offsets = new Offset[thisRecordIdList.numRecords];
    if (offsets == NULL)
    {
	fclose(fin);
	fclose(fout);
    	return 0;
    }
    for (int i=0; i<thisRecordIdList.numRecords; i++)
    {
	//printf("Reading at %d\n",ftell(fin));
	fread(&offsets[i],1,8,fin);
	offsets[i].recordOffset = ntohl(offsets[i].recordOffset);
    }
    
    // Simple PalmDoc format
    if (docType == 2)
    {
	buffer_out = new BYTE[65535];
	int out_size;
	for (int i=1; i<thisRecordIdList.numRecords; i++)
	{
	    fseek(fin,offsets[i].recordOffset,SEEK_SET); 
	    if ( i< (thisRecordIdList.numRecords - 1)) dataSize = offsets[i+1].recordOffset - ftell(fin);
	    else dataSize = fileSize - ftell(fin);
	    if (buffer_in != NULL) delete[] buffer_in;
	    buffer_in = new BYTE[dataSize];
	    if ((buffer_out == NULL) || (buffer_in == NULL))
	    {
		err = true;
		break;
	    }
	    fread(buffer_in,1,dataSize,fin);
	    out_size = Decompress(buffer_in,buffer_out,dataSize);
	    fwrite(buffer_out,1,out_size,fout);
	    //fwrite("################################",1,32,fout);
	}
	delete[] buffer_in;
	delete[] buffer_out;
	fclose(fin);
	fclose(fout);
	if (err) return 0;
	return docType;
    }
 
    //Plucker format
    // go to Index record
    fseek(fin,offsets[0].recordOffset,SEEK_SET);
    fread(&thisIndexRecord,1,6,fin);
    thisIndexRecord.uid = ntohs(thisIndexRecord.uid);
    thisIndexRecord.version = ntohs(thisIndexRecord.version);
    thisIndexRecord.records = ntohs(thisIndexRecord.records);
    //printf("uid=%d, version=%d, records=%d\n",thisIndexRecord.uid,thisIndexRecord.version,thisIndexRecord.records);
    IDs = new reservedIDs[thisIndexRecord.records];
    if (IDs == NULL)
    {
	delete[] offsets;
	fclose(fin);
	fclose(fout);
	return 0;
    }
    for (int i=0; i<thisIndexRecord.records;i++)
    {
	fread(&IDs[i],1,4,fin);
	IDs[i].name = ntohs(IDs[i].name);
	IDs[i].ID = ntohs(IDs[i].ID);
	//printf("name=%d, ID=%d\n",IDs[i].name,IDs[i].ID);
    }

    recordHeader thisRecordHeader;
    for (int i=1; i<thisRecordIdList.numRecords; i++)
    {
	if (reorder && nextUID)
	{
	    for (int j=1; j<thisRecordIdList.numRecords; j++)
	    {
		fseek(fin,offsets[j].recordOffset,SEEK_SET);
		fread(&thisRecordHeader,1,8,fin);
		thisRecordHeader.uid = ntohs(thisRecordHeader.uid);
		recordNum = j;
		if (nextUID == thisRecordHeader.uid) break;
	    }
	} else {
	    fseek(fin,offsets[i].recordOffset,SEEK_SET);
	    fread(&thisRecordHeader,1,8,fin);
	    thisRecordHeader.uid = ntohs(thisRecordHeader.uid);
	    recordNum = i;
	}
	//printf("This record: %d\n",recordNum);
	//printf("This UID: %d\n",thisRecordHeader.uid);
	thisRecordHeader.paragraphs = ntohs(thisRecordHeader.paragraphs);
	thisRecordHeader.size = ntohs(thisRecordHeader.size);
	//printf ("i=%d, offset = %d, uid=%d, paragraphs=%d, size=%d, type=%d\n",i,offsets[recordNum].recordOffset,thisRecordHeader.uid,thisRecordHeader.paragraphs,thisRecordHeader.size,thisRecordHeader.type);
	if (thisParagraphInfo != NULL) delete[] thisParagraphInfo;
	thisParagraphInfo = new paragraphInfo[thisRecordHeader.paragraphs];
	if (thisParagraphInfo == NULL)
	{
	    err = true;
	    break;
	}
	//int sum;
	//sum = 0;
	for (int j=0; j<thisRecordHeader.paragraphs;j++)
	{
	    fread(&thisParagraphInfo[j],1,4,fin);
	    thisParagraphInfo[j].size = ntohs(thisParagraphInfo[j].size);
	    thisParagraphInfo[j].attributes = ntohs(thisParagraphInfo[j].attributes);
	    //printf("\tp=%d, size=%d\n",j,thisParagraphInfo[j].size);
	    //sum += thisParagraphInfo[j].size;
	}
	//printf("\tsum size=%d\n",sum);
	
	if ( recordNum< (thisRecordIdList.numRecords - 1)) dataSize = offsets[recordNum+1].recordOffset - ftell(fin);
	else dataSize = fileSize - ftell(fin);

	//printf("record dataSzie=%d\n",dataSize);
	if (buffer_out != NULL) delete[] buffer_out;
	if (buffer_in != NULL) delete[] buffer_in;
	buffer_out = new BYTE[thisRecordHeader.size];
	buffer_in = new BYTE[dataSize];
	if ((buffer_out == NULL) || (buffer_in == NULL))
	{
	    err = true;
	    break;
	}
	switch (thisRecordHeader.type)
	{
	    case 0:
		fread(buffer_out,1,dataSize,fin);
		break;
	    case 1:
		fread(buffer_in,1,dataSize,fin);
		if (thisIndexRecord.version == 2)
		{
		    if(Unzip(buffer_in,buffer_out,dataSize,thisRecordHeader.size) != Z_OK) err = true;
		} else if (thisIndexRecord.version == 1)
		{
		    if(Decompress(buffer_in,buffer_out,dataSize) != thisRecordHeader.size) err = true;
		} else err = true; 
		break;
	    case 2:
		break;
	    case 3:
		break;
	    case 4:
		break;
	    case 5:
		break;
	    case 6:
		break;
	    case 7:
		break;
	    case 8:
		break;
	    case 9:
		break;
	    case 10:
		break;
	    default:
		err = true;
		printf("Unknown type %d\n",thisRecordHeader.type);
	}
	if (err) break;
	if (thisRecordHeader.type<2)
	{
	    fRecordMap =  fopen(recordMap,"ab");
	    tempPointer = buffer_out;
	    for (int j=0;j<thisRecordHeader.paragraphs;j++)
	    {
		outIndex = ftell(fout);
		fwrite(&thisRecordHeader.uid,1,2,fRecordMap);
		WORD xtmp = j;
		DWORD xtmp1 = outIndex;
		fwrite(&xtmp,1,2,fRecordMap);
		fwrite(&xtmp1,1,4,fRecordMap);
		/*pdbToIndex[mapPointer].record = i;
		pdbToIndex[mapPointer].offset = j;
		pdbToIndex[mapPointer].index = ftell(fout);*/
		if (thisParagraphInfo[j].size>0) fwrite(buffer_out,1,thisParagraphInfo[j].size,fout);
		buffer_out +=thisParagraphInfo[j].size;
		fputc('\n',fout);
		fputc(0,fout);
		fputc(0x08,fout);
		fputc(0,fout);
		fputc(0x48,fout);
		fputc(0,fout);
		fputc(0x68,fout);
		fputc(0,fout);
		fputc(0x11,fout);
		fputc(0,fout);
		
		//fputc('\n',fout);
	    }
	    buffer_out = tempPointer;
	    if (reorder)
		{
		    unsigned int k;
		    QString string = "";
		    QChar ch = ' ';
		    k = 0;
		    //nextUID = thisRecordHeader.uid+1;
		    nextUID = 0;
		    while (k<thisRecordHeader.size)
		    {
			if (buffer_out[k++] != 0) 
			{
			    if (!QChar(buffer_out[k-1]).isSpace())
			    {
				if (ch.isSpace()) string = "";
				string.append(QChar(buffer_out[k-1]));
			    }
			    ch = QChar(buffer_out[k-1]);
			    continue;
			}
			switch (buffer_out[k++])
			{
			    case 0x0a:
				if ((buffer_out[k+2] == 'N') || (buffer_out[k+2] == 'n'))
				{
				    nextUID = buffer_out[k]*256;
				    nextUID += buffer_out[k+1];
				} else if (string.lower().find(QRegExp("next"),0)>-1)
				//} else if (k<50)
				{
				    nextUID = buffer_out[k]*256;
				    nextUID += buffer_out[k+1];
				}
				k += 2;
				break;
			    case 0x08:
			    case 0x38:
			    case 0x40:
			    case 0x48:
			    case 0x60:
			    case 0x68:
			    case 0x70:
			    case 0x78:
				break;
			    case 0x11:
			    case 0x29:
				k++;
				break;
			    case 0x1a:
			    case 0x22:
				k += 2;
				break;
			    case 0x33:
			    case 0x53:
			    case 0x83:
				k += 3;
				break;
			    case 0x0c:
			    case 0x5c:
				k += 4;
				break;
			    case 0x85:
				k += 5;
				break;
			    default:
				break;
			}
		    }
		}

	    fclose(fRecordMap);
	    //fwrite(buffer_out,1,thisRecordHeader.size,debug);
	    //fwrite("################",1,16,debug);
	}
    }

    if (thisParagraphInfo != NULL) delete[] thisParagraphInfo;
    if (buffer_out != NULL) delete[] buffer_out;
    if (buffer_in != NULL) delete[] buffer_in;
    if (IDs !=0) delete[] IDs;
    if (offsets != NULL) delete[] offsets;
    
    fclose(fin);
    fclose(fout);
    //fclose(debug);
    if (err) return 0;
    return docType;
}

