/***************************************************************************
 *                       TextReader.cpp  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "TextReader.h"
#include "SettingsDlg.h"
#include "FileDialog.h"
#include "Bookmarks.h"
#include <qmainwindow.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#ifndef __FOR_QT__
#include <qpe/config.h>
#include <qpe/filemanager.h>
#include <qpe/applnk.h>
#include <qpe/qpeapplication.h>
#else
#include "qpex/config.h"
#endif
#include <qpopupmenu.h>
#include <qdir.h>
#include <qtextcodec.h>
#include <qapplication.h>

// TxtReader Constructor
TextReader::TextReader (QMainWindow *parent,const char*name, WFlags f)
    : QMainWindow (parent,name,f)
{
    //QPEApplication::grabKeyboard();
    setCaption("JustReader");
    setupMenus();
    setMainMenu();
    showToolbar();
    settingsdlg = new SettingsDlg(this);
    settingsdlg->hide();
    bookmarks = new Bookmarks(this);
    bookmarks->hide();
    contents = new Bookmarks(this);
    contents ->hide();
    textview = new Control(this);
    connect(goBackAction,SIGNAL( activated() ), textview,SLOT(goLinkBack()));
    textview->goBackAction = goBackAction;
    goBackAction->setEnabled(false);
    connect(findAction,SIGNAL( activated() ), textview,SLOT(findWord()));
    textview->config.display.rotation = 0;
    setCentralWidget(textview);
    //resize(600,800);
    fullscreen = FALSE;
    showMaximized();

    folderpath = QDir::homeDirPath();
    filedialog = new GetFileName(this);
    connect(filedialog,SIGNAL(fileSelectedSignal()),this,SLOT(fileOpenedSlot()));
    connect(filedialog,SIGNAL(fileNotSelectedSignal()),this,SLOT(fileNotOpenedSlot()));
    // 2002-09-13, Psimon Ghim, If encoding is changed, resuming is more convenient to user.
    connect(settingsdlg,SIGNAL(acceptSettings()),this,SLOT(acceptSettings()));
    connect(settingsdlg,SIGNAL(closeSettings()),this,SLOT(closeSettings()));
    connect(textview,SIGNAL(toggleFullScreen()),this,SLOT(toggleFullScreenSlot()));
    connect(textview,SIGNAL(fileOpenSignal()),this,SLOT(fileOpen()));
    connect(textview,SIGNAL(settingsSignal()),this,SLOT(settings()));
    connect(textview,SIGNAL(bookmarkSignal()),this,SLOT(addMarkSlot()));
    // Connection for bookmarks
    connect(bookmarks,SIGNAL(BookmarkSignal()), this, SLOT(gotBookmark()));
    // Connection for contents
    connect(contents,SIGNAL(BookmarkSignal()), this, SLOT(gotContents()));
    loadSettings();
}

TextReader::~TextReader()
{
    //QPEApplication::ungrabKeyboard();
    textview->~Control();
    settingsdlg->~SettingsDlg();
    bookmarks->~Bookmarks();
    contents->~Bookmarks();
    filedialog->~GetFileName();
}

void TextReader::gotBookmark()
{
    closeBookmark();
    if (bookmarks->itemChanged)
    {
	textview->docPosition = bookmarks->filePos;
	//textview->pagenewparagraph = bookmarks->newparagraph;
	textview->resume();
    }
}

void TextReader::gotContents()
{
    closeContents();
    if (contents->itemChanged)
    {
	textview->docPosition = contents->filePos;
	//textview->pagenewparagraph = contents->newparagraph;
	textview->resume();
    }
}

void TextReader::closeBookmark()
{
    bookmarks->hide();
    setMainMenu();
    setCentralWidget(textview);
    textview->show();
    textview->setFocus();
}

void TextReader::closeContents()
{
    contents->hide();
    setMainMenu();
    setCentralWidget(textview);
    textview->show();
    textview->setFocus();
}

void TextReader::gotoMarkSlot()
{
    textview->hide();
    setBookmarksMenu();
    setCentralWidget(bookmarks);
    bookmarks->fontname = textview->config.display.fontName;
    bookmarks->show();
    bookmarks->setFocus();
}

void TextReader::gotoContentsSlot()
{
    textview->hide();
    setContentsMenu();
    setCentralWidget(contents);
    contents->fontname = textview->config.display.fontName;
    contents->show();
    contents->setFocus();
}

void TextReader::saveBookmarks()
{
    bookmarks->saveBookmarks(folderpath+"/"+basefilename+".bkm");
}

void TextReader::generateContents()
{
    textview->generateContents(folderpath+"/"+basefilename+".cnt");
    contents->loadBookmarks(folderpath+"/"+basefilename+".cnt");
}

void TextReader::addMarkSlot()
{
    if (textview->docIsOpen)
    {
	    bookmarks->addBookmark(textview->getBookmarkName(),textview->docPosition,textview->getPageNumber(),true);
    }
    textview->setFocus();
}

void TextReader::toggleFullScreenSlot()
{
    if (!textview->isVisible()) return;
    if (fullscreen)
    {
	showToolbar();
	showNormal();
	//resize(appSize);
	showMaximized();
    } else {
	appSize = size();
	hideToolbar();
	//showNormal();	
	showFullScreen();
    }
    fullscreen = !fullscreen;
}

void TextReader::focusOutEvent(QFocusEvent *)
{
    if (fullscreen) toggleFullScreenSlot();
    textview->stopScrolling = true;
}

void TextReader::focusInEvent(QFocusEvent *)
{
}

void TextReader::fileOpen()
{
    textview->hide();
    setFileOpenMenu();
    setCentralWidget(filedialog);
    //filedialog->folderpath = folderpath;
    filedialog->setFolderList(folderpath);
    filedialog->fontName = textview->config.display.fontName;
    filedialog->show();
    filedialog->setFocus();
}

void TextReader::fileOpenedSlot()
{
    fullfilename = filedialog->filename;
    QFileInfo fileinfo(fullfilename);
    basefilename = fileinfo.baseName();
    folderpath = fileinfo.dirPath(TRUE);
    bookmarks->loadBookmarks(folderpath+"/"+basefilename+".bkm");
    contents->loadBookmarks(folderpath+"/"+basefilename+".cnt");
    textview->setFocus();
    fileNotOpenedSlot();
    textview->fileOpen(filedialog->filename);
}

void TextReader::fileNotOpenedSlot()
{
    filedialog->hide();
    setMainMenu();
    setCentralWidget(textview);
    textview->show();
    textview->setFocus();
}

void TextReader::settings()
{
    settingsdlg->config = textview->config;
    textview->hide();
    setSettingsMenu();
    setCentralWidget(settingsdlg);
    settingsdlg->show();
    settingsdlg->setFocus();
}

void TextReader::closeSettings()
{
    settingsdlg->hide();
    setMainMenu();
    setCentralWidget(textview);
    textview->show();
    textview->setFocus();
}

void TextReader::acceptSettings()
{
    settingsdlg->acceptChanges();
    textview->config = settingsdlg->config;
    textview->pickUpSettings();
    closeSettings();
}

void TextReader::loadSettings()
{
    Config *myconfig = new Config("JustReader");
#ifndef __FOR_QT__
    Config *qpeconfig = new Config("qpe");
    if (qpeconfig->isValid())
    {
	//qpeconfig->setGroup("BatteryPower");
	qpeconfig->setGroup("Screensaver");
	if (qpeconfig->hasKey("Interval"))
	{
	    textview->config.display.intervalSuspend = qpeconfig->readNumEntry("Interval", 60);
	    textview->config.display.intervalLightOff = qpeconfig->readNumEntry("Interval_LightOff", 30);
	    textview->config.display.intervalDim = qpeconfig->readNumEntry( "Interval_Dim", 20 );
	}
    }
#endif
    if (!myconfig->isValid()) return;
    myconfig->setGroup("Global");
    if (myconfig->hasKey("File"))
    {
	textview->fileName=myconfig->readEntry("File","");
	folderpath=myconfig->readEntry("Folderpath","~/Documents");
	QFileInfo fileinfo(textview->fileName);
	fullfilename = textview->fileName;
	basefilename = fileinfo.baseName();
	bookmarks->loadBookmarks(folderpath+"/"+basefilename+".bkm");
	contents->loadBookmarks(folderpath+"/"+basefilename+".cnt");
	textview->docPosition=long(myconfig->readNumEntry("Position",0));
    }
	
    myconfig->setGroup("Display");
	textview->config.display.fontName=myconfig->readEntry("Fontname","helvetica");
	textview->config.display.fontSize=myconfig->readNumEntry("Fontsize",12);
	textview->config.display.fontBold=myconfig->readBoolEntry("Bold",false);
	textview->config.display.fakeBold=myconfig->readBoolEntry("Fake Bold",false);
	textview->config.display.fontItalic=myconfig->readBoolEntry("Italic",false);
	textview->config.display.defaultAlign = myconfig->readNumEntry("Align",3);
	textview->config.display.barVisible = myconfig->readBoolEntry("BarVisible",true);
	textview->config.display.barPercent = myconfig->readBoolEntry("BarPercent",false);
	textview->config.display.rotation=myconfig->readNumEntry("Rotation",0);
	textview->config.display.indentPoints=myconfig->readNumEntry("Indent",10);
	textview->config.display.margin=myconfig->readNumEntry("Margin",4);
	textview->config.display.spacing=myconfig->readNumEntry("Spacing",1);
	textview->config.display.overlap = myconfig->readNumEntry("Overlap",0);
	textview->config.display.imageScaling = myconfig->readNumEntry("ImageScaling",100);
	textview->config.display.imageAsWord = myconfig->readBoolEntry("ImageAsWord",false);
	textview->config.display.scrollDelay=myconfig->readNumEntry("Scroll",50);
	
    myconfig->setGroup("Format");
	textview->config.format.reparagraph = myconfig->readBoolEntry("Reparagraph",true);
	textview->config.format.docFormat = myconfig->readNumEntry("DocFormat",0);
	textview->config.format.palmFormat = myconfig->readNumEntry("PalmFormat",128);
	textview->config.format.removeSpacePads = myconfig->readBoolEntry("SpacePadded",false);
	textview->config.format.separateParagraphs = myconfig->readBoolEntry("SeparateParagraphs",false);
	textview->config.format.stripCR = myconfig->readBoolEntry("StripCR",true);
	textview->config.format.reorderPlucker = myconfig->readBoolEntry("ReorderPlucker",true);
	textview->config.format.encoding=myconfig->readEntry("Encoding","ISO 8859-1");
	//textview->config.format.htmlReparagraph=myconfig->readBoolEntry("HtmlReparagraph",true);
   
    myconfig->setGroup("Misc");
    textview->config.misc.intDict = myconfig->readBoolEntry("InternalDictionary",false);
    textview->config.misc.dictionary = myconfig->readEntry("DictionaryPath","");
	
    myconfig->setGroup("Colors");
	textview->config.colors.bgColor.setNamedColor(myconfig->readEntry("bgColor","#ffffff"));
	textview->config.colors.normalColor.setNamedColor(myconfig->readEntry("normalColor","#000000"));
	textview->config.colors.linkColor.setNamedColor(myconfig->readEntry("linkColor","#0000ff"));
	textview->config.colors.barBgColor.setNamedColor(myconfig->readEntry("barBgColor","#c0c0c0"));
	textview->config.colors.barFgColor.setNamedColor(myconfig->readEntry("barFgColor","#808080"));
	textview->config.colors.barTextColor.setNamedColor(myconfig->readEntry("barTextColor","#000000"));

    myconfig->setGroup("Keys");
	textview->config.keys.scroll = myconfig->readNumEntry("ScrollKey",83);
	textview->config.keys.bar = myconfig->readNumEntry("BarKey",66);
	textview->config.keys.fullScreen = myconfig->readNumEntry("FullScreenKey",32);
	textview->config.keys.rotate = myconfig->readNumEntry("RotateKey",82);
	textview->config.keys.settings = myconfig->readNumEntry("SettingsKey",84);
	textview->config.keys.fileopen = myconfig->readNumEntry("FileopenKey",79);
	textview->config.keys.bookmark = myconfig->readNumEntry("BookmarkKey",77);
	textview->config.keys.find = myconfig->readNumEntry("FindKey",70);
	textview->config.keys.back = myconfig->readNumEntry("BackKey",4099);
	textview->config.keys.up = myconfig->readNumEntry("UpKey",87);
	textview->config.keys.down = myconfig->readNumEntry("DownKey",83);
	textview->config.keys.left = myconfig->readNumEntry("LeftKey",65);
	textview->config.keys.right = myconfig->readNumEntry("RightKey",68);
	textview->config.keys.joypad = myconfig->readBoolEntry("UseJoypad",true);
	
    delete myconfig;
    textview->resume();
}

void TextReader::saveSettings()
{
    Config *myconfig = new Config("JustReader");
    myconfig->setGroup("Global");
    myconfig->writeEntry("File",textview->fileName);
    myconfig->writeEntry("Folderpath",folderpath);
    myconfig->writeEntry("Position",int(textview->docPosition));
	
    myconfig->setGroup("Display");
    myconfig->writeEntry("Fontname",textview->config.display.fontName);
    myconfig->writeEntry("Fontsize",textview->config.display.fontSize);
    myconfig->writeEntry("Bold",textview->config.display.fontBold);
    myconfig->writeEntry("Fake Bold",textview->config.display.fakeBold);
    myconfig->writeEntry("Italic",textview->config.display.fontItalic);
    myconfig->writeEntry("Align",textview->config.display.defaultAlign);
    myconfig->writeEntry("BarVisible",textview->config.display.barVisible);
    myconfig->writeEntry("BarPercent",textview->config.display.barPercent);
    myconfig->writeEntry("Rotation",QString::number(int(textview->config.display.rotation)));
    myconfig->writeEntry("Indent",textview->config.display.indentPoints);
    myconfig->writeEntry("Margin",textview->config.display.margin);
    myconfig->writeEntry("Spacing",textview->config.display.spacing);
    myconfig->writeEntry("Overlap",textview->config.display.overlap);
    myconfig->writeEntry("ImageScaling",textview->config.display.imageScaling);
    myconfig->writeEntry("ImageAsWord",textview->config.display.imageAsWord);
    myconfig->writeEntry("Scroll",textview->config.display.scrollDelay);
    
    myconfig->setGroup("Format");
    myconfig->writeEntry("Reparagraph",textview->config.format.reparagraph);
    myconfig->writeEntry("DocFormat",textview->config.format.docFormat);
    myconfig->writeEntry("PalmFormat",textview->config.format.palmFormat);
    myconfig->writeEntry("SpacePadded",textview->config.format.removeSpacePads);
    myconfig->writeEntry("SeparateParagraphs",textview->config.format.separateParagraphs);
    myconfig->writeEntry("StripCR",textview->config.format.stripCR);
    myconfig->writeEntry("ReorderPlucker",textview->config.format.reorderPlucker);
    myconfig->writeEntry("Encoding",textview->config.format.encoding);
    //myconfig->writeEntry("HtmlReparagraph",textview->config.format.htmlReparagraph);
	
    myconfig->setGroup("Misc");
    myconfig->writeEntry("InternalDictionary",textview->config.misc.intDict);
    myconfig->writeEntry("DictionaryPath",textview->config.misc.dictionary);
	
    myconfig->setGroup("Colors");
    myconfig->writeEntry("bgColor",textview->config.colors.bgColor.name());
    myconfig->writeEntry("normalColor",textview->config.colors.normalColor.name());
    myconfig->writeEntry("linkColor",textview->config.colors.linkColor.name());
    myconfig->writeEntry("barBgColor",textview->config.colors.barBgColor.name());
    myconfig->writeEntry("barFgColor",textview->config.colors.barFgColor.name());
    myconfig->writeEntry("barTextColor",textview->config.colors.barTextColor.name());
	
    myconfig->setGroup("Keys");
    myconfig->writeEntry("ScrollKey",textview->config.keys.scroll);
    myconfig->writeEntry("BarKey",textview->config.keys.bar);
    myconfig->writeEntry("FullScreenKey",textview->config.keys.fullScreen);
    myconfig->writeEntry("RotateKey",textview->config.keys.rotate);
    myconfig->writeEntry("SettingsKey",textview->config.keys.settings);
    myconfig->writeEntry("FileopenKey",textview->config.keys.fileopen);
    myconfig->writeEntry("BookmarkKey",textview->config.keys.bookmark);
    myconfig->writeEntry("FindKey",textview->config.keys.find);
    myconfig->writeEntry("BackKey",textview->config.keys.back);
    myconfig->writeEntry("UpKey",textview->config.keys.up);
    myconfig->writeEntry("DownKey",textview->config.keys.down);
    myconfig->writeEntry("LeftKey",textview->config.keys.left);
    myconfig->writeEntry("RightKey",textview->config.keys.right);
    myconfig->writeEntry("UseJoypad",textview->config.keys.joypad);
    myconfig->~Config();
}

void TextReader::closeEvent ( QCloseEvent * e)
{
    saveSettings();
    if (centralWidget() == textview)
    {
	saveSettings();
	e->accept();
    }
}

void TextReader::keyPressEvent(QKeyEvent * e)
{
    //if (textview->translating) return;
    switch(e->key())
    {
	case Key_Escape:
	    if ((centralWidget() == bookmarks) || (centralWidget() == contents))
	    {
		centralWidget()->hide();
	        setMainMenu();
	        setCentralWidget(textview);
	        textview->show();
	        textview->setFocus();
	    }
	    break;
	case Key_F11:	// Menu pressed
	    if (menubar->isVisible())
	    {
	    	menubar->activateItemAt(0);
	    	break;
	    }
	default:
	    //e->ignore();
	    if (e->key() == Key_F33)
	    {
		QKeyEvent k(QEvent::KeyPress,Key_Return,Key_Return,e->state());
		textview->keyPressed(&k);
	    } else {
	    	textview->keyPressed(e);
	    }
    }
}

QPixmap TextReader::IconScale(QString pix)
{
    QWMatrix m;
    double scale;
    int h;
    QPixmap p;
#ifdef __FOR_QT__
    if (!p.load(pix))
    {
	if (!p.load("pics/"+pix))
	{
	    if (!p.load("pics/"+pix+".png"))
	    {
		if (!p.load("/usr/share/pixmaps/actions/"+pix+".png"))
		{
		    if (!p.load("/usr/share/pixmaps/"+pix+".png"))
		    {
			if (!p.load("/usr/share/icons/actions/"+pix+".png"))
			{
			    if (!p.load("/usr/share/icons/"+pix+".png"))
			    {
				p.load("/usr/share/pixmaps/justreader/"+pix+".png");
			    }
			}
		    }
		}
	    }
	}
    }
    
#else
    p = Resource::loadPixmap(pix);
#endif
    return p;
/*    h = p.height();
    scale = 16/ double(h);
    m.reset();
    m.scale(scale,scale);
    return p.xForm(m);*/
}

void TextReader::setupMenus()
{
    filemenu = new QPopupMenu(this);
    navigationmenu = new QPopupMenu(this);
    QPixmap hPix(IconScale( "fileopen" ));
    //hPix.load("close");
    int menuHeight = hPix.height()+6;
    //menuHeight = 16;

    openAction = new QAction( tr( "Open" ),IconScale( "fileopen" ), QString::null, 0, this, 0 );
    connect( openAction, SIGNAL( activated() ), this, SLOT(fileOpen()));
    openAction->addTo(filemenu);

    goBackAction = new QAction( tr( "goBack"), IconScale( "back"),QString::null, 0, this, 0 );
    findAction = new QAction( tr( "Find"), IconScale( "search"),QString::null, 0, this, 0 );

    closeFileOpenAction = new QAction(tr("Close"),IconScale("button_cancel"),QString::null,0,this,0);  
    connect(closeFileOpenAction,SIGNAL( activated() ), this,SLOT(fileNotOpenedSlot()));

    settingsAction = new QAction(tr("Settings"),IconScale("configure"), QString::null, 0, this, 0 );
    connect(settingsAction,SIGNAL( activated() ), this, SLOT(settings()));
    settingsAction->addTo(filemenu);

    addBookmarkAction =  new QAction(tr("Add mark"),IconScale("bookmark_add"), QString::null, 0, this, 0 );
    connect(addBookmarkAction,SIGNAL( activated() ), this, SLOT(addMarkSlot()));
    addBookmarkAction->addTo(navigationmenu);

    gotoBookmarkAction = new QAction(tr("Goto mark"),IconScale("bookmark"),QString::null,0,this, 0 );
    connect(gotoBookmarkAction,SIGNAL( activated() ), this, SLOT(gotoMarkSlot()));
    gotoBookmarkAction->addTo(navigationmenu);

    saveBookmarksAction = new QAction(tr("Save marks"),IconScale("filesave"),QString::null,0,this, 0 );
    connect(saveBookmarksAction,SIGNAL( activated() ), this, SLOT(saveBookmarks()));
    saveBookmarksAction->addTo(navigationmenu);

    closeBookmarksAction  = new QAction(tr("Close"),IconScale("button_cancel"),QString::null,0,this,0);
    connect(closeBookmarksAction,SIGNAL( activated() ), this,SLOT(closeBookmark()));
	
    okBookmarksAction = new QAction(tr("Ok"),IconScale("button_ok"),QString::null, 0, this, 0 );
    connect(okBookmarksAction,SIGNAL( activated() ), this,SLOT(gotBookmark()));
	
    navigationmenu->insertSeparator();

    contentsAction = new QAction(tr("Table of Contents"),IconScale("contents"),QString::null,0,this,0);
    connect(contentsAction,SIGNAL( activated() ), this, SLOT(gotoContentsSlot()));
    contentsAction->addTo(navigationmenu);

    buildContentsAction = new QAction(tr("Build Contents"),IconScale("gear"), QString::null, 0, this, 0 );
    connect(buildContentsAction,SIGNAL( activated() ), this, SLOT(generateContents()));
    buildContentsAction->addTo(navigationmenu);

    okContentsAction = new QAction(tr("Ok"),IconScale("button_ok"),QString::null,0,this,0);
    connect(okContentsAction,SIGNAL( activated() ), this,SLOT(gotContents()));

    closeContentsAction  = new QAction(tr("Close"),IconScale("button_cancel"), QString::null, 0, this, 0 );
    connect(closeContentsAction,SIGNAL( activated() ), this,SLOT(closeContents()));

    closeSettingsAction  = new QAction(tr("Close"),IconScale("button_cancel"), QString::null, 0, this, 0 );
    connect(closeSettingsAction,SIGNAL( activated() ), this,SLOT(closeSettings()));

    acceptSettingsAction  = new QAction(tr("OK"),IconScale("button_ok"), QString::null, 0, this, 0 );
    connect(acceptSettingsAction,SIGNAL( activated() ), this,SLOT(acceptSettings()));
    
#ifdef __FOR_QT__
    menubar = new QMenuBar(this);
    iconstoolbar = new QToolBar(this);
//    menubar->setFixedHeight(menuHeight+4);
//    iconstoolbar->setFixedHeight(menuHeight+4);
#else
    setToolBarsMovable( false );
    menutoolbar = new QToolBar(this);
    menutoolbar->setHorizontalStretchable( true );
    menubar = new QMenuBar(menutoolbar);
    iconstoolbar = new QToolBar(this);
    menubar->setFixedHeight(menuHeight);
    menutoolbar->setFixedHeight(menuHeight);
    iconstoolbar->setFixedHeight(menuHeight);
#endif
}

void TextReader::setMainMenu()
{
    iconstoolbar->clear();
    menubar->clear();
    menubar->insertItem("File",filemenu);
    menubar->insertItem("Navigation",navigationmenu);
    goBackAction->addTo(iconstoolbar);
    findAction->addTo(iconstoolbar);
    openAction->addTo(iconstoolbar);
    settingsAction->addTo(iconstoolbar);
    addBookmarkAction->addTo(iconstoolbar);
    gotoBookmarkAction->addTo(iconstoolbar);
}

void TextReader::setBookmarksMenu()
{
    iconstoolbar->clear();
    menubar->clear();
    menubar->insertItem(IconScale("filesave"),this,SLOT(saveBookmarks()));
    menubar->insertItem(IconScale("edittrash"),bookmarks,SLOT(deleteSelected()));

    closeBookmarksAction->addTo(iconstoolbar);
}

void TextReader::setContentsMenu()
{
    iconstoolbar->clear();
    menubar->clear();
    closeContentsAction->addTo(iconstoolbar);
}

void TextReader::setSettingsMenu()
{
    iconstoolbar->clear();
    menubar->clear();
    closeSettingsAction->addTo(iconstoolbar);
    acceptSettingsAction->addTo(iconstoolbar);
}

void TextReader::setFileOpenMenu()
{
    iconstoolbar->clear();
    menubar->clear();
    closeFileOpenAction->addTo(iconstoolbar);
}

void TextReader::showToolbar()
{
#ifdef __FOR_QT__
    menubar->show();
#else
    menutoolbar->show();
#endif
    iconstoolbar->show();
}

void TextReader::hideToolbar()
{
    iconstoolbar->hide();
#ifdef __FOR_QT__
    menubar->hide();
#else
    menutoolbar->hide();
#endif
}
