/***************************************************************************
 *                       StreamPRC.cpp  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "StreamPRC.h"

StreamPRC::~StreamPRC()
{
/*    QDir dir;
    if (pdbToIndex) delete [] pdbToIndex;
    dir = QDir::QDir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }*/
}

QChar StreamPRC::isTag(QChar t)
{
    if (t == '\n')
    {
	newLine = true;
	newParagraph = true;
	return QChar();
    }
    if (t.latin1() != '\0') return t;
    textstream->operator>>(tc);
    return getTag(tc);
}

QChar StreamPRC::getTag(QChar t)
{
    int record;
    int offset;
    QString imgFileName;
    switch(t)
    {
	case 0x0a:
	    textstream->operator>>(tc);
	    record = BYTE(tc.latin1())*256;
	    textstream->operator>>(tc);
	    record += BYTE(tc.latin1());
	    offset  = 0;
	    tag.a = true;
	    tag.href = "#" + QString::QString().setNum(record) + ":" + QString::QString().setNum(offset);
	    break;
	case 0x0c:
	    textstream->operator>>(tc);
	    record = BYTE(tc.latin1())*256;
	    textstream->operator>>(tc);
	    record += BYTE(tc.latin1());
	    textstream->operator>>(tc);
	    offset = BYTE(tc.latin1())*256;
	    textstream->operator>>(tc);
	    offset += BYTE(tc.latin1());
	    tag.a = true;
	    tag.href = "#" + QString::QString().setNum(record) + ":" + QString::QString().setNum(offset);
	    break;
	case 0x08:
	    tag.a = false;
	    tag.href = "";
	    break;
	case 0x11:
	    textstream->operator>>(tc);
	    if (tc == '\0')
	    {
		tag.h = 0;
		break;
	    }
	    tag.h = 7 - int(tc.latin1());
	    if (tag.h>7) tag.h = 0;
	    break;
	case 0x1a:
	    textstream->operator>>(tc);
	    record = BYTE(tc.latin1())*256;
	    textstream->operator>>(tc);
	    record += BYTE(tc.latin1());
	    //deal with image here
	    imgFileName = "/tmp/justreader/" + QString::QString().setNum(record) + ".bmp";
	    if (!QFile::QFile(imgFileName).exists())
	    {
	        docPix = new QPixmap();
	    	GetImage(plucker_file,record, docPix);
		docPix->save(imgFileName,"BMP");
		docPix->~QPixmap();
	    }
	    tag.img = true;
	    tag.imgSrc = imgFileName;
	    tag.imgAlt = "image";
	    break;
	case 0x22:
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    break;
	case 0x29:
	    textstream->operator>>(tc);
	    break;
	case 0x33:
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    break;
	case 0x38:
	    newLine = true;
	    break;
	case 0x40:
	    tag.i = true;
	    break;
	case 0x48:
	    tag.i = false;
	    break;
	case 0x53:
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    break;
	case 0x5c:
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    textstream->operator>>(tc);
	    break;
	case 0x60:
	    tag.u = true;
	    break;
	case 0x68:
	    tag.u = false;
	    break;
	default:
	    break;
    }
    return QChar();	
}

bool StreamPRC::openFile(const QString & filepath)
{
    char out_char[256],rim_char[256];
    plucker_file = new char[256];
    QString out_file,rim_file;
    QDir dir;
    out_file = "/tmp/justreader/palmdoc.tmp\0";
    rim_file = "/tmp/justreader/palmdoc.rim\0";
    strncpy(plucker_file,(filepath+"\0").latin1(),(filepath+"\0").length()+1);
    strncpy(out_char,out_file.latin1(),out_file.length()+1);
    strncpy(rim_char,rim_file.latin1(),rim_file.length()+1);
    //printf("%s\n%s\n%s\n",plucker_file,out_char,rim_char);
    //plucker_file[255] = 0;
    //out_char[255] = 0;
    //rim_file[255] = 0;
    QFile f;
    int docType;
    if ( !QFile::exists( filepath ) ) return false;
    f.setName( filepath ); 
    if (!f.open( IO_ReadOnly ))
    {
	return false;
    }
    fileOpened = true;
    f.close();
    if (file.isOpen()) file.close();
    dir = QDir::QDir("/tmp/justreader");
    dir.mkdir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }
    docType = Decomp(plucker_file,out_char,rim_char,reorderPlucker);
    if (docType == 1)
    {
	FILE * rim;
	rim = 0;
	rim = fopen(rim_char,"rb");
	fseek(rim,0,SEEK_END);
	rimSize = ftell(rim)/8;
	fseek(rim,0,SEEK_SET);
	if (pdbToIndex) delete [] pdbToIndex;
	pdbToIndex = new PdbToFileMap[rimSize];
	for (unsigned int i = 0; i < rimSize; i++)
	{
	    fread(&pdbToIndex[i].record,1,2,rim);
	    fread(&pdbToIndex[i].offset,1,2,rim);
	    fread(&pdbToIndex[i].index,1,4,rim);
	}
	fclose(rim);
    }
    
    file.setName( out_file ); 
    file.open( IO_ReadOnly );
    docSize = file.size();
    numberOfPages = int(docSize/2000) + 1;
    newParagraph = false;
    newLine = false;
    if (textstream) textstream->~QTextStream();
    textstream = new QTextStream(&file);
    resetTags();
    setEncoding(encoding);
    if (links) delete [] links;
    links = 0;
    linksFound = false;
    return true;
}

void StreamPRC::findLinks()
{
}

int StreamPRC::getInLinkPosition(QString l)
{
    int r,o,t;
    QString R,O;
    bool ok;
    t = l.find(":");
    R = l.left(t);
    O = l.mid(t+1);
    r = R.toInt(&ok,10);
    o = O.toInt(&ok,10);
    for (unsigned int i = 0;i < rimSize;i++)
    {
	if (pdbToIndex[i].record != r) continue;
	if (pdbToIndex[i].offset != o) continue;
	return pdbToIndex[i].index;
    }
    return -1;
}
