/***************************************************************************
 *                       SettingsDlg.h  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qaction.h>
#include <qpainter.h>
#include <qframe.h>
#include <qstring.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include "Config.h"
#include "ColorComboBox.h"
#include "SelectKeyButton.h"

class QAction;
class QActionGroup;
class QPopupMenu;
class QPainter;
class QPixmap;
class QDialog;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class SettingsDlg;
class ColorComboBox;
class SelectKeyButton;

class SettingsDlg : public QWidget
{
    Q_OBJECT
    public:
	SettingsDlg(QWidget *parent=0, const char *name=0);
	c_config config;
	QString paragraphRegexp,docFormatString,palmFormatString;
	void acceptChanges();
    signals:
	void acceptSettings();
	void closeSettings();
    private slots:
	void showEvent(QShowEvent *);	
	void resizeEvent(QResizeEvent *);
	void dictBrowse();
	void pathChanged(const QString &filename);
	void joypadChanged();
	
    private:
	QTabWidget *settingsTab;
    QWidget *tab,*tab_2,*tab_3,*tab_4,*tab_5,*tab_6,*tab_7;
    QLabel *TextLabel1,*TextLabel2,*TextLabel3,*TextLabel4,
    	*TextLabel5,*TextLabel9,*TextLabel7,*TextLabel,
	*TextLabel8,*TextLabel6,*TextLabel10,*TextLabel1_2,
	*TextLabel2_2,*TextLabel3_2,*textLabel1,*TextLabel7_2,
	*TextLabel8_2,*TextLabel6_2,*TextLabel4_2,*TextLabel9_2, *TextLabel99_2,
	*TextLabel5_2,*TextLabel12,*TextLabel14,*TextLabel10_2,
	*TextLabel17,*TextLabel15,*TextLabel11,* TextLabel18,
	*TextLabel16,*TextLabel13,*TextLabel20_2_2,*TextLabel22_2_2,
	*TextLabel19_2_2,*TextLabel21_2_2,*textLabel3;

	QCheckBox *fontBoldCheckBox,*fontItalicCheckBox,*fakeBoldCheckBox,
		*justifyCheckBox,*reparagraphCheckBox,
		*barCheckBox,*barPercentCheckBox,*removeSpacePadsCheckBox,
		*separateParagraphsCheckBox,*stripCRCheckBox,
		*intDictCheckBox,*reorderPluckerCheckBox,
		*imageAsWordCheckBox,
		*joypadCheckBox;
	QSpinBox *indentSpinBox,*marginsSpinBox,
	    *spacingSpinBox,*fontSizeSpinBox,*scrollSpinBox,*overlapSpinBox,*imageScalingSpinBox;
	QComboBox *fontNameComboBox,*encodingComboBox,
	    *rotationComboBox,*paragraphRegexpComboBox,
	    *docFormatComboBox,*palmFormatComboBox,
	    *alignComboBox;
	QLineEdit *dictionaryLineEdit;
	ColorComboBox *bgColorComboBox,*normalColorComboBox,*linkColorComboBox,*barFgColorComboBox,*barBgColorComboBox,*barTextColorComboBox,*highlightColorComboBox;
	SelectKeyButton *scrollButton,*barButton,*fullScreenButton,
		*rotateButton,*settingsButton,*fileopenButton,
		*bookmarkButton,*findButton,*backButton,
		*upButton,*downButton,*leftButton,*rightButton;
	QComboBox *dictComboBox;
	QString currentPath;
	QString alignString;
	void setFolderList(QString filename);
protected:
    QVBoxLayout* SettingsDlgLayout;
    QVBoxLayout *displayTabLayout,*fontLayoutLeft,*fontLayoutRight,*barImagesChecksLayout,
	*formatCombosLayout,*formatChecksLayout,*miscTabLayout,*controls2TabLayout,*tabLayout;
    QHBoxLayout *fontNameLayout,*fontLayout,*fontSizeLayout,*rotateAlignLayout,*formatTabLayout,*dictPathLayout;
    QGridLayout *numbersLayout,*colorsTabLayout,*controls1TabLayout,*directionKeysLayout;


    protected slots:
	void keyPressEvent(QKeyEvent * e);
    	virtual void languageChange();
};

