/***************************************************************************
 *                       SettingsDlg.cpp  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "SettingsDlg.h"
#include "toUnicode.h"
#include <qapplication.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qdir.h>
#include <qlabel.h>
#include <qtextcodec.h>
#include <qfontdatabase.h> 
#include <qtabwidget.h>
#include <qabstractlayout.h>
#include <qregexp.h>
#ifndef __FOR_QT__
#include <qpe/resource.h>
#endif
#include <qpalette.h>

SettingsDlg::SettingsDlg(QWidget *parent, const char *name)
    : QWidget(parent, name)
{
    if ( !name )
	    setName( "SettingsDlg" );
	
	QWidget *d = QApplication::desktop();
	
    SettingsDlgLayout = new QVBoxLayout( this, 0, 0); 
    settingsTab = new QTabWidget(this);

    tab = new QWidget( settingsTab, "tab" );

    QWidget* privateLayoutWidget = tab; //new QWidget( tab );
//    privateLayoutWidget->setGeometry( QRect( 0, 0, 240, 237 ) );

	QGridLayout* layout = new QGridLayout(privateLayoutWidget, 10, 4, 5, 5);

    TextLabel1 = new QLabel(privateLayoutWidget);
	layout->addWidget(TextLabel1, 0, 0);

    fontNameComboBox = new QComboBox( FALSE, privateLayoutWidget );
//     fontNameComboBox->setMaximumWidth(d->width() / 3);
	layout->addMultiCellWidget(fontNameComboBox, 0, 0, 1, 2, Qt::AlignLeft);
	
    TextLabel2 = new QLabel( privateLayoutWidget );
	//layout->addWidget(TextLabel2, 1, 0);
	TextLabel2->hide();
	
    fontSizeSpinBox = new QSpinBox( privateLayoutWidget );
    fontSizeSpinBox->setMinValue(8);
    fontSizeSpinBox->setMaxValue(MAX_FONT_SIZE);
    fontSizeSpinBox->setLineStep(1);
    layout->addWidget(fontSizeSpinBox, 0, 3);
	
    fontBoldCheckBox = new QCheckBox( privateLayoutWidget );
	layout->addWidget(fontBoldCheckBox, 1, 0);

    fontItalicCheckBox = new QCheckBox( privateLayoutWidget );
	layout->addWidget(fontItalicCheckBox, 1, 1);
	
	fakeBoldCheckBox = new QCheckBox( privateLayoutWidget );
	layout->addMultiCellWidget(fakeBoldCheckBox, 1, 1, 2, 3);

    TextLabel3 = new QLabel( privateLayoutWidget );
	layout->addWidget(TextLabel3, 2, 0);

    rotationComboBox = new QComboBox( FALSE, privateLayoutWidget );
	layout->addWidget(rotationComboBox, 2, 1);
	
    TextLabel4 = new QLabel( privateLayoutWidget );
	layout->addWidget(TextLabel4, 2, 2);
	
    alignComboBox = new QComboBox( FALSE, privateLayoutWidget );
    layout->addWidget(alignComboBox, 2, 3);

    TextLabel5 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel5, 3, 0);

    indentSpinBox = new QSpinBox( privateLayoutWidget );
    indentSpinBox->setMinValue(0);
    indentSpinBox->setMaxValue(40);
    indentSpinBox->setLineStep(1);

    layout->addWidget(indentSpinBox, 3, 1);

    TextLabel6 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel6, 4, 0);

    marginsSpinBox = new QSpinBox( privateLayoutWidget );
    marginsSpinBox->setMinValue(0);
    marginsSpinBox->setMaxValue(40);
    marginsSpinBox->setLineStep(1);

    layout->addWidget(marginsSpinBox, 4, 1);

    TextLabel7 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel7, 5, 0);

    spacingSpinBox = new QSpinBox( privateLayoutWidget );
    spacingSpinBox->setMinValue(0);
    spacingSpinBox->setMaxValue(10);
    spacingSpinBox->setLineStep(1);

    layout->addWidget(spacingSpinBox, 5, 1);

    TextLabel8 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel8, 3, 2);

    overlapSpinBox = new QSpinBox( privateLayoutWidget );
    overlapSpinBox->setMinValue(0);
    overlapSpinBox->setMaxValue(5);
    overlapSpinBox->setLineStep(1);

    layout->addWidget(overlapSpinBox, 3, 3);

    TextLabel9 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel9, 4, 2);

    imageScalingSpinBox = new QSpinBox( privateLayoutWidget );
    imageScalingSpinBox->setMinValue(10);
    imageScalingSpinBox->setMaxValue(100);
    imageScalingSpinBox->setLineStep(5);

    layout->addWidget(imageScalingSpinBox, 4, 3);

    TextLabel10 = new QLabel( privateLayoutWidget );
    layout->addWidget(TextLabel10, 5, 2);

    scrollSpinBox = new QSpinBox( privateLayoutWidget );
    scrollSpinBox->setMinValue(5);
    scrollSpinBox->setMaxValue(1000);
    scrollSpinBox->setLineStep(5);

    layout->addWidget(scrollSpinBox, 5, 3);

    barCheckBox = new QCheckBox(privateLayoutWidget);
    layout->addMultiCellWidget(barCheckBox, 6, 6, 0, 2);

    barPercentCheckBox = new QCheckBox( privateLayoutWidget );
    layout->addMultiCellWidget(barPercentCheckBox, 7, 7, 0, 2);
    
    imageAsWordCheckBox = new QCheckBox( privateLayoutWidget );
    layout->addMultiCellWidget(imageAsWordCheckBox, 8, 8, 0, 1);

    settingsTab->insertTab( tab, "" );
	
    ///////////////////////////////////////////////////////////////	

    tab_2 = new QWidget( settingsTab, "tab_2" );

    QWidget* privateLayoutWidget_2 = tab_2; //new QWidget( tab_2 );
//    privateLayoutWidget_2->setGeometry( QRect( 0, 0, 250, 139 ) );

    QGridLayout* layout2 = new QGridLayout(privateLayoutWidget_2, 9, 2, 7, 7);
    
//    formatTabLayout = new QHBoxLayout( privateLayoutWidget_2, 1, 1); 

//    formatCombosLayout = new QVBoxLayout( 0, 1, 1); 

    TextLabel1_2 = new QLabel( privateLayoutWidget_2 );
    layout2->addWidget(TextLabel1_2, 0, 0);

    encodingComboBox = new QComboBox( FALSE, privateLayoutWidget_2);
//    encodingComboBox->setMaximumWidth(100);
    layout2->addWidget(encodingComboBox, 0, 1);

    TextLabel2_2 = new QLabel( privateLayoutWidget_2 );
    layout2->addWidget(TextLabel2_2, 1, 0);

    docFormatComboBox = new QComboBox( FALSE, privateLayoutWidget_2);
//    docFormatComboBox->setMaximumWidth(100);
    layout2->addWidget(docFormatComboBox, 1, 1);

    TextLabel3_2 = new QLabel( privateLayoutWidget_2 );
    layout2->addWidget(TextLabel3_2, 2, 0);

    palmFormatComboBox = new QComboBox( FALSE, privateLayoutWidget_2);
//    palmFormatComboBox->setMaximumWidth(100);
    layout2->addWidget(palmFormatComboBox, 2, 1);
//    formatTabLayout->addLayout( formatCombosLayout );

//    formatChecksLayout = new QVBoxLayout( 0, 1, 1); 

    reparagraphCheckBox = new QCheckBox( privateLayoutWidget_2);
    layout2->addMultiCellWidget(reparagraphCheckBox, 3, 3, 0, 1);

    separateParagraphsCheckBox = new QCheckBox( privateLayoutWidget_2);
    layout2->addMultiCellWidget(separateParagraphsCheckBox, 4, 4, 0, 1);

    stripCRCheckBox = new QCheckBox( privateLayoutWidget_2);
    layout2->addMultiCellWidget(stripCRCheckBox, 5, 5, 0, 1);

    removeSpacePadsCheckBox = new QCheckBox( privateLayoutWidget_2);
    layout2->addMultiCellWidget(removeSpacePadsCheckBox, 6, 6, 0, 1);

    reorderPluckerCheckBox = new QCheckBox( privateLayoutWidget_2);
    layout2->addMultiCellWidget(reorderPluckerCheckBox, 7, 7, 0, 1);
    
//    QSpacerItem* spacer_3 = new QSpacerItem( 0, 30, QSizePolicy::Minimum, QSizePolicy::Expanding );
//    formatChecksLayout->addItem( spacer_3 );
//    formatTabLayout->addLayout( formatChecksLayout );
    settingsTab->insertTab( tab_2, "" );

    /////////////////////////////////////////////////////////////
    
    tab_3 = new QWidget( settingsTab, "tab_3" );

    QWidget* privateLayoutWidget_3 = tab_3; //new QWidget( tab_3 );
//    privateLayoutWidget_3->setGeometry( QRect( 0, 0, 232, 76 ) );

    QGridLayout* layout3 = new QGridLayout(privateLayoutWidget_3, 4, 2, 7, 7);

    //miscTabLayout = new QVBoxLayout( privateLayoutWidget_3, 1, 1); 

    intDictCheckBox = new QCheckBox( privateLayoutWidget_3);
    layout3->addMultiCellWidget(intDictCheckBox, 0, 0, 0, 1);

    //dictPathLayout = new QHBoxLayout( 0, 0, 0); 

    textLabel1 = new QLabel( privateLayoutWidget_3 );
    layout3->addWidget(textLabel1, 1, 0);

    dictionaryLineEdit = new QLineEdit( privateLayoutWidget_3);
    layout3->addWidget(dictionaryLineEdit, 1, 1);
    //miscTabLayout->addLayout( dictPathLayout );

    dictComboBox = new QComboBox( FALSE, privateLayoutWidget_3);
    //dictComboBox->setMinimumSize( QSize( 230, 0 ) );
    layout3->addMultiCellWidget(dictComboBox, 2, 2, 0, 1);
    settingsTab->insertTab( tab_3, "" );

    tab_4 = new QWidget( settingsTab);

    QVBoxLayout *tmpvb_4 = new QVBoxLayout(tab_4);
    QScrollView *sv_4 = new QScrollView(tab_4);
    tmpvb_4->addWidget(sv_4, 0, 0);
    
    sv_4->setResizePolicy(QScrollView::AutoOneFit);
    sv_4->setFrameStyle(QFrame::NoFrame);
    sv_4->setVScrollBarMode(QScrollView::Auto);
    sv_4->setHScrollBarMode(QScrollView::AlwaysOff);
    
    QWidget* privateLayoutWidget_4 = new QWidget(sv_4->viewport());
    sv_4->addChild(privateLayoutWidget_4);

    colorsTabLayout = new QGridLayout(privateLayoutWidget_4, 8, 2, 7, 5);

    TextLabel4_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel4_2, 0, 0 );
    bgColorComboBox = new ColorComboBox(  privateLayoutWidget_4);
    colorsTabLayout->addWidget( bgColorComboBox, 0, 1 );

    TextLabel5_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel5_2, 1, 0 );
    normalColorComboBox = new ColorComboBox(  privateLayoutWidget_4 );
    colorsTabLayout->addWidget( normalColorComboBox, 1, 1 );

    TextLabel6_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel6_2, 2, 0 );
    linkColorComboBox = new ColorComboBox(  privateLayoutWidget_4);
    colorsTabLayout->addWidget( linkColorComboBox, 2, 1 );
    
    TextLabel7_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel7_2, 3, 0 );
    barFgColorComboBox = new ColorComboBox( privateLayoutWidget_4);
    colorsTabLayout->addWidget(barFgColorComboBox, 3, 1);
    
    TextLabel8_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel8_2, 4, 0 );
    barBgColorComboBox = new ColorComboBox(  privateLayoutWidget_4 );
    colorsTabLayout->addWidget( barBgColorComboBox, 4, 1 );

    TextLabel9_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel9_2, 5, 0 );
    barTextColorComboBox = new ColorComboBox(  privateLayoutWidget_4 );
    colorsTabLayout->addWidget( barTextColorComboBox, 5, 1 );
    
    TextLabel99_2 = new QLabel( privateLayoutWidget_4 );
    colorsTabLayout->addWidget( TextLabel99_2, 6, 0 );
    highlightColorComboBox = new ColorComboBox(  privateLayoutWidget_4 );
    colorsTabLayout->addWidget( highlightColorComboBox, 6, 1 );
    
    settingsTab->insertTab( tab_4, "" );

    ////// Controls 1 ///////

    tab_5 = new QWidget( settingsTab, "tab_5" );
    
    QVBoxLayout *tmpvb_5 = new QVBoxLayout(tab_5);
    QScrollView *sv_5 = new QScrollView(tab_5);
    tmpvb_5->addWidget(sv_5, 0, 0);
    
    sv_5->setResizePolicy(QScrollView::AutoOneFit);
    sv_5->setFrameStyle(QFrame::NoFrame);
    sv_5->setVScrollBarMode(QScrollView::Auto);
    sv_5->setHScrollBarMode(QScrollView::AlwaysOff);
    
    QWidget* privateLayoutWidget_5 = new QWidget(sv_5->viewport());
    sv_5->addChild(privateLayoutWidget_5);

    controls1TabLayout = new QGridLayout( privateLayoutWidget_5, 11, 2, 7, 5); 

    TextLabel10_2 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel10_2, 0, 0 );
    scrollButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( scrollButton, 0, 1 );

    TextLabel11 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel11, 1, 0 );
    barButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( barButton, 1, 1 );

    TextLabel12 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel12, 2, 0 );
    fullScreenButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( fullScreenButton, 2, 1 );

    TextLabel13 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel13, 3, 0 );
    rotateButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( rotateButton, 3, 1 );

    TextLabel14 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel14, 4, 0 );
    settingsButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( settingsButton, 4, 1 );

    TextLabel15 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel15, 5, 0 );
    fileopenButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( fileopenButton, 5, 1 );

    TextLabel16 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel16, 6, 0 );
    bookmarkButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( bookmarkButton, 6, 1 );

    TextLabel17 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel17, 7, 0 );
    findButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( findButton, 7, 1 );

    TextLabel18 = new QLabel( privateLayoutWidget_5 );
    controls1TabLayout->addWidget( TextLabel18, 8, 0 );
    backButton = new SelectKeyButton(  privateLayoutWidget_5);
    controls1TabLayout->addWidget( backButton, 8, 1 );
    
    settingsTab->insertTab( tab_5, "" );

    tab_6 = new QWidget( settingsTab, "tab_6" );

    QVBoxLayout *tmpvb_6 = new QVBoxLayout(tab_6);
    QScrollView *sv_6 = new QScrollView(tab_6);
    tmpvb_6->addWidget(sv_6, 0, 0);
    
    sv_6->setResizePolicy(QScrollView::AutoOneFit);
    sv_6->setFrameStyle(QFrame::NoFrame);
    sv_6->setVScrollBarMode(QScrollView::Auto);
    sv_6->setHScrollBarMode(QScrollView::AlwaysOff);
    
    QWidget* privateLayoutWidget_6 = new QWidget(sv_6->viewport());
    sv_6->addChild(privateLayoutWidget_6);

    QGridLayout* layout7 = new QGridLayout( privateLayoutWidget_6, 6, 2, 7, 7); 

    joypadCheckBox = new QCheckBox( privateLayoutWidget_6);
    layout7->addMultiCellWidget(joypadCheckBox, 0, 0, 0, 1);

    TextLabel19_2_2 = new QLabel( privateLayoutWidget_6 );
    layout7->addWidget( TextLabel19_2_2, 1, 0 );
    upButton = new SelectKeyButton(  privateLayoutWidget_6);
    layout7->addWidget( upButton, 1, 1 );

    TextLabel20_2_2 = new QLabel( privateLayoutWidget_6 );
    layout7->addWidget( TextLabel20_2_2, 2, 0 );
    downButton = new SelectKeyButton(  privateLayoutWidget_6);
    layout7->addWidget( downButton, 2, 1 );

    TextLabel21_2_2 = new QLabel( privateLayoutWidget_6 );
    layout7->addWidget( TextLabel21_2_2, 3, 0 );
    leftButton = new SelectKeyButton(  privateLayoutWidget_6);
    layout7->addWidget( leftButton, 3, 1 );
    
    TextLabel22_2_2 = new QLabel( privateLayoutWidget_6 );
    layout7->addWidget( TextLabel22_2_2, 4, 0 );
    rightButton = new SelectKeyButton(  privateLayoutWidget_6);
    layout7->addWidget( rightButton, 4, 1 );

    settingsTab->insertTab( tab_6, "" );

    tab_7 = new QWidget( settingsTab);
    //tabLayout = new QVBoxLayout( tab_7, 0, 0); 
    QGridLayout* layout8 = new QGridLayout( tab_7, 2, 1, 7, 7); 

    textLabel3 = new QLabel( tab_7 );
    //textLabel3->setTextFormat( QLabel::AutoText );
    //textLabel3->setFont(QFont("helvetica",12,QFont::Bold,FALSE));
    //textLabel3->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );
    layout8->addWidget( textLabel3, 0, 0 );
    settingsTab->insertTab( tab_7, "" );
    
    SettingsDlgLayout->addWidget( settingsTab );
    languageChange();
    resize( QSize(312, 351).expandedTo(minimumSizeHint()) );


    connect(dictComboBox,SIGNAL(activated( const QString &)),this,SLOT(pathChanged(const QString &)));
    
    QFontDatabase *fontdatabase = new QFontDatabase();
    toUnicode * decoder = new toUnicode();
    QString codecs;
    for(int i=0;i<3000;i++)
    {
	if (QTextCodec::codecForMib(i) == NULL) continue;
	decoder->setCodec((QTextCodec::codecForMib(i))->name());
	if (decoder->Index > -1) continue;
	codecs +=QString((QTextCodec::codecForMib(i))->name())+",";
    }
    codecs += decoder->getCodecList();
    fontNameComboBox->insertStringList(fontdatabase->families(FALSE),-1);
    encodingComboBox->insertStringList(QStringList::split(",",codecs,-1),-1);
    rotationComboBox->insertStringList(QStringList::split(",","0,-90,90,180",-1),-1);
    alignComboBox->insertStringList(QStringList::split(",","Left,Center,Right,Justify",-1),-1);
    docFormatComboBox->insertStringList(QStringList::split(",","Auto,HTML,TXT,XML",-1),-1);
    palmFormatComboBox->insertStringList(QStringList::split(",","Plucker,DOC,HTML,TXT,MobiPocket",-1),-1);
    connect(joypadCheckBox,SIGNAL(clicked()),this,SLOT(joypadChanged()));
    
}

void SettingsDlg::languageChange()
{
    setCaption( tr( "Settings" ) );
    TextLabel1->setText( tr( "Font" ) );
    TextLabel2->setText( tr( "Size" ) );
    fontBoldCheckBox->setText( tr( "Bold" ) );
    fakeBoldCheckBox->setText( tr( "Use fake Bold" ) );
    fontItalicCheckBox->setText( tr( "Italic" ) );
    TextLabel3->setText( tr( "Rotation" ) );
    TextLabel4->setText( tr( "Align" ) );
    TextLabel9->setText( tr( "Pics scaling" ) );
    TextLabel7->setText( tr( "Spacing" ) );
    TextLabel5->setText( tr( "Indents" ) );
    TextLabel8->setText( tr( "Overlap" ) );
    TextLabel6->setText( tr( "Margins" ) );
    TextLabel10->setText( tr( "Scroll delay" ) );
    barCheckBox->setText( tr( "Show progress bar" ) );
    barPercentCheckBox->setText( tr( "Progress as %" ) );
    imageAsWordCheckBox->setText( tr( "Pack Pics" ) );
    settingsTab->changeTab( tab, tr( "Display" ) );
    TextLabel1_2->setText( tr( "Encoding" ) );
    TextLabel2_2->setText( tr( "Book Format" ) );
    TextLabel3_2->setText( tr( "Palm Format" ) );
    reparagraphCheckBox->setText( tr( "Reparagraph" ) );
    separateParagraphsCheckBox->setText( tr( "Separate paragraphs" ) );
    stripCRCheckBox->setText( tr( "Strip CR(DOS texts)" ) );
    removeSpacePadsCheckBox->setText( tr( "Strip space pads" ) );
    reorderPluckerCheckBox->setText( tr( "Reorder Plucker" ) );
    settingsTab->changeTab( tab_2, tr( "Format" ) );
    intDictCheckBox->setText( tr( "Built-in dictionary" ) );
    textLabel1->setText( tr( "Path:" ) );
    settingsTab->changeTab( tab_3, tr( "Misc" ) );
    TextLabel7_2->setText( tr( "Bar Color1" ) );
    TextLabel8_2->setText( tr( "Bar Color2" ) );
    TextLabel6_2->setText( tr( "Link text" ) );
    TextLabel4_2->setText( tr( "Background" ) );
    TextLabel9_2->setText( tr( "Bar text" ) );
    TextLabel5_2->setText( tr( "Normal text" ) );
    TextLabel99_2->setText( tr( "Search Highlight" ) );
    settingsTab->changeTab( tab_4, tr( "Colors" ) );
    TextLabel12->setText( tr( "FullScreen" ) );
    TextLabel14->setText( tr( "Settings" ) );
    TextLabel10_2->setText( tr( "Scroll" ) );
    TextLabel17->setText( tr( "FindWord" ) );
    TextLabel15->setText( tr( "OpenFile" ) );
    TextLabel11->setText( tr( "ProgressBar" ) );
    TextLabel18->setText( tr( "GoBack" ) );
    TextLabel16->setText( tr( "Bookmark" ) );
    TextLabel13->setText( tr( "Rotate" ) );
    settingsTab->changeTab( tab_5, tr( "Controls 1" ) );
    joypadCheckBox->setText( tr( "Use Joypad" ) );
    TextLabel20_2_2->setText( tr( "PageDown" ) );
    TextLabel22_2_2->setText( tr( "Right" ) );
    TextLabel19_2_2->setText( tr( "PageUp" ) );
    TextLabel21_2_2->setText( tr( "Left" ) );
    settingsTab->changeTab( tab_6, tr( "Controls 2" ) );
    textLabel3->setText( tr( "<center><br><b>Just Reader</b>"
"<br>"
"Version 2.0k<br>"
"<br>"
"Author: Dmitri Skachkov<br>"
"d_skachkov@yahoo.com<br>"
"<br>"
"Licensed under<br>"
"the GNU Public License<br>"
"<br>"
"Latest version at:<br>"
"http://justreader.sourceforge.net"
"" ) );
    settingsTab->changeTab( tab_7, tr( "About" ) );
}


void SettingsDlg::joypadChanged()
{
    config.keys.joypad = joypadCheckBox->isChecked();
    upButton->setEnabled(!joypadCheckBox->isChecked());
    downButton->setEnabled(!joypadCheckBox->isChecked());
    leftButton->setEnabled(!joypadCheckBox->isChecked());
    rightButton->setEnabled(!joypadCheckBox->isChecked());
}


void SettingsDlg::keyPressEvent(QKeyEvent * e)
{
    switch (e->key())
    {
	    case Key_F33:
	    emit acceptSettings();
	    break;
	case Key_Return:
	    emit acceptSettings();
	    break;
	case Key_Escape:
	    emit closeSettings();
	    break;
	default:
	    e->ignore();
    }
}

void SettingsDlg::resizeEvent(QResizeEvent *)
{
    settingsTab->resize(size());
}

void SettingsDlg::showEvent ( QShowEvent * )
{
    int i;
    i = 0;
    while (i < fontNameComboBox->count())
    {
		fontNameComboBox->setCurrentItem(i++);
		if (fontNameComboBox->currentText() == config.display.fontName) break;
    }
    if (i > fontNameComboBox->count())
    {
		fontNameComboBox->setCurrentItem(0);
    }
    i = 0;
    while (i < encodingComboBox->count())
    {
    	encodingComboBox->setCurrentItem(i++);
	if (encodingComboBox->currentText() == config.format.encoding) break;
    }
    if (i > encodingComboBox->count())
    {
	encodingComboBox->setCurrentItem(0);
    }
    i = 0;
    while (i < rotationComboBox->count())
    {
    	rotationComboBox->setCurrentItem(i++);
	if (rotationComboBox->currentText() == QString().setNum(int(config.display.rotation))) break;
    }
    if (i > rotationComboBox->count())
    {
	rotationComboBox->setCurrentItem(0);
    }
    switch (config.format.docFormat)
    {
	case FORMAT_AUTO:
	    docFormatString = "Auto";
	    break;
	case FORMAT_HTML:
	    docFormatString = "HTML";
	    break;
	case FORMAT_XML:
	    docFormatString = "XML";
	    break;
	case FORMAT_TXT:
	    docFormatString = "TXT";
	    break;
	default:
	    docFormatString = "TXT";
	    break;
    }
    i = 0;
    while (i < docFormatComboBox->count())
    {
	docFormatComboBox->setCurrentItem(i++);
	if (docFormatComboBox->currentText() == docFormatString) break;
    }
    if (i>docFormatComboBox->count())
    {
	docFormatComboBox->setCurrentItem(0);
    }
    switch (config.format.palmFormat)
    {
	case FORMAT_PALM_PLUCKER:
	    palmFormatString = "Plucker";
	    break;
	case FORMAT_PALM_DOC:
	    palmFormatString = "DOC";
	    break;
	case FORMAT_PALM_HTML:
	    palmFormatString = "HTML";
	    break;
	case FORMAT_PALM_TXT:
	    palmFormatString = "TXT";
	    break;
	case FORMAT_PALM_MOBIPOCKET:
	    palmFormatString = "MobiPocket";
	    break;
	default:
	    palmFormatString = "TXT";
	    break;
    }

    i = 0;
    while (i < palmFormatComboBox->count())
    {
	palmFormatComboBox->setCurrentItem(i++);
	if (palmFormatComboBox->currentText() == palmFormatString) break;
    }
    if (i>palmFormatComboBox->count())
    {
	palmFormatComboBox->setCurrentItem(0);
    }

	
    /*while (i < paragraphRegexpComboBox->count())
    {
    	paragraphRegexpComboBox->setCurrentItem(i++);
	if (paragraphRegexpComboBox->currentText() == paragraphRegexp) break;
    }
    if (i > paragraphRegexpComboBox->count())
    {
	paragraphRegexpComboBox->setCurrentItem(0);
    }*/
    if (config.display.defaultAlign == 0)
    {
	alignString = "Left";
    } else if (config.display.defaultAlign == 1)
    {
	alignString = "Center";
    } else if (config.display.defaultAlign == 2)
    {
	alignString = "Right";
    } else {
	alignString = "Justify";
    }
    i = 0;
    while (i < alignComboBox->count())
    {
    	alignComboBox->setCurrentItem(i++);
	if (alignComboBox->currentText() == alignString) break;
    }
    if (i > alignComboBox->count())
    {
	alignComboBox->setCurrentItem(0);
    }


    fontSizeSpinBox->setValue(config.display.fontSize);
    fontBoldCheckBox->setChecked(config.display.fontBold);
    fakeBoldCheckBox->setChecked(config.display.fakeBold);
    fontItalicCheckBox->setChecked(config.display.fontItalic);
    //justifyCheckBox->setChecked(justify);
    reparagraphCheckBox->setChecked(config.format.reparagraph);
    removeSpacePadsCheckBox->setChecked(config.format.removeSpacePads);
    separateParagraphsCheckBox->setChecked(config.format.separateParagraphs);
    stripCRCheckBox->setChecked(config.format.stripCR);
    reorderPluckerCheckBox->setChecked(config.format.reorderPlucker);
    barCheckBox->setChecked(config.display.barVisible);
    barPercentCheckBox->setChecked(config.display.barPercent);
    indentSpinBox->setValue(config.display.indentPoints);
    marginsSpinBox->setValue(config.display.margin);
    spacingSpinBox->setValue(config.display.spacing);
    overlapSpinBox->setValue(config.display.overlap);
    imageScalingSpinBox->setValue(config.display.imageScaling);
    imageAsWordCheckBox->setChecked(config.display.imageAsWord);
    scrollSpinBox->setValue(config.display.scrollDelay);
    intDictCheckBox->setChecked(config.misc.intDict);
    dictionaryLineEdit->setText(config.misc.dictionary);
    QFileInfo fileinfo(config.misc.dictionary);
    setFolderList(fileinfo.dirPath(true));
    //boxAll->resize(width(),height());
    bgColorComboBox->setCurrentColor(config.colors.bgColor);
    normalColorComboBox->setCurrentColor(config.colors.normalColor);
    linkColorComboBox->setCurrentColor(config.colors.linkColor);
    barBgColorComboBox->setCurrentColor(config.colors.barBgColor);
    barFgColorComboBox->setCurrentColor(config.colors.barFgColor);
    barTextColorComboBox->setCurrentColor(config.colors.barTextColor);
    highlightColorComboBox->setCurrentColor(config.colors.highlightColor);

    scrollButton->setCurrentKey(config.keys.scroll);
    barButton->setCurrentKey(config.keys.bar);
    fullScreenButton->setCurrentKey(config.keys.fullScreen);
    rotateButton->setCurrentKey(config.keys.rotate);
    settingsButton->setCurrentKey(config.keys.settings);
    fileopenButton->setCurrentKey(config.keys.fileopen);
    bookmarkButton->setCurrentKey(config.keys.bookmark);
    findButton->setCurrentKey(config.keys.find);
    backButton->setCurrentKey(config.keys.back);
    upButton->setCurrentKey(config.keys.up);
    downButton->setCurrentKey(config.keys.down);
    leftButton->setCurrentKey(config.keys.left);
    rightButton->setCurrentKey(config.keys.right);
    joypadCheckBox->setChecked(config.keys.joypad);
    joypadChanged();
    settingsTab->resize(width(),height());
    //dictionaryButton->adjustSize();	
}

//void SettingsDlg::hideEvent(QHideEvent *)
void SettingsDlg::acceptChanges()
{
    config.display.fontName = fontNameComboBox->currentText();
    config.format.encoding = encodingComboBox->currentText();
    config.display.rotation = rotationComboBox->currentText().toDouble();
    docFormatString = docFormatComboBox->currentText();
    if (docFormatString == "Auto") config.format.docFormat = FORMAT_AUTO;
    else if (docFormatString == "HTML") config.format.docFormat = FORMAT_HTML;
    else if (docFormatString == "XML") config.format.docFormat = FORMAT_XML;
    else if (docFormatString == "TXT") config.format.docFormat = FORMAT_TXT;
    else config.format.docFormat = FORMAT_TXT;
    palmFormatString = palmFormatComboBox->currentText();
    if (palmFormatString == "Plucker") config.format.palmFormat = FORMAT_PALM_PLUCKER;
    else if (palmFormatString == "HTML") config.format.palmFormat = FORMAT_PALM_HTML;
    else if (palmFormatString == "DOC") config.format.palmFormat = FORMAT_PALM_DOC;
    else if (palmFormatString == "TXT") config.format.palmFormat = FORMAT_PALM_TXT;
    else if (palmFormatString == "MobiPocket") config.format.palmFormat = FORMAT_PALM_MOBIPOCKET;
    else config.format.palmFormat = FORMAT_PALM_DOC;

    config.display.fontSize = fontSizeSpinBox->value();
    config.display.fontBold = fontBoldCheckBox->isChecked();
    config.display.fakeBold = fakeBoldCheckBox->isChecked();
    config.display.fontItalic = fontItalicCheckBox->isChecked();
    //justify = justifyCheckBox->isChecked();
    alignString = alignComboBox->currentText();
    if (alignString == "Left")
    {
	config.display.defaultAlign = 0;
    } else if (alignString == "Center")
    {
	config.display.defaultAlign = 1;
    } else if (alignString == "Right")
    {
	config.display.defaultAlign = 2;
    } else {
	config.display.defaultAlign = 3;
    }
    config.format.reparagraph = reparagraphCheckBox->isChecked();
    //paragraphRegexp = paragraphRegexpComboBox->currentText();
    config.format.removeSpacePads = removeSpacePadsCheckBox->isChecked();
    config.format.separateParagraphs = separateParagraphsCheckBox->isChecked();
    config.format.stripCR = stripCRCheckBox->isChecked();
    config.format.reorderPlucker = reorderPluckerCheckBox->isChecked();
    config.display.barVisible = barCheckBox->isChecked();
    config.display.barPercent = barPercentCheckBox->isChecked();
    config.display.indentPoints = indentSpinBox->value();
    config.display.margin = marginsSpinBox->value();
    config.display.spacing = spacingSpinBox->value();
    config.display.overlap = overlapSpinBox->value();
    config.display.imageScaling = imageScalingSpinBox->value();
    config.display.imageAsWord = imageAsWordCheckBox->isChecked();
    config.display.scrollDelay = scrollSpinBox->value();
    config.misc.intDict =  intDictCheckBox->isChecked();
    config.misc.dictionary = dictionaryLineEdit->text();
    config.colors.bgColor = bgColorComboBox->color;
    config.colors.highlightColor = highlightColorComboBox->color;
    
    config.colors.normalColor = normalColorComboBox->color;
    config.colors.linkColor = linkColorComboBox->color;
    config.colors.barBgColor = barBgColorComboBox->color;
    config.colors.barFgColor = barFgColorComboBox->color;
    config.colors.barTextColor = barTextColorComboBox->color;
    config.keys.scroll = scrollButton->key;
    config.keys.bar = barButton->key;
    config.keys.fullScreen = fullScreenButton->key;
    config.keys.rotate = rotateButton->key;
    config.keys.settings = settingsButton->key;
    config.keys.fileopen = fileopenButton->key;
    config.keys.bookmark = bookmarkButton->key;
    config.keys.find = findButton->key;
    config.keys.back = backButton->key;
    config.keys.up = upButton->key;
    config.keys.down = downButton->key;
    config.keys.left = leftButton->key;
    config.keys.right = rightButton->key;
}

void SettingsDlg::setFolderList(QString folder)
{
    QDir dir;
    dictComboBox->clear();
#ifdef __FOR_QT__
    QPixmap p;
    p.load("folder");
    dictComboBox->insertItem(p,folder);
    dictComboBox->insertItem(p,"..");
#else
    dictComboBox->insertItem(Resource::loadPixmap("folder"),folder);
    dictComboBox->insertItem(Resource::loadPixmap("folder"),"..");
#endif
    dir.setPath(folder);
    if (!dir.exists()) dir.setPath(dir.homeDirPath());
    currentPath = dir.absPath();
    dir.setSorting(QDir::Name|QDir::DirsFirst|QDir::IgnoreCase);
    const QFileInfoList * filelist = dir.entryInfoList();
    QFileInfoListIterator it(*filelist);
    QFileInfo * fi;
    while( (fi=it.current()) != 0 )
    {
	++it;
	 if ( fi->fileName() == ".")
	     ;
	 else if ( fi->fileName() == "..")
	 {
	     ;//dictComboBox->insertItem("..");
	 }
	 else if ( fi->fileName() == "NotAvailable")
	 {
	     dictComboBox->insertItem("..");
	 }
	 else if ( fi->isDir())
	 {
#ifdef __FOR_QT__
	     p.load("folder");
	     dictComboBox->insertItem(p,fi->fileName());
#else
	     dictComboBox->insertItem(Resource::loadPixmap("folder"),fi->fileName());
#endif
	 }
	 else
	 {
#ifdef __FOR_QT__
	     p.load("DocsIcon");
	     if ((fi->fileName().find(QRegExp("\\.dic$"),0))>-1) dictComboBox->insertItem(p,fi->fileName());
	     if ((fi->fileName().find(QRegExp("\\.dic\\.dz$"),0))>-1) dictComboBox->insertItem(p,fi->fileName());
#else
	     if ((fi->fileName().find(QRegExp("\\.dic$"),0))>-1) dictComboBox->insertItem(Resource::loadPixmap("DocsIcon"),fi->fileName());
	     if ((fi->fileName().find(QRegExp("\\.dic\\.dz$"),0))>-1) dictComboBox->insertItem(Resource::loadPixmap("DocsIcon"),fi->fileName());
#endif
	 }
    }

} 

void SettingsDlg::pathChanged(const QString &filename)
{
    QDir dir(currentPath);
    if (currentPath == filename) return;
    QFileInfo fileinfo(currentPath+"/"+filename);
    if (fileinfo.isDir())
    {
	dir.cd(filename);
	setFolderList(dir.absPath());
    } else {
	dictionaryLineEdit->setText(currentPath+"/"+filename);	
    }
}

void SettingsDlg::dictBrowse()
{
}
