/***************************************************************************
 *                       SelectKeyButton.cpp  -  description
 *                               -------------------
 *  begin                : Tue May 22 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "SelectKeyButton.h"

SelectKeyButton::SelectKeyButton(QWidget *parent, const char *name)
    : QComboBox(parent, name)
{
    //setMaximumWidth(64);
    w = parent;
    maxKeys = sizeof(special_keys)/sizeof(special_keys[0]);
    special_keys[0].code = Key_F9;
    special_keys[0].name = "<Tasks>"; 
    special_keys[1].code = Key_F10;
    special_keys[1].name = "<Contacts>"; 
    special_keys[2].code = Key_F11;
    special_keys[2].name = "<Home>"; 
    special_keys[3].code = Key_F12;
    special_keys[3].name = "<Menu>"; 
    special_keys[4].code = Key_F13;
    special_keys[4].name = "<Mail>"; 
    special_keys[5].code = Key_F33;
    special_keys[5].name = "<Ok>"; 
    special_keys[6].code = Key_Space;
    special_keys[6].name = "<Select>"; 
    special_keys[7].code = Key_Tab;
    special_keys[7].name = "<Tab>"; 
    special_keys[8].code = Key_Backspace;
    special_keys[8].name = "<Backspace>"; 
    special_keys[9].code = Key_Return;
    special_keys[9].name = "<Ok/Return>"; 
    special_keys[10].code = Key_Shift;
    special_keys[10].name = "<Left Shift>"; 
    special_keys[11].code = Key_Meta;
    special_keys[11].name = "<Right Shift>"; 
    special_keys[12].code = Key_F22;
    special_keys[12].name = "<Fn>"; 
    special_keys[13].code = Key_Up;
    special_keys[13].name = "<Up>"; 
    special_keys[14].code = Key_Down;
    special_keys[14].name = "<Down>"; 
    special_keys[15].code = Key_Left;
    special_keys[15].name = "<Left>"; 
    special_keys[16].code = Key_Right;
    special_keys[16].name = "<Right>"; 
    special_keys[17].code = Key_0;
    special_keys[17].name = "User defined"; 

    for (int i = 0;i<maxKeys;i++)
    {
	insertItem(special_keys[i].name,i);
    }
    connect(this,SIGNAL(activated(int)),this,SLOT(setKey(int)));
}

void SelectKeyButton::keyPressEvent(QKeyEvent * e)
{
    if (e->key() == Key_Escape)
    {
	setCurrentKey(key);
	return;
    }
    if (e->key() == Key_F33)
    {
	setCurrentKey(Key_Return);
    } else {
    	setCurrentKey(e->key());
    }
    w->setFocus();
}

void SelectKeyButton::setKey(int i)
{
    if (i < (maxKeys-1))
    {
	key = special_keys[i].code;
	return;
    }
    setFocus();
    changeItem("Press new key",maxKeys-1);
}

void SelectKeyButton::setCurrentKey(int i)
{
    for (int j = 0;j<(maxKeys-1);j++)
    {
	if (special_keys[j].code == i)
	{
	    setCurrentItem(j);
	    key = special_keys[j].code;
	    return;
	}
    }
    setCurrentItem(maxKeys-1);
    special_keys[maxKeys-1].code = i;
    key = i;
    changeItem("Key<"+QString(QChar(key))+">",maxKeys-1);
}


