/***************************************************************************
 *                       Frame.cpp  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Frame.h"

Frame::Frame()
{
    frame = 0;
    scrolledFrame = 0;
    imageLoaded = false;
    setImageScaling(0.75);
    rotation = 0;
    painter = 0;
    fontMetrics = 0;
    wordsOnPage = 0;
    wordToHighlight = -1;
    width = height = 0;
    margin = bottomMargin = spacing = 0;
    upMargin = 2;
    indentPoints = 16;
    frameCleared = false;
    bgColor = Qt::white;
    highlightColor = Qt::yellow;
    maxFontHeight = 0;
    imageHeightProcessed = -1;
    href = "";
    setProgressBarVisible(true,false);
    setProgressBarHeight(QApplication::font().pointSize());
    setProgressBarProps(Qt::darkGray,Qt::lightGray,Qt::black,50,1,1);
}

Frame::~Frame()
{
    painter->~QPainter();
    frame->~QPixmap();
    if (fontMetrics) fontMetrics->~QFontMetrics();
    if (scrolledFrame) scrolledFrame->~QPixmap();
}

void Frame::create()
{
    wordCounter = 0;
    wordNumber = 0;
    wordToHighlight = -1;
    wordStartNumber = 0;
    wordsPoints = 0;
    charsPoints = 0;
    sumSpacePoints = 0;
    word = "";
    //lineIndent = true;
    lineIndent = false;
    lineHeightFit = true;
    lineAlign = ALIGN_LEFT;
    frame = new QPixmap();
    frame->resize(width,height);
    painter = new QPainter();
    maxLines = sizeof(yAxis2Line)/sizeof(yAxis2Line[0]);
}

void Frame::clear(bool clearPix)
{
    //newPage = true;
    linePointer = 0;
    wordNumber = 0;
    //wordToHighlight = -1;
    wordStartNumber = 0;
    maxFontHeight = 0;
    if (frameCleared) return;
    if (clearPix)
    {
	frame->fill(bgColor);
    }
    if (painter->isActive()) painter->end();
    painter->begin(frame);
    y = upMargin;
    pageComplete = false;
    lineComplete = false;
    lineHeightFit = true;
    wordCounter = 0;
    wordsPoints = 0;
    charsPoints = 0;
    sumSpacePoints = 0;
}

void Frame::clearImage()
{
    imageLoaded = false;
    imageHeightProcessed = -1;
}

void Frame::setLinepoints()
{
    linePoints = width - margin*2 - (lineIndent?indentPoints:0);
}

void Frame::setSize(int w,int h)
{
    bool a;
    if ((rotation == -90) || (rotation == 90))
    {
	width = h;
	height = w;
    } else {
	width = w;
	height = h;
    }
    if (wordsOnPage) delete [] wordsOnPage;
    wordsOnPage = new pageWords[(width/14)*(height/(font.pointSize()+spacing))];
    if (frame) 
    {
    	a = painter->isActive();
    	if (a) painter->end();
	frame->resize(width,height);
	frame->fill(bgColor);
    	if (a) painter->begin(frame);
    }
    setLinepoints();
}

bool Frame::wordIn(QString word)
{
    if (!word.length())
    {
	testHeightFit();
	return true;
    }
    int w;
    w = fontMetrics->width(word);
    if ((w + wordsPoints + wordCounter*spacePoints) > linePoints) return false;
    wordsPoints += w;
    if (wordCounter) sumSpacePoints += spacePoints;
    wordsOnPage[wordNumber].word = word;
    wordsOnPage[wordNumber].width = w;
    wordsOnPage[wordNumber].spaceWidth = spacePoints;
    wordsOnPage[wordNumber].img = false;
    setWordProperties();
    ++wordCounter;
    testHeightFit();
    return true;
}

void Frame::setWordProperties()
{
    //printf("wordToHighlight = %d", wordToHighlight);
    
    wordsOnPage[wordNumber].highlight = (wordNumber == wordToHighlight);
    
    wordsOnPage[wordNumber].font = font;
    wordsOnPage[wordNumber].color = penColor;
    wordsOnPage[wordNumber].href = href;
    ++wordNumber;
}

void Frame::highlightWord(int wordNumber)
{
    wordToHighlight = wordNumber;
}

void Frame::testHeightFit()
{
    int h;
    h = font.pointSize();
    //if ((h + y + spacing) > (height - upMargin - bottomMargin - (progressBarVisible?progressBarHeight:0)))
    if ((h + y + spacing) > getPageHeight() + upMargin)
    {
	lineHeightFit = false;
    } else if (h > maxFontHeight) maxFontHeight = h;
    lineHeight = maxFontHeight + spacing;
}

int Frame::getLineHeight()
{
    return lineHeight;
}

int Frame::getPageHeight()
{
    return height - upMargin - bottomMargin - (progressBarVisible?progressBarHeight:0);
}

bool Frame::charIn(QChar ch)
{
    int w;
    w = fontMetrics->width(ch);
    if ((w + wordsPoints + wordCounter*spacePoints) > linePoints)
    {
	wordCounterUp();
	return false;
    }
    wordsPoints += w;
    charsPoints += w;
    word.append(ch);
    return true;
}

void Frame::wordCounterUp()
{
    wordsOnPage[wordNumber].word = word;
    wordsOnPage[wordNumber].width = charsPoints;
    wordsOnPage[wordNumber].spaceWidth = spacePoints;
    wordsOnPage[wordNumber+1].word = "";
    wordsOnPage[wordNumber].img = false;
    setWordProperties();
    testHeightFit();
    ++wordCounter;
    word = "";
    charsPoints = 0;
}

void Frame::setMargin(int m)
{
    margin = m;
    setLinepoints();
}

void Frame::setSpacing(int s)
{
    spacing = s;
}

void Frame::setIndentPoints(int i)
{
    indentPoints = i;
    setLinepoints();
}

void Frame::setBottomMargin(int i)
{
    bottomMargin = i;
} 

bool Frame::getIndent()
{
    return lineIndent;
}

void Frame::setIndent(bool i)
{
    lineIndent = i;
    setLinepoints();
}

void Frame::setFont(QFont f)
{
    font = f;
}

void Frame::applyFont()
{
    //if (fontMetrics) fontMetrics->~QFontMetrics();
    if (fontMetrics)
    {
	*fontMetrics = QFontMetrics::QFontMetrics(font);
    } else {
	fontMetrics = new QFontMetrics(font);
    }
    spacePoints = fontMetrics->width(' ');
}

void Frame::setBold(bool b)
{
    font.setBold(b);
}

void Frame::setItalic(bool i)
{
    font.setItalic(i);
}

void Frame::setFontSize(int s)
{
    font.setPointSize(s);
}

void Frame::setFontFixedWidth(bool s)
{
    font.setFixedPitch(s);
}

void Frame::setStrikeOut(bool s)
{
    font.setStrikeOut(s);
}

void Frame::setUnderline(bool s)
{
    font.setUnderline(s);
}

void Frame::setHref(QString s)
{
    href = s;
}

// p == 0: return word, p == 1: return href
QString Frame::wordPropsForXY(int xx,int yy, int p)
{
    int i = 0;
    int j,k;
    while ((i < linePointer) && (yAxis2Line[i] < yy)) i++;
    if (i == linePointer) return "";
    j = wordLineStartNumber[i];
    k = j + wordCounterLines[i]; 
    while (1)
    {
	if ((wordsOnPage[j].x > xx) || (j == k)) break;
	++j;
    }
    if (j>0) --j;
    if (p == 1) return wordsOnPage[j].href;
    if (wordsOnPage[j].img) return "";
    if (p == 0) return wordsOnPage[j].word;
    return "";
}

void Frame::setPenColor(QColor p)
{
    penColor = p;
}

void Frame::setBgColor(QColor b)
{
    bgColor = b;
}

void Frame::setHighlightColor(QColor h)
{
    highlightColor = h;
}


void Frame::setLineAlign(int a)
{
    lineAlign = a;
}

void Frame::setDefaultFont(QFont f)
{
    defaultFont = f;
}

void Frame::setRotation(int r)
{
    if (r == rotation) return;
    matrix.reset();
    matrix.rotate(r);
    rotation = r;
}

void Frame::printLine()
{
    if (imageLoaded) return;
    if (wordCounter > 0)
    {
	while (wordsOnPage[wordStartNumber+wordCounter-1].word.stripWhiteSpace() == "")
	{
	    wordsPoints -= wordsOnPage[wordStartNumber+wordCounter-1].width;
	    --wordCounter;
	    if (wordCounter == 0) break;
	}
    }
    if (wordCounter)
    {
    	//newPage = false;
    	//y += maxFontHeight + spacing;
	y += lineHeight;
	//printf("y = %d ->",y);
	wordCounterLines[linePointer] = wordCounter;
	yAxis2Line[linePointer] = y;
	wordLineStartNumber[linePointer] = wordStartNumber;
    	maxFontHeight = 0;
	x = (lineIndent?indentPoints:0) + margin;
	if (lineAlign == ALIGN_JUSTIFY)
	{
	    tempCounter = 0;
	    if (wordCounter > 1)
	    {
	        while(wordsPoints<linePoints)
	        {
	            ++wordsOnPage[wordStartNumber + tempCounter].width;
	            ++tempCounter;
	            ++wordsPoints;
	            if (tempCounter < (wordCounter-1)) continue;
	            tempCounter = 0;
	        }
	    }
	    for (int i = 0; i < wordCounter; i++)
	    {
	        printWord(wordStartNumber + i, x, y);
	        x += wordsOnPage[wordStartNumber+i].width;
	    }

	} else {
	    switch (lineAlign)
	    {
		case ALIGN_CENTER:
		    x += int((linePoints - wordsPoints - sumSpacePoints)/2);
		    break;
		case ALIGN_RIGHT:
		    x += (linePoints - wordsPoints - sumSpacePoints);
		    break;
		case ALIGN_LEFT:
		default:
		    break;
	    }
	    for (int i = 0; i < wordCounter; i++)
	    {
	        printWord(wordStartNumber + i, x, y);
	        x += wordsOnPage[wordStartNumber+i].width + wordsOnPage[wordStartNumber+i+1].spaceWidth;
	    }
	}
	++linePointer;
	wordStartNumber += wordCounter;
	wordNumber = wordStartNumber;
    } else {
	y += defaultFont.pointSize() + spacing;
	maxFontHeight = 0;
    }
    wordCounter = 0;
    wordsPoints = 0;
    charsPoints = 0;
    sumSpacePoints = 0;
}

void Frame::printWord( int i, int xx, int yy)
{
    bool b = false;
    wordsOnPage[i].x = xx;
    if (wordsOnPage[i].img)
    {
	//printf("Drawing image %s\n",wordsOnPage[i].word.latin1());
	//printf("Scaling = %f\n",wordsOnPage[i].scaling);
	imageOrig.load(wordsOnPage[i].word);
	image = &imageOrig;
	if (wordsOnPage[i].scaling != 1)
	{
	    fitMatrix.reset();
	    fitMatrix.scale(wordsOnPage[i].scaling,wordsOnPage[i].scaling);
	    imageTrans = imageOrig.xForm(fitMatrix);
	    image = &imageTrans;
	}
	bitBlt(frame,xx,y - image->height(),image);
	return;
    }
    if (wordsOnPage[i].font.bold() && fakeBold)
    {
	b = true;
	wordsOnPage[i].font.setBold(false);
    }
    painter->setFont(wordsOnPage[i].font);
    painter->setPen(wordsOnPage[i].color);
//    painter->setBackgroundMode(Qt::TransparentMode);
    
    if (wordsOnPage[i].highlight)
    {
        //painter->setBackgroundMode(Qt::OpaqueMode);
        //painter->setBackgroundColor(highlightColor);
        QRect r =  painter->fontMetrics().boundingRect(wordsOnPage[i].word);
        painter->fillRect(xx, yy - lineHeight, r.width(), r.height(), highlightColor);
    }
    
    painter->drawText(xx, yy, wordsOnPage[i].word,-1);
    //if (fakeBold && wordsOnPage[i].font.bold())
    if (b)
    {
	painter->drawText(xx+1, yy, wordsOnPage[i].word,-1);
    }
}

void Frame::createScrollBuffer()
{
    bool a;
    if (scrolledFrame) scrolledFrame->~QPixmap();
    scrolledFrame = new QPixmap();
    scrolledFrame->resize(width,height);
    scrolledFrame->fill(bgColor);
    height = height*2;
    a = painter->isActive();
    if (a) painter->end();
    frame->resize(width,height);
    if (a) painter->begin(frame);
}

void Frame::destroyScrollBuffer()
{
    bool a;
    if (!scrolledFrame) return;
    scrolledFrame->~QPixmap();
    scrolledFrame = 0;
    height = height/2;
    a = painter->isActive();
    if (a) painter->end();
    frame->resize(width,height);
    if (a) painter->begin(frame);
}

void Frame::printPage(QPaintDevice* w,int scrollLines)
{
    if (scrollLines)
    {
	if (!scrolledFrame) createScrollBuffer();
	bitBlt(scrolledFrame,0,upMargin,frame,0,upMargin+scrollLines,width,scrolledFrame->height()-upMargin-bottomMargin);
	if (rotation == 0) {bitBlt(w,0,0,scrolledFrame);}
	else bitBlt(w,0,0,&scrolledFrame->xForm(matrix));
	return;
    }
    if (progressBarVisible)
    {
	painter->setPen(progressBarTextColor);
	painter->setFont(QFont("helvetica",progressBarHeight,QFont::Bold,FALSE));
	painter->fillRect(0,height-progressBarHeight,width*progressBarPercent/100,progressBarHeight,progressBarFgColor);
	painter->fillRect(width*progressBarPercent/100,height-progressBarHeight,width - width*progressBarPercent/100,progressBarHeight,progressBarBgColor);
	if (progressBarPercentShow)
	{
		painter->drawText(width/2 - 10,height - 1,QString().setNum(progressBarPercent)+"%");
	} else {
		painter->drawText(width/2 - 10,height - 1,QString().setNum(progressBarPage)+" ( "+QString().setNum(progressBarPages)+" )");
	}
    }
    if (rotation == 0)
    {
	bitBlt(w,0,0,frame);
    } else {
	bitBlt(w,0,0,&frame->xForm(matrix));
    }
}


bool Frame::imgIn(QString img,QString alt,int p)
{
    if (imageAsWord)
    {
	//printf("wordNumber = %d, wordCounter = %d\n",wordNumber,wordCounter);
	//printf("Default scaling = %f\n",imageScaling);
	double scaling,s;
	int w,h,scrollFactor;
	scrollFactor = (scrolledFrame?2:1);
	if (imageOrig.load(img))
	{
	    scaling = double((getPageHeight()/scrollFactor)-spacing)/double(imageOrig.height());
	    if (imageScaling != 1)
	    {
		imageTrans = imageOrig.xForm(scaleMatrix);
		image = &imageTrans;
	    } else {
		image = &imageOrig;	
	    }
	    if (image->height()>(getPageHeight()/scrollFactor))
	    {
		fitMatrix.reset();
		fitMatrix.scale(scaling,scaling);
		imageTrans = imageOrig.xForm(fitMatrix);
		s = scaling;
		image = &imageTrans;
	    } else s = imageScaling;
	    w = image->width();
	    h = image->height();
	    if (wordCounter>0)
	    {
		if ((w + wordsPoints + wordCounter*spacePoints) > linePoints)
		{
		    //printf("Width doesn't fit\n");
		    return false;
		}
	    } else setIndent(false);
	    //printf("Width fits\n");
	    wordsPoints += w;
	    if (wordCounter) sumSpacePoints += spacePoints;
	    wordsOnPage[wordNumber].img = true;
	    wordsOnPage[wordNumber].scaling = s;
	    wordsOnPage[wordNumber].word = img;
	    wordsOnPage[wordNumber].width = w;
	    wordsOnPage[wordNumber].spaceWidth = spacePoints;
	    //printf("Image height = %d(%d)\n",h,getPageHeight());
	    //printf("Final scaling = %f(%f)\n",s,wordsOnPage[wordNumber].scaling);
	    setWordProperties();
	    ++wordCounter;
	    if ((h + y + spacing) > getPageHeight()+upMargin)
	    {
		//printf("Height doesn't fit from y = %d(spacing=%d,h=%d,pageHeight+upMargin= %d\n",y,spacing,h,getPageHeight()+upMargin);
		lineHeightFit = false;
		//return false;
	    } else if (h > maxFontHeight) maxFontHeight = h;
	    lineHeight = maxFontHeight + spacing;
	    //printf("Image in: %s\n",img.latin1());
	    //if (href != "") printf("Image links to %s\n",href.latin1());
	    return true;
	} else return true;
    }
    if (imgFileName != img)
    {
	imageLoaded = false;
    }
    if (!imageLoaded)
    {
	if (imageOrig.load(img))
	{
	    imageLoaded = true;
	    if (imageScaling != 1)
	    {
		imageTrans = imageOrig.xForm(scaleMatrix);
		image = &imageTrans;
	    } else {
		image = &imageOrig;
	    }
	    imgFileName = img;
	    imageHeight = image->height();
	    imageWidth = image->width();
	    y += spacing;
	}
    }
    imgAlt = alt;
    if (p < 0) p = 0;
    imageHeightProcessed = p;
    return imageLoaded;
}

bool Frame::processingImage()
{
    int xx,heightRemaining;
    xx = margin;
    if (!imageLoaded) return false;
    if (imageHeightProcessed>= imageHeight)
    {
	imageHeightProcessed = -1;
	imageLoaded = false;
	return true;
    }
    //printf("Processing image from %d of %d\n",imageHeightProcessed,imageHeight);
    if ((height - y - upMargin - bottomMargin - (progressBarVisible?progressBarHeight:0)) < (defaultFont.pointSize() + spacing))
    {
	imageLoaded = false;
        lineHeightFit = false;
        return true;
    }
    heightRemaining = imageHeight - imageHeightProcessed;
    lineHeight = defaultFont.pointSize() + spacing;
    if (heightRemaining<lineHeight) lineHeight = heightRemaining;
    bitBlt(frame,xx,y,image,0,imageHeightProcessed,imageWidth,lineHeight);
    imageHeightProcessed += lineHeight;
    y += lineHeight;
    wordCounterLines[linePointer] = 1;
    yAxis2Line[linePointer] = y;
    wordLineStartNumber[linePointer] = wordStartNumber;
    wordsOnPage[wordStartNumber].word = imgAlt;
    wordsOnPage[wordStartNumber].href = href;
    wordsOnPage[wordStartNumber].x = xx;
    ++wordStartNumber;
    ++wordNumber;
    ++linePointer;
    return true;
}

void Frame::setImageScaling(double s)
{
    imageScaling = s;
    scaleMatrix.reset();
    scaleMatrix.scale(s,s);
}

void Frame::setProgressBarVisible(bool v, bool p)
{
    progressBarVisible = v;
    progressBarPercentShow = p;
}

void Frame::setProgressBarHeight(int h)
{
    progressBarHeight = h;
}

void Frame::setProgressBarProps(QColor fg,QColor bg, QColor text, int percent,int page,int pages)
{
    progressBarFgColor = fg;
    progressBarBgColor = bg;
    progressBarTextColor = text;
    progressBarPercent = percent;
    progressBarPage = page;
    progressBarPages = pages;
}

bool Frame::inBarArea(int yy)
{
    if (!progressBarVisible) return false;
    if (yy < (height-progressBarHeight)) return false;
    return true;
}

double Frame::barPartForX(int xx)
{
    return double(xx)/double(width);
}
