/* pdaXrom virtual drive
 *
 * Copyright (C) 2003-2005, Alexander Zaprjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <windows.h>
#include "resource.h"

/*
 */
static void DialogInit(HWND hWnd) {
	
	for(char c = 'A'; c <= 'X'; c++) {
		char buf[128];
		sprintf(buf,"%c:",c);
		SendDlgItemMessage(hWnd,IDC_COMBO1,CB_ADDSTRING,0,(LPARAM)buf);
	}
	SendDlgItemMessage(hWnd,IDC_COMBO1,CB_SELECTSTRING,(WPARAM)-1,(LPARAM)"C:");

	SetDlgItemText(hWnd,IDC_EDIT1,"64");
	SetDlgItemText(hWnd,IDC_EDIT2,".pdaX86.dsk");
}

/*
 */
static INT_PTR CALLBACK DialogProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam) {
	switch(message) {
		case WM_INITDIALOG:
			DialogInit(hWnd);
			return TRUE;
		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDOK: {
						int disk = (int)SendDlgItemMessage(hWnd,IDC_COMBO1,CB_GETCURSEL,0,0);
						char buf[1024];
						GetDlgItemText(hWnd,IDC_EDIT1,buf,sizeof(buf));
						int size = atoi(buf);
						char name[1024];
						GetDlgItemText(hWnd,IDC_EDIT2,name,sizeof(name));
						sprintf(buf,"%c://%s",'A' + disk,name);
						FILE *file = fopen(buf,"wb");
						if(file == NULL) {
							char error[1024];
							sprintf(error,"can't create \"%s\" file");
							MessageBox(NULL,error,"error",MB_OK);
						} else {
							char *data = new char[1024 * 1024];
							memset(data,0,sizeof(char) * 1024 * 1024);
							for(int i = 0; i < size; i++) {
								if(fwrite(data,sizeof(char) * 1024,1024,file) != 1024) {
									MessageBox(NULL,"no such space","virtual drive",MB_OK);
								}
							}
							delete [] data;
							fclose(file);
							MessageBox(NULL,"creating complete","virtual drive",MB_OK);
						}
						EndDialog(hWnd,1);
						return TRUE;
					}
				case IDCANCEL:
					EndDialog(hWnd,0);
					return TRUE;
				default:
					return FALSE;
			}
		default:
			return FALSE;
	}
	return TRUE;
}

/*
 */
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow) {
	
	DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),NULL,DialogProc,NULL);
	
	return 0;
}