
; **************************************************************************************************
;
; Release File record list (recursively)
;
;	IN:	BHL pointer to file record and its brothers & childs to be deleted
;
.ReleaseFile		PUSH BC
				PUSH HL					; preserve srcfile pointer
				LD	A, srcfile_usedsrcfile
				CALL Read_pointer
				XOR	A
				CP	B
				JR	Z, rel_file			; if ( srcfile->usedsourcefile != NULL )
					CALL ReleaseOwnedFile	;	ReleaseOwnedFile(srcfile->usedsourcefile)

.rel_file			POP	HL
				POP	BC
				PUSH BC
				PUSH HL
				LD	A, srcfile_fname
				CALL Read_pointer
				CALL mfree				; free(srcfile->fname)	{release filename}
				POP	HL
				POP	BC
				CALL mfree				; free(srcfile)		{release file record}
				RET


; **************************************************************************************************
;
; Release File record owned by previous file record
;
; IN:	BHL = pointer to owned source file
;
.ReleaseOwnedFile	PUSH BC
				PUSH HL					; preserve ownedfile
				LD	A, usedfile_nextfile
				CALL Read_pointer			; {ownedfile->nextusedfile}
				XOR	A
				CP	B
				JR	Z, rel_ownedfile		; if ( ownedfile->nextusedfile != NULL )
					CALL ReleaseOwnedFile	;	ReleaseOwnedFile(ownedfile->nextusedfile)
										;	{release first other files called by this file}
.rel_ownedfile		POP	HL
				POP	BC					; {restore ownedfile}
				PUSH BC
				PUSH HL
				LD	A,usedfile_ownedfile
				CALL Read_pointer			; {ownedfile->ownedsourcefile}
				XOR	A
				CP	B
				JR	Z, rel_thisfile		; if ( ownedfile->ownedsourcefile != NULL )
					CALL ReleaseFile		;	ReleaseFile(ownedfile->ownedsourcefile)
										;	{ Release first file owned by this file}
.rel_thisfile		POP	HL
				POP	BC					; {restore ownedfile}
				CALL mfree				; free(ownedfile) {then release this owned file}
				RET

