
;	 ZZZZZZZZZZZZZZZZZZZZ	8888888888888		00000000000
;   ZZZZZZZZZZZZZZZZZZZZ	   88888888888888888    0000000000000
;			  ZZZZZ	   888		  888  0000		0000
;			ZZZZZ	   88888888888888888  0000		0000
;		   ZZZZZ			8888888888888	  0000		0000		 AAAAAA		 SSSSSSSSSSS	MMMM		 MMMM
;		 ZZZZZ		   88888888888888888  0000		0000		AAAAAAAA	    SSSS			MMMMMM   MMMMMM
;	    ZZZZZ			   8888		 8888  0000		0000	    AAAA	AAAA	    SSSSSSSSSSS	MMMMMMMMMMMMMMM
;	  ZZZZZ			   8888		 8888  0000		0000	   AAAAAAAAAAAA	 SSSSSSSSSSS	MMMM	MMMMM MMMM
;	ZZZZZZZZZZZZZZZZZZZZZ  88888888888888888    0000000000000	  AAAA	  AAAA		  SSSSS	MMMM		 MMMM
;  ZZZZZZZZZZZZZZZZZZZZZ		8888888888888		00000000000	 AAAA	   AAAA  SSSSSSSSSSS	MMMM		 MMMM
;
; Copyright (C) Gunther Strube, InterLogic 1995

	MODULE  Z80asm_time

if QDOS
	INCLUDE "defs_h"
	INCLUDE "symbol_def"
	INCLUDE "#stdio_def"
	INCLUDE "#time_def"
	INCLUDE "#syspar_def"
else
	INCLUDE "defs.h"
	INCLUDE "symbol.def"
	if MSDOS | UNIX
		INCLUDE "#stdio.def"
		INCLUDE "#time.def"
		INCLUDE "#syspar.def"
	endif
	if Z88
		INCLUDE ":*//stdio.def"
		INCLUDE ":*//time.def"
		INCLUDE ":*//syspar.def"
	endif
endif

	XDEF	Get_time,	Display_asmtime


; ***********************************************************************
;
.Get_time			LD	C,0
				LD	DE,0
				CALL_OZ(GN_Gmt)				; current	internal machine time
				LD	(asmtime),BC
				LD	(asmtime+2),A				; current	machine time
				RET							; in	ABC


; ***********************************************************************
;
.Display_asmtime	PUSH	AF
				LD	C,0
				LD	DE,0
				CALL_OZ(GN_Gmt)				; current	internal machine time
				LD	H,B
				LD	L,C
				LD	BC,(asmtime)
				SBC	HL,BC
				LD	D,A
				LD	A,(asmtime+2)				; elapsed	time	= current	- previous
				LD	E,A
				LD	A,D
				SBC	A,E
				LD	(asmtime),HL
				LD	(asmtime+2),A				; AHL = elapsed time in centiseconds

				LD	BC, NQ_OHN
				CALL_OZ(Os_Nq)					; get handle in IX for standard output

				LD	HL, select_win5
				CALL_OZ(Gn_sop)
				LD	HL, time1_msg
				CALL_OZ(Gn_Sop)				; "Compiled in '
				LD	DE,0						; write time to #5 window...
				LD	HL, asmtime				; pointer	to internal time
				LD	A, @00110111				; time display	format
				CALL_OZ(Gn_Ptm)				; display	elapsed time...
				LD	HL, time2_msg
				CALL_OZ(Gn_Sop)
				CALL_OZ(Gn_Nln)
				POP	AF
				RET
.time1_msg		DEFM	"Compiled in" & 0
.time2_msg		DEFM	"minutes"	& 0
.select_win5		DEFM	1 & "2H5"	&  0				; select window "5"
