
; ****************************************************************************
;
; Additional Z80 instructions:
;								r = A, B,	C, D, E, H, L
; IN	  r,(C)					    dd = BC, DE, HL, SP
; OUT  (C),r					    nn = 16 bit address
; SBC  HL,dd
; ADC  HL,dd
; LD	  (nn),dd
; NEG
; RETN, RETI
; IM	 0, IM  1, IM	2
; LD	I,A	;  LD R,A	 ;  LD A,I  ;	LD A,R
; RRD, RLD
;
; LDI, LDIR, LDD, LDDR
; CPI, CPIR, CPD, CPDR
; INI, INIR, IND, INDR
; OUTI, OTIR, OUTD,	OTDR
;
; ****************************************************************************


    MODULE ED_instructions


    XREF RestoreMainReg

    ; Routines	defined in 'Stdinstr_asm'
    XREF Opcode_201


if QDOS
	INCLUDE "Defs_h"		 ; assembly directives &	various constants
else
	if UNIX | MSDOS
		INCLUDE "defs.h"
	endif
	if Z88
		INCLUDE "defs.h"
	endif
endif


    XDEF EDcode_64,	EDcode_65, EDcode_66, EDcode_67, EDcode_68, EDcode_69,	EDcode_70, EDcode_71, EDcode_72, EDcode_73
    XDEF EDcode_74,	EDcode_75
    XDEF EDcode_77
    XDEF EDcode_79,	EDcode_80, EDcode_81, EDcode_82, EDcode_83
    XDEF EDcode_86,	EDcode_87, EDcode_88, EDcode_89, EDcode_90, EDcode_91
    XDEF EDcode_94,	EDcode_95, EDcode_96, EDcode_97, EDcode_98
    XDEF EDcode_103, EDcode_104, EDcode_105,	EDcode_106
    XDEF EDcode_111, EDcode_112
    XDEF EDcode_114, EDcode_115
    XDEF EDcode_120, EDcode_121, EDcode_122,	EDcode_123
    XDEF EDcode_160, EDcode_161, EDcode_162,	EDcode_163
    XDEF EDcode_168, EDcode_169, EDcode_170,	EDcode_171
    XDEF EDcode_176, EDcode_177, EDcode_178,	EDcode_179
    XDEF EDcode_184, EDcode_185, EDcode_186,	EDcode_187




; ****************************************************************************************
;
; ADC  HL,SP	   instruction			    1 byte
;
.EDcode_122	   EXX				    ;						   ** V0.28
			   PUSH IX			    ;						   ** V1.04
			   EX   (SP),HL		    ; preserve	PC, use HL as acc.	   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   ADC  HL,DE			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   EX   (SP),HL		    ; restore PC				   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   EXX				    ;						   ** V0.28
			   RET				    ;						   ** V1.04


; ****************************************************************************************
;
; SBC  HL,SP	   instruction			    1 byte
;
.EDcode_114	   EXX				    ;						   ** V0.28
			   PUSH IX			    ;						   ** V1.04
			   EX   (SP),HL		    ; preserve	PC, use HL as acc.	   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   SBC  HL,DE			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   EX   (SP),HL		    ; restore PC				   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   EXX				    ;						   ** V0.28
			   RET				    ;						   ** V1.04


; ****************************************************************************************
;
; SBC  HL,BC	   instruction			    1 byte
;
.EDcode_66	   LD   C,(IY + VP_C)	    ;						   ** V1.04
			   LD   B,(IY + VP_B)	    ;						   ** V1.04
			   JR   sbc_hl			    ;						   ** V1.04


; ****************************************************************************************
;
; SBC  HL,DE	   instruction			    1 byte
;
.EDcode_82	   LD   C,(IY + VP_E)	    ;						   ** V1.04
			   LD   B,(IY + VP_D)	    ;						   ** V1.04

.sbc_hl		   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ; use	HL as accumulator		   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   SBC  HL,BC			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   PUSH HL			    ;						   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   RET


; ****************************************************************************************
;
; ADC  HL,BC	   instruction			    1 byte
;
.EDcode_74	   LD   C,(IY + VP_C)	    ;						   ** V1.04
			   LD   B,(IY + VP_B)	    ;						   ** V1.04
			   JR   adc_hl			    ;						   ** V1.04


; ****************************************************************************************
;
; ADC  HL,DE	   instruction			    1 byte
;
.EDcode_90	   LD   C,(IY + VP_E)	    ;						   ** V1.04
			   LD   B,(IY + VP_D)	    ;						   ** V1.04

.adc_hl		   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ;						   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   ADC  HL,BC			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   PUSH HL			    ;						   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   RET


; ****************************************************************************************
;
; SBC  HL,HL	   instruction			    1 byte
;
.EDcode_98	   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ; use	HL as accumulator		   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   SBC  HL,HL			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   PUSH HL			    ;						   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   RET


; ****************************************************************************************
;
; ADC  HL,HL	   instruction			    1 byte
;
.EDcode_106	   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ; use	HL as accumulator		   ** V1.04
			   EX   AF,AF'               ; install virtual AF              ** V1.04
			   ADC  HL,HL			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V1.04
			   PUSH HL			    ;						   ** V1.04
			   POP  IX			    ; restore virtual HL			   ** V1.04
			   RET


; ****************************************************************************
;
; NEG
;
.EDcode_68	   EX   AF,AF'               ;                                 ** V0.23
			   NEG
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; OUT  (C),B
;
.EDcode_65	   LD   D,(IY + 1)
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),C
;
.EDcode_73	   LD   D,(IY + 0)
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),D
;
.EDcode_81	   LD   D,(IY+3)
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),E
;
.EDcode_89	   LD   D,(IY+2)
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),H
;
.EDcode_97	   LD   D,IXH			    ;					** V1.04
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),L
;
.EDcode_105	   LD   D,IXL			    ;					** V1.04
			   JR   Out_direction


; ****************************************************************************
;
; OUT  (C),A
;
.EDcode_121	   EX   AF,AF'               ;                                 ** V0.27d
			   LD   D,A			    ;						   ** V0.27d
			   EX   AF,AF'               ;                                 ** V0.27d

.Out_direction	   LD   B,(IY+1)
			   LD   C,(IY+0)		    ; port (C)
			   OUT  (C),D			    ; no flags	affected.
			   RET


; ****************************************************************************
;
.IN_r		   LD   B,(IY+1)		    ; get	A8 to A15
			   LD   C,(IY+0)		    ; port (C)
			   EX   AF,AF'               ;
			   IN   C,(C)			    ; receive byte into C
			   EX   AF,AF'               ;
			   RET


; ****************************************************************************
;
;	IN  B,(C)
;
.EDcode_64	   CALL IN_r
			   LD   (IY+1),C		    ; B
			   RET


; ****************************************************************************
;
;	IN  C,(C)
;
.EDcode_72	   CALL IN_r
			   LD   (IY+0),C		    ; C
			   RET


; ****************************************************************************
;
;	IN  D,(C)
;
.EDcode_80	   CALL IN_r
			   LD   (IY+3),C		    ; D
			   RET


; ****************************************************************************
;
;	IN  E,(C)
;
.EDcode_88	   CALL IN_r
			   LD   (IY+2),C		    ; E
			   RET


; ****************************************************************************
;
;	IN  H,(C)
;
.EDcode_96	   CALL IN_r
			   LD   IXH,C			    ; ** V1.04
			   RET


; ****************************************************************************
;
;	IN  L,(C)
;
.EDcode_104	   CALL IN_r
			   LD   IXL,C			    ; ** V1.04
			   RET


; ****************************************************************************
;
;	IN  F,(C)
;
.EDcode_112	   CALL IN_r			    ; F
			   RET


; ****************************************************************************
;
;	IN  A,(C)
;
.EDcode_120	   CALL IN_r
			   EX   AF,AF'
			   LD   A,C
			   EX   AF,AF'
			   RET



; ****************************************************************************
;
.Get_address_indd EXX				    ; swap to alternate registers
			   LD   C,(HL)			    ; get	low byte of address
			   INC  HL
			   LD   B,(HL)			    ; get	high	byte	of address
			   INC  HL
			   PUSH BC
			   EXX
			   POP  HL
			   LD   E,(HL)
			   INC  HL
			   LD   D,(HL)			    ; DE = (nn), HL	= nn+1
			   RET



; ****************************************************************************
;
; LD	 BC,(nn)
;
.EDcode_75	   CALL Get_address_indd
			   LD   (IY + VP_C),E
			   LD   (IY + VP_B),D		    ; store (nn) into BC
			   RET


; ****************************************************************************
;
; LD	 DE,(nn)
;
.EDcode_91	   CALL Get_address_indd
			   LD   (IY + VP_E),E
			   LD   (IY + VP_D),D		    ; store (nn) into DE
			   RET


; ****************************************************************************
;
; LD	  SP,(nn)
;
.EDcode_123	   CALL Get_address_indd	    ; get	(nn)
			   POP  BC			    ; get	return address			   ** V0.16
			   EX   DE,HL
			   LD   SP,HL			    ; set	new SP
			   PUSH HL
			   EXX
			   POP  DE			    ; LD	SP,(nn)
			   EXX
			   PUSH BC
			   RET				    ; fetch next Z80 instruction


; ****************************************************************************
;
.Get_nn		   EXX				    ; swap to alternate registers
			   LD   C,(HL)			    ; get	low byte of address
			   INC  HL
			   LD   B,(HL)			    ; get	high	byte	of address
			   INC  HL
			   PUSH BC
			   EXX
			   POP  HL			    ; nn
			   RET


; ****************************************************************************
;
; LD	 (nn),BC
;
.EDcode_67	   CALL Get_nn
			   LD   C,(IY + VP_C)
			   LD   B,(IY + VP_B)
			   LD   (HL),C
			   INC  HL
			   LD   (HL),B
			   RET


; ****************************************************************************
;
; LD	 (nn),DE
;
.EDcode_83	   CALL Get_nn
			   LD   C,(IY + VP_E)
			   LD   B,(IY + VP_D)
			   LD   (HL),C
			   INC  HL
			   LD   (HL),B
			   RET



; ****************************************************************************
;
; LD	  (nn),SP
;
.EDcode_115	   EXX
			   LD   B,D
			   LD   C,E			    ; virtual SP in	BC
			   LD   E,(HL)
			   INC  HL
			   LD   D,(HL)			    ; {DE = nn}
			   INC  HL			    ; PC += 2
			   EX   DE,HL			    ; {HL = nn, DE = PC}
			   LD   (HL),C
			   INC  HL
			   LD   (HL),B			    ; LD	(nn),SP
			   EX   DE,HL			    ; virtual PC restored
			   LD   D,B
			   LD   E,C			    ; virtual SP restored
			   EXX
			   RET


; ****************************************************************************
;
; IM	 0
;
.EDcode_70	   RET


; ****************************************************************************
;
; IM	 1
;
.EDcode_86	   RET


; ****************************************************************************
;
; IM	 2
;
.EDcode_94	   RET


; ****************************************************************************
;
; LD	  I,A
;
.EDcode_71	   RET


; ****************************************************************************
;
; LD	  R,A
;
.EDcode_79	   EX   AF,AF'               ;                                 ** V0.23
			   LD   R,A
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; LD	  A,I
;
.EDcode_87	   EX   AF,AF'               ;                                 ** V0.23
			   LD   A,I
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; LD	  A,R
;
.EDcode_95	   EX   AF,AF'               ;                                 ** V0.23
			   LD   A,R
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; RRD
;
.EDcode_103	   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V0.23
			   RRD
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; RLD
;
.EDcode_111	   PUSH IX			    ;						   ** V1.04
			   POP  HL			    ;						   ** V1.04
			   EX   AF,AF'               ;                                 ** V0.23
			   RLD
			   EX   AF,AF'               ;                                 ** V0.23
			   RET


; ****************************************************************************
;
; LDI
;
.EDcode_160	   CALL FetchBlockRegs
			   LDI
			   JP   SaveBlockRegs


; ****************************************************************************
;
; LDIR
;
.EDcode_176	   CALL FetchBlockRegs
			   LDIR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; LDD
;
.EDcode_168	   CALL FetchBlockRegs
			   LDD
			   JP   SaveBlockRegs


; ****************************************************************************
;
; LDDR
;
.EDcode_184	   CALL FetchBlockRegs
			   LDDR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; CPI
;
.EDcode_161	   CALL FetchBlockRegs
			   CPI
			   JP   SaveBlockRegs


; ****************************************************************************
;
; CPIR
;
.EDcode_177	   CALL FetchBlockRegs
			   CPIR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; CPD
;
.EDcode_169	   CALL FetchBlockRegs
			   CPD
			   JP   SaveBlockRegs


; ****************************************************************************
;
; CPDR
;
.EDcode_185	   CALL FetchBlockRegs
			   CPDR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; INI
;
.EDcode_162	   CALL FetchBlockRegs
			   INI
			   JP   SaveBlockRegs


; ****************************************************************************
;
; INIR
;
.EDcode_178	   CALL FetchBlockRegs
			   INIR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; IND
;
.EDcode_170	   CALL FetchBlockRegs
			   IND
			   JP   SaveBlockRegs


; ****************************************************************************
;
; INDR
;
.EDcode_186	   CALL FetchBlockRegs
			   INDR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; OUTI
;
.EDcode_163	   CALL FetchBlockRegs
			   OUTI
			   JP   SaveBlockRegs


; ****************************************************************************
;
; OTIR
;
.EDcode_179	   CALL FetchBlockRegs
			   OTIR
			   JP   SaveBlockRegs


; ****************************************************************************
;
; OUTD
;
.EDcode_171	   CALL FetchBlockRegs
			   OUTD
			   JP   SaveBlockRegs


; ****************************************************************************
;
; OTDR
;
.EDcode_187	   CALL FetchBlockRegs
			   OTDR
			   JP   SaveBlockRegs


.FetchBlockRegs   EXX
			   PUSH HL
			   EXX
			   CALL RestoreMainReg
			   EXX
			   POP  HL
			   EXX
			   EX   AF,AF'
			   RET

.SaveBlockRegs	   EX   AF,AF'
			   PUSH HL
			   POP  IX			    ;	 HL
			   LD   (IY+0),C
			   LD   (IY+1),B		    ;	 BC
			   LD   (IY+2),E
			   LD   (IY+3),D		    ;	 DE
			   RET
