
    MODULE Serialport_IO

; ******************************************************************************
;
; $Header: /Z88/Applications/EazyLink/Byteio.asm 1     31-05-98 10:21 Gbs $
;
; $History: Byteio.asm $
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 31-05-98   Time: 10:21
; Created in $/Z88/Applications/EazyLink
; Release 5.0.3:
; Popdown organised as "ugly popdown" with 1.5K contiguous RAM from $2000
; onwards. OS_TIN now used as keyboard interface. 
; New Server command implemented: ESC "M" - get free memory of RAM Card.
; 

    XREF ErrHandler
    XREF System_Error
    XREF Write_Message, Message2, ESC_B, ESC_ESC

    XDEF Check_synch, Send_Synch, Check_timeout, SendString, SendString_ackn
    XDEF Send_ESC_byte, Send_ESC_byte_ackn
    XDEF GetByte, GetByte_ackn, PutByte, PutByte_ackn, TranslateByte

if QDOS
	INCLUDE "Defs_asm"
	INCLUDE "#fileio_def"
	INCLUDE "#screen_def"
	INCLUDE "#error_def"
endif
if MSDOS | UNIX
	INCLUDE "defs.asm"
	INCLUDE "#fileio.def"
	INCLUDE "#screen.def"
	INCLUDE "#error.def"
endif
if Z88
	INCLUDE "defs.asm"
	INCLUDE ":*//fileio.def"
	INCLUDE ":*//screen.def"
	INCLUDE ":*//error.def"
endif

; ***********************************************************************
; H = <startsynch>, L = <end_synch> ID
;
.Check_synch
.Synch_loop	   CALL Getbyte				   ; byte in A.
			   RET  C 					   ; system error
			   RET  Z 					   ; timeout...
			   CP   L 					   ; check end synch byte
			   JR   Z,synch_OK				   ; eof synch...
			   CP   H 					   ; receive next synch byte?
			   JR   Z, Synch_loop			   ; synch byte, continue...
			   JR   bad_synch				   ; illegal <synch> ID received.
.synch_OK 	   SET  0,A
			   OR   A 					   ; Z = 0, indicate succes,
			   RET						   ; A non-zero value...
.bad_synch	   XOR  A 					   ; Zero = 1
			   RET


; ***********************************************************************
.Send_synch	   LD   B,2
.Send_synch_loop  LD   A,H					   ; start, body of synch...
			   CALL Putbyte				   ; B = length of synch...
			   RET  C 					   ; return if ESC pressed
			   RET  Z 					   ; return if timeout
			   DJNZ,Send_synch_loop
			   LD   A,L					   ; end of synch...
			   CALL Putbyte
			   RET


; ***********************************************************************
.Getbyte		   PUSH BC
			   LD   BC,3000				   ; 30 sek. timeout
			   LD   IX,(serport_handle)
			   CALL_OZ (Os_Gbt) 			   ; get a byte from serial port
			   CALL C,Check_timeout
			   JR   C,Getbyte_error
			   JR   Z,Getbyte_error
			   PUSH HL
			   LD   HL,TraTableOut
			   CALL TranslateByte			   ; byte in A
			   LD   B,A
			   SET  0,A					   ; reset Z flag, indicate no timeout
			   OR   A
			   LD   A,B					   ; A = byte received & translated
			   POP  HL
.Getbyte_error    POP  BC
			   RET




; ***********************************************************************
; Get byte and acknowledge...
;
.Getbyte_ackn	   PUSH BC
			   LD   BC,3000				   ; 30 sek. timeout
			   LD   IX,(serport_handle)
			   CALL_OZ (Os_Gbt) 			   ; get a byte from serial port
			   CALL C,Check_timeout			   ; byte in A
			   JR   C,end_GetbyteAckn
			   JR   Z,end_GetbyteAckn
			   PUSH DE
			   LD   D,A
			   LD   A,0					   ; acknowledge byte...
			   LD   BC,50
			   CALL_OZ (Os_Pbt)
			   LD   A,D
			   POP  DE
			   CALL C,Check_timeout
			   JR   C,end_GetbyteAckn		   ; system error, e.g. ESC pressed...
			   JR   Z,end_GetbyteAckn
			   PUSH HL
			   LD   HL,TraTableOut
			   CALL TranslateByte
			   LD   B,A
			   SET  0,A					   ; reset Z flag, indicate no timeout
			   OR   A
			   LD   A,B					   ; A = byte received & translated
			   POP  HL
.end_GetbyteAckn  POP  BC
			   RET


; ***********************************************************************
.Putbyte		   PUSH HL					   ; save counter
			   LD   HL,TraTableIn
			   CALL TranslateByte			   ; A contains translated byte
			   LD   IX,(serport_handle)
			   CALL_OZ (Os_Pb)				   ; send byte to serial port
			   CALL C,Check_timeout			   ; byte in A.
			   JR   C,Putbyte_error
			   JR   Z,Putbyte_error
			   SET  0,A
			   OR   A
.Putbyte_error    POP  HL
			   RET


; ***********************************************************************
.Putbyte_ackn	   PUSH BC
			   PUSH HL					   ; save counter
			   LD   HL,TraTableIn
			   CALL TranslateByte			   ; A contains translated byte
			   LD   BC,1000				   ; 10 sek. timeout
			   LD   IX, (Serport_handle)
			   CALL_OZ (Os_Pbt) 			   ; send byte to serial port
			   CALL C,Check_timeout
			   JR   C,error_Putbyte_ackn		   ; byte in A.
			   JR   Z,error_Putbyte_ackn
			   LD   BC,3000				   ; 30 sek. timeout.
			   CALL_OZ (Os_Gbt)
			   CALL C,Check_timeout
			   JR   C,error_Putbyte_ackn
			   JR   Z,error_Putbyte_ackn
			   SET  0,A					   ; reset Z flag, indicate no timeout
			   OR   A
.error_Putbyte_ackn
			   POP  HL
			   POP  BC
			   RET


; ***********************************************************************
.Check_timeout    CALL ErrHandler
			   CP   RC_Time				   ; timeout?
			   JR   Z,timeout_flag
			   CALL System_error
			   SCF
			   RET						   ; other errors.
.timeout_flag	   LD   HL,message2 			   ; 'Waiting...'
			   CALL Write_message
			   XOR  A 					   ; no system error, only timeout
			   RET						   ; Carry = 0, Zero = 1


; ***********************************************************************
; byte in A.
;
.TranslateByte    PUSH BC					   ; HL >> Translation Table
			   EX   AF,AF'                        ; save byte to/from serial port
			   LD   A,(tra_flag)
			   CP   $FF
			   JR   Z,tra_byte
			   EX   AF,AF'
			   POP  BC
			   RET
.tra_byte 	   EX   AF,AF'
			   LD   B,0
			   LD   C,A
			   ADD  HL,BC					   ; Offset calculated
			   LD   A,(HL) 				   ; Translated byte...
			   POP  BC
			   RET


; ***********************************************************************
; Send sequense of bytes, untranslated.
;
.SendString_ackn  PUSH BC					   ; HL >> string, 0 terminated...
			   PUSH AF
.SendLoop_ackn    LD   A,(HL)
			   CP   0 					   ; check for terminator
			   JR   Z,end_SendString_ackn
			   CALL Putbyte_ackn			   ; put byte to serial port
			   JR   C,err_SendString_ackn 	   ; error - stop transmit...
			   JR   Z,err_SendString_ackn
			   INC  HL					   ; byte sent , continue
			   JR   SendLoop_ackn
.end_SendString_ackn
			   POP  AF
			   LD   B,A
			   SET  0,A
			   OR   A 					   ; reset Z flag.
			   LD   A,B					   ; restore original contents of A
			   POP  BC					   ; restore original contents of BC
			   RET
.err_SendString_ackn
			   EX   AF,AF'                        ; save contents of F register
			   POP  AF
			   LD   B,A
			   EX   AF,AF'                        ; restore F register
			   LD   A,B					   ; restore original contents of A
			   POP  BC					   ; restore original contents of BC
			   RET


; ***********************************************************************
; Send sequense of bytes
;
.SendString	   PUSH BC					   ; HL >> string, 0 terminated...
			   PUSH AF
.SendLoop 	   LD   A,(HL) 				   ; Carry if transmit error...
			   CP   0 					   ; check for terminator
			   JR   Z,end_SendString
			   CALL Putbyte				   ; put byte to serial port
			   JR   C,err_SendString 		   ; error - stop transmit...
			   JR   Z,err_SendString
			   INC  HL					   ; byte sent , continue
			   JR   SendLoop
.end_SendString   POP  AF
			   LD   B,A
			   SET  0,A
			   OR   A 					   ; reset Z flag.
			   LD   A,B					   ; restore original contents of A
			   POP  BC					   ; restore original contents of BC
			   RET
.err_SendString   EX   AF,AF'                        ; save contents of F register
			   POP  AF
			   LD   B,A
			   EX   AF,AF'                        ; restore F register
			   LD   A,B					   ; restore original contents of A
			   POP  BC					   ; restore original contents of BC
			   RET


; ***********************************************************************
.Send_ESC_byte    PUSH HL
			   LD   HL,ESC_ESC
			   CALL SendString
			   POP  HL
			   RET


; ***********************************************************************
.Send_ESC_byte_ackn
			   PUSH HL
			   LD   HL,ESC_B
			   CALL SendString_ackn
			   POP  HL
			   RET
