#ifndef PVR350DEVICE_H
#define PVR350DEVICE_H

#include <vdr/osdbase.h>



#if VDRVERSNUM >= 10307

class cPvr350Osd : public cOsd {
private:
    int  fd;
    unsigned char *osd;

public:
    cPvr350Osd(int Left, int Top,int fbfd, unsigned char *osdbuf);
    ~cPvr350Osd();
    eOsdError CanHandleAreas(const tArea *Areas, int NumAreas);
    void Flush(void);

private:
    void Hide(cBitmap *Bitmap);
};

class cPvr350OsdProvider : public cOsdProvider {
private:
    unsigned char *osdBuf;
    int            osdfd; 
public:
    cPvr350OsdProvider(int fd, unsigned char *buf);
    virtual cOsd *CreateOsd(int Left, int Top);
};

#else


class cPvr350Osd : public cOsdBase {
private:
    int  fd;
    unsigned char *osd;
    int  xoff;
    int  yoff;
    bool m_ShownWindows[MAXNUMWINDOWS];

public:
    cPvr350Osd(int fd, unsigned char *buf,int X, int Y);
    ~cPvr350Osd();
    virtual bool OpenWindow(cWindow *Window);
    virtual void CommitWindow(cWindow *Window);
    virtual void ShowWindow(cWindow *Window);
    virtual void HideWindow(cWindow *Window, bool Hide);
    virtual void CloseWindow(cWindow *Window);
    virtual void MoveWindow(cWindow *Window, int x, int y);
};
#endif

#endif
