
#ifndef PVR350_DEVICE_H
#define PVR350_DEVICE_H

#include <vdr/device.h>
#include <vdr/thread.h>
extern "C" {
#include <avcodec.h>
}
#include "pvr350osd.h"
#include "writer.h"

class cPvr350Device: public cDevice {
private:
    int       fd_out;
    int       fbfd;
    int       mute;
    int       storedglobalalpha;
    unsigned long initglobalalpha;
    int       osdbufsize;
    unsigned char *osdbuffer;
    unsigned char *osdbuf_aligned;
    int       stride;
    int       output_mode;


    ePlayMode m_PlayMode;  
    cSpuDecoder        *spuDecoder;

    cRingBufferLinear *m_RingBuffer;

    /* Needed for the demuxing */
    int  state, payload, streamtype;
    unsigned char header[6];     
    unsigned int syncword;

    int	save;


    /* Current sizes of the display */
    unsigned int   current_horiz;
    unsigned int   current_vertical;
    int		   current_afd;

    cPvr350Writer  *writer;

    void SetVidInfo(const uchar *mbuf, int count);

public:
    cPvr350Device(void);
    ~cPvr350Device();
    void MakePrimaryDevice(bool On);
    int ProvidesCa(int Ca);
    virtual bool HasDecoder(void) const;

    virtual bool CanReplay(void) const;
    virtual bool SetPlayMode(ePlayMode PlayMode);


    //   virtual int64_t GetSTC(void);

    virtual void TrickSpeed(int Speed);
    virtual void Clear(void);
    virtual void Play(void);
    virtual void Freeze(void);
    virtual void Mute(void);
    virtual void StillPicture(const uchar *Data, int Length);
    virtual int PlayVideo(const uchar *Data, int Length);
    virtual void SetVideoFormat(bool VideoFormat16_9);
    virtual void SetVolumeDevice(int Volume);
#if VDRVERSNUM < 10307
    virtual cOsdBase *NewOsd(int x, int y);
#endif


    virtual bool Poll(cPoller &Poller, int TimeoutMs = 0);
    virtual cSpuDecoder *GetSpuDecoder(void);
    virtual int64_t GetSTC(void);


};

#endif
