/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: url_udp.c,v 1.5 2004/05/07 19:27:25 dom Exp $
 *   $Date: 2004/05/07 19:27:25 $
 *
 *
 *   Some nasty stuff to hack udp - maybe of use for picking videolan streams
 */

#include "libmvp_internal.h"

static void           *udp_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr );
static void            udp_close(void *ptr);
static off_t           udp_seek(void *ptr, off_t offset, int whence);
static int             udp_read(void *ptr, unsigned char *buf, size_t buflen);
static int             udp_info(void *ptr, int cmd, void *arg);

typedef struct {
    int            fd;
    char          *name;
} udp_t;

static fops_t          udp_fops = {
    NULL,
    udp_open,
    udp_close,
    udp_seek,
    udp_read,
    udp_info
};

void urludp_init()
{
    urlhandler_add("udp://",&udp_fops);
}


static void *udp_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr )
{
    udp_t   *udp;

    udp = (udp_t *)calloc(1,sizeof(*udp));

    udp->fd = udp_listen(NULL,1234);
    udp->name = strdup(name);

    fcntl(udp->fd,F_SETFL,O_NONBLOCK);
    *type = MEDIA_MPEG;
    

    return udp;
}

static void udp_close(void *ptr)
{
    udp_t   *udp = (udp_t *)ptr;
    close(udp->fd);
    if ( udp->name ) {
        free(udp->name);
        udp->name = NULL;
    }
    udp->fd = -1;
    free(udp);
}

static off_t udp_seek(void *ptr, off_t off, int whence)
{
    return (off_t) -1;
}

static int udp_read(void *ptr, unsigned char *buf, size_t buflen)
{
    udp_t  *udp = (udp_t *)ptr;

    return read(udp->fd,buf,buflen);
}

static int udp_info(void *ptr, int cmd, void *dest)
{
    udp_t      *udp = (udp_t*)ptr;

    switch ( cmd ) {
    case URLFILE_SIZE:
        *(off_t *)dest = 0;
        break;
    case URLFILE_NAME:
        *(char **)dest = udp->name;
        break;
    default:
        return -1;
    }
  
    return 0;
}
