

#include <vdr/menuitems.h>

#include "setup.h"
#include "server.h"
#include "i18n.h"



mvpinit_t  MediamvpSetup = MVPINIT_INITIALISER;

int       c_screen_width = 720;
int       c_screen_depth = 576;
int       c_gui_width    = 640;
int       c_gui_depth    = 480;
int       c_screensaver  = 0;
/* Not sure of the best way to set the font up - vdr edits into a buffer */
char     *c_font_file    = NULL;





cMediamvpMenuSetupPage::cMediamvpMenuSetupPage(void) 
{

    Add(new cMenuEditIntItem(tr("MediaMVP GUI Port"), &MediamvpSetup.gui_port,0,65535));
    Add(new cMenuEditIntItem(tr("MediaMVP Stream Port"), &MediamvpSetup.stream_port,0,65535));
    Add(new cMenuEditIntItem(tr("MediaMVP dongle.bin version"), &MediamvpSetup.dongle_version,21303,65535));
    Add(new cMenuEditIntItem(tr("Total Screen Width"), &c_screen_width,480,720));
    Add(new cMenuEditIntItem(tr("Total Screen Depth"), &c_screen_depth,400,576));
    Add(new cMenuEditIntItem(tr("GUI Screen Width"), &c_gui_width,480,720));
    Add(new cMenuEditIntItem(tr("GUI Screen Depth"), &c_gui_depth,400,576));
    Add(new cMenuEditStraItem(tr("Debug Level"), &MediamvpSetup.debug_level,4,debug_levels));
    Add(new cMenuEditBoolItem(tr("Screensaver Enabled"), &c_screensaver));
    SetCurrent(Get(0));
}

cMediamvpMenuSetupPage::~cMediamvpMenuSetupPage()
{
}


void cMediamvpMenuSetupPage::Store(void)
{

    SetupStore("gui_port",MediamvpSetup.gui_port);
    SetupStore("stream_port",MediamvpSetup.stream_port);
    SetupStore("dongle_version",MediamvpSetup.dongle_version);
    SetupStore("screen_width",c_screen_width);
    SetupStore("screen_depth",c_screen_depth);
    SetupStore("gui_width",c_gui_width);
    SetupStore("gui_depth",c_gui_depth);   
    SetupStore("debug_level",MediamvpSetup.debug_level);  
    SetupStore("screensaver",c_screensaver);    
}


bool ConfigParse(const char *Name, const char *Value)
{
    /* Messed up config...ahem */
    if ( strcmp(Name,"stream_port") == 0 || strcmp(Name,"streamport") == 0 ) {
        MediamvpSetup.stream_port = atoi(Value);
    } else if ( strcmp(Name,"gui_port") == 0 ) {
        MediamvpSetup.gui_port = atoi(Value);
    } else if ( strcmp(Name,"dongle_version") == 0 ) {
        MediamvpSetup.dongle_version = atoi(Value);
    } else if ( strcmp(Name,"screen_width") == 0 ) {
        c_screen_width = atoi(Value);
    } else if ( strcmp(Name,"screen_depth") == 0 ) {
        c_screen_depth = atoi(Value);
    } else if ( strcmp(Name,"gui_width") == 0 ) {
        c_gui_width = atoi(Value);
    } else if ( strcmp(Name,"gui_depth") == 0 ) {
        c_gui_depth = atoi(Value);
    } else if ( strcmp(Name,"debug_level") == 0 ) {
        MediamvpSetup.debug_level = atoi(Value);
    } else if ( strcmp(Name,"screensaver") == 0 ) {
        c_screensaver = atoi(Value);
    } else {
        return false;
    }

    return true;
}
