/*
 *  MediaMVP Output Device for VDR
 *
 *  $Id: mvposd.h,v 1.2 2004/05/22 16:41:27 dom Exp $ 
 *  $Date: 2004/05/22 16:41:27 $
 *
 *  This does the OSD
 *
 */

#ifndef MVPOSD_H
#define MVPOSD_H

#include <vdr/osdbase.h>
#include "libmvp.h"


class cMvpProgram;

#if VDRVERSNUM >= 10307

class cMvpOsd : public cOsd {
private:   
    surface_t *sfc;
    cMvpProgram *program;


public:
    cMvpOsd(int Left, int Top, surface_t *surface, cMvpProgram *prog);
    ~cMvpOsd();
    eOsdError CanHandleAreas(const tArea *Areas, int NumAreas);
    void Flush(void);

private:
    void Hide(cBitmap *Bitmap);
};

class cMvpOsdProvider : public cOsdProvider {
private:
    surface_t *sfc;
    cMvpProgram *program;
public:
    cMvpOsdProvider(surface_t *surface, cMvpProgram *prog);
    virtual cOsd *CreateOsd(int Left, int Top);
};

#else
class cMvpOsd : public cOsdBase {
private:   
    bool       m_ShownWindows[MAXNUMWINDOWS];
    surface_t *sfc;
    cMvpProgram *program;

public:
    cMvpOsd(cMvpProgram *prog,surface_t *surface,int X, int Y);
    ~cMvpOsd();
    virtual bool OpenWindow(cWindow *Window);
    virtual void CommitWindow(cWindow *Window);
    virtual void ShowWindow(cWindow *Window);
    virtual void HideWindow(cWindow *Window, bool Hide);
    virtual void CloseWindow(cWindow *Window);
    virtual void MoveWindow(cWindow *Window, int x, int y);
};
#endif

#endif // MVPOSD_H
