/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: menuapp.h,v 1.6 2004/04/22 18:36:24 dom Exp $
 *   $Date: 2004/04/22 18:36:24 $
 *
 *
 *   Details of the menuapp
 */



#ifndef MENUAPP_H
#define MENUAPP_H

#include "program.h"


#ifdef VDR_PLUGIN
#include <vdr/plugin.h>
#define VDRURL "vdr://"
#define VDRRECURL "vdrrec://"
#endif

typedef struct _menuapp menuapp_t;
typedef struct _menu    menu_t;


#ifndef VDR_PLUGIN
#define tr(a)   a
#endif


#define   MENU_NUMBERS   1

#define   MENU_NONE      0
#define   MENU_INT       1



#define MAX_DIALCODE_LEN	8

extern void            menuapp_config();
extern void            menuapp_init();
extern menuapp_t      *new_menuapp(dongle_t *dongle, render_t *render, program_t *app);
extern void            delete_menuapp(menuapp_t *app);

extern menu_t         *new_menu(dongle_t *dongle, render_t *render, program_t *app,menu_t *parent,void *param, int flags);
extern void            delete_menu_tree(menu_t *menu);
extern void            delete_menu(menu_t *menu);
extern void            menu_set_title(menu_t *menu, const char *text);
extern void            menu_add_option(menu_t *menu, const char *name, 
                                       int (callback_func)(menu_t *menu,void *param, int sel),
                                       int type, int num_options, char const **options,void *value_ptr);

extern void            menu_add(menu_t *menu,const char *name, int (*callback_func)(menu_t *menu,void *param, int sel));
extern void            menu_display_article(menu_t *menu);
extern void            menu_display(menu_t *menu);
extern void            menu_set_param_clearup(menu_t *menu, void (*clearup)(void *ptr));
extern void            menu_set_colour_actions(menu_t *menu,
                                               const char   *red,
                                               const char   *green,
                                               const char   *yellow,
                                               const char   *blue,
                                               int   (*func)(menu_t *menu,void *param, int key, int sel));




extern void            menu_set_flags(menu_t *menu, int flags);
extern int             menu_get_flags(menu_t *menu);
extern void            menu_toggle_predictive(menu_t *menu);

extern void            menu_init_dialcode(menu_t *menu, int length);
extern void            menu_free_dialcode(menu_t *menu);
extern void            menu_set_dialcode_callback(menu_t *menu, int (*dialcode_func)(menu_t *menu, void *param, int key, int sel));

extern char           *menu_get_dialcode(menu_t *menu);
extern void            menu_set_dialcode(menu_t *menu, char *code);
extern int             menu_get_dialcode_selection(menu_t *menu);
extern void            menu_set_dialcode_selection(menu_t *menu, int sel);
extern menu_t         *menu_parent(menu_t *menu);
extern menu_t         *menu_child(menu_t *menu);


#endif
