/*
 *  MediaMVP Output Device for VDR
 *
 *  $Id: mvpprog.h,v 1.1 2004/04/25 16:35:46 dom Exp $ 
 *  $Date: 2004/04/25 16:35:46 $
 *
 *  The MVP application
 *
 */

#ifndef MVPAPP_H
#define MVPAPP_H

#include <vdr/thread.h>

#include "libmvp.h"
#include "mvpremote.h"
#include "mvposd.h"
#include "mvplive.h"

typedef enum { MEVT_STOP, 
               MEVT_PLAY, 
               MEVT_PAUSE,
               MEVT_MUTE,
               MEVT_MENU_ON,
               MEVT_MENU_OFF,
               MEVT_UPDATE,
} mvpevent_t;

class cMvpProgram: public cThread {

private:
    cRingBufferLinear *ringy;
    bool          Running;
    cMvpRemote    remote;
    surface_t    *surface;
    int           pipes[2];      /* Used to send events */
    ePlayMode     playmode;
    ePlayMode     lastmode;

    cMvpLiveURL  *url;

public:
    dongle_t     *dongle;        /* Our registered dongle */

    struct event  event;         /* Event for EventProcess_cb */

    cMvpProgram(void);
    ~cMvpProgram();

    void Connect(dongle_t *dgl);
    void Disconnect();

    void Remote(int keycode);

    uint8_t  *Surface(int *size);

    bool SetPlayMode(ePlayMode PlayMode);

    int PlayVideo(const uchar *Data, int Length);


    /* cMvpWrap calls Program->NewOsd() i.e. this.. */
    virtual cOsdBase *NewOsd(int x, int y);



    void SendEvent(mvpevent_t event);

    /* Thread that starts up the event loop */
    virtual void Action(void);

    bool Poll(cPoller &Poller, int TimeoutMs = 0);


};



#endif // MVPAPP_H
