/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: url_udp.c,v 1.1 2004/01/16 23:06:25 dom Exp $
 *   $Date: 2004/01/16 23:06:25 $
 *
 *
 *   Some nasty stuff to hack udp - maybe of use for picking videolan streams
 */

#include "libmvp_internal.h"

static void           *udp_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr );
static void            udp_close(void *ptr);
static off_t           udp_seek(void *ptr, off_t offset, int whence);
static int             udp_read(void *ptr, unsigned char *buf, size_t buflen);

typedef struct { 
    int            fd;
} udp_t;

static fops_t          udp_fops = { 
    NULL,
    udp_open,
    udp_close,
    udp_seek,
    udp_read
};
          
void urludp_init()
{
    urlhandler_add("udp://",&udp_fops);
}


static void *udp_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr )
{
    udp_t   *udp;

    udp = calloc(1,sizeof(*udp));

    udp->fd = udp_listen(NULL,1234);

    fcntl(udp->fd,F_SETFL,O_NONBLOCK);
    *type = MEDIA_MPEG;


    return udp;
}
      
static void udp_close(void *ptr)
{
    udp_t   *udp = ptr;
    close(udp->fd);
    udp->fd = -1;
    free(udp);
}

static off_t udp_seek(void *ptr, off_t off, int whence)
{
    return (off_t) -1;
}

static int udp_read(void *ptr, unsigned char *buf, size_t buflen)
{
    udp_t  *udp = ptr;

    return read(udp->fd,buf,buflen);
}

