/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: url.c,v 1.14 2004/01/16 23:06:24 dom Exp $
 *   $Date: 2004/01/16 23:06:24 $
 *
 *
 *   Deals with handling URLs and passing the buck around the place, not
 *   entirely certain where stream detection should be, but place it here
 *   for the moment...
 */

#include "libmvp_internal.h"



static fops_t         *fops_list = NULL;
static int             fops_num  = 0;






int urlhandler_init()
{   
    urlfile_init();
    urlhttp_init();   

    return 0;
}

static fops_t *urlhandler_find(char *name)
{
    fops_t      *fops;
    int          i;

    for ( i = 0; i < fops_num; i++ ) {
        fops = &fops_list[i];
        if ( strncmp(fops->prefix,name,strlen(fops->prefix)) == 0 ) {
            return fops;
        }
    }
    return NULL;
}


void urlhandler_add(char *prefix, fops_t *fops)                    
{
    fops_t  *ofops = urlhandler_find(prefix);
    int      i;


    if ( ofops == NULL ) {
        i = fops_num++;
        fops_list = realloc(fops_list,fops_num * sizeof(fops_t));
        ofops = &fops_list[i];
        ofops->prefix = strdup(prefix);
    } 

    ofops->open = fops->open;
    ofops->close = fops->close;
    ofops->seek = fops->seek;
    ofops->read = fops->read;

}

void *urlhandler_open(char *name, int *type, fops_t **fops_ptr, readready_cb cb,void *cb_ptr)
{
    fops_t  *fops = urlhandler_find(name);

    if ( fops && fops->open ) {
        /* Set the file operations */
        *fops_ptr = fops;
        return (fops->open)(name,type,fops_ptr,cb,cb_ptr);       
    }
    return NULL;
}




