/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: libmvp_internal.h,v 1.8 2004/01/16 23:06:24 dom Exp $
 *   $Date: 2004/01/16 23:06:24 $
 *
 *
 *   Internal definitions
 */


#ifndef MVP_INTERNAL_H
#define MVP_INTERNAL_H

#include "libmvp.h"
#include "msgs.h"

/* Some handy (de-) serialisation macros */
#define INT16_TO_BUF(src,dest) \
(dest)[0] = (((src) >> 8) & 0xff); \
(dest)[1] = ((src) & 0xff); \
(dest) += 2;

#define INT32_TO_BUF(src,dest) \
(dest)[0] = (((src) >> 24) & 0xff); \
(dest)[1] = (((src) >> 16) & 0xff); \
(dest)[2] = (((src) >> 8) & 0xff); \
(dest)[3] = ((src) & 0xff); \
(dest) += 4;

#define BUF_TO_INT16(dest,src) \
(dest) = (((unsigned char)(src)[0] << 8) | (unsigned char)(src)[1]); \
(src) += 2;

#define BUF_TO_INT32(dest,src) \
(dest) = ( ((unsigned char)(src)[0] << 24) | ((unsigned char)(src)[1] << 16) |((unsigned char)(src)[2] << 8) | (unsigned char)(src)[3]); \
(src) += 4;



/* Global variables needed internally */
extern uint32_t        main_interfaceip;    /* This is set externally, nasty */
extern mvpinit_t       initparams;

/* Internal */
extern dongle_t       *dongle_return(char *addr);
extern void            dongle_close(dongle_t *dongle);
extern void            dongle_closeall();

/* gui.c - internal */
extern int             gui_init();
extern void            gui_exit();
extern void            delete_gui(gui_t *gui);
extern void            gui_send_play(gui_t *gui, char *name);
extern void            gui_send_message(gui_t *gui, int msgtype);
extern void            gui_send_settings(gui_t *gui, int subcommand);


/* misc.c - internal */
extern void            dump_hex(int level, unsigned char *buf, int len);

/* net.c - internal */
extern int             tcp_accept(int fd, char **hostbuf);
extern uint32_t        host_resolve(char *serv);
extern int             tcp_connect(char *serv, int port);
extern int             tcp_listen(struct in_addr *addr, int port, int backlog);
extern int             udp_listen(const char *iface, int port);
extern int             udp_send(char *data, int len, const char *addr, int port);


/* render.c - internal */
extern render_t       *new_render(int width, int depth);
extern void            delete_render(render_t *render);
extern void           *render_rgb2yvuy(render_t *render);
extern int             render_get_yuvsize(render_t *render);



/* stream.c */
/* Library internal */
extern int        stream_init();
extern void       stream_exit();
extern void       delete_stream(stream_t *stream);
extern int        stream_get_type(stream_t *stream);
extern int        stream_get_lasttype(stream_t *stream);


/* udp.c */
extern int        udp_init();
extern void       udp_exit();


/* urlhandler.c - internal */
extern int        urlhandler_init();
extern void      *urlhandler_open(char *name, int *type,  fops_t **fops, readready_cb cb, void *callback_ptr);
extern void       urlfile_init();
extern void       urlhttp_init();
extern void       urludp_init();


#endif /* MVP_INTERNAL_H */
