/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: keys.c,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   Handle keys
 */

#include "mvp_internal.h"
#include "keys.h"

typedef struct {
    int          code;
    char        *name;
    int          internal_code;
} mvpkey_t;

static mvpkey_t defkeys[] = {
    { 0x01, "0", k0 },
    { 0x02, "1", k1 },
    { 0x03, "2", k2 },
    { 0x04, "3", k3 },
    { 0x05, "4", k4 },
    { 0x06, "5", k5 },
    { 0x07, "6", k6 },
    { 0x08, "7", k7 },
    { 0x09, "8", k8 },
    { 0x0a, "9", k9 },
    { 0x0d, "OK", kOk },
    { 0x0e, "Rewind", kFastRew },
    { 0x0f, "Forward", kFastFwd },
    { 0x10, "Vol-", kVolDn },
    { 0x11, "Vol+", kVolUp },
    { 0x12, "Ch+", kChanUp },
    { 0x13, "Ch-", kChanDn },
    { 0x14, "Power", kPower },
    { 0x15, "Mute", kMute },
    { 0x19, "Play", kPlay },
    { 0x1a, "Record", kRecord },
    { 0x1b, "Stop", kStop },
    { 0x1c, "Pause", kPause },
    { 0x1e, "Menu", kMenu },
    { 0x20, "Back", kBack },
    { 0x23, "Go", kGo },
    { 0x24, "Red", kRed },
    { 0x25, "Green", kGreen },
    { 0x26, "Yellow", kYellow },
    { 0x27, "Blue", kBlue },
    { 0x28, "Blank", kBlank },
    { 0x29, "Full", kFull },
    { 0x2a, "Replay", kReplay },
    { 0x2b, "Skip", kSkip },
    { 0x00, NULL, }
};


static mvpkey_t *find_key(int code)
{
    mvpkey_t *key;

    key = &defkeys[0];
    while ( key->code ) {
        if ( key->code == code ) {
            return key;
        }
        key++;
    }

    return NULL;
}


int key_code(int ircode)
{
    mvpkey_t *key = find_key(ircode);

    if ( key == NULL ) {
        DPRINTF("Unknown key code %d\n",ircode);
        return 0;
    }

    return key->internal_code;
}

char *key_string(int ircode)
{   
    mvpkey_t *key = find_key(ircode);

    if ( key == NULL ) {
        DPRINTF("Unknown key code %d\n",ircode);
        return 0;
    }
    
    return key->name;
}
