/*
 *  Header for MediaMVP server
 *
 *
 *  $Id: mediamvp.h,v 1.23 2003/11/25 17:25:44 dom Exp $
 *  $Date: 2003/11/25 17:25:44 $
 */

#ifndef _MEDIAMVP_H_
#define _MEDIAMVP_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/queue.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdint.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <float.h>
#include <math.h>

#include <event.h>

#include "libini.h"


/* Some handy (de-) serialisation macros */
#define INT16_TO_BUF(src,dest) \
(dest)[0] = (((src) >> 8) & 0xff); \
(dest)[1] = ((src) & 0xff); \
(dest) += 2;

#define INT32_TO_BUF(src,dest) \
(dest)[0] = (((src) >> 24) & 0xff); \
(dest)[1] = (((src) >> 16) & 0xff); \
(dest)[2] = (((src) >> 8) & 0xff); \
(dest)[3] = ((src) & 0xff); \
(dest) += 4;

#define BUF_TO_INT16(dest,src) \
(dest) = (((unsigned char)(src)[0] << 8) | (unsigned char)(src)[1]); \
(src) += 2;

#define BUF_TO_INT32(dest,src) \
(dest) = ( ((unsigned char)(src)[0] << 24) | ((unsigned char)(src)[1] << 16) |((unsigned char)(src)[2] << 8) | (unsigned char)(src)[3]); \
(src) += 4;


enum { FALSE = 0, TRUE };

typedef unsigned char bool_t;
typedef struct _app   app_t;
typedef struct _menu menu_t;
typedef struct _render render_t;
typedef struct _gui gui_t;
typedef struct _stream stream_t;
typedef struct _mvprfbmsg mvprfbmsg_t;

typedef struct {
    char      address[30];      /* Should be more than enough */
    int       tvmode;
    int       flickermode;
    int       aspectratio;
    int       videooutput;      /* Sent by client?!? */
    char      inuse;
    gui_t    *gui;
    stream_t *stream;
} dongle_t;


extern uint32_t        main_interfaceip;



/* app.c */
extern void            app_config();
extern void            app_init();
extern app_t          *new_app(dongle_t *dongle, render_t *render, gui_t *gui);
extern void            delete_app(app_t *app);


/* dongle.c */
extern dongle_t       *dongle_return(char *addr);
extern void            dongle_close(dongle_t *dongle);

/* gui.c */
extern uint32_t        c_gui_hostip;
extern int             c_gui_port;

extern void            gui_config();
extern void            gui_init();
extern void            delete_gui(gui_t *gui);
#define  REGISTER_MENU  1
#define  REGISTER_MEDIA 2
extern void            gui_register_keys(gui_t *gui,int type,int (*key_func)(void *app,int keycode), void *menu);
extern void            gui_register_ack(gui_t *gui, int type,
                                        int    (*ack_func)(int acktype, void *param, unsigned char *buf, int len),
                                        void  *param);
extern void            gui_send_play(gui_t *gui, char *name);
extern void            gui_send_message(gui_t *gui, mvprfbmsg_t *msg);
extern void            gui_send_settings(gui_t *gui, int subcommand);

/* http.c */
extern int             http_open(char *url);

/* menu.c */
#define MENU_NUMBERS   1
extern menu_t         *new_menu(dongle_t *dongle, render_t *render, menu_t *parent,void *app, int flags);
extern void            delete_menu_tree(menu_t *menu);
extern void            delete_menu(menu_t *menu);
extern void            menu_set_title(menu_t *menu, char *text);
#define   MENU_NONE    0
#define   MENU_INT     1
extern void            menu_add_option(menu_t *menu, char *name, 
                                       int (callback_func)(menu_t *menu,void *app, int sel),
                                       int type, int num_options, char **options, void *value_ptr);
extern void            menu_add(menu_t *menu, char *name, int (*callback_func)(menu_t *menu,void *app, int sel));
extern void            menu_display(menu_t *menu);
extern void            menu_set_app_clearup(menu_t *menu, void (*clearup)(void *ptr));


/* misc.c */
extern void            dump_hex(unsigned char *buf, int len);

/* net.c */
extern int             tcp_accept(int fd, char **hostbuf);
extern uint32_t        host_resolve(char *serv);
extern int             tcp_connect(char *serv, int port);
extern int             tcp_listen(struct in_addr *addr, int port, int backlog);
extern int             udp_listen(const char *iface, int port);
extern int             udp_send(char *data, int len, const char *addr, int port);

/* render.c */
extern render_t       *new_render(int width, int depth);
extern void            delete_render(render_t *render);
extern void           *render_rgb2yvuy(render_t *render);
extern void            render_set_fgcol(render_t *render, int red, int green, int blue);
extern void            render_set_bgcol(render_t *render, int red, int green, int blue);
extern void            render_print(render_t *render, int x, int y, char *text);
extern void            render_printrow(render_t *render, int row, char *text);
extern void            render_clear(render_t *render);
extern int             render_get_yuvsize(render_t *render);
extern int             render_get_maxrows(render_t *render);
extern int             render_get_depth(render_t *render);
extern int             render_get_width(render_t *render);



/* stream.c */
/* Definitions for the type of stream */
#define MEDIA_MASK       3
#define MEDIA_MPEG       1
#define MEDIA_MP3        2
#define MEDIA_SOCKET   128
extern uint32_t        c_stream_hostip;
extern int             c_stream_port;
extern void            stream_config();
extern void            stream_init();
extern void            delete_stream(stream_t *stream);
extern int             stream_get_type(stream_t *stream);
extern int             stream_get_lasttype(stream_t *stream);


/* udp.c */
extern void            udp_config();
extern void            udp_init();


#endif
