/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: main.c,v 1.6 2003/11/19 16:25:53 dom Exp $
 *   $Date: 2003/11/19 16:25:53 $
 *
 *
 *   Startup..
 */


#include "mediamvp.h"



static char       *c_interface;
uint32_t           main_interfaceip;

int main(int argc, char *argv[])
{
    char hostbuf[2048];


    iniparse_init();

    iniparse_add("main:interface",OPT_STR,&c_interface);

    udp_config();
    gui_config();
    stream_config();
    app_config();

    iniparse_file("mediamvp.conf");
    iniparse_cleanup();


    if ( c_interface == NULL ) {
        if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
            perror("gethostbyname");
            exit(1);
        }
        c_interface = hostbuf;
    }

    if ( ( main_interfaceip = host_resolve(c_interface) ) == - 1 ) {
        fprintf(stderr,"Cannot resolve host <%s>\n",c_interface);
        exit(1);
    }

    event_init();

    udp_init();
    gui_init();
    stream_init();
    app_init();

    event_dispatch();

    return 0;
}

    


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
