/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: app.c,v 1.6 2003/11/18 23:12:48 dom Exp $
 *   $Date: 2003/11/18 23:12:48 $
 *
 *
 *   Implements the application
 */

#include "mediamvp.h"

/* Need to know some GUI constants */
#include "gui.h"

/* Now get some message types */
#include "msgs.h"


struct _app {
    render_t  *render;
    gui_t     *gui;
    menu_t    *menu;
};

typedef struct {
    char     *name;
    char     *url;
} channel_t;

static char         *c_livetv_file = NULL;
static char         *c_liveradio_file = NULL;
static char         *c_mp3_dir     = NULL;
static char         *c_mpeg_dir    = NULL;

static int           livetv_num    = 0;
static channel_t    *livetv        = NULL;
static time_t        livetv_time   = 0;

static int           liveradio_num    = 0;
static channel_t    *liveradio        = NULL;
static time_t        liveradio_time   = 0;

static int           app_main(menu_t *menu,app_t *app, int sel);
static int           app_live_tv(menu_t *menu,app_t *app, int sel);
static int           app_live_radio(menu_t *menu,app_t *app, int sel);
static int           app_recordings(menu_t *menu,app_t *app, int sel);
static int           app_music(menu_t *menu,app_t *app, int sel);
static int           app_settings(menu_t *menu,app_t *app, int sel);
static int           app_dummy(menu_t *menu,app_t *app, int sel);
static int           app_livetv(menu_t *menu,app_t *app, int sel);
static int           app_liveradio(menu_t *menu,app_t *app, int sel);

static int           livetv_keys(void *ptr, int code);
static int           liveradio_keys(void *ptr, int code);


static int           read_channel_file(char *filename, int *num, channel_t **list, time_t *update_time);

void app_config()
{
    iniparse_add("media:livetv",OPT_STR,&c_livetv_file);
    iniparse_add("media:liveradio",OPT_STR,&c_liveradio_file);
    iniparse_add("media:mp3",OPT_STR,&c_mp3_dir);
    iniparse_add("media:mpeg",OPT_STR,&c_mpeg_dir);
}


void app_init()
{
    if ( c_livetv_file != NULL ) {
	if ( read_channel_file(c_livetv_file,&livetv_num,&livetv,&livetv_time)  < 0 ) {
	    printf("Malformed file %s\n",c_livetv_file);
	    exit(1);
	}
    }   
    if ( c_liveradio_file != NULL ) {
	if ( read_channel_file(c_liveradio_file,&liveradio_num,&liveradio,&liveradio_time)  < 0 ) {
	    printf("Malformed file %s\n",c_liveradio_file);
	    exit(1);
	}
    }   

}

app_t *new_app(render_t *render, gui_t *gui)
{
    app_t      *app = malloc(sizeof(*app));

    app->render = render;
    app->gui    = gui;

    app_main(NULL,app,0);    

    return app;
}


void delete_app(app_t *app)
{

    delete_menu_tree(app->menu);

    free(app);
}


static int app_main(menu_t *menu,app_t *app, int sel)
{   
    app->menu = new_menu(app->render,NULL,app,app->gui,MENU_NUMBERS);
    menu_set_title(app->menu,"MediaMVP");
    menu_add(app->menu,"Live TV",app_live_tv);
    menu_add(app->menu,"Live Radio",app_live_radio);
    menu_add(app->menu,"Recordings",app_recordings);
    menu_add(app->menu,"Music",app_music);
    menu_add(app->menu,"Settings",app_settings);
    menu_display(app->menu);
    return 1;
}

static int app_live_tv(menu_t *menu,app_t *app, int sel)
{
    channel_t *chan;
    menu_t    *child;
    int        i;

    /* Force a re-read of the channel file */
    read_channel_file(c_livetv_file,&livetv_num,&livetv,&livetv_time);

    child = new_menu(app->render,menu,app,app->gui,0);
    menu_set_title(child,"Live TV"); 

    for ( i = 0; i < livetv_num; i++ ) {
	chan = &livetv[i];
	menu_add(child,chan->name,app_livetv);
    }
    menu_display(child);
    return 1;
}

static int app_live_radio(menu_t *menu,app_t *app, int sel)
{
    channel_t *chan;
    menu_t    *child;
    int        i;

    /* Force a re-read of the channel file */
    read_channel_file(c_liveradio_file,&liveradio_num,&liveradio,&liveradio_time);
    child = new_menu(app->render,menu,app,app->gui,0);
    menu_set_title(child,"Live Radio Stations");  
    for ( i = 0; i < liveradio_num; i++ ) {
	chan = &liveradio[i];
	menu_add(child,chan->name,app_liveradio);
    } 
    menu_display(child);
    return 1;
}

static int app_recordings(menu_t *menu,app_t *app, int sel)
{
    menu_t   *child;
    child = new_menu(app->render,menu,app,app->gui,0);
    menu_set_title(child,"Video Recordings");   
    menu_display(child);
    return 1;
}

static int app_music(menu_t *menu,app_t *app, int sel)
{
    menu_t   *child;
    child = new_menu(app->render,menu,app,app->gui,0);
    menu_set_title(child,"Music");   
    menu_display(child);
    return 1;
}

static int app_settings(menu_t *menu,app_t *app, int sel)
{
    menu_t   *child;
    child = new_menu(app->render,menu,app,app->gui,0);
    menu_set_title(child,"Settings"); 
    menu_display(child);
    return 1;
}

static int app_dummy(menu_t *menu,app_t *app, int sel)
{
    return 1;
}



static int app_livetv(menu_t *menu,app_t *app, int sel)
{
    channel_t *chan = &livetv[sel];
    gui_send_filename(app->gui,chan->url);
    gui_register_keys(app->gui,KEYS_MEDIA,livetv_keys,app);

    return 1;
}

static int app_liveradio(menu_t *menu,app_t *app, int sel)
{
    channel_t *chan = &liveradio[sel];
    gui_send_filename(app->gui,chan->url);
    gui_register_keys(app->gui,KEYS_MEDIA,liveradio_keys,app);

    return 1;
}




static int livetv_keys(void *ptr, int code)
{
    app_t    *app = ptr;

    switch ( code ) {
    case kStop:
	gui_send_message(app->gui,&rfb_media_stop);
	menu_display(app->menu);
	break;
    case kVolUp:
	gui_send_message(app->gui,&rfb_media_volup);
	break;
    case kVolDn:
	gui_send_message(app->gui,&rfb_media_voldown);
	break;
    case kMute:
	gui_send_message(app->gui,&rfb_media_mute);
	break;
    }
    return 1;
}

static int liveradio_keys(void *ptr, int code)
{
    app_t    *app = ptr;

   switch ( code ) {
    case kStop:
	gui_send_message(app->gui,&rfb_media_stop);
	menu_display(app->menu);
	break;
    case kVolUp:
	gui_send_message(app->gui,&rfb_media_volup);
	break;
    case kVolDn:
	gui_send_message(app->gui,&rfb_media_voldown);
	break;
    case kMute:
	gui_send_message(app->gui,&rfb_media_mute);
	break;
    }   
    return 0;
}









static int read_channel_file(char *filename, int *num, channel_t **list, 
			     time_t *update_time)
{
    char         buf[500];
    int          channum;
    channel_t   *chan = *list;
    char        *ptr;
    FILE        *fp;
    struct stat  sb;
    int          i;

    if ( stat(filename,&sb) < 0 ) {
	return 0;
    }

    if ( *update_time < sb.st_mtime ) {
	*update_time = sb.st_mtime;
	for ( i = 0; i < *num; i++ ) {
	    free(chan[i].name);
	    free(chan[i].url);
	}


	if ( ( fp = fopen(filename,"r") ) == NULL ) {
	    return -1;
	}

	if ( chan != NULL ) {
	    free(chan);
	}
	chan = NULL;
	channum = 0;

	*list = NULL;
	*num = 0;

	while ( !feof(fp) && fgets(buf,sizeof(buf),fp) ) {
	    if ( (ptr = strchr(buf,';') ) == NULL ) {
		continue;
	    }
	    *ptr = 0;
	    ptr++;

	    i = channum++;

	    chan = realloc(chan,channum * sizeof(channel_t));
	    chan[i].name = strdup(buf);
	    chan[i].url = strdup(ptr);	    
	}
	*list = chan;
	*num = channum;
    }

    return 0;
}





