; -----------------------------------------------------------------------------
;
; File: PACKET.INI
;
; Configuration parameters file for the Wireless Packet Driver.
; The name of this driver is: WVLAN42.COM.
;
; Date: $Date:   07 Nov 2001 11:57:58  $        $Revision:   6.7  $
;
; -----------------------------------------------------------------------------
; Wireless specific configuration parameters:
;
;	For more information on the configuration parameters, refer to the 
;	documentation which came with the product.

;	WARNING: Parameter values are case sensitive. There may be other
;	platforms in your network that are case insensitive, and that 
;	automatically convert all lower case characters to upper case. If that 
;	is your situation, you should enter the Wireless_Network_Name in upper
;       case.

; BASIC parameters:

;   Wireless_Network_Name: 0..32 printable character string.
;	This specifies the network this station is to connect to.
;	When this parameter is omitted, or is specified as an empty string or as
;	"ANY", the station may connect to any network it finds.
;	This information should be provided by your network supervisor.
;	This parameter used to be known as Wavelan_Network_Name
Wireless_Network_Name = ANY

;   Create_IBSS
;   Valid values:  Y, N
;   Default value: N
;   Create_IBSS specifies whether the station must create or connect 
;   to an IBSS.
;Create_IBSS = N

;   Station_Name: 0..32 printable character string.
;	Plain-text name of this station. Used for diagnostic purposes.
Station_Name = John Does Notebook PC

; ADVANCED parameters (specify only when really needed):

;   Distance between AP's: decimal value
;       Valid values:
;       1 = Large distance,
;       2 = Medium distance,
;       3 = Small distance
;       Default value: 1
;   Specifies the distance between the Access Points in your network.
;   This information should be provided by your network supervisor.
;AP_Distance = 1

;   Microwave_Oven_Robustness
;       Valid values: Y, N
;       Default:      N
;   Select Y(es) when there are microwave ovens present in the area where 
;   you intend to use your PC
;Microwave_Oven_Robustness = N

;   Medium_Reservation: decimal value.
;       Valid values: 0..2437
;       Default value: 2347
;   Specifies the number of octets in a message or fragment above which a
;   RTS/CTS handshake is performed to reserve the medium for the message or
;   fragment transmission. Setting the value to 2347 disables this mechanism.
;   Medium_Reservation is advised to be used in the following case:
;   - Environments with known "hidden" stations, like a (single) cell where
;     many stations are located at the periphery at maximum range from the AP.
;Medium_Reservation = 2347

;   MAC_Address: 12 Hex digits.
;	Specifies a local MAC address, that will be used instead of the cards
;	own universal MAC address. If required, this information should be
;	provided by your network supervisor.
;MAC_Address = 02000000cafe

;   Card_Power_Management: 1 character
;       Valid values:  N (0), Y (1), 2
;       Default value: N (0)
;   Card_Power_Management is used to enable or disable the station to use Power
;   Management in an ESS. Specifying Y or 1 enables Enhanced Power Management,
;   specifying 2 will enable standard power management, while specifying N or 0
;   will disable power management.
;Card_Power_Management = N

;   Enhanced_Power_Save: 1 character
;       Valid values: Y, N
;       Default value: Y
;   Enhanced_Power_Save is used to enable or disable the station to use
;   Enhanced Power Management (EPM) in an ESS. EPM implies that the station
;   switches between Power Save Mode and Continuous Active Mode
;   dependent on the communications activity. Any frame transfer switches
;   the station to Continuous Active Mode. Inactivity for 100 ms switches it
;   to Power Save Mode. This improves performance during e.g. file transfer,
;   but may cost a bit more power consumption.
;   This parameter is ignored if Card_Power_Management is not enabled.
;Enhanced_Power_Save = Y

;   Maximum_Sleep_Duration: decimal value
;       Valid range: 1 - 6553
;       Default value: 100
;   Maximum_Sleep_Duration specifies the maximum time the station is allowed
;   to spend consecutively in DOZE state, used to determine the Listen
;   Interval on the station's Power Management scheme.
;Maximum_Sleep_Duration = 100

;   Receive_All_Multicasts: 1 character
;       Valid values:  Y, N
;       Default value: Y
;   Receive_All_Multicasts specifies whether the station must receive all
;   multicast frames (with addresses specified by the protocol stack) when
;   using Power Management. When this is the case, the station will have to
;   wake up frequently to receive the multicast frames. This causes less
;   optimal power savings.
;Receive_All_Multicasts = Y

; Encryption parameters: (specify only when really needed)

;   Wired Equivalent Privacy (WEP) data encryption enables you to encrypt all
;   data that will be transmitted via the wireless LAN medium.
;   WEP is supported by Wireless cards only. To use WEP
;   within your network all Accesspoint devices and wireless stations must
;   be equipped with Wireless cards, that have been
;   configured to use identical encryption keys.
;   Up to 4 different keys to decrypt data received via the wireless interface
;   can be entered.
;   One of these 4 keys can be selected to encrypt wireless data that is to be
;   transmitted via the wireless interface.
;
;   Note: Enabling WEP encryption on wireless stations does not affect the
;   ability of your computer to interpret non-encrypted data traffic: i.e.
;   when you enable encryption, your computer will be able to receive both
;   encrypted and non-encrypted messages with one of the listed WEP
;   Encryption Key Values.

;	Enable_Encryption: 1 character
;	    Valid values:  Y, N
;	    Default value: N
;   Enables or disables encryption.
;Enable_Encryption = N

;   Key<n>: 5/13 character string or 10/26 digit hex number (n in range 1..4)
;   Depending on encryption type, keys are either 40 or 104 bits long.
;   40 bits keys are supported on the Silver and Gold cards.
;   104 bits keys are supported on the Gold card only.
;   The keys can be specified in ASCII or in hex. In case the ASCII form is
;   used, a key must be either 5 or 13 characters. In case of the hex form,
;   a key must start with '0x' followed by 10 or 26 hex digits. Up to 4 keys
;   can be specified. When multiple keys are specified, the form as well as
;   the length of the keys need not be the same. If the Card does not support
;   104 bits keys, the lenght is truncated to 40 bits without warning.
;Key1 = abcde
;Key2 = 0x123456789a
;Key3 = abcdefghijkl2
;Key4 = 0x112233445566778899AABBCCDD

;   Transmit_Key_ID: decimal value
;       Valid values: 1,2,3 or 4
;       Default value: 1
;   If you enable WEP encryption, you can select one key for wireless data
;   transmissions from the list of WEP Encryption Key Values.
;Transmit_Key_ID = 1

; -----------------------------------------------------------------------------
; Packet Driver specific configuration parameters:

;	Driver_Class: 1 or 11, default = 1.
;	Specifies the Packet Driver Class, that is reported by the driver in
;	response to the driver_info() function.
;	This is dependent on the need of your protocol stack.
;	  Class 1 uses the DIX Ethernet (Ethernet V2.0) frame format.
;	  Class 11 uses the IEEE 802.3 with 802.2 headers frame format.
;Driver_Class = 11

;	Novell_Flag: Yes/No, default = No.
;	"Yes" specifies support for Novell's IPX Ethernet_802.3 frame format.
;Novell_Flag = No

;   Packet_Interrupt: 60..70 (hex values), default = 60.
;	Specifies the software interrupt for access to this driver.
;Packet_Interrupt = 60
