:
:    CHANGED.BAT -- Generates a parameter file and invokes Eztape to 
:	back up all changed files on the drives specified, for example:
:
:		"CHANGED C D E"
:	
:	Will back up all changed files on drives C, D, and E.  
:
:	If no drives are specified, "changed" will invoke Eztape to
:	back up all changed files on the currently logged drive.
:
@ECHO OFF

:-----Delete previous parameter file
IF EXIST CHANGED.BPF DEL CHANGED.BPF

:-----Check for command line arguments
IF "%1"=="" GOTO ELSE

    :-----Add line to parameter file for each listed drive
    :BEGINWHILE
        IF "%1"=="" GOTO ENDWHILE
        ECHO /n CHANGED-%1 /a /r /q /s %1:\*.* >>CHANGED.BPF
        SHIFT
        GOTO BEGINWHILE
    :ENDWHILE

    GOTO ENDIF

:ELSE
    :------Backup currently logged file only
    ECHO /n CHANGED /a /r /q /s \*.* >>CHANGED.BPF

:ENDIF

:-----Start backup
EZTAPE BACKUP /f CHANGED.BPF
DEL CHANGED.BPF
