/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "ntdomain.h"
#include "bin/default/librpc/gen_ndr/srv_winspool.h"
#include "bin/default/librpc/gen_ndr/srv_spoolss.c"

static bool api_winspool_SyncRegisterForRemoteNotifications(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_SyncRegisterForRemoteNotifications *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_SYNCREGISTERFORREMOTENOTIFICATIONS];

	r = talloc(talloc_tos(), struct winspool_SyncRegisterForRemoteNotifications);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRegisterForRemoteNotifications, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.phRpcHandle = talloc_zero(r, struct policy_handle);
	if (r->out.phRpcHandle == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _winspool_SyncRegisterForRemoteNotifications(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRegisterForRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_SyncUnRegisterForRemoteNotifications(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_SyncUnRegisterForRemoteNotifications *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_SYNCUNREGISTERFORREMOTENOTIFICATIONS];

	r = talloc(talloc_tos(), struct winspool_SyncUnRegisterForRemoteNotifications);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncUnRegisterForRemoteNotifications, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.phRpcHandle = r->in.phRpcHandle;
	r->out.result = _winspool_SyncUnRegisterForRemoteNotifications(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncUnRegisterForRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_SyncRefreshRemoteNotifications(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_SyncRefreshRemoteNotifications *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_SYNCREFRESHREMOTENOTIFICATIONS];

	r = talloc(talloc_tos(), struct winspool_SyncRefreshRemoteNotifications);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRefreshRemoteNotifications, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppNotifyData = talloc_zero(r, struct winspool_PrintPropertiesCollection *);
	if (r->out.ppNotifyData == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _winspool_SyncRefreshRemoteNotifications(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_SyncRefreshRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_AsyncGetRemoteNotifications(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_AsyncGetRemoteNotifications *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_ASYNCGETREMOTENOTIFICATIONS];

	r = talloc(talloc_tos(), struct winspool_AsyncGetRemoteNotifications);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetRemoteNotifications, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ppNotifyData = talloc_zero(r, struct winspool_PrintPropertiesCollection *);
	if (r->out.ppNotifyData == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _winspool_AsyncGetRemoteNotifications(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncGetRemoteNotifications, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_AsyncInstallPrinterDriverFromPackage(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_AsyncInstallPrinterDriverFromPackage *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_ASYNCINSTALLPRINTERDRIVERFROMPACKAGE];

	r = talloc(talloc_tos(), struct winspool_AsyncInstallPrinterDriverFromPackage);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncInstallPrinterDriverFromPackage, NDR_IN, r);
	}

	r->out.result = _winspool_AsyncInstallPrinterDriverFromPackage(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncInstallPrinterDriverFromPackage, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_AsyncUploadPrinterDriverPackage(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_AsyncUploadPrinterDriverPackage *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_ASYNCUPLOADPRINTERDRIVERPACKAGE];

	r = talloc(talloc_tos(), struct winspool_AsyncUploadPrinterDriverPackage);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncUploadPrinterDriverPackage, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pszDestInfPath = r->in.pszDestInfPath;
	r->out.pcchDestInfPath = r->in.pcchDestInfPath;
	r->out.result = _winspool_AsyncUploadPrinterDriverPackage(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncUploadPrinterDriverPackage, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_AsyncCorePrinterDriverInstalled(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_AsyncCorePrinterDriverInstalled *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_ASYNCCOREPRINTERDRIVERINSTALLED];

	r = talloc(talloc_tos(), struct winspool_AsyncCorePrinterDriverInstalled);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCorePrinterDriverInstalled, NDR_IN, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pbDriverInstalled = talloc_zero(r, int32_t);
	if (r->out.pbDriverInstalled == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _winspool_AsyncCorePrinterDriverInstalled(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncCorePrinterDriverInstalled, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}

static bool api_winspool_AsyncDeletePrinterDriverPackage(struct pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	struct winspool_AsyncDeletePrinterDriverPackage *r;

	call = &ndr_table_iremotewinspool.calls[NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVERPACKAGE];

	r = talloc(talloc_tos(), struct winspool_AsyncDeletePrinterDriverPackage);
	if (r == NULL) {
		return false;
	}

	pull = ndr_pull_init_blob(&p->in_data.data, r);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	if (p->endian) {
		pull->flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverPackage, NDR_IN, r);
	}

	r->out.result = _winspool_AsyncDeletePrinterDriverPackage(p, r);

	if (p->fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_FUNCTION_DEBUG(winspool_AsyncDeletePrinterDriverPackage, NDR_OUT | NDR_SET_VALUES, r);
	}

	push = ndr_push_init_ctx(r);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	/*
	 * carry over the pointer count to the reply in case we are
	 * using full pointer. See NDR specification for full pointers
	 */
	push->ptr_count = pull->ptr_count;

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	p->out_data.rdata = ndr_push_blob(push);
	talloc_steal(p->mem_ctx, p->out_data.rdata.data);

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_iremotewinspool_cmds[] =
{
	{"WINSPOOL_ASYNCOPENPRINTER", NDR_WINSPOOL_ASYNCOPENPRINTER, api_spoolss_OpenPrinterEx},
	{"WINSPOOL_ASYNCADDPRINTER", NDR_WINSPOOL_ASYNCADDPRINTER, api_spoolss_AddPrinterEx},
	{"WINSPOOL_ASYNCSETJOB", NDR_WINSPOOL_ASYNCSETJOB, api_spoolss_SetJob},
	{"WINSPOOL_ASYNCGETJOB", NDR_WINSPOOL_ASYNCGETJOB, api_spoolss_GetJob},
	{"WINSPOOL_ASYNCENUMJOBS", NDR_WINSPOOL_ASYNCENUMJOBS, api_spoolss_EnumJobs},
	{"WINSPOOL_ASYNCADDJOB", NDR_WINSPOOL_ASYNCADDJOB, api_spoolss_AddJob},
	{"WINSPOOL_ASYNCSCHEDULEJOB", NDR_WINSPOOL_ASYNCSCHEDULEJOB, api_spoolss_ScheduleJob},
	{"WINSPOOL_ASYNCDELETEPRINTER", NDR_WINSPOOL_ASYNCDELETEPRINTER, api_spoolss_DeletePrinter},
	{"WINSPOOL_ASYNCSETPRINTER", NDR_WINSPOOL_ASYNCSETPRINTER, api_spoolss_SetPrinter},
	{"WINSPOOL_ASYNCGETPRINTER", NDR_WINSPOOL_ASYNCGETPRINTER, api_spoolss_GetPrinter},
	{"WINSPOOL_ASYNCSTARTDOCPRINTER", NDR_WINSPOOL_ASYNCSTARTDOCPRINTER, api_spoolss_StartDocPrinter},
	{"WINSPOOL_ASYNCSTARTPAGEPRINTER", NDR_WINSPOOL_ASYNCSTARTPAGEPRINTER, api_spoolss_StartPagePrinter},
	{"WINSPOOL_ASYNCWRITEPRINTER", NDR_WINSPOOL_ASYNCWRITEPRINTER, api_spoolss_WritePrinter},
	{"WINSPOOL_ASYNCENDPAGEPRINTER", NDR_WINSPOOL_ASYNCENDPAGEPRINTER, api_spoolss_EndPagePrinter},
	{"WINSPOOL_ASYNCENDDOCPRINTER", NDR_WINSPOOL_ASYNCENDDOCPRINTER, api_spoolss_EndDocPrinter},
	{"WINSPOOL_ASYNCABORTPRINTER", NDR_WINSPOOL_ASYNCABORTPRINTER, api_spoolss_AbortPrinter},
	{"WINSPOOL_ASYNCGETPRINTERDATA", NDR_WINSPOOL_ASYNCGETPRINTERDATA, api_spoolss_GetPrinterData},
	{"WINSPOOL_ASYNCGETPRINTERDATAEX", NDR_WINSPOOL_ASYNCGETPRINTERDATAEX, api_spoolss_GetPrinterDataEx},
	{"WINSPOOL_ASYNCSETPRINTERDATA", NDR_WINSPOOL_ASYNCSETPRINTERDATA, api_spoolss_SetPrinterData},
	{"WINSPOOL_ASYNCSETPRINTERDATAEX", NDR_WINSPOOL_ASYNCSETPRINTERDATAEX, api_spoolss_SetPrinterDataEx},
	{"WINSPOOL_ASYNCCLOSEPRINTER", NDR_WINSPOOL_ASYNCCLOSEPRINTER, api_spoolss_ClosePrinter},
	{"WINSPOOL_ASYNCADDFORM", NDR_WINSPOOL_ASYNCADDFORM, api_spoolss_AddForm},
	{"WINSPOOL_ASYNCDELETEFORM", NDR_WINSPOOL_ASYNCDELETEFORM, api_spoolss_DeleteForm},
	{"WINSPOOL_ASYNCGETFORM", NDR_WINSPOOL_ASYNCGETFORM, api_spoolss_GetForm},
	{"WINSPOOL_ASYNCSETFORM", NDR_WINSPOOL_ASYNCSETFORM, api_spoolss_SetForm},
	{"WINSPOOL_ASYNCENUMFORMS", NDR_WINSPOOL_ASYNCENUMFORMS, api_spoolss_EnumForms},
	{"WINSPOOL_ASYNCGETPRINTERDRIVER", NDR_WINSPOOL_ASYNCGETPRINTERDRIVER, api_spoolss_GetPrinterDriver2},
	{"WINSPOOL_ASYNCENUMPRINTERDATA", NDR_WINSPOOL_ASYNCENUMPRINTERDATA, api_spoolss_EnumPrinterData},
	{"WINSPOOL_ASYNCENUMPRINTERDATAEX", NDR_WINSPOOL_ASYNCENUMPRINTERDATAEX, api_spoolss_EnumPrinterDataEx},
	{"WINSPOOL_ASYNCENUMPRINTERKEY", NDR_WINSPOOL_ASYNCENUMPRINTERKEY, api_spoolss_EnumPrinterKey},
	{"WINSPOOL_ASYNCDELETEPRINTERDATA", NDR_WINSPOOL_ASYNCDELETEPRINTERDATA, api_spoolss_DeletePrinterData},
	{"WINSPOOL_ASYNCDELETEPRINTERDATAEX", NDR_WINSPOOL_ASYNCDELETEPRINTERDATAEX, api_spoolss_DeletePrinterDataEx},
	{"WINSPOOL_ASYNCDELETEPRINTERKEY", NDR_WINSPOOL_ASYNCDELETEPRINTERKEY, api_spoolss_DeletePrinterKey},
	{"WINSPOOL_ASYNCXCVDATA", NDR_WINSPOOL_ASYNCXCVDATA, api_spoolss_XcvData},
	{"WINSPOOL_ASYNCSENDRECVBIDIDATA", NDR_WINSPOOL_ASYNCSENDRECVBIDIDATA, api_spoolss_SendRecvBidiData},
	{"WINSPOOL_ASYNCCREATEPRINTERIC", NDR_WINSPOOL_ASYNCCREATEPRINTERIC, api_spoolss_CreatePrinterIC},
	{"WINSPOOL_ASYNCPLAYGDISCRIPTONPRINTERIC", NDR_WINSPOOL_ASYNCPLAYGDISCRIPTONPRINTERIC, api_spoolss_PlayGDIScriptOnPrinterIC},
	{"WINSPOOL_ASYNCDELETEPRINTERIC", NDR_WINSPOOL_ASYNCDELETEPRINTERIC, api_spoolss_DeletePrinterIC},
	{"WINSPOOL_ASYNCENUMPRINTERS", NDR_WINSPOOL_ASYNCENUMPRINTERS, api_spoolss_EnumPrinters},
	{"WINSPOOL_ASYNCADDPRINTERDRIVER", NDR_WINSPOOL_ASYNCADDPRINTERDRIVER, api_spoolss_AddPrinterDriver},
	{"WINSPOOL_ASYNCENUMPRINTERDRIVERS", NDR_WINSPOOL_ASYNCENUMPRINTERDRIVERS, api_spoolss_EnumPrinterDrivers},
	{"WINSPOOL_ASYNCGETPRINTERDRIVERDIRECTORY", NDR_WINSPOOL_ASYNCGETPRINTERDRIVERDIRECTORY, api_spoolss_GetPrinterDriverDirectory},
	{"WINSPOOL_ASYNCDELETEPRINTERDRIVER", NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVER, api_spoolss_DeletePrinterDriver},
	{"WINSPOOL_ASYNCDELETEPRINTERDRIVEREX", NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVEREX, api_spoolss_DeletePrinterDriverEx},
	{"WINSPOOL_ASYNCADDPRINTPROCESSOR", NDR_WINSPOOL_ASYNCADDPRINTPROCESSOR, api_spoolss_AddPrintProcessor},
	{"WINSPOOL_ASYNCENUMPRINTPROCESSORS", NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORS, api_spoolss_EnumPrintProcessors},
	{"WINSPOOL_ASYNCGETPRINTPROCESSORDIRECTORY", NDR_WINSPOOL_ASYNCGETPRINTPROCESSORDIRECTORY, api_spoolss_GetPrintProcessorDirectory},
	{"WINSPOOL_ASYNCENUMPORTS", NDR_WINSPOOL_ASYNCENUMPORTS, api_spoolss_EnumPorts},
	{"WINSPOOL_ASYNCENUMMONITORS", NDR_WINSPOOL_ASYNCENUMMONITORS, api_spoolss_EnumMonitors},
	{"WINSPOOL_ASYNCADDPORT", NDR_WINSPOOL_ASYNCADDPORT, api_spoolss_AddPort},
	{"WINSPOOL_ASYNCSETPORT", NDR_WINSPOOL_ASYNCSETPORT, api_spoolss_SetPort},
	{"WINSPOOL_ASYNCADDMONITOR", NDR_WINSPOOL_ASYNCADDMONITOR, api_spoolss_AddMonitor},
	{"WINSPOOL_ASYNCDELETEMONITOR", NDR_WINSPOOL_ASYNCDELETEMONITOR, api_spoolss_DeleteMonitor},
	{"WINSPOOL_ASYNCDELETEPRINTPROCESSOR", NDR_WINSPOOL_ASYNCDELETEPRINTPROCESSOR, api_spoolss_DeletePrintProcessor},
	{"WINSPOOL_ASYNCENUMPRINTPROCESSORDATATYPES", NDR_WINSPOOL_ASYNCENUMPRINTPROCESSORDATATYPES, api_spoolss_EnumPrintProcessorDataTypes},
	{"WINSPOOL_ASYNCADDPERMACHINECONNECTION", NDR_WINSPOOL_ASYNCADDPERMACHINECONNECTION, api_spoolss_AddPerMachineConnection},
	{"WINSPOOL_ASYNCDELETEPERMACHINECONNECTION", NDR_WINSPOOL_ASYNCDELETEPERMACHINECONNECTION, api_spoolss_DeletePerMachineConnection},
	{"WINSPOOL_ASYNCENUMPERMACHINECONNECTIONS", NDR_WINSPOOL_ASYNCENUMPERMACHINECONNECTIONS, api_spoolss_EnumPerMachineConnections},
	{"WINSPOOL_SYNCREGISTERFORREMOTENOTIFICATIONS", NDR_WINSPOOL_SYNCREGISTERFORREMOTENOTIFICATIONS, api_winspool_SyncRegisterForRemoteNotifications},
	{"WINSPOOL_SYNCUNREGISTERFORREMOTENOTIFICATIONS", NDR_WINSPOOL_SYNCUNREGISTERFORREMOTENOTIFICATIONS, api_winspool_SyncUnRegisterForRemoteNotifications},
	{"WINSPOOL_SYNCREFRESHREMOTENOTIFICATIONS", NDR_WINSPOOL_SYNCREFRESHREMOTENOTIFICATIONS, api_winspool_SyncRefreshRemoteNotifications},
	{"WINSPOOL_ASYNCGETREMOTENOTIFICATIONS", NDR_WINSPOOL_ASYNCGETREMOTENOTIFICATIONS, api_winspool_AsyncGetRemoteNotifications},
	{"WINSPOOL_ASYNCINSTALLPRINTERDRIVERFROMPACKAGE", NDR_WINSPOOL_ASYNCINSTALLPRINTERDRIVERFROMPACKAGE, api_winspool_AsyncInstallPrinterDriverFromPackage},
	{"WINSPOOL_ASYNCUPLOADPRINTERDRIVERPACKAGE", NDR_WINSPOOL_ASYNCUPLOADPRINTERDRIVERPACKAGE, api_winspool_AsyncUploadPrinterDriverPackage},
	{"WINSPOOL_ASYNCGETCOREPRINTERDRIVERS", NDR_WINSPOOL_ASYNCGETCOREPRINTERDRIVERS, api_spoolss_GetCorePrinterDrivers},
	{"WINSPOOL_ASYNCCOREPRINTERDRIVERINSTALLED", NDR_WINSPOOL_ASYNCCOREPRINTERDRIVERINSTALLED, api_winspool_AsyncCorePrinterDriverInstalled},
	{"WINSPOOL_ASYNCGETPRINTERDRIVERPACKAGEPATH", NDR_WINSPOOL_ASYNCGETPRINTERDRIVERPACKAGEPATH, api_spoolss_GetPrinterDriverPackagePath},
	{"WINSPOOL_ASYNCDELETEPRINTERDRIVERPACKAGE", NDR_WINSPOOL_ASYNCDELETEPRINTERDRIVERPACKAGE, api_winspool_AsyncDeletePrinterDriverPackage},
	{"WINSPOOL_ASYNCREADPRINTER", NDR_WINSPOOL_ASYNCREADPRINTER, api_spoolss_ReadPrinter},
	{"WINSPOOL_ASYNCRESETPRINTER", NDR_WINSPOOL_ASYNCRESETPRINTER, api_spoolss_ResetPrinter},
	{"WINSPOOL_ASYNCGETJOBNAMEDPROPERTYVALUE", NDR_WINSPOOL_ASYNCGETJOBNAMEDPROPERTYVALUE, api_spoolss_GetJobNamedPropertyValue},
	{"WINSPOOL_ASYNCSETJOBNAMEDPROPERTY", NDR_WINSPOOL_ASYNCSETJOBNAMEDPROPERTY, api_spoolss_SetJobNamedProperty},
	{"WINSPOOL_ASYNCDELETEJOBNAMEDPROPERTY", NDR_WINSPOOL_ASYNCDELETEJOBNAMEDPROPERTY, api_spoolss_DeleteJobNamedProperty},
	{"WINSPOOL_ASYNCENUMJOBNAMEDPROPERTIES", NDR_WINSPOOL_ASYNCENUMJOBNAMEDPROPERTIES, api_spoolss_EnumJobNamedProperties},
	{"WINSPOOL_ASYNCLOGJOBINFOFORBRANCHOFFICE", NDR_WINSPOOL_ASYNCLOGJOBINFOFORBRANCHOFFICE, api_spoolss_LogJobInfoForBranchOffice},
};

const struct api_struct *iremotewinspool_get_pipe_fns(int *n_fns)
{
	*n_fns = sizeof(api_iremotewinspool_cmds) / sizeof(struct api_struct);
	return api_iremotewinspool_cmds;
}

NTSTATUS rpc_iremotewinspool_init(const struct rpc_srv_callbacks *rpc_srv_cb)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "iremotewinspool", "iremotewinspool", &ndr_table_iremotewinspool, api_iremotewinspool_cmds, sizeof(api_iremotewinspool_cmds) / sizeof(struct api_struct), rpc_srv_cb);
}

NTSTATUS rpc_iremotewinspool_shutdown(void)
{
	return rpc_srv_unregister(&ndr_table_iremotewinspool);
}
