; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple thumbv7-eabi | FileCheck %s -check-prefix=T2
; RUN: llc < %s -mtriple thumbv6m-eabi | FileCheck %s -check-prefix=T1
; <rdar://problem/7569620>

define i32 @compare_i_gt(i32 %a) {
; T2-LABEL: compare_i_gt:
; T2:       @ %bb.0: @ %entry
; T2-NEXT:    movs r1, #24
; T2-NEXT:    cmn.w r0, #78
; T2-NEXT:    it gt
; T2-NEXT:    movgt r1, #42
; T2-NEXT:    mov r0, r1
; T2-NEXT:    bx lr
;
; T1-LABEL: compare_i_gt:
; T1:       @ %bb.0: @ %entry
; T1-NEXT:    mov r1, r0
; T1-NEXT:    movs r0, #77
; T1-NEXT:    mvns r3, r0
; T1-NEXT:    movs r0, #42
; T1-NEXT:    movs r2, #24
; T1-NEXT:    cmp r1, r3
; T1-NEXT:    bgt .LBB0_2
; T1-NEXT:  @ %bb.1: @ %entry
; T1-NEXT:    mov r0, r2
; T1-NEXT:  .LBB0_2: @ %entry
; T1-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %a, -78
  %ret = select i1 %cmp, i32 42, i32 24
  ret i32 %ret
}

define i32 @compare_r_eq(i32 %a, i32 %b) {
; T2-LABEL: compare_r_eq:
; T2:       @ %bb.0: @ %entry
; T2-NEXT:    movs r2, #24
; T2-NEXT:    cmn r0, r1
; T2-NEXT:    it eq
; T2-NEXT:    moveq r2, #42
; T2-NEXT:    mov r0, r2
; T2-NEXT:    bx lr
;
; T1-LABEL: compare_r_eq:
; T1:       @ %bb.0: @ %entry
; T1-NEXT:    mov r2, r0
; T1-NEXT:    movs r0, #42
; T1-NEXT:    movs r3, #24
; T1-NEXT:    cmn r2, r1
; T1-NEXT:    beq .LBB1_2
; T1-NEXT:  @ %bb.1: @ %entry
; T1-NEXT:    mov r0, r3
; T1-NEXT:  .LBB1_2: @ %entry
; T1-NEXT:    bx lr
entry:
  %sub = sub nsw i32 0, %b
  %cmp = icmp eq i32 %a, %sub
  %ret = select i1 %cmp, i32 42, i32 24
  ret i32 %ret
}
