/**** dir.h - various defines for talking to MS-DOS directories ****/

typedef unsigned short	word;
typedef unsigned char	byte;

/* This structure is returned by the search for first/next functions */

typedef struct
{
    byte    fi_resv[21];	/* bytes  0-20	reserved by DOS     */
    byte    fi_attrib;		/* byte  21	file attributes     */
    word    fi_time;		/* bytes 22-23	create/update time  */
    word    fi_date;		/* bytes 24-25	create/update date  */
    long    fi_fsize;		/* bytes 26-27	file size in bytes  */
    byte    fi_name[13];	/* bytes 28-40	file name & extension	*/
} FILE_INFO;

/* attribute bit definitions */

#define READONLY	0x01
#define HIDDEN		0x02
#define SYSTEM		0x04
#define LABEL		0x08
#define DIRECT		0x10
#define ARCHIVE 	0x20

/*  Macros to extract information from a FILE_INFO structure. */

/*              5432109876543210        */
/*      date:   yyyyyyymmmmddddd    0-127, 0-15, 0-31   */
/*      time:   hhhhhmmmmmmsssss    0-31,  0-63, 0-31   */

#define FILE_HR(p)	( ((p)->fi_time >> 11) & 0x1f )
#define FILE_MIN(p)	( ((p)->fi_time >>  5) & 0x3f )
#define FILE_SEC(p)	( ((p)->fi_time <<  1) & 0x3e )
#define FILE_YEAR(p)	((((p)->fi_date >>  9) & 0x7f ) + 1980)
#define FILE_MONTH(p)	( ((p)->fi_date >>  5) & 0x0f )
#define FILE_DAY(p)	( ((p)->fi_date      ) & 0x1f )

/* directory related dos call numbers */

#define FINDFIRST	0x4e
#define FINDNEXT	0x4f
#define SETDTA		0x1a
#define GETDTA		0x2f

