;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

;***	Z204IO.ASM - Z-204 Multiport I/O Card I/O handler
;
;	Z204IO provides the low level I/O routines for the
;	Z204 device driver. Hopefully, the upper level driver
;	contained in Z204 will not need changing, and only
;	these low level routines will need modifying for
;	any necessary changes.
;

;***	CHR_GET - Get one character from the device
;
;	CHR_GET gets one character from the device. This
;	may simply mean reading from a que. PSW.CY set on
;	return indicates no characters ready. The driver will
;	just hang on this recalling CHR_GET until one gets
;	in
;

CHR_GET	PROC	NEAR
	MOV	SI,OFFSET INPUT_QUE
	CALL	QUE_GET				; Get one
	RET
CHR_GET	ENDP

;***	CHR_LOOK - Peek at the next character in the input que
;
;	CHR_LOOK Peeks at the next character in the input
;	que, returning it in AL
;

CHR_LOOK PROC	NEAR
	MOV	SI,OFFSET INPUT_QUE
	CALL	QUE_LOOK			; Peek at it
	RET
CHR_LOOK ENDP

;***	CHR_STATUSI - Return input status
;
;	CHR_STATUSI returns the input status flag
;	CY set indicates no input ready
;

CHR_STATUSI PROC	NEAR
	MOV	SI,OFFSET INPUT_QUE
	CALL	QUE_LOOK			; Peek at it
	RET
CHR_STATUSI ENDP

;***	CHR_FLUSHI - Flush Input
;
;	CHR_FLUSHI is called to flush the Input buffer.
;

CHR_FLUSHI PROC	NEAR
	CLC
	RET
CHR_FLUSHI ENDP

;***	CHR_PUT - Output the character to the device
;
;	CHR_PUT outputs the character in AL to the device.
;	This may simply mean stuffing an output buffer
;

CHR_PUT	PROC	NEAR
	MOV	SI,OFFSET OUTPUT_QUE		; Get the output que
	CALL	QUE_PUT				; Put it in
	JC	CHR_PUT1			; If troubles
	CALL	CHKBSY				; This will turn Tx on
	CLC
CHR_PUT1:
	RET
CHR_PUT ENDP

;***	CHR_STATUSO - Check output status
;
;	CHR_STATUSO returns the output status. CY
;	set indicates output busy
;

CHR_STATUSO PROC	NEAR
	MOV	BX,CS:WORD PTR [OUTPUT_QUE.TAILPTR]
	CALL	QUE_BUMP			; Bump head pointer
	CMP	BX,CS:WORD PTR [OUTPUT_QUE.HEADPTR]	; Room for 1 more?
	JZ	CHR_STATUSO1			; Nope, que is full
	CLC
	RET					; Que has room
CHR_STATUSO1:
	STC
	RET					; Que is full
CHR_STATUSO ENDP

;***	CHR_FLUSHO - Flush Output
;
;	CHR_FLUSHO is called to flush the output buffer.
;

CHR_FLUSHO PROC	NEAR
	CLC
	RET
CHR_FLUSHO ENDP

;***	CHR_INT - Handle interrupts
;
;	AL	=	Interrupt value from 8259
;

CHR_INT	PROC	NEAR
	XOR	AH,AH
	SHL	AX,1
	MOV	SI,AX				; Make word offset
	JMP	CS:WORD PTR INTVEC[SI]
INT_DONE:
	RET

INTVEC	LABEL	WORD				; Interrupt vectors
	DW	OFFSET INT_GET			; Char ready on #1
	DW	OFFSET INT_DONE			; Char ready on #2
	DW	OFFSET INT_PUT			; Put character on #1
    REPT 5
	DW	OFFSET INT_DONE			; And all the rest
    ENDM

;	Get a character from the device at interrupt time

INT_GET:
	IN	AL,Z204EP2A+EPSTAT		; Get status
	TEST	AL,EPRXR			; Really ready?
	JZ	INT_GET1
	IN	AL,Z204EP2A+EPDATA		; Get the character
	MOV	SI,OFFSET INPUT_QUE
	CALL	QUE_PUT				; Put it in the que
INT_GET1:
	RET

;	Have a transmitter ready interrupt

INT_PUT:
	IN	AL,Z204EP2A+EPSTAT
	TEST	AL,EPTXR			; Is it really?
	JZ	INT_PUTS			; Nope, stop the transmitter

;	It was us

	MOV	SI,OFFSET OUTPUT_QUE
	CALL	QUE_LOOK			; Get a character
	JC	INT_PUTS			; If none ready
	CALL	CHKBSY
	JC	INT_PUTS			; If not ready
	OUT	Z204EP2A+EPDATA,AL		; Send out character
	MOV	SI,OFFSET OUTPUT_QUE
	CALL	QUE_GET				; Eat the character
	RET

;	Que empty. Turn off the transmitter

INT_PUTS:
	IN	AL,Z204EP2A+EPCMD
	AND	AL,NOT EPTXEN			; Turn it off
	OUT	Z204EP2A+EPCMD,AL
	RET
CHR_INT	ENDP

;*	Support subroutines for the device
;

;*	CHKBSY - Check for Device Busy
;
;	CHKBSY returns CY set if device is busy
;

CHKBSY	PROC	NEAR
	PUSH	AX
	IN	AL,Z204EP2A+EPCMD		; See if transmitter enabled
	TEST	AL,EPTXEN			; Is it?
	JNZ	READY				; Yep
	OR	AL,EPTXEN			; Nope, force it on
	OUT	Z204EP2A+EPCMD,AL		; Turn it on
READY:
	IN	AL,Z204EP2A+EPSTAT		; Get status
	TEST	AL,EPTXR			; Ready?
	POP	AX
	JNZ	CHKBSY1				; It's ready
	STC					; Not ready, set errors
CHKBSY1:
	RET					; All done
CHKBSY	ENDP

;***	END_DRIVER - Define the resident end of the drive
;
;	END_DRIVER defines the physical end of the
;	resident portion of the driver
;

END_DRIVER	LABEL	NEAR

;***	CHR_INIT - Initialize the device
;
;	CHR_INIT should initialize the device. The interrupt
;	vectors have NOT been set at this point. Note that this
;	is in the portion overlayed after INIT time
;
;	NOTE: The transmitter is not turned on. When output is
;	done through CHR_PUT, CHR_PUT places the character in the
;	output que with QUE_PUT and calls CHKBSY to turn the
;	transmitter on.
;

CHR_INIT PROC	NEAR
	XOR	AL,AL
	OUT	Z204EP2A+EPCMD,AL		; Turn it off
	IN	AL,Z204EP2A+EPCMD		; Reset mode pointer
	MOV	AL,EPSB1+EPCL8+EPA16X		; 1 stop bit, 8bit words x16
	OUT	Z204EP2A+EPMODE,AL		;   Set in mode 1
	MOV	AL,EPB960+EPMR2A		; 9600 baud Internal clocks
	OUT	Z204EP2A+EPMODE,AL		;   Set in mode 2
	MOV	AL,EPRTS+EPRESE+EPRXEN+EPDTR	; RTS, DTR, Rx enable, reset
	OUT	Z204EP2A+EPCMD,AL		;   Set in command reg
	IN	AL,Z204EP2A+EPDATA
	IN	AL,Z204EP2A+EPDATA		; Clear any data
	CLC
	RET
CHR_INIT ENDP
