/***********************************************************************/
/*	wrtchatr.c                                                    */
/***********************************************************************/

wrtchatr(count,charac,forgnd,bakrnd) /* write character and attribute */
int count; /* the count of how many times to print the character */
int forgnd; /* foreground color of character to be printed */
int bakrnd; /* background color of character to print */
char charac; /* the character to print */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code;        /* return code for gdosint */

  if ( count <= 0 || count > 16384 )
     return(-1);
  regs.ah=15;  /* get current mode. sets bh = current display page  */
  ret_code = gdosint(0x10,&regs,&regs);
  regs.ch= count >> 8;   /* high byte of count into ch register */
  regs.cl=count - (regs.ch << 8);
  regs.al=charac;
  if (forgnd < 16 )
     regs.bl= ( bakrnd << 4 ) + forgnd;
  else
     regs.bl= ( ( bakrnd << 4 ) + forgnd - 16 ) | 0x0080 ;
  regs.ah=9;
  ret_code = gdosint(0x10,&regs,&regs);
  return(0);
}
