/***********************************************************************/
/*	rstwindo.c                                                    */
/***********************************************************************/

/* restore a screen window from memory */
rstwindo(uplr,uplc,lrr,lrc,buffer)
int uplc,uplr; /* upper left column and row coordinates */
int lrc,lrr;   /* lower right corner (col and row) */
char *buffer;  /* pointer to buffer area to restore screen */
{
  int length;  /* length of each row to restore */
  int i;       /* counter fro for loop */
  int actpage,mode,cols; /* current screen attributes */

  getscmod(&mode,&cols,&actpage);

  if (mode > 3 && mode < 7)    /* graphics modes are not supported */
	return(-1);

  length = lrc - uplc + 1;   /* length= right corner - left corner */
  if (length == cols){         /* restoring contiguous area */
	memtoscr( (lrr-uplr+1) * length, ((uplr * cols) + uplc)*2, buffer);
                 /*    offset into screen memory, length in bytes  */
  }else{
	for(i=uplr;i<=lrr;i++){

		memtoscr( length, ((i * cols)+uplc)*2,buffer);
		buffer += (length*2);
	}
  }
}
