/***********************************************************************/
/*	grarcl.c                                                      */
/***********************************************************************/
/* function to help in filling out arc array */
grarcl(c1,r1,c2,r2,color,f,top,bot)
int c1; /* column coordinate of first point */
int r1; /* row coordinate of first point */
int c2; /* column coordinate of second point */
int r2; /* row coordinate of second point */
int color; /* foreground color of line */
int f[200][2];
int *top;
int *bot;
{
int dr; /* delta r */
int dc; /* delta c */
int rem; /* remainder of slope */
int slope; /* slope */
int r; /* row coordinate to write out */
int c; /* column coordinate to write out */
int i; /* counter of # of points written out */
int j; /* temp counter of incrementing remainder */
int ir; /* increment value of row */
int ic; /* increment value of column */
int mode; /* current mode */
int cols; /* current # of columns */
int page; /* current page */
/* do checks */
getscmod(&mode,&cols,&page);
if(mode < 3) return(-1);
cols = cols * 8;
if((r1 < 0)||(r1 > 199)) return(-2);
if((c1 < 0)||(c1 > cols - 1)) return(-3);
if((r2 < 0)||(r2 > 199)) return(-4);
if((c2 < 0)||(c2 > cols - 1)) return(-5);
if((color < 1)||(color > 3)) return(-6);
/* get delta r and c */
dr = ((r1-r2)<0?-(r1-r2):(r1-r2));
dc = ((c1-c2)<0?-(c1-c2):(c1-c2));
/* check that we aren't writing out just one point */
if((dr == 0)&&(dc == 0))
  {
  dot(c1,r1,color);
  if((f[r1][0] > c1)||(f[r1][0] == -1)) f[r1][0] = c1;
  if(f[r1][1] < c1) f[r1][1] = c1;
  if(*top > r1) *top = r1;
  if(*bot < r1) *bot = r1;
  return(1);
  }
/* which way does the slope go ?? */
if(dr > dc) goto vertical;
r = r1;
c = c1;
if(c1 > c2) ic = -1;
  else ic = 1;
if(r1 > r2) ir = -1;
  else ir = 1;
/* get slopes remainder */
rem = dr % dc;
/* write out start point */
dot(c1,r1,color);
if((f[r1][0] > c1)||(f[r1][0] == -1)) f[r1][0] = c1;
if(f[r1][1] < c1) f[r1][1] = c1;
if(*top > r1) *top = r1;
if(*bot < r1) *bot = r1;
/* check for diagonal */
if(dc == dr)
  {
  j = 1;
  dc = 0;
  }
  else j = dc / 2;
/* start loop for line slopes > 1 */
for(i = 1; ; ++i)
  {
  /* are we done ? */
  if((r == r2)&&(c == c2)) return(i);
  j = j + rem;
  if(j > dc)
    {
    r = r + ir;
    j = j - dc;
    }
  c = c + ic;
  dot(c,r,color);
  if((f[r][0] > c)||(f[r][0] == -1)) f[r][0] = c;
  if(f[r][1] < c) f[r][1] = c;
  if(*top > r) *top = r;
  if(*bot < r) *bot = r;
  }
vertical:
r = r1;
c = c1;
if(c1 > c2) ic = -1;
  else ic = 1;
if(r1 > r2) ir = -1;
  else ir = 1;
/* get slopes remainder */
rem = dc % dr;
/* write out start point */
dot(c1,r1,color);
if((f[r1][0] > c1)||(f[r1][0] == -1)) f[r1][0] = c1;
if(f[r1][1] < c1) f[r1][1] = c1;
if(*top > r1) *top = r1;
if(*bot < r1) *bot = r1;
j = dr / 2;
/* start loop for line slopes < or = 1 */
for(i = 1; ; ++i)
  {
  /* are we done ? */
  if((r == r2)&&(c == c2)) return(i);
  j = j + rem;
  if(j > dr)
    {
    c = c + ic;
    j = j - dr;
    }
  r = r + ir;
  dot(c,r,color);
  if((f[r][0] > c)||(f[r][0] == -1)) f[r][0] = c;
  if(f[r][1] < c) f[r][1] = c;
  if(*top > r) *top = r;
  if(*bot < r) *bot = r;
  }
}
