;***********************************************************************/
;*	paint.asm                                                     */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC

PSEG

ENDIF
;
;**************************************************************************
;
; THIS SUBROUTINE HIGHLIGHTS AN AREA OF THE SCREEN DEFINED BY THE
; UPPER LEFT-HAND CORNER AND LOWER-RIGHT HAND CORNER. THE RANGE FOR
; ROWS IS 0 TO 24 AND THE COLUMN RANGE IS 0 TO 79. THE PROCEDURE
; SETS THE ATTRUBUTE BYTE OF EACH CHARACTER/ATTRIBUTE PAIR IN THE AREA
; TO THE ATTRIBUTE PASSED TO THE SUBROUTINE. THE PROC IS CALLED FROM
; AS FOLLOWS:
;	PAINT(UPPER_ROW,UPPER_COL,LOWER_ROW,LOWER_COL,FOREGROUND,BACKGROUND)
;
;
;
;
	ASSUME DS:NOTHING

        PUBLIC PAINT

if @BIGMODEL+LPROG
PAINT PROC FAR
BIGOFF EQU  2

else
PAINT PROC NEAR
BIGOFF EQU  0
endif

	PUSH BP
	MOV BP,SP
	PUSH ES
	MOV BX,[BP+10+BIGOFF]	;LOWER COLUMN IN BX
	MOV AX,[BP+6+BIGOFF]	;UPPER COLUMN IN AX
	MOV DI,AX	;SAVE FOR LATER USE IN OFFSET CALCULATION
	CMP DI,0	;EDIT UPPER COL TO BE WITHIN LIMITS OF 0 TO 79
	JGE HI01
	JMP BAD_PARMS	; RETURN IF ERROR
HI01:	CMP DI,79
	JLE HI02
	JMP BAD_PARMS	; RETURN IF ERROR
HI02:	SUB BX,AX	;
	INC BX		;BX HAS NUMBER OF COLUMNS TO HIGHLIGHT
	MOV CX,[BP+8+BIGOFF]	;LOWER ROW
	MOV AX,[BP+4+BIGOFF]	;UPPER ROW
	MOV SI,AX	;SAVE FOR LATER USE IN OFFSET CALCULATION
	CMP SI,0	;EDIT UPPER ROW TO BE WITHIN 0 T0 24 LIMIT
	JGE HI03
	JMP BAD_PARMS	;RETURN IF ERROR
HI03:	CMP SI,24
	JLE HI04
	JMP BAD_PARMS	;RETURN IF ERROR
HI04:	SUB CX,AX	;
	INC CX		;CX HAS NUMBER OF ROWS TO BE HIGHLIGHTED
	CMP CX,0	; TEST FOR NUMBER OF ROWS WITHIN LIMITS OF 1 TO 25
	JG HI05		; THESE TESTS ALSO TEST VALIDITY OF LOWER COL. & ROW
	JMP BAD_PARMS	; IN RELATION TO UPPER COL. & ROW
HI05:	CMP CX,25	
	JLE HI10
	JMP BAD_PARMS
HI10:	CMP BX,1	; TEST FOR NUMBER OF COLUMNS WITHIN 1 TO 80
	JGE HI15
	JMP BAD_PARMS
HI15:	CMP BX,80
	JLE HI20
	JMP BAD_PARMS
HI20:	PUSH BX		; SAVE BX BECAUSE COLOR_MONO ALTERS IT
	COLOR_MONO
			; COLOR_MONO RETURNS ADDRESS OF VIDEO CONTROLLER
			; STATUS PORT IN DX WHICH IS USED BY THE
			; CHK_RETRACE MACRO BELOW
	POP BX		; RETRIEVE BX 
	MOV ES,AX	; COLOR_MONO RETURNS VIDEO ADDRESS IN AX
   	MOV AX,SI	; AX HAS UPPER ROW. WE CALCULATE OFFSET INTO
			; SCREEN BY: OFFSET=(ROW*160)+(COL*2)
	MOV AH,160
	MUL AH 	        ; MUST BE LESS THAN 256 ROWS SO AL IS OK
	MOV SI,AX	; STORE ROW OFFSET VALUE
	MOV AX,DI	; DI HAS UPPER COLUMN OFFSET
	SAL AX,1	; MULTIPLY BY TWO
	ADD AX,SI	; AX NOW CONTAINS OFFSET INTO SCREEN
	MOV SI,AX	; HOLD VALUE IN SI FOR INITIALIZATION IN LOOP
	MOV DI,BX	; HOLD COLUMN COUNT IN DI
	MOV BL,BYTE PTR [BP+12+BIGOFF]	; BL HAS FOREGROUND ATTRIBUTE
	MOV AH,BYTE PTR [BP+14+BIGOFF] ; AH HAS BACKGROUND ATTRIBUTE
	SHL AH,1	; MOVE BACKGROUND COLOR TO PROPER POSITION IN 
	SHL AH,1	;      ATTRIBUTE BYTE
	SHL AH,1
	SHL AH,1
	CMP BL,15	; IF FOREGROUND IS GREATER THAN 15 (BLINK OR UNDERLINE
	JLE HI30
	SUB BL,16	; DO SUBTRACTION SO BL CAN BE ADDED TO AH WITHOUT
			; CHANGING BACKGROUND BIT SETTINGS
	OR AH,10000000B ; SET HIGH BIT FOR BLINK
HI30:
	ADD AH,BL	; AH NOW HAS PROPER ATTRIBUTE BYTE
PROCEED:
	MOV BX,SI	; PUT CURRENT OFFSET VALUE INTO BX FOR ADDRESSING
	PUSH CX		; SAVE CX (ROW COUNTER) WHILE CX GETS USED FOR LOOP
	MOV CX,DI	; PUT COUNT OF COLUMNS IN CX FOR LOOP
LOOP3:
	INC BX		; POINT TO ATTRIBUTE BYTE OF CHAR/ATRIB PAIR
	CHK_RETRACE
	MOV BYTE PTR ES:[BX],AH		;STORE ATRIBUTE THERE
	INC BX		; POINT TO NEXT CHARACTER BYTE
	LOOP LOOP3	; CONTINUE FOR CX ITERATIONS
	STI		; CHK_RETRACE CLEARED INTERRUPTS SO RESET THEM NOW
	POP CX		; GET CX BACK
	ADD SI,160	; POINT TO OFFSET OF START OF NEXT ROW
	DEC CX		; REDUCE COUNT OF ROWS REMAINING TO PAINT
	CMP CX,0	; ARE WE DONE
	JG PROCEED	; CONTINUE IF NOT WITH NEXT ROW
	MOV AX,0000H	; RETURN 0 FOR GOOD CALL
	JMP DONE
BAD_PARMS:
	MOV AX,0FFFFH	; RETURN -1 FOR BAD CALL
DONE:	POP ES
	POP BP
	RET

PAINT	ENDP

;***************************************************************************
;
IFDEF CI_C86
@CODE	ENDS

ELSE
ENDPS
ENDIF
	END
